/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class RelativeContentGene
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 318574260997761935L;
    private DoubleValue[] _aTargets = null;
    private double[] _adOrigValues = null;
    private double dTotal = 0.0;

    public RelativeContentGene(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst, DoubleValue[] aTargets, double[] adOrigValues) {
        super(dLowLimit, dHighLimit, dDefaultValue, dDecayConst);
        assert (aTargets.length == adOrigValues.length);
        this._aTargets = aTargets;
        this._adOrigValues = new double[aTargets.length];
        int i = 0;
        while (i < aTargets.length) {
            aTargets[i].setGene(true);
            this._adOrigValues[i] = adOrigValues[i] / dDefaultValue;
            this.dTotal += this._adOrigValues[i];
            ++i;
        }
    }

    @Override
    public void computeVariables() {
        int i = 0;
        while (i < this._aTargets.length) {
            this._aTargets[i].setValue(this.getGeneValue() * this._adOrigValues[i]);
            ++i;
        }
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._aTargets.length) {
            this._aTargets[i].setGene(bActive);
            ++i;
        }
    }
}

