/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class RelatedPositionGeneInTwoGlycerine
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 4198636805825801234L;
    private DoubleValue[] _aTargets = null;
    private DoubleValue _dSpacingTarget = null;
    private double[] _adAtomRelativePosition = null;
    private double _dSkeletThickness = 0.0;

    public RelatedPositionGeneInTwoGlycerine(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst, DoubleValue[] aTargets, double[] adAtomRelativePosition, DoubleValue dSpacing, double dSkeletonThickness) {
        super(dLowLimit, dHighLimit, dDefaultValue, dDecayConst);
        if (aTargets.length != adAtomRelativePosition.length) {
            throw new IllegalArgumentException("Mismatch in input arrays length - targets: " + aTargets.length + ", positions: " + adAtomRelativePosition.length);
        }
        this._aTargets = aTargets;
        int i = 0;
        while (i < aTargets.length) {
            aTargets[i].setGene(true);
            ++i;
        }
        this._dSkeletThickness = dSkeletonThickness;
        this._dSpacingTarget = dSpacing;
        this._adAtomRelativePosition = adAtomRelativePosition;
    }

    @Override
    public void computeVariables() {
        double d001 = this.getGeneValue();
        double dMidPlane = (d001 - this._dSkeletThickness) / 2.0 + this._dSkeletThickness;
        double dGly1 = 0.276 * d001 - 3.68;
        double dGly2 = 0.567 * d001 - 7.63;
        double dH2O1 = 0.284 * d001 - 4.1;
        double dH2O2 = 0.778 * d001 - 10.98;
        double dMg = 0.78 * d001 - 12.62;
        this._aTargets[0].setValue(dMidPlane - dH2O2);
        this._aTargets[9].setValue(dMidPlane + dH2O2);
        this._aTargets[1].setValue(dMidPlane - dGly2);
        this._aTargets[8].setValue(dMidPlane + dGly2);
        this._aTargets[2].setValue(dMidPlane - dGly1);
        this._aTargets[7].setValue(dMidPlane + dGly1);
        this._aTargets[3].setValue(dMidPlane - dH2O1);
        this._aTargets[6].setValue(dMidPlane + dH2O1);
        this._aTargets[4].setValue(dMidPlane - dMg);
        this._aTargets[5].setValue(dMidPlane + dMg);
        this._dSpacingTarget.setValue(this.getGeneValue());
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._aTargets.length) {
            this._aTargets[i].setGene(bActive);
            ++i;
        }
        this._dSpacingTarget.setGene(bActive);
    }

    @Override
    public void updateTo(AbstractLayerGene absPattern) {
        super.updateTo(absPattern);
        RelatedPositionGeneInTwoGlycerine pattern = (RelatedPositionGeneInTwoGlycerine)absPattern;
        this._dSkeletThickness = pattern._dSkeletThickness;
        System.arraycopy(pattern._adAtomRelativePosition, 0, this._adAtomRelativePosition, 0, this._adAtomRelativePosition.length);
    }
}

