/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class RelatedPositionGene
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 4198636805825801234L;
    private DoubleValue[] _aTargets = null;
    private DoubleValue _dSpacingTarget = null;
    private double[] _adAtomRelativePosition = null;
    private double _dSkeletThickness = 0.0;

    public RelatedPositionGene(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst, DoubleValue[] aTargets, double[] adAtomRelativePosition, DoubleValue dSpacing, double dSkeletonThickness) {
        super(dLowLimit, dHighLimit, dDefaultValue, dDecayConst);
        if (aTargets.length != adAtomRelativePosition.length) {
            throw new IllegalArgumentException("Mismatch in input arrays length - targets: " + aTargets.length + ", positions: " + adAtomRelativePosition.length);
        }
        this._aTargets = aTargets;
        int i = 0;
        while (i < aTargets.length) {
            aTargets[i].setGene(true);
            ++i;
        }
        this._dSkeletThickness = dSkeletonThickness;
        this._dSpacingTarget = dSpacing;
        this._adAtomRelativePosition = adAtomRelativePosition;
    }

    @Override
    public void computeVariables() {
        double dRefPosition = (this.getGeneValue() - this._dSkeletThickness) / 2.0 + this._dSkeletThickness;
        int i = 0;
        while (i < this._aTargets.length) {
            this._aTargets[i].setValue(dRefPosition + this._adAtomRelativePosition[i]);
            ++i;
        }
        this._dSpacingTarget.setValue(this.getGeneValue());
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._aTargets.length) {
            this._aTargets[i].setGene(bActive);
            ++i;
        }
        this._dSpacingTarget.setGene(bActive);
    }

    @Override
    public void updateTo(AbstractLayerGene absPattern) {
        super.updateTo(absPattern);
        RelatedPositionGene pattern = (RelatedPositionGene)absPattern;
        this._dSkeletThickness = pattern._dSkeletThickness;
        System.arraycopy(pattern._adAtomRelativePosition, 0, this._adAtomRelativePosition, 0, this._adAtomRelativePosition.length);
    }
}

