/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class RelatedPositionAndRatioGene
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 6475425166783261528L;
    private DoubleValue _targetMainPos = null;
    private DoubleValue _targetSubstPos = null;
    private DoubleValue _targetMainCont = null;
    private DoubleValue _targetSubstCont = null;
    private DoubleValue _dSpacingTarget = null;
    private double _dSkeletThickness = 0.0;
    private double _dRatio0At = 0.0;
    private double _dRatio1At = 0.0;

    public RelatedPositionAndRatioGene(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst, DoubleValue targetMainPos, DoubleValue targetSubstPos, DoubleValue targetMainCont, DoubleValue targetSubstCont, DoubleValue dSpacing, double dSkeletonThickness, double dRatio0At, double dRatio1At) {
        super(dLowLimit, dHighLimit, dDefaultValue, dDecayConst);
        this._targetMainPos = targetMainPos;
        this._targetMainPos.setGene(true);
        this._targetSubstPos = targetSubstPos;
        this._targetSubstPos.setGene(true);
        this._targetMainCont = targetMainCont;
        this._targetMainCont.setGene(true);
        this._targetSubstCont = targetSubstCont;
        this._targetSubstCont.setGene(true);
        this._dSkeletThickness = dSkeletonThickness;
        this._dSpacingTarget = dSpacing;
        this._dRatio0At = dRatio0At;
        this._dRatio1At = dRatio1At;
    }

    @Override
    public void computeVariables() {
        double dRefPosition = (this.getGeneValue() - this._dSkeletThickness) / 2.0 + this._dSkeletThickness;
        this._targetMainPos.setValue(dRefPosition);
        this._targetSubstPos.setValue(dRefPosition);
        double dTotal = this._targetMainCont.getValue() + this._targetSubstCont.getValue();
        double dRatio = (this.getGeneValue() - this._dRatio0At) / (this._dRatio1At - this._dRatio0At);
        if (dRatio < 0.0) {
            dRatio = 0.0;
        }
        assert (dRatio <= 1.0) : "dRatio: " + dRatio;
        this._targetMainCont.setValue(dTotal * (1.0 - dRatio));
        this._targetSubstCont.setValue(dTotal * dRatio);
        this._dSpacingTarget.setValue(this.getGeneValue());
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        this._targetMainPos.setGene(bActive || this._targetMainPos.isGene());
        this._targetSubstPos.setGene(bActive || this._targetSubstPos.isGene());
        this._targetMainCont.setGene(bActive || this._targetMainCont.isGene());
        this._targetSubstCont.setGene(bActive || this._targetMainCont.isGene());
        this._dSpacingTarget.setGene(bActive);
    }

    @Override
    public void updateTo(AbstractLayerGene absPattern) {
        super.updateTo(absPattern);
        RelatedPositionAndRatioGene pattern = (RelatedPositionAndRatioGene)absPattern;
        this._dSkeletThickness = pattern._dSkeletThickness;
        this._dRatio0At = pattern._dRatio0At;
        this._dRatio1At = pattern._dRatio1At;
    }
}

