/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.analysis.evolution.Gene;

public class ModGene
extends Gene
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6675004267622878971L;
    private double _dLowLimit = 0.0;
    private double _dFinalLowLimit = 0.0;
    private double _dHighLimit = 0.0;
    private double _dFinalHighLimit = 0.0;
    private double _dGeneValue = 0.0;
    private double _dDecayConst = 0.0;
    private String _sName = "unknown";

    public ModGene(double dLowLimit, double dHighLimit, double dDefaultValue, double dDecayConst) {
        this._dLowLimit = dLowLimit;
        this._dFinalLowLimit = dLowLimit;
        this._dHighLimit = dHighLimit;
        this._dFinalHighLimit = dHighLimit;
        this._dGeneValue = dDefaultValue;
        this._dDecayConst = dDecayConst;
    }

    public void randomize() {
        this.randomizeAround(this, 0.0, 0.0);
    }

    public void randomizeAround(Gene pattern, double popValue, double progress) {
        assert (pattern instanceof ModGene);
        double aroundValue = ((ModGene)pattern)._dGeneValue;
        this._dGeneValue = this.randomizeAround(aroundValue, this._dLowLimit, this._dHighLimit, popValue);
    }

    public void mutate(double progress) {
        this._dGeneValue += this.delta(progress, this._dHighLimit, this._dLowLimit, this._dDecayConst, this._dGeneValue);
    }

    public boolean equals(Gene pattern) {
        return ((ModGene)pattern)._dGeneValue == this._dGeneValue;
    }

    public void copy(Gene pattern) {
        ModGene source = (ModGene)pattern;
        this._dLowLimit = source._dLowLimit;
        this._dFinalLowLimit = source._dFinalLowLimit;
        this._dHighLimit = source._dHighLimit;
        this._dFinalHighLimit = source._dFinalHighLimit;
        this._dGeneValue = source._dGeneValue;
        this._dDecayConst = source._dDecayConst;
        this._sName = source._sName;
    }

    public double getValue() {
        return this._dGeneValue;
    }

    public void setValue(double dValue) {
        this._dGeneValue = dValue >= this._dLowLimit && dValue <= this._dHighLimit ? dValue : (Math.abs(this._dLowLimit - dValue) < Math.abs(this._dHighLimit - dValue) ? this._dLowLimit : this._dHighLimit);
    }

    public String getName() {
        return this._sName;
    }

    public void setName(String sName) {
        this._sName = sName;
    }

    public void updateTo(ModGene pattern) {
        this._dGeneValue = pattern._dGeneValue;
        this._dLowLimit = pattern._dLowLimit;
        this._dFinalLowLimit = pattern._dFinalLowLimit;
        this._dHighLimit = pattern._dHighLimit;
        this._dFinalHighLimit = pattern._dFinalHighLimit;
        this._dDecayConst = pattern._dDecayConst;
    }

    public void setLimits(double dLowLimit, double dHighLimit) {
        assert (dLowLimit < dHighLimit) : "Mistake, isn't it?: " + dLowLimit + ", " + dHighLimit;
        assert (dLowLimit >= this._dFinalLowLimit) : "New limit is lower than allowed: " + this._dFinalLowLimit;
        assert (dHighLimit <= this._dFinalHighLimit) : "New limit is higher than allowed: " + this._dFinalHighLimit;
        this._dLowLimit = dLowLimit;
        this._dHighLimit = dHighLimit;
        if (!(this._dGeneValue >= this._dLowLimit) || !(this._dGeneValue <= this._dHighLimit)) {
            this._dGeneValue = this._dLowLimit + (this._dHighLimit - this._dLowLimit) / 2.0;
        }
    }

    public double getLowLimit() {
        return this._dLowLimit;
    }

    public double getFinalLowLimit() {
        return this._dFinalLowLimit;
    }

    public double getHighLimit() {
        return this._dHighLimit;
    }

    public double getFinalHighLimit() {
        return this._dFinalHighLimit;
    }

    public double getDecayConst() {
        return this._dDecayConst;
    }

    public String toString() {
        return this._sName;
    }

    public void set_dLowLimit(double _dLowLimit) {
        this._dLowLimit = _dLowLimit;
    }

    public void set_dHighLimit(double _dHighLimit) {
        this._dHighLimit = _dHighLimit;
    }
}

