/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class ContentSubstGene
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 4269103704853604616L;
    private DoubleValue[] _aContent = null;
    private double[] _adDefaultContent = null;
    private boolean[] _abAdd = null;

    public ContentSubstGene(DoubleValue[] aContent, double[] adDefaultContent, boolean[] abAdd, double dMaxChange, double dDecayConst) {
        super(0.0, dMaxChange, 0.0, dDecayConst);
        assert (dMaxChange > 0.0) : "max change must be positive: " + dMaxChange;
        assert (aContent.length == adDefaultContent.length) : "argument lenght do not match";
        assert (aContent.length == abAdd.length) : "argument lenght do not match";
        assert (this.verifyInput(aContent, adDefaultContent, abAdd)) : "Inconsistent input";
        this._aContent = aContent;
        this._adDefaultContent = adDefaultContent;
        this._abAdd = abAdd;
    }

    @Override
    public void computeVariables() {
        int i = 0;
        while (i < this._aContent.length) {
            this._aContent[i].setValue(this._adDefaultContent[i] + (this._abAdd[i] ? this.getGeneValue() : -this.getGeneValue()));
            ++i;
        }
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._aContent.length) {
            this._aContent[i].setGene(bActive);
            ++i;
        }
    }

    private boolean verifyInput(DoubleValue[] aContent, double[] adDefaultContent, boolean[] abAdd) {
        boolean bOK = true;
        double dFirstShift = abAdd[0] ? aContent[0].getValue() - adDefaultContent[0] : adDefaultContent[0] - aContent[0].getValue();
        int i = 1;
        while (i < aContent.length) {
            double dCurrentShift;
            double d = dCurrentShift = abAdd[i] ? aContent[i].getValue() - adDefaultContent[i] : adDefaultContent[i] - aContent[i].getValue();
            if (Math.abs(dFirstShift - dCurrentShift) > 1.0E-12) {
                bOK = false;
                break;
            }
            ++i;
        }
        return bOK;
    }
}

