/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class ContentRatioGeneTotalFeChlorites
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 7386082388126432681L;
    private DoubleValue[] _targetFe = null;
    private DoubleValue[] _targetOther = null;
    private double[] _adOrigValues = null;
    private double _dTotal = 0.0;

    public ContentRatioGeneTotalFeChlorites(double dDefaultValue, double dDecayConst, DoubleValue targetMgOct, DoubleValue targetFeOct, DoubleValue targetMgInt, DoubleValue targetFeInt, double[] adOrigValues) {
        this(dDefaultValue, 0.0, targetMgOct.getValue() + targetFeOct.getValue() + targetMgInt.getValue() + targetFeInt.getValue(), dDecayConst, targetMgOct, targetFeOct, targetMgInt, targetFeInt, adOrigValues);
    }

    public ContentRatioGeneTotalFeChlorites(double dDefaultValue, double dMinValue, double dMaxValue, double dDecayConst, DoubleValue targetMgOct, DoubleValue targetFeOct, DoubleValue targetMgInt, DoubleValue targetFeInt, double[] adOrigValues) {
        super(dMinValue, dMaxValue, dDefaultValue, dDecayConst);
        assert (dDefaultValue >= dMinValue && dDefaultValue <= dMaxValue) : "default value out of range: " + dDefaultValue + " [" + dMinValue + " - " + dMaxValue + "]";
        this._targetFe = new DoubleValue[2];
        this._targetFe[0] = targetFeOct;
        this._targetFe[0].setGene(true);
        this._targetFe[1] = targetFeInt;
        this._targetFe[1].setGene(true);
        this._targetOther = new DoubleValue[2];
        this._targetOther[0] = targetMgOct;
        this._targetOther[0].setGene(true);
        this._targetOther[1] = targetMgInt;
        this._targetOther[1].setGene(true);
        this._adOrigValues = new double[adOrigValues.length];
        this._dTotal = 0.0;
        int i = 0;
        while (i < adOrigValues.length) {
            this._adOrigValues[i] = adOrigValues[i];
            this._dTotal += adOrigValues[i];
            ++i;
        }
    }

    @Override
    public void computeVariables() {
        this._targetFe[0].setValue(this.getGeneValue());
        this._targetFe[1].setValue(0.0);
        this._targetOther[0].setValue(this._dTotal - this.getGeneValue());
        this._targetOther[1].setValue(0.0);
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._targetFe.length) {
            this._targetFe[i].setGene(bActive);
            this._targetOther[i].setGene(bActive);
            ++i;
        }
    }
}

