/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class ContentRatioGeneRatioInternalOuter
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 7386082388126432681L;
    private DoubleValue[] _targetOuter = null;
    private DoubleValue[] _targetInternal = null;
    private double[] _adOrigValues = null;
    private double _dTotal = 0.0;
    private DoubleValue _targetOuter1;
    private DoubleValue _targetOuter2;
    private DoubleValue _targetInternal1;
    private DoubleValue _targetInternal2;

    public ContentRatioGeneRatioInternalOuter(double dDefaultValue, double dDecayConst, DoubleValue targetOuter1, DoubleValue targetOuter2, DoubleValue targetInternal1, DoubleValue targetInternal2, double[] adOrigValues) {
        this(dDefaultValue, 0.0, 1.0, dDecayConst, targetOuter1, targetOuter2, targetInternal1, targetInternal2, adOrigValues);
    }

    public ContentRatioGeneRatioInternalOuter(double dDefaultValue, double dMinValue, double dMaxValue, double dDecayConst, DoubleValue targetOuter1, DoubleValue targetOuter2, DoubleValue targetInternal1, DoubleValue targetInternal2, double[] adOrigValues) {
        super(dMinValue, dMaxValue, dDefaultValue, dDecayConst);
        assert (dDefaultValue >= dMinValue && dDefaultValue <= dMaxValue) : "default value out of range: " + dDefaultValue + " [" + dMinValue + " - " + dMaxValue + "]";
        this._targetOuter = new DoubleValue[2];
        this._targetOuter[0] = targetOuter1;
        this._targetOuter[0].setGene(true);
        this._targetOuter[1] = targetOuter2;
        this._targetOuter[1].setGene(true);
        this._targetInternal = new DoubleValue[2];
        this._targetInternal[0] = targetInternal1;
        this._targetInternal[0].setGene(true);
        this._targetInternal[1] = targetInternal1;
        this._targetInternal[1].setGene(true);
        this._adOrigValues = new double[adOrigValues.length];
        this._dTotal = 0.0;
        int i = 0;
        while (i < adOrigValues.length) {
            this._adOrigValues[i] = adOrigValues[i];
            this._dTotal += adOrigValues[i];
            ++i;
        }
        this._targetOuter1 = targetOuter1;
        this._targetOuter2 = targetOuter2;
        this._targetInternal1 = targetInternal1;
        this._targetInternal2 = targetInternal2;
    }

    @Override
    public void computeVariables() {
        double totalContent = this._targetOuter[0].getValue();
        double ratioInternalTotal = this.getGeneValue();
        double internal1 = totalContent * ratioInternalTotal;
        double internal2 = totalContent * ratioInternalTotal;
        double outer1 = totalContent * (1.0 - ratioInternalTotal);
        double outer2 = totalContent * (1.0 - ratioInternalTotal);
        this._targetOuter1.setValue(outer1);
        this._targetOuter2.setValue(outer2);
        this._targetInternal1.setValue(internal1);
        this._targetInternal2.setValue(internal2);
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._targetOuter.length) {
            this._targetOuter[i].setGene(bActive);
            this._targetInternal[i].setGene(bActive);
            ++i;
        }
    }
}

