/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class ContentRatioGeneRatioFeChlorites
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 7386082388126432681L;
    private DoubleValue[] _targetFe = null;
    private DoubleValue[] _targetOther = null;
    private double[] _adOrigValues = null;
    private double _dTotal = 0.0;
    private DoubleValue _targetMgOct;
    private DoubleValue _targetFeOct;
    private DoubleValue _targetMgInt;
    private DoubleValue _targetFeInt;

    public ContentRatioGeneRatioFeChlorites(double dDefaultValue, double dDecayConst, DoubleValue targetMgOct, DoubleValue targetFeOct, DoubleValue targetMgInt, DoubleValue targetFeInt, double[] adOrigValues) {
        this(dDefaultValue, 0.0, 1.0, dDecayConst, targetMgOct, targetFeOct, targetMgInt, targetFeInt, adOrigValues);
    }

    public ContentRatioGeneRatioFeChlorites(double dDefaultValue, double dMinValue, double dMaxValue, double dDecayConst, DoubleValue targetMgOct, DoubleValue targetFeOct, DoubleValue targetMgInt, DoubleValue targetFeInt, double[] adOrigValues) {
        super(dMinValue, dMaxValue, dDefaultValue, dDecayConst);
        assert (dDefaultValue >= dMinValue && dDefaultValue <= dMaxValue) : "default value out of range: " + dDefaultValue + " [" + dMinValue + " - " + dMaxValue + "]";
        this._targetFe = new DoubleValue[2];
        this._targetFe[0] = targetFeOct;
        this._targetFe[0].setGene(true);
        this._targetFe[1] = targetFeInt;
        this._targetFe[1].setGene(true);
        this._targetOther = new DoubleValue[2];
        this._targetOther[0] = targetMgOct;
        this._targetOther[0].setGene(true);
        this._targetOther[1] = targetMgInt;
        this._targetOther[1].setGene(true);
        this._adOrigValues = new double[adOrigValues.length];
        this._dTotal = 0.0;
        int i = 0;
        while (i < adOrigValues.length) {
            this._adOrigValues[i] = adOrigValues[i];
            this._dTotal += adOrigValues[i];
            ++i;
        }
        this._targetMgOct = targetMgOct;
        this._targetFeOct = targetFeOct;
        this._targetMgInt = targetMgInt;
        this._targetFeInt = targetFeInt;
    }

    @Override
    public void computeVariables() {
        double feInt;
        double ratioIntOct = this.getGeneValue();
        double totalOct = this._dTotal / 2.0;
        double totalInt = this._dTotal / 2.0;
        double totalFe = this._targetFe[0].getValue();
        double feOct = totalFe * (1.0 - ratioIntOct);
        if (feOct > 6.0) {
            feOct = 6.0;
        }
        if ((feInt = totalFe * ratioIntOct) > 6.0) {
            feInt = 6.0;
        }
        double mgOct = totalOct - feOct;
        double mgInt = totalInt - feInt;
        this._targetMgOct.setValue(mgOct);
        this._targetFeOct.setValue(feOct);
        this._targetMgInt.setValue(mgInt);
        this._targetFeInt.setValue(feInt);
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._targetFe.length) {
            this._targetFe[i].setGene(bActive);
            this._targetOther[i].setGene(bActive);
            ++i;
        }
    }
}

