/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.gene;

import java.io.Serializable;
import net.ndmystko.xrd.mod.gene.AbstractLayerGene;
import net.ndmystko.xrd.mod.layer.DoubleValue;

public class ContentRatioGene
extends AbstractLayerGene
implements Serializable {
    private static final long serialVersionUID = 7386082388126432681L;
    private DoubleValue[] _targetMain = null;
    private DoubleValue[] _targetSubst = null;

    public ContentRatioGene(double dDefaultValue, double dDecayConst, DoubleValue targetMain, DoubleValue targetSubst) {
        this(dDefaultValue, 0.0, targetMain.getValue() + targetSubst.getValue(), dDecayConst, targetMain, targetSubst);
    }

    public ContentRatioGene(double dDefaultValue, double dMaxValue, double dDecayConst, DoubleValue targetMain, DoubleValue targetSubst) {
        this(dDefaultValue, 0.0, dMaxValue, dDecayConst, targetMain, targetSubst);
    }

    public ContentRatioGene(double dDefaultValue, double dMinValue, double dMaxValue, double dDecayConst, DoubleValue targetMain, DoubleValue targetSubst) {
        super(dMinValue, dMaxValue, dDefaultValue, dDecayConst);
        assert (dDefaultValue >= dMinValue && dDefaultValue <= dMaxValue) : "default value out of range: " + dDefaultValue + " [" + dMinValue + " - " + dMaxValue + "]";
        this._targetMain = new DoubleValue[1];
        this._targetMain[0] = targetMain;
        this._targetMain[0].setGene(true);
        this._targetSubst = new DoubleValue[1];
        this._targetSubst[0] = targetSubst;
        this._targetSubst[0].setGene(true);
    }

    public ContentRatioGene(double dDefaultValue, double dDecayConst, DoubleValue[] targetMain, DoubleValue[] targetSubst) {
        super(0.0, targetMain[0].getValue() + targetSubst[0].getValue(), dDefaultValue, dDecayConst);
        assert (targetMain.length == targetSubst.length);
        int i = 1;
        while (i < targetMain.length) {
            assert (targetMain[i].getValue() == targetMain[i - 1].getValue());
            assert (targetSubst[i].getValue() == targetSubst[i - 1].getValue());
            ++i;
        }
        this._targetMain = targetMain;
        this._targetSubst = targetSubst;
        i = 0;
        while (i < this._targetMain.length) {
            this._targetMain[i].setGene(true);
            this._targetSubst[i].setGene(true);
            ++i;
        }
    }

    @Override
    public void computeVariables() {
        double dTotal = this._targetMain[0].getValue() + this._targetSubst[0].getValue();
        int i = 0;
        while (i < this._targetMain.length) {
            this._targetSubst[i].setValue(this.getGeneValue());
            this._targetMain[i].setValue(dTotal - this.getGeneValue());
            ++i;
        }
    }

    @Override
    public void setActive(boolean bActive) {
        super.setActive(bActive);
        int i = 0;
        while (i < this._targetMain.length) {
            this._targetMain[i].setGene(bActive);
            this._targetSubst[i].setGene(bActive);
            ++i;
        }
    }
}

