/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.equation;

import java.io.Serializable;
import net.ndmystko.xrd.mod.equation.Equation;
import net.ndmystko.xrd.util.Distribution;

public class RegularEquation
extends Equation
implements Serializable {
    private static final long serialVersionUID = 7215133385720694684L;

    public void compute(double[][][] adQRe, double[][][] adQIm, Distribution distr, double[][] adW, double[][][] adVRe, double[][][] adVIm, double[] adIntens) {
        assert (adQRe.length == adQIm.length);
        assert (adQRe[0].length == adQIm[0].length);
        assert (adQRe[0][0].length == adQIm[0][0].length);
        int iNoOfData = adIntens.length;
        int iNmax = distr.getNoOfClasses();
        double[][][] adQnRe = new double[iNmax][adQRe[0].length][adQRe[0][0].length];
        double[][][] adQnIm = new double[iNmax][adQIm[0].length][adQIm[0][0].length];
        double[][] adSubTotalRe = new double[adQRe[0].length][adQRe[0][0].length];
        double[][] adSubTotalIm = new double[adQIm[0].length][adQIm[0][0].length];
        double[][] adSubSubTotalRe = new double[adQRe[0].length][adQRe[0][0].length];
        double[][] adSubSubTotalIm = new double[adQIm[0].length][adQIm[0][0].length];
        double[][] adNE = this.diag(distr.getMean(), adQRe[0].length);
        double[][] adVWRe = new double[adQRe[0].length][adQRe[0][0].length];
        double[][] adVWIm = new double[adQIm[0].length][adQIm[0][0].length];
        double[][] adWIm = new double[adQIm[0].length][adQIm[0][0].length];
        double[][] adTotalRe = new double[adQIm[0].length][adQIm[0][0].length];
        double[][] adTotalIm = new double[adQIm[0].length][adQIm[0][0].length];
        int i = 0;
        while (i < iNoOfData) {
            if (iNmax > 1) {
                this.createQn(iNmax - 1, adQRe[i], adQIm[i], adQnRe, adQnIm);
            }
            int n = 1;
            while (n < iNmax) {
                double dFactor = 0.0;
                int m = n + 1;
                while (m <= iNmax) {
                    dFactor += (double)(m - n) * distr.getContent(m);
                    ++m;
                }
                this.mult(adQnRe[n], adQnIm[n], 2.0 * dFactor, adSubSubTotalRe, adSubSubTotalIm);
                this.add(adSubTotalRe, adSubTotalIm, adSubSubTotalRe, adSubSubTotalIm);
                ++n;
            }
            this.add(adSubTotalRe, adNE);
            this.mult(adVRe[i], adVIm[i], adW, adWIm, adVWRe, adVWIm);
            this.mult(adVWRe, adVWIm, adSubTotalRe, adSubTotalIm, adTotalRe, adTotalIm);
            adIntens[i] = this.spur(adTotalRe);
            this.reset(adSubTotalRe);
            this.reset(adSubTotalIm);
            ++i;
        }
    }
}

