/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.equation;

import java.io.Serializable;
import net.ndmystko.xrd.Z;
import net.ndmystko.xrd.mod.equation.Equation;
import net.ndmystko.xrd.util.Distribution;

public class MonoRegularEquation
extends Equation
implements Serializable {
    private static final long serialVersionUID = 4659649684147465993L;

    public void compute(double[] adFRe, double[] adFIm, double dDSpacing, double dDeltaDSpacing, Z z, Distribution distr, double[] adIntens) {
        assert (adFRe.length == adFIm.length);
        assert (adFRe.length == adIntens.length);
        int iNoOfData = adIntens.length;
        int iNmax = distr.getNoOfClasses();
        double dNmean = distr.getMean();
        if (dDeltaDSpacing == 0.0) {
            double dTwoPiKsi = Math.PI * 2 * dDSpacing;
            int i = 0;
            while (i < iNoOfData) {
                double dSubTotal = 0.0;
                int n = 1;
                while (n < iNmax) {
                    double dFactor = 0.0;
                    int m = n + 1;
                    while (m <= iNmax) {
                        dFactor += (double)(m - n) * distr.getContent(m);
                        ++m;
                    }
                    dSubTotal += dFactor * Math.cos(dTwoPiKsi * (double)n * z.getZ(i));
                    ++n;
                }
                dSubTotal *= 2.0;
                adIntens[i] = (adFRe[i] * adFRe[i] + adFIm[i] * adFIm[i]) * (dSubTotal += dNmean);
                ++i;
            }
        } else {
            double dTwoPiKsi = Math.PI * 2 * dDSpacing;
            double dTwoPiSquareDeltaSquare = -19.739208802178716 * dDeltaDSpacing * dDeltaDSpacing;
            int i = 0;
            while (i < iNoOfData) {
                double dSubTotal = 0.0;
                double dZTek = z.getZ(i);
                int n = 1;
                while (n < iNmax) {
                    double dFactor = 0.0;
                    int m = n + 1;
                    while (m <= iNmax) {
                        dFactor += (double)(m - n) * distr.getContent(m);
                        ++m;
                    }
                    dSubTotal += dFactor * Math.cos(dTwoPiKsi * (double)n * dZTek) * Math.exp(dTwoPiSquareDeltaSquare * (double)n * dZTek * dZTek);
                    ++n;
                }
                dSubTotal *= 2.0;
                adIntens[i] = (adFRe[i] * adFRe[i] + adFIm[i] * adFIm[i]) * (dSubTotal += dNmean);
                ++i;
            }
        }
    }
}

