/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.equation;

import java.io.Serializable;
import net.ndmystko.xrd.Z;
import net.ndmystko.xrd.mod.equation.Equation;
import net.ndmystko.xrd.util.Distribution;

public class MonoEdgeEquation
extends Equation
implements Serializable {
    private static final long serialVersionUID = -3841394500833030824L;

    public void compute(double[] adFRe, double[] adFIm, double[] adFkRe, double[] adFkIm, double[] adF0Re, double[] adF0Im, double dDSpacing, double dDeltaDSpacing, double dDSpacing0, Z z, Distribution distr, double[] adIntens) {
        assert (adFRe.length == adFIm.length);
        assert (adFRe.length == adIntens.length);
        assert (adFkRe.length == adFRe.length);
        assert (adFkRe.length == adFkIm.length);
        assert (adF0Re.length == adFRe.length);
        assert (adF0Re.length == adF0Im.length);
        int iNoOfData = adIntens.length;
        int iNmax = distr.getNoOfClasses();
        double dNmean = distr.getMean();
        double dTwoPiKsi = Math.PI * 2 * dDSpacing;
        double dTwoPiKsi0 = Math.PI * 2 * dDSpacing0;
        if (dDeltaDSpacing == 0.0) {
            int i = 0;
            while (i < iNoOfData) {
                double dSubTotal1 = 0.0;
                int n = 1;
                while (n < iNmax) {
                    double dFactor = 0.0;
                    int m = n + 1;
                    while (m <= iNmax) {
                        dFactor += (double)(m - n) * distr.getContent(m);
                        ++m;
                    }
                    dSubTotal1 += dFactor * Math.cos(dTwoPiKsi * (double)n * z.getZ(i));
                    ++n;
                }
                dSubTotal1 *= 2.0;
                adIntens[i] = (adFRe[i] * adFRe[i] + adFIm[i] * adFIm[i]) * (dSubTotal1 += dNmean);
                double dSubTotal2Re = 0.0;
                double dSubTotal2Im = 0.0;
                int n2 = 1;
                while (n2 < iNmax) {
                    double dFactor = 0.0;
                    int m = n2 + 1;
                    while (m <= iNmax) {
                        dFactor += distr.getContent(m);
                        ++m;
                    }
                    dSubTotal2Re += dFactor * Math.cos(dTwoPiKsi * (double)n2 * z.getZ(i));
                    dSubTotal2Im += dFactor * Math.sin(dTwoPiKsi * (double)n2 * z.getZ(i));
                    ++n2;
                }
                double dF0FRe = adF0Re[i] * adFRe[i] + adF0Im[i] * adFIm[i];
                double dF0FIm = adF0Re[i] * adFIm[i] - adFRe[i] * adF0Im[i];
                double dExp2Re = Math.cos(dTwoPiKsi0 * z.getZ(i));
                double dExp2Im = Math.sin(dTwoPiKsi0 * z.getZ(i));
                double dF0FExp2Re = dF0FRe * dExp2Re - dF0FIm * dExp2Im;
                double dF0FExp2Im = dF0FRe * dExp2Im + dF0FIm * dExp2Re;
                int n3 = i;
                adIntens[n3] = adIntens[n3] + 2.0 * ((dSubTotal2Re + 1.0) * dF0FExp2Re - dSubTotal2Im * dF0FExp2Im);
                double dSubTotal3Re = 0.0;
                double dSubTotal3Im = 0.0;
                int m = 1;
                while (m <= iNmax) {
                    dSubTotal3Re += distr.getContent(m) * Math.cos(dTwoPiKsi * (double)m * z.getZ(i));
                    dSubTotal3Im += distr.getContent(m) * Math.sin(dTwoPiKsi * (double)m * z.getZ(i));
                    ++m;
                }
                double dFFkRe = adFRe[i] * adFkRe[i] + adFIm[i] * adFkIm[i];
                double dFFkIm = adFRe[i] * adFkIm[i] - adFkRe[i] * adFIm[i];
                int n4 = i;
                adIntens[n4] = adIntens[n4] + 2.0 * ((dSubTotal2Re + dSubTotal3Re) * dFFkRe - (dSubTotal2Im + dSubTotal3Im) * dFFkIm);
                double dF0FkRe = adF0Re[i] * adFkRe[i] + adF0Im[i] * adFkIm[i];
                double dF0FkIm = adF0Re[i] * adFkIm[i] - adFkRe[i] * adF0Im[i];
                double dExp4Re = Math.cos(dTwoPiKsi0 * z.getZ(i));
                double dExp4Im = Math.sin(dTwoPiKsi0 * z.getZ(i));
                double dF0FkExp4Re = dF0FkRe * dExp4Re - dF0FkIm * dExp4Im;
                double dF0FkExp4Im = dF0FkRe * dExp4Im + dF0FkIm * dExp4Re;
                int n5 = i;
                adIntens[n5] = adIntens[n5] + 2.0 * (dF0FkExp4Re * dSubTotal3Re - dF0FkExp4Im * dSubTotal3Im);
                int n6 = i;
                adIntens[n6] = adIntens[n6] + (adF0Re[i] * adF0Re[i] + adF0Im[i] * adF0Im[i]);
                int n7 = i;
                adIntens[n7] = adIntens[n7] + (adFkRe[i] * adFkRe[i] + adFkIm[i] * adFkIm[i]);
                ++i;
            }
        } else {
            double dTwoPiSquareDeltaSquare = -19.739208802178716 * dDeltaDSpacing * dDeltaDSpacing;
            int i = 0;
            while (i < iNoOfData) {
                double dSubTotal1 = 0.0;
                int n = 1;
                while (n < iNmax) {
                    double dFactor = 0.0;
                    int m = n + 1;
                    while (m <= iNmax) {
                        dFactor += (double)(m - n) * distr.getContent(m);
                        ++m;
                    }
                    dSubTotal1 += dFactor * Math.cos(dTwoPiKsi * (double)n * z.getZ(i)) * Math.exp(dTwoPiSquareDeltaSquare * (double)n * z.getZ(i) * z.getZ(i));
                    ++n;
                }
                dSubTotal1 *= 2.0;
                adIntens[i] = (adFRe[i] * adFRe[i] + adFIm[i] * adFIm[i]) * (dSubTotal1 += dNmean);
                double dSubTotal2Re = 0.0;
                double dSubTotal2Im = 0.0;
                int n8 = 1;
                while (n8 < iNmax) {
                    double dFactor = 0.0;
                    int m = n8 + 1;
                    while (m <= iNmax) {
                        dFactor += distr.getContent(m);
                        ++m;
                    }
                    double dDSpacingDeltaTerm = Math.exp(dTwoPiSquareDeltaSquare * (double)n8 * z.getZ(i) * z.getZ(i));
                    dSubTotal2Re += dFactor * dDSpacingDeltaTerm * Math.cos(dTwoPiKsi * (double)n8 * z.getZ(i));
                    dSubTotal2Im += dFactor * dDSpacingDeltaTerm * Math.sin(dTwoPiKsi * (double)n8 * z.getZ(i));
                    ++n8;
                }
                double dF0FRe = adF0Re[i] * adFRe[i] + adF0Im[i] * adFIm[i];
                double dF0FIm = adF0Re[i] * adFIm[i] - adFRe[i] * adF0Im[i];
                double dExp2Re = Math.cos(dTwoPiKsi0 * z.getZ(i));
                double dExp2Im = Math.sin(dTwoPiKsi0 * z.getZ(i));
                double dF0FExp2Re = dF0FRe * dExp2Re - dF0FIm * dExp2Im;
                double dF0FExp2Im = dF0FRe * dExp2Im + dF0FIm * dExp2Re;
                int n9 = i;
                adIntens[n9] = adIntens[n9] + 2.0 * ((dSubTotal2Re + 1.0) * dF0FExp2Re - dSubTotal2Im * dF0FExp2Im);
                double dSubTotal3Re = 0.0;
                double dSubTotal3Im = 0.0;
                int m = 1;
                while (m <= iNmax) {
                    double dDSpacingDeltaTerm = Math.exp(dTwoPiSquareDeltaSquare * (double)m * z.getZ(i) * z.getZ(i));
                    dSubTotal3Re += distr.getContent(m) * dDSpacingDeltaTerm * Math.cos(dTwoPiKsi * (double)m * z.getZ(i));
                    dSubTotal3Im += distr.getContent(m) * dDSpacingDeltaTerm * Math.sin(dTwoPiKsi * (double)m * z.getZ(i));
                    ++m;
                }
                double dFFkRe = adFRe[i] * adFkRe[i] + adFIm[i] * adFkIm[i];
                double dFFkIm = adFRe[i] * adFkIm[i] - adFkRe[i] * adFIm[i];
                int n10 = i;
                adIntens[n10] = adIntens[n10] + 2.0 * ((dSubTotal2Re + dSubTotal3Re) * dFFkRe - (dSubTotal2Im + dSubTotal3Im) * dFFkIm);
                double dF0FkRe = adF0Re[i] * adFkRe[i] + adF0Im[i] * adFkIm[i];
                double dF0FkIm = adF0Re[i] * adFkIm[i] - adFkRe[i] * adF0Im[i];
                double dExp4Re = Math.cos(dTwoPiKsi0 * z.getZ(i));
                double dExp4Im = Math.sin(dTwoPiKsi0 * z.getZ(i));
                double dF0FkExp4Re = dF0FkRe * dExp4Re - dF0FkIm * dExp4Im;
                double dF0FkExp4Im = dF0FkRe * dExp4Im + dF0FkIm * dExp4Re;
                int n11 = i;
                adIntens[n11] = adIntens[n11] + 2.0 * (dF0FkExp4Re * dSubTotal3Re - dF0FkExp4Im * dSubTotal3Im);
                int n12 = i;
                adIntens[n12] = adIntens[n12] + (adF0Re[i] * adF0Re[i] + adF0Im[i] * adF0Im[i]);
                int n13 = i;
                adIntens[n13] = adIntens[n13] + (adFkRe[i] * adFkRe[i] + adFkIm[i] * adFkIm[i]);
                ++i;
            }
        }
    }
}

