/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.equation;

import java.io.Serializable;
import java.util.Arrays;

public abstract class Equation
implements Serializable {
    private static final long serialVersionUID = 7796637953705670309L;
    private double[][] _adPowTempRe = null;
    private double[][] _adPowTempIm = null;

    protected void mult(double[][] adA, double[][] adB, double[][] adC) {
        assert (adA.length == adC.length);
        assert (adA.length == adB.length);
        assert (adA[0].length == adC[0].length);
        assert (adA[0].length == adB[0].length);
        int iRows = adC.length;
        int iCols = adC[0].length;
        int iBRows = adB.length;
        int i = 0;
        while (i < iRows) {
            int j = 0;
            while (j < iCols) {
                double dTotal = 0.0;
                int k = 0;
                while (k < iBRows) {
                    dTotal += adA[i][k] * adB[k][j];
                    ++k;
                }
                adC[i][j] = dTotal;
                ++j;
            }
            ++i;
        }
    }

    protected void mult(double[][] adARe, double[][] adAIm, double[][] adBRe, double[][] adBIm, double[][] adCRe, double[][] adCIm) {
        assert (adARe.length == adCRe.length);
        assert (adARe.length == adBRe.length);
        assert (adARe[0].length == adCRe[0].length);
        assert (adARe[0].length == adBRe[0].length);
        assert (adAIm.length == adCIm.length);
        assert (adAIm.length == adBIm.length);
        assert (adAIm[0].length == adCIm[0].length);
        assert (adAIm[0].length == adBIm[0].length);
        int iRows = adCRe.length;
        int iCols = adCRe[0].length;
        int iBRows = adBRe.length;
        int i = 0;
        while (i < iRows) {
            int j = 0;
            while (j < iCols) {
                double dTotalRe = 0.0;
                double dTotalIm = 0.0;
                int k = 0;
                while (k < iBRows) {
                    dTotalRe += adARe[i][k] * adBRe[k][j] - adAIm[i][k] * adBIm[k][j];
                    dTotalIm += adARe[i][k] * adBIm[k][j] + adAIm[i][k] * adBRe[k][j];
                    ++k;
                }
                adCRe[i][j] = dTotalRe;
                adCIm[i][j] = dTotalIm;
                ++j;
            }
            ++i;
        }
    }

    protected void mult(double[][] adA, double dB) {
        int iRows = adA.length;
        int iCols = adA[0].length;
        int r = 0;
        while (r < iRows) {
            int c = 0;
            while (c < iCols) {
                double[] dArray = adA[r];
                int n = c++;
                dArray[n] = dArray[n] * dB;
            }
            ++r;
        }
    }

    protected void mult(double[][] adARe, double[][] adAIm, double dB) {
        assert (adARe.length == adAIm.length);
        assert (adARe[0].length == adAIm[0].length);
        int iRows = adARe.length;
        int iCols = adARe[0].length;
        if (dB != 1.0) {
            int r = 0;
            while (r < iRows) {
                int c = 0;
                while (c < iCols) {
                    double[] dArray = adARe[r];
                    int n = c;
                    dArray[n] = dArray[n] * dB;
                    double[] dArray2 = adAIm[r];
                    int n2 = c++;
                    dArray2[n2] = dArray2[n2] * dB;
                }
                ++r;
            }
        }
    }

    protected void mult(double[][] adARe, double[][] adAIm, double dB, double[][] adCRe, double[][] adCIm) {
        assert (adARe.length == adAIm.length);
        assert (adARe.length == adCRe.length);
        assert (adARe[0].length == adAIm[0].length);
        assert (adARe[0].length == adCIm[0].length);
        int iRows = adARe.length;
        int iCols = adARe[0].length;
        switch (iRows) {
            case 2: {
                adCRe[0][0] = dB * adARe[0][0];
                adCRe[0][1] = dB * adARe[0][1];
                adCRe[1][0] = dB * adARe[1][0];
                adCRe[1][1] = dB * adARe[1][1];
                adCIm[0][0] = dB * adAIm[0][0];
                adCIm[0][1] = dB * adAIm[0][1];
                adCIm[1][0] = dB * adAIm[1][0];
                adCIm[1][1] = dB * adAIm[1][1];
                break;
            }
            case 3: {
                adCRe[0][0] = dB * adARe[0][0];
                adCRe[0][1] = dB * adARe[0][1];
                adCRe[0][2] = dB * adARe[0][2];
                adCRe[1][0] = dB * adARe[1][0];
                adCRe[1][1] = dB * adARe[1][1];
                adCRe[1][2] = dB * adARe[1][2];
                adCRe[2][0] = dB * adARe[2][0];
                adCRe[2][1] = dB * adARe[2][1];
                adCRe[2][2] = dB * adARe[2][2];
                adCIm[0][0] = dB * adAIm[0][0];
                adCIm[0][1] = dB * adAIm[0][1];
                adCIm[0][2] = dB * adAIm[0][2];
                adCIm[1][0] = dB * adAIm[1][0];
                adCIm[1][1] = dB * adAIm[1][1];
                adCIm[1][2] = dB * adAIm[1][2];
                adCIm[2][0] = dB * adAIm[2][0];
                adCIm[2][1] = dB * adAIm[2][1];
                adCIm[2][2] = dB * adAIm[2][2];
                break;
            }
            case 4: {
                adCRe[0][0] = dB * adARe[0][0];
                adCRe[0][1] = dB * adARe[0][1];
                adCRe[0][2] = dB * adARe[0][2];
                adCRe[0][3] = dB * adARe[0][3];
                adCRe[1][0] = dB * adARe[1][0];
                adCRe[1][1] = dB * adARe[1][1];
                adCRe[1][2] = dB * adARe[1][2];
                adCRe[1][3] = dB * adARe[1][3];
                adCRe[2][0] = dB * adARe[2][0];
                adCRe[2][1] = dB * adARe[2][1];
                adCRe[2][2] = dB * adARe[2][2];
                adCRe[2][3] = dB * adARe[2][3];
                adCRe[3][0] = dB * adARe[3][0];
                adCRe[3][1] = dB * adARe[3][1];
                adCRe[3][2] = dB * adARe[3][2];
                adCRe[3][3] = dB * adARe[3][3];
                adCIm[0][0] = dB * adAIm[0][0];
                adCIm[0][1] = dB * adAIm[0][1];
                adCIm[0][2] = dB * adAIm[0][2];
                adCIm[0][3] = dB * adAIm[0][3];
                adCIm[1][0] = dB * adAIm[1][0];
                adCIm[1][1] = dB * adAIm[1][1];
                adCIm[1][2] = dB * adAIm[1][2];
                adCIm[1][3] = dB * adAIm[1][3];
                adCIm[2][0] = dB * adAIm[2][0];
                adCIm[2][1] = dB * adAIm[2][1];
                adCIm[2][2] = dB * adAIm[2][2];
                adCIm[2][3] = dB * adAIm[2][3];
                adCIm[3][0] = dB * adAIm[3][0];
                adCIm[3][1] = dB * adAIm[3][1];
                adCIm[3][2] = dB * adAIm[3][2];
                adCIm[3][3] = dB * adAIm[3][3];
                break;
            }
            case 8: {
                adCRe[0][0] = dB * adARe[0][0];
                adCRe[0][1] = dB * adARe[0][1];
                adCRe[0][2] = dB * adARe[0][2];
                adCRe[0][3] = dB * adARe[0][3];
                adCRe[0][4] = dB * adARe[0][4];
                adCRe[0][5] = dB * adARe[0][5];
                adCRe[0][6] = dB * adARe[0][6];
                adCRe[0][7] = dB * adARe[0][7];
                adCRe[1][0] = dB * adARe[1][0];
                adCRe[1][1] = dB * adARe[1][1];
                adCRe[1][2] = dB * adARe[1][2];
                adCRe[1][3] = dB * adARe[1][3];
                adCRe[1][4] = dB * adARe[1][4];
                adCRe[1][5] = dB * adARe[1][5];
                adCRe[1][6] = dB * adARe[1][6];
                adCRe[1][7] = dB * adARe[1][7];
                adCRe[2][0] = dB * adARe[2][0];
                adCRe[2][1] = dB * adARe[2][1];
                adCRe[2][2] = dB * adARe[2][2];
                adCRe[2][3] = dB * adARe[2][3];
                adCRe[2][4] = dB * adARe[2][4];
                adCRe[2][5] = dB * adARe[2][5];
                adCRe[2][6] = dB * adARe[2][6];
                adCRe[2][7] = dB * adARe[2][7];
                adCRe[3][0] = dB * adARe[3][0];
                adCRe[3][1] = dB * adARe[3][1];
                adCRe[3][2] = dB * adARe[3][2];
                adCRe[3][3] = dB * adARe[3][3];
                adCRe[3][4] = dB * adARe[3][4];
                adCRe[3][5] = dB * adARe[3][5];
                adCRe[3][6] = dB * adARe[3][6];
                adCRe[3][7] = dB * adARe[3][7];
                adCRe[4][0] = dB * adARe[4][0];
                adCRe[4][1] = dB * adARe[4][1];
                adCRe[4][2] = dB * adARe[4][2];
                adCRe[4][3] = dB * adARe[4][3];
                adCRe[4][4] = dB * adARe[4][4];
                adCRe[4][5] = dB * adARe[4][5];
                adCRe[4][6] = dB * adARe[4][6];
                adCRe[4][7] = dB * adARe[4][7];
                adCRe[5][0] = dB * adARe[5][0];
                adCRe[5][1] = dB * adARe[5][1];
                adCRe[5][2] = dB * adARe[5][2];
                adCRe[5][3] = dB * adARe[5][3];
                adCRe[5][4] = dB * adARe[5][4];
                adCRe[5][5] = dB * adARe[5][5];
                adCRe[5][6] = dB * adARe[5][6];
                adCRe[5][7] = dB * adARe[5][7];
                adCRe[6][0] = dB * adARe[6][0];
                adCRe[6][1] = dB * adARe[6][1];
                adCRe[6][2] = dB * adARe[6][2];
                adCRe[6][3] = dB * adARe[6][3];
                adCRe[6][4] = dB * adARe[6][4];
                adCRe[6][5] = dB * adARe[6][5];
                adCRe[6][6] = dB * adARe[6][6];
                adCRe[6][7] = dB * adARe[6][7];
                adCRe[7][0] = dB * adARe[7][0];
                adCRe[7][1] = dB * adARe[7][1];
                adCRe[7][2] = dB * adARe[7][2];
                adCRe[7][3] = dB * adARe[7][3];
                adCRe[7][4] = dB * adARe[7][4];
                adCRe[7][5] = dB * adARe[7][5];
                adCRe[7][6] = dB * adARe[7][6];
                adCRe[7][7] = dB * adARe[7][7];
                adCIm[0][0] = dB * adAIm[0][0];
                adCIm[0][1] = dB * adAIm[0][1];
                adCIm[0][2] = dB * adAIm[0][2];
                adCIm[0][3] = dB * adAIm[0][3];
                adCIm[0][4] = dB * adAIm[0][4];
                adCIm[0][5] = dB * adAIm[0][5];
                adCIm[0][6] = dB * adAIm[0][6];
                adCIm[0][7] = dB * adAIm[0][7];
                adCIm[1][0] = dB * adAIm[1][0];
                adCIm[1][1] = dB * adAIm[1][1];
                adCIm[1][2] = dB * adAIm[1][2];
                adCIm[1][3] = dB * adAIm[1][3];
                adCIm[1][4] = dB * adAIm[1][4];
                adCIm[1][5] = dB * adAIm[1][5];
                adCIm[1][6] = dB * adAIm[1][6];
                adCIm[1][7] = dB * adAIm[1][7];
                adCIm[2][0] = dB * adAIm[2][0];
                adCIm[2][1] = dB * adAIm[2][1];
                adCIm[2][2] = dB * adAIm[2][2];
                adCIm[2][3] = dB * adAIm[2][3];
                adCIm[2][4] = dB * adAIm[2][4];
                adCIm[2][5] = dB * adAIm[2][5];
                adCIm[2][6] = dB * adAIm[2][6];
                adCIm[2][7] = dB * adAIm[2][7];
                adCIm[3][0] = dB * adAIm[3][0];
                adCIm[3][1] = dB * adAIm[3][1];
                adCIm[3][2] = dB * adAIm[3][2];
                adCIm[3][3] = dB * adAIm[3][3];
                adCIm[3][4] = dB * adAIm[3][4];
                adCIm[3][5] = dB * adAIm[3][5];
                adCIm[3][6] = dB * adAIm[3][6];
                adCIm[3][7] = dB * adAIm[3][7];
                adCIm[4][0] = dB * adAIm[4][0];
                adCIm[4][1] = dB * adAIm[4][1];
                adCIm[4][2] = dB * adAIm[4][2];
                adCIm[4][3] = dB * adAIm[4][3];
                adCIm[4][4] = dB * adAIm[4][4];
                adCIm[4][5] = dB * adAIm[4][5];
                adCIm[4][6] = dB * adAIm[4][6];
                adCIm[4][7] = dB * adAIm[4][7];
                adCIm[5][0] = dB * adAIm[5][0];
                adCIm[5][1] = dB * adAIm[5][1];
                adCIm[5][2] = dB * adAIm[5][2];
                adCIm[5][3] = dB * adAIm[5][3];
                adCIm[5][4] = dB * adAIm[5][4];
                adCIm[5][5] = dB * adAIm[5][5];
                adCIm[5][6] = dB * adAIm[5][6];
                adCIm[5][7] = dB * adAIm[5][7];
                adCIm[6][0] = dB * adAIm[6][0];
                adCIm[6][1] = dB * adAIm[6][1];
                adCIm[6][2] = dB * adAIm[6][2];
                adCIm[6][3] = dB * adAIm[6][3];
                adCIm[6][4] = dB * adAIm[6][4];
                adCIm[6][5] = dB * adAIm[6][5];
                adCIm[6][6] = dB * adAIm[6][6];
                adCIm[6][7] = dB * adAIm[6][7];
                adCIm[7][0] = dB * adAIm[7][0];
                adCIm[7][1] = dB * adAIm[7][1];
                adCIm[7][2] = dB * adAIm[7][2];
                adCIm[7][3] = dB * adAIm[7][3];
                adCIm[7][4] = dB * adAIm[7][4];
                adCIm[7][5] = dB * adAIm[7][5];
                adCIm[7][6] = dB * adAIm[7][6];
                adCIm[7][7] = dB * adAIm[7][7];
                break;
            }
            case 9: {
                adCRe[0][0] = dB * adARe[0][0];
                adCRe[0][1] = dB * adARe[0][1];
                adCRe[0][2] = dB * adARe[0][2];
                adCRe[0][3] = dB * adARe[0][3];
                adCRe[0][4] = dB * adARe[0][4];
                adCRe[0][5] = dB * adARe[0][5];
                adCRe[0][6] = dB * adARe[0][6];
                adCRe[0][7] = dB * adARe[0][7];
                adCRe[0][8] = dB * adARe[0][8];
                adCRe[1][0] = dB * adARe[1][0];
                adCRe[1][1] = dB * adARe[1][1];
                adCRe[1][2] = dB * adARe[1][2];
                adCRe[1][3] = dB * adARe[1][3];
                adCRe[1][4] = dB * adARe[1][4];
                adCRe[1][5] = dB * adARe[1][5];
                adCRe[1][6] = dB * adARe[1][6];
                adCRe[1][7] = dB * adARe[1][7];
                adCRe[1][8] = dB * adARe[1][8];
                adCRe[2][0] = dB * adARe[2][0];
                adCRe[2][1] = dB * adARe[2][1];
                adCRe[2][2] = dB * adARe[2][2];
                adCRe[2][3] = dB * adARe[2][3];
                adCRe[2][4] = dB * adARe[2][4];
                adCRe[2][5] = dB * adARe[2][5];
                adCRe[2][6] = dB * adARe[2][6];
                adCRe[2][7] = dB * adARe[2][7];
                adCRe[2][8] = dB * adARe[2][8];
                adCRe[3][0] = dB * adARe[3][0];
                adCRe[3][1] = dB * adARe[3][1];
                adCRe[3][2] = dB * adARe[3][2];
                adCRe[3][3] = dB * adARe[3][3];
                adCRe[3][4] = dB * adARe[3][4];
                adCRe[3][5] = dB * adARe[3][5];
                adCRe[3][6] = dB * adARe[3][6];
                adCRe[3][7] = dB * adARe[3][7];
                adCRe[3][8] = dB * adARe[3][8];
                adCRe[4][0] = dB * adARe[4][0];
                adCRe[4][1] = dB * adARe[4][1];
                adCRe[4][2] = dB * adARe[4][2];
                adCRe[4][3] = dB * adARe[4][3];
                adCRe[4][4] = dB * adARe[4][4];
                adCRe[4][5] = dB * adARe[4][5];
                adCRe[4][6] = dB * adARe[4][6];
                adCRe[4][7] = dB * adARe[4][7];
                adCRe[4][8] = dB * adARe[4][8];
                adCRe[5][0] = dB * adARe[5][0];
                adCRe[5][1] = dB * adARe[5][1];
                adCRe[5][2] = dB * adARe[5][2];
                adCRe[5][3] = dB * adARe[5][3];
                adCRe[5][4] = dB * adARe[5][4];
                adCRe[5][5] = dB * adARe[5][5];
                adCRe[5][6] = dB * adARe[5][6];
                adCRe[5][7] = dB * adARe[5][7];
                adCRe[5][8] = dB * adARe[5][8];
                adCRe[6][0] = dB * adARe[6][0];
                adCRe[6][1] = dB * adARe[6][1];
                adCRe[6][2] = dB * adARe[6][2];
                adCRe[6][3] = dB * adARe[6][3];
                adCRe[6][4] = dB * adARe[6][4];
                adCRe[6][5] = dB * adARe[6][5];
                adCRe[6][6] = dB * adARe[6][6];
                adCRe[6][7] = dB * adARe[6][7];
                adCRe[6][8] = dB * adARe[6][8];
                adCRe[7][0] = dB * adARe[7][0];
                adCRe[7][1] = dB * adARe[7][1];
                adCRe[7][2] = dB * adARe[7][2];
                adCRe[7][3] = dB * adARe[7][3];
                adCRe[7][4] = dB * adARe[7][4];
                adCRe[7][5] = dB * adARe[7][5];
                adCRe[7][6] = dB * adARe[7][6];
                adCRe[7][7] = dB * adARe[7][7];
                adCRe[7][8] = dB * adARe[7][8];
                adCRe[8][0] = dB * adARe[8][0];
                adCRe[8][1] = dB * adARe[8][1];
                adCRe[8][2] = dB * adARe[8][2];
                adCRe[8][3] = dB * adARe[8][3];
                adCRe[8][4] = dB * adARe[8][4];
                adCRe[8][5] = dB * adARe[8][5];
                adCRe[8][6] = dB * adARe[8][6];
                adCRe[8][7] = dB * adARe[8][7];
                adCRe[8][8] = dB * adARe[8][8];
                adCIm[0][0] = dB * adAIm[0][0];
                adCIm[0][1] = dB * adAIm[0][1];
                adCIm[0][2] = dB * adAIm[0][2];
                adCIm[0][3] = dB * adAIm[0][3];
                adCIm[0][4] = dB * adAIm[0][4];
                adCIm[0][5] = dB * adAIm[0][5];
                adCIm[0][6] = dB * adAIm[0][6];
                adCIm[0][7] = dB * adAIm[0][7];
                adCIm[0][8] = dB * adAIm[0][8];
                adCIm[1][0] = dB * adAIm[1][0];
                adCIm[1][1] = dB * adAIm[1][1];
                adCIm[1][2] = dB * adAIm[1][2];
                adCIm[1][3] = dB * adAIm[1][3];
                adCIm[1][4] = dB * adAIm[1][4];
                adCIm[1][5] = dB * adAIm[1][5];
                adCIm[1][6] = dB * adAIm[1][6];
                adCIm[1][7] = dB * adAIm[1][7];
                adCIm[1][8] = dB * adAIm[1][8];
                adCIm[2][0] = dB * adAIm[2][0];
                adCIm[2][1] = dB * adAIm[2][1];
                adCIm[2][2] = dB * adAIm[2][2];
                adCIm[2][3] = dB * adAIm[2][3];
                adCIm[2][4] = dB * adAIm[2][4];
                adCIm[2][5] = dB * adAIm[2][5];
                adCIm[2][6] = dB * adAIm[2][6];
                adCIm[2][7] = dB * adAIm[2][7];
                adCIm[2][8] = dB * adAIm[2][8];
                adCIm[3][0] = dB * adAIm[3][0];
                adCIm[3][1] = dB * adAIm[3][1];
                adCIm[3][2] = dB * adAIm[3][2];
                adCIm[3][3] = dB * adAIm[3][3];
                adCIm[3][4] = dB * adAIm[3][4];
                adCIm[3][5] = dB * adAIm[3][5];
                adCIm[3][6] = dB * adAIm[3][6];
                adCIm[3][7] = dB * adAIm[3][7];
                adCIm[3][8] = dB * adAIm[3][8];
                adCIm[4][0] = dB * adAIm[4][0];
                adCIm[4][1] = dB * adAIm[4][1];
                adCIm[4][2] = dB * adAIm[4][2];
                adCIm[4][3] = dB * adAIm[4][3];
                adCIm[4][4] = dB * adAIm[4][4];
                adCIm[4][5] = dB * adAIm[4][5];
                adCIm[4][6] = dB * adAIm[4][6];
                adCIm[4][7] = dB * adAIm[4][7];
                adCIm[4][8] = dB * adAIm[4][8];
                adCIm[5][0] = dB * adAIm[5][0];
                adCIm[5][1] = dB * adAIm[5][1];
                adCIm[5][2] = dB * adAIm[5][2];
                adCIm[5][3] = dB * adAIm[5][3];
                adCIm[5][4] = dB * adAIm[5][4];
                adCIm[5][5] = dB * adAIm[5][5];
                adCIm[5][6] = dB * adAIm[5][6];
                adCIm[5][7] = dB * adAIm[5][7];
                adCIm[5][8] = dB * adAIm[5][8];
                adCIm[6][0] = dB * adAIm[6][0];
                adCIm[6][1] = dB * adAIm[6][1];
                adCIm[6][2] = dB * adAIm[6][2];
                adCIm[6][3] = dB * adAIm[6][3];
                adCIm[6][4] = dB * adAIm[6][4];
                adCIm[6][5] = dB * adAIm[6][5];
                adCIm[6][6] = dB * adAIm[6][6];
                adCIm[6][7] = dB * adAIm[6][7];
                adCIm[6][8] = dB * adAIm[6][8];
                adCIm[7][0] = dB * adAIm[7][0];
                adCIm[7][1] = dB * adAIm[7][1];
                adCIm[7][2] = dB * adAIm[7][2];
                adCIm[7][3] = dB * adAIm[7][3];
                adCIm[7][4] = dB * adAIm[7][4];
                adCIm[7][5] = dB * adAIm[7][5];
                adCIm[7][6] = dB * adAIm[7][6];
                adCIm[7][7] = dB * adAIm[7][7];
                adCIm[7][8] = dB * adAIm[7][8];
                adCIm[8][0] = dB * adAIm[8][0];
                adCIm[8][1] = dB * adAIm[8][1];
                adCIm[8][2] = dB * adAIm[8][2];
                adCIm[8][3] = dB * adAIm[8][3];
                adCIm[8][4] = dB * adAIm[8][4];
                adCIm[8][5] = dB * adAIm[8][5];
                adCIm[8][6] = dB * adAIm[8][6];
                adCIm[8][7] = dB * adAIm[8][7];
                adCIm[8][8] = dB * adAIm[8][8];
                break;
            }
            default: {
                int r = 0;
                while (r < iRows) {
                    int c = 0;
                    while (c < iCols) {
                        adCRe[r][c] = dB * adARe[r][c];
                        adCIm[r][c] = dB * adAIm[r][c];
                        ++c;
                    }
                    ++r;
                }
                break block0;
            }
        }
    }

    protected void add(double[][] adA, double[][] adB) {
        assert (adA.length == adB.length);
        assert (adA[0].length == adB[0].length);
        int iRows = adA.length;
        int iCols = adA[0].length;
        int i = 0;
        while (i < iRows) {
            int j = 0;
            while (j < iCols) {
                double[] dArray = adA[i];
                int n = j;
                dArray[n] = dArray[n] + adB[i][j];
                ++j;
            }
            ++i;
        }
    }

    protected void add(double[][] adA, double[][] adB, double[][] adC) {
        assert (adA.length == adB.length);
        assert (adA[0].length == adB[0].length);
        assert (adA.length == adC.length);
        assert (adA[0].length == adC[0].length);
        int iRows = adA.length;
        int iCols = adA[0].length;
        int i = 0;
        while (i < iRows) {
            int j = 0;
            while (j < iCols) {
                adC[i][j] = adA[i][j] + adB[i][j];
                ++j;
            }
            ++i;
        }
    }

    protected void add(double[][] adA, double[][] adB, double dFactor) {
        assert (adA.length == adB.length);
        assert (adA[0].length == adB[0].length);
        int iRows = adA.length;
        int iCols = adA[0].length;
        int i = 0;
        while (i < iRows) {
            int j = 0;
            while (j < iCols) {
                double[] dArray = adA[i];
                int n = j;
                dArray[n] = dArray[n] + dFactor * adB[i][j];
                ++j;
            }
            ++i;
        }
    }

    protected void addUnity(double[][] adA) {
        assert (adA.length == adA[0].length);
        int iRows = adA.length;
        int i = 0;
        while (i < iRows) {
            double[] dArray = adA[i];
            int n = i++;
            dArray[n] = dArray[n] + 1.0;
        }
    }

    protected void add(double[][] adARe, double[][] adAIm, double[][] adBRe, double[][] adBIm) {
        assert (adARe.length == adBRe.length);
        assert (adAIm.length == adBIm.length);
        assert (adARe[0].length == adBRe[0].length);
        assert (adAIm[0].length == adBIm[0].length);
        int iRows = adARe.length;
        int iCols = adARe[0].length;
        switch (iRows) {
            case 2: {
                double[] dArray = adARe[0];
                dArray[0] = dArray[0] + adBRe[0][0];
                double[] dArray2 = adARe[0];
                dArray2[1] = dArray2[1] + adBRe[0][1];
                double[] dArray3 = adARe[1];
                dArray3[0] = dArray3[0] + adBRe[1][0];
                double[] dArray4 = adARe[1];
                dArray4[1] = dArray4[1] + adBRe[1][1];
                double[] dArray5 = adAIm[0];
                dArray5[0] = dArray5[0] + adBIm[0][0];
                double[] dArray6 = adAIm[0];
                dArray6[1] = dArray6[1] + adBIm[0][1];
                double[] dArray7 = adAIm[1];
                dArray7[0] = dArray7[0] + adBIm[1][0];
                double[] dArray8 = adAIm[1];
                dArray8[1] = dArray8[1] + adBIm[1][1];
                break;
            }
            case 3: {
                double[] dArray = adARe[0];
                dArray[0] = dArray[0] + adBRe[0][0];
                double[] dArray9 = adARe[0];
                dArray9[1] = dArray9[1] + adBRe[0][1];
                double[] dArray10 = adARe[0];
                dArray10[2] = dArray10[2] + adBRe[0][2];
                double[] dArray11 = adARe[1];
                dArray11[0] = dArray11[0] + adBRe[1][0];
                double[] dArray12 = adARe[1];
                dArray12[1] = dArray12[1] + adBRe[1][1];
                double[] dArray13 = adARe[1];
                dArray13[2] = dArray13[2] + adBRe[1][2];
                double[] dArray14 = adARe[2];
                dArray14[0] = dArray14[0] + adBRe[2][0];
                double[] dArray15 = adARe[2];
                dArray15[1] = dArray15[1] + adBRe[2][1];
                double[] dArray16 = adARe[2];
                dArray16[2] = dArray16[2] + adBRe[2][2];
                double[] dArray17 = adAIm[0];
                dArray17[0] = dArray17[0] + adBIm[0][0];
                double[] dArray18 = adAIm[0];
                dArray18[1] = dArray18[1] + adBIm[0][1];
                double[] dArray19 = adAIm[0];
                dArray19[2] = dArray19[2] + adBIm[0][2];
                double[] dArray20 = adAIm[1];
                dArray20[0] = dArray20[0] + adBIm[1][0];
                double[] dArray21 = adAIm[1];
                dArray21[1] = dArray21[1] + adBIm[1][1];
                double[] dArray22 = adAIm[1];
                dArray22[2] = dArray22[2] + adBIm[1][2];
                double[] dArray23 = adAIm[2];
                dArray23[0] = dArray23[0] + adBIm[2][0];
                double[] dArray24 = adAIm[2];
                dArray24[1] = dArray24[1] + adBIm[2][1];
                double[] dArray25 = adAIm[2];
                dArray25[2] = dArray25[2] + adBIm[2][2];
                break;
            }
            case 4: {
                double[] dArray = adARe[0];
                dArray[0] = dArray[0] + adBRe[0][0];
                double[] dArray26 = adARe[0];
                dArray26[1] = dArray26[1] + adBRe[0][1];
                double[] dArray27 = adARe[0];
                dArray27[2] = dArray27[2] + adBRe[0][2];
                double[] dArray28 = adARe[0];
                dArray28[3] = dArray28[3] + adBRe[0][3];
                double[] dArray29 = adARe[1];
                dArray29[0] = dArray29[0] + adBRe[1][0];
                double[] dArray30 = adARe[1];
                dArray30[1] = dArray30[1] + adBRe[1][1];
                double[] dArray31 = adARe[1];
                dArray31[2] = dArray31[2] + adBRe[1][2];
                double[] dArray32 = adARe[1];
                dArray32[3] = dArray32[3] + adBRe[1][3];
                double[] dArray33 = adARe[2];
                dArray33[0] = dArray33[0] + adBRe[2][0];
                double[] dArray34 = adARe[2];
                dArray34[1] = dArray34[1] + adBRe[2][1];
                double[] dArray35 = adARe[2];
                dArray35[2] = dArray35[2] + adBRe[2][2];
                double[] dArray36 = adARe[2];
                dArray36[3] = dArray36[3] + adBRe[2][3];
                double[] dArray37 = adARe[3];
                dArray37[0] = dArray37[0] + adBRe[3][0];
                double[] dArray38 = adARe[3];
                dArray38[1] = dArray38[1] + adBRe[3][1];
                double[] dArray39 = adARe[3];
                dArray39[2] = dArray39[2] + adBRe[3][2];
                double[] dArray40 = adARe[3];
                dArray40[3] = dArray40[3] + adBRe[3][3];
                double[] dArray41 = adAIm[0];
                dArray41[0] = dArray41[0] + adBIm[0][0];
                double[] dArray42 = adAIm[0];
                dArray42[1] = dArray42[1] + adBIm[0][1];
                double[] dArray43 = adAIm[0];
                dArray43[2] = dArray43[2] + adBIm[0][2];
                double[] dArray44 = adAIm[0];
                dArray44[3] = dArray44[3] + adBIm[0][3];
                double[] dArray45 = adAIm[1];
                dArray45[0] = dArray45[0] + adBIm[1][0];
                double[] dArray46 = adAIm[1];
                dArray46[1] = dArray46[1] + adBIm[1][1];
                double[] dArray47 = adAIm[1];
                dArray47[2] = dArray47[2] + adBIm[1][2];
                double[] dArray48 = adAIm[1];
                dArray48[3] = dArray48[3] + adBIm[1][3];
                double[] dArray49 = adAIm[2];
                dArray49[0] = dArray49[0] + adBIm[2][0];
                double[] dArray50 = adAIm[2];
                dArray50[1] = dArray50[1] + adBIm[2][1];
                double[] dArray51 = adAIm[2];
                dArray51[2] = dArray51[2] + adBIm[2][2];
                double[] dArray52 = adAIm[2];
                dArray52[3] = dArray52[3] + adBIm[2][3];
                double[] dArray53 = adAIm[3];
                dArray53[0] = dArray53[0] + adBIm[3][0];
                double[] dArray54 = adAIm[3];
                dArray54[1] = dArray54[1] + adBIm[3][1];
                double[] dArray55 = adAIm[3];
                dArray55[2] = dArray55[2] + adBIm[3][2];
                double[] dArray56 = adAIm[3];
                dArray56[3] = dArray56[3] + adBIm[3][3];
                break;
            }
            case 8: {
                double[] dArray = adARe[0];
                dArray[0] = dArray[0] + adBRe[0][0];
                double[] dArray57 = adARe[0];
                dArray57[1] = dArray57[1] + adBRe[0][1];
                double[] dArray58 = adARe[0];
                dArray58[2] = dArray58[2] + adBRe[0][2];
                double[] dArray59 = adARe[0];
                dArray59[3] = dArray59[3] + adBRe[0][3];
                double[] dArray60 = adARe[0];
                dArray60[4] = dArray60[4] + adBRe[0][4];
                double[] dArray61 = adARe[0];
                dArray61[5] = dArray61[5] + adBRe[0][5];
                double[] dArray62 = adARe[0];
                dArray62[6] = dArray62[6] + adBRe[0][6];
                double[] dArray63 = adARe[0];
                dArray63[7] = dArray63[7] + adBRe[0][7];
                double[] dArray64 = adARe[1];
                dArray64[0] = dArray64[0] + adBRe[1][0];
                double[] dArray65 = adARe[1];
                dArray65[1] = dArray65[1] + adBRe[1][1];
                double[] dArray66 = adARe[1];
                dArray66[2] = dArray66[2] + adBRe[1][2];
                double[] dArray67 = adARe[1];
                dArray67[3] = dArray67[3] + adBRe[1][3];
                double[] dArray68 = adARe[1];
                dArray68[4] = dArray68[4] + adBRe[1][4];
                double[] dArray69 = adARe[1];
                dArray69[5] = dArray69[5] + adBRe[1][5];
                double[] dArray70 = adARe[1];
                dArray70[6] = dArray70[6] + adBRe[1][6];
                double[] dArray71 = adARe[1];
                dArray71[7] = dArray71[7] + adBRe[1][7];
                double[] dArray72 = adARe[2];
                dArray72[0] = dArray72[0] + adBRe[2][0];
                double[] dArray73 = adARe[2];
                dArray73[1] = dArray73[1] + adBRe[2][1];
                double[] dArray74 = adARe[2];
                dArray74[2] = dArray74[2] + adBRe[2][2];
                double[] dArray75 = adARe[2];
                dArray75[3] = dArray75[3] + adBRe[2][3];
                double[] dArray76 = adARe[2];
                dArray76[4] = dArray76[4] + adBRe[2][4];
                double[] dArray77 = adARe[2];
                dArray77[5] = dArray77[5] + adBRe[2][5];
                double[] dArray78 = adARe[2];
                dArray78[6] = dArray78[6] + adBRe[2][6];
                double[] dArray79 = adARe[2];
                dArray79[7] = dArray79[7] + adBRe[2][7];
                double[] dArray80 = adARe[3];
                dArray80[0] = dArray80[0] + adBRe[3][0];
                double[] dArray81 = adARe[3];
                dArray81[1] = dArray81[1] + adBRe[3][1];
                double[] dArray82 = adARe[3];
                dArray82[2] = dArray82[2] + adBRe[3][2];
                double[] dArray83 = adARe[3];
                dArray83[3] = dArray83[3] + adBRe[3][3];
                double[] dArray84 = adARe[3];
                dArray84[4] = dArray84[4] + adBRe[3][4];
                double[] dArray85 = adARe[3];
                dArray85[5] = dArray85[5] + adBRe[3][5];
                double[] dArray86 = adARe[3];
                dArray86[6] = dArray86[6] + adBRe[3][6];
                double[] dArray87 = adARe[3];
                dArray87[7] = dArray87[7] + adBRe[3][7];
                double[] dArray88 = adARe[4];
                dArray88[0] = dArray88[0] + adBRe[4][0];
                double[] dArray89 = adARe[4];
                dArray89[1] = dArray89[1] + adBRe[4][1];
                double[] dArray90 = adARe[4];
                dArray90[2] = dArray90[2] + adBRe[4][2];
                double[] dArray91 = adARe[4];
                dArray91[3] = dArray91[3] + adBRe[4][3];
                double[] dArray92 = adARe[4];
                dArray92[4] = dArray92[4] + adBRe[4][4];
                double[] dArray93 = adARe[4];
                dArray93[5] = dArray93[5] + adBRe[4][5];
                double[] dArray94 = adARe[4];
                dArray94[6] = dArray94[6] + adBRe[4][6];
                double[] dArray95 = adARe[4];
                dArray95[7] = dArray95[7] + adBRe[4][7];
                double[] dArray96 = adARe[5];
                dArray96[0] = dArray96[0] + adBRe[5][0];
                double[] dArray97 = adARe[5];
                dArray97[1] = dArray97[1] + adBRe[5][1];
                double[] dArray98 = adARe[5];
                dArray98[2] = dArray98[2] + adBRe[5][2];
                double[] dArray99 = adARe[5];
                dArray99[3] = dArray99[3] + adBRe[5][3];
                double[] dArray100 = adARe[5];
                dArray100[4] = dArray100[4] + adBRe[5][4];
                double[] dArray101 = adARe[5];
                dArray101[5] = dArray101[5] + adBRe[5][5];
                double[] dArray102 = adARe[5];
                dArray102[6] = dArray102[6] + adBRe[5][6];
                double[] dArray103 = adARe[5];
                dArray103[7] = dArray103[7] + adBRe[5][7];
                double[] dArray104 = adARe[6];
                dArray104[0] = dArray104[0] + adBRe[6][0];
                double[] dArray105 = adARe[6];
                dArray105[1] = dArray105[1] + adBRe[6][1];
                double[] dArray106 = adARe[6];
                dArray106[2] = dArray106[2] + adBRe[6][2];
                double[] dArray107 = adARe[6];
                dArray107[3] = dArray107[3] + adBRe[6][3];
                double[] dArray108 = adARe[6];
                dArray108[4] = dArray108[4] + adBRe[6][4];
                double[] dArray109 = adARe[6];
                dArray109[5] = dArray109[5] + adBRe[6][5];
                double[] dArray110 = adARe[6];
                dArray110[6] = dArray110[6] + adBRe[6][6];
                double[] dArray111 = adARe[6];
                dArray111[7] = dArray111[7] + adBRe[6][7];
                double[] dArray112 = adARe[7];
                dArray112[0] = dArray112[0] + adBRe[7][0];
                double[] dArray113 = adARe[7];
                dArray113[1] = dArray113[1] + adBRe[7][1];
                double[] dArray114 = adARe[7];
                dArray114[2] = dArray114[2] + adBRe[7][2];
                double[] dArray115 = adARe[7];
                dArray115[3] = dArray115[3] + adBRe[7][3];
                double[] dArray116 = adARe[7];
                dArray116[4] = dArray116[4] + adBRe[7][4];
                double[] dArray117 = adARe[7];
                dArray117[5] = dArray117[5] + adBRe[7][5];
                double[] dArray118 = adARe[7];
                dArray118[6] = dArray118[6] + adBRe[7][6];
                double[] dArray119 = adARe[7];
                dArray119[7] = dArray119[7] + adBRe[7][7];
                double[] dArray120 = adAIm[0];
                dArray120[0] = dArray120[0] + adBIm[0][0];
                double[] dArray121 = adAIm[0];
                dArray121[1] = dArray121[1] + adBIm[0][1];
                double[] dArray122 = adAIm[0];
                dArray122[2] = dArray122[2] + adBIm[0][2];
                double[] dArray123 = adAIm[0];
                dArray123[3] = dArray123[3] + adBIm[0][3];
                double[] dArray124 = adAIm[0];
                dArray124[4] = dArray124[4] + adBIm[0][4];
                double[] dArray125 = adAIm[0];
                dArray125[5] = dArray125[5] + adBIm[0][5];
                double[] dArray126 = adAIm[0];
                dArray126[6] = dArray126[6] + adBIm[0][6];
                double[] dArray127 = adAIm[0];
                dArray127[7] = dArray127[7] + adBIm[0][7];
                double[] dArray128 = adAIm[1];
                dArray128[0] = dArray128[0] + adBIm[1][0];
                double[] dArray129 = adAIm[1];
                dArray129[1] = dArray129[1] + adBIm[1][1];
                double[] dArray130 = adAIm[1];
                dArray130[2] = dArray130[2] + adBIm[1][2];
                double[] dArray131 = adAIm[1];
                dArray131[3] = dArray131[3] + adBIm[1][3];
                double[] dArray132 = adAIm[1];
                dArray132[4] = dArray132[4] + adBIm[1][4];
                double[] dArray133 = adAIm[1];
                dArray133[5] = dArray133[5] + adBIm[1][5];
                double[] dArray134 = adAIm[1];
                dArray134[6] = dArray134[6] + adBIm[1][6];
                double[] dArray135 = adAIm[1];
                dArray135[7] = dArray135[7] + adBIm[1][7];
                double[] dArray136 = adAIm[2];
                dArray136[0] = dArray136[0] + adBIm[2][0];
                double[] dArray137 = adAIm[2];
                dArray137[1] = dArray137[1] + adBIm[2][1];
                double[] dArray138 = adAIm[2];
                dArray138[2] = dArray138[2] + adBIm[2][2];
                double[] dArray139 = adAIm[2];
                dArray139[3] = dArray139[3] + adBIm[2][3];
                double[] dArray140 = adAIm[2];
                dArray140[4] = dArray140[4] + adBIm[2][4];
                double[] dArray141 = adAIm[2];
                dArray141[5] = dArray141[5] + adBIm[2][5];
                double[] dArray142 = adAIm[2];
                dArray142[6] = dArray142[6] + adBIm[2][6];
                double[] dArray143 = adAIm[2];
                dArray143[7] = dArray143[7] + adBIm[2][7];
                double[] dArray144 = adAIm[3];
                dArray144[0] = dArray144[0] + adBIm[3][0];
                double[] dArray145 = adAIm[3];
                dArray145[1] = dArray145[1] + adBIm[3][1];
                double[] dArray146 = adAIm[3];
                dArray146[2] = dArray146[2] + adBIm[3][2];
                double[] dArray147 = adAIm[3];
                dArray147[3] = dArray147[3] + adBIm[3][3];
                double[] dArray148 = adAIm[3];
                dArray148[4] = dArray148[4] + adBIm[3][4];
                double[] dArray149 = adAIm[3];
                dArray149[5] = dArray149[5] + adBIm[3][5];
                double[] dArray150 = adAIm[3];
                dArray150[6] = dArray150[6] + adBIm[3][6];
                double[] dArray151 = adAIm[3];
                dArray151[7] = dArray151[7] + adBIm[3][7];
                double[] dArray152 = adAIm[4];
                dArray152[0] = dArray152[0] + adBIm[4][0];
                double[] dArray153 = adAIm[4];
                dArray153[1] = dArray153[1] + adBIm[4][1];
                double[] dArray154 = adAIm[4];
                dArray154[2] = dArray154[2] + adBIm[4][2];
                double[] dArray155 = adAIm[4];
                dArray155[3] = dArray155[3] + adBIm[4][3];
                double[] dArray156 = adAIm[4];
                dArray156[4] = dArray156[4] + adBIm[4][4];
                double[] dArray157 = adAIm[4];
                dArray157[5] = dArray157[5] + adBIm[4][5];
                double[] dArray158 = adAIm[4];
                dArray158[6] = dArray158[6] + adBIm[4][6];
                double[] dArray159 = adAIm[4];
                dArray159[7] = dArray159[7] + adBIm[4][7];
                double[] dArray160 = adAIm[5];
                dArray160[0] = dArray160[0] + adBIm[5][0];
                double[] dArray161 = adAIm[5];
                dArray161[1] = dArray161[1] + adBIm[5][1];
                double[] dArray162 = adAIm[5];
                dArray162[2] = dArray162[2] + adBIm[5][2];
                double[] dArray163 = adAIm[5];
                dArray163[3] = dArray163[3] + adBIm[5][3];
                double[] dArray164 = adAIm[5];
                dArray164[4] = dArray164[4] + adBIm[5][4];
                double[] dArray165 = adAIm[5];
                dArray165[5] = dArray165[5] + adBIm[5][5];
                double[] dArray166 = adAIm[5];
                dArray166[6] = dArray166[6] + adBIm[5][6];
                double[] dArray167 = adAIm[5];
                dArray167[7] = dArray167[7] + adBIm[5][7];
                double[] dArray168 = adAIm[6];
                dArray168[0] = dArray168[0] + adBIm[6][0];
                double[] dArray169 = adAIm[6];
                dArray169[1] = dArray169[1] + adBIm[6][1];
                double[] dArray170 = adAIm[6];
                dArray170[2] = dArray170[2] + adBIm[6][2];
                double[] dArray171 = adAIm[6];
                dArray171[3] = dArray171[3] + adBIm[6][3];
                double[] dArray172 = adAIm[6];
                dArray172[4] = dArray172[4] + adBIm[6][4];
                double[] dArray173 = adAIm[6];
                dArray173[5] = dArray173[5] + adBIm[6][5];
                double[] dArray174 = adAIm[6];
                dArray174[6] = dArray174[6] + adBIm[6][6];
                double[] dArray175 = adAIm[6];
                dArray175[7] = dArray175[7] + adBIm[6][7];
                double[] dArray176 = adAIm[7];
                dArray176[0] = dArray176[0] + adBIm[7][0];
                double[] dArray177 = adAIm[7];
                dArray177[1] = dArray177[1] + adBIm[7][1];
                double[] dArray178 = adAIm[7];
                dArray178[2] = dArray178[2] + adBIm[7][2];
                double[] dArray179 = adAIm[7];
                dArray179[3] = dArray179[3] + adBIm[7][3];
                double[] dArray180 = adAIm[7];
                dArray180[4] = dArray180[4] + adBIm[7][4];
                double[] dArray181 = adAIm[7];
                dArray181[5] = dArray181[5] + adBIm[7][5];
                double[] dArray182 = adAIm[7];
                dArray182[6] = dArray182[6] + adBIm[7][6];
                double[] dArray183 = adAIm[7];
                dArray183[7] = dArray183[7] + adBIm[7][7];
                break;
            }
            case 9: {
                double[] dArray = adARe[0];
                dArray[0] = dArray[0] + adBRe[0][0];
                double[] dArray184 = adARe[0];
                dArray184[1] = dArray184[1] + adBRe[0][1];
                double[] dArray185 = adARe[0];
                dArray185[2] = dArray185[2] + adBRe[0][2];
                double[] dArray186 = adARe[0];
                dArray186[3] = dArray186[3] + adBRe[0][3];
                double[] dArray187 = adARe[0];
                dArray187[4] = dArray187[4] + adBRe[0][4];
                double[] dArray188 = adARe[0];
                dArray188[5] = dArray188[5] + adBRe[0][5];
                double[] dArray189 = adARe[0];
                dArray189[6] = dArray189[6] + adBRe[0][6];
                double[] dArray190 = adARe[0];
                dArray190[7] = dArray190[7] + adBRe[0][7];
                double[] dArray191 = adARe[0];
                dArray191[8] = dArray191[8] + adBRe[0][8];
                double[] dArray192 = adARe[1];
                dArray192[0] = dArray192[0] + adBRe[1][0];
                double[] dArray193 = adARe[1];
                dArray193[1] = dArray193[1] + adBRe[1][1];
                double[] dArray194 = adARe[1];
                dArray194[2] = dArray194[2] + adBRe[1][2];
                double[] dArray195 = adARe[1];
                dArray195[3] = dArray195[3] + adBRe[1][3];
                double[] dArray196 = adARe[1];
                dArray196[4] = dArray196[4] + adBRe[1][4];
                double[] dArray197 = adARe[1];
                dArray197[5] = dArray197[5] + adBRe[1][5];
                double[] dArray198 = adARe[1];
                dArray198[6] = dArray198[6] + adBRe[1][6];
                double[] dArray199 = adARe[1];
                dArray199[7] = dArray199[7] + adBRe[1][7];
                double[] dArray200 = adARe[1];
                dArray200[8] = dArray200[8] + adBRe[1][8];
                double[] dArray201 = adARe[2];
                dArray201[0] = dArray201[0] + adBRe[2][0];
                double[] dArray202 = adARe[2];
                dArray202[1] = dArray202[1] + adBRe[2][1];
                double[] dArray203 = adARe[2];
                dArray203[2] = dArray203[2] + adBRe[2][2];
                double[] dArray204 = adARe[2];
                dArray204[3] = dArray204[3] + adBRe[2][3];
                double[] dArray205 = adARe[2];
                dArray205[4] = dArray205[4] + adBRe[2][4];
                double[] dArray206 = adARe[2];
                dArray206[5] = dArray206[5] + adBRe[2][5];
                double[] dArray207 = adARe[2];
                dArray207[6] = dArray207[6] + adBRe[2][6];
                double[] dArray208 = adARe[2];
                dArray208[7] = dArray208[7] + adBRe[2][7];
                double[] dArray209 = adARe[2];
                dArray209[8] = dArray209[8] + adBRe[2][8];
                double[] dArray210 = adARe[3];
                dArray210[0] = dArray210[0] + adBRe[3][0];
                double[] dArray211 = adARe[3];
                dArray211[1] = dArray211[1] + adBRe[3][1];
                double[] dArray212 = adARe[3];
                dArray212[2] = dArray212[2] + adBRe[3][2];
                double[] dArray213 = adARe[3];
                dArray213[3] = dArray213[3] + adBRe[3][3];
                double[] dArray214 = adARe[3];
                dArray214[4] = dArray214[4] + adBRe[3][4];
                double[] dArray215 = adARe[3];
                dArray215[5] = dArray215[5] + adBRe[3][5];
                double[] dArray216 = adARe[3];
                dArray216[6] = dArray216[6] + adBRe[3][6];
                double[] dArray217 = adARe[3];
                dArray217[7] = dArray217[7] + adBRe[3][7];
                double[] dArray218 = adARe[3];
                dArray218[8] = dArray218[8] + adBRe[3][8];
                double[] dArray219 = adARe[4];
                dArray219[0] = dArray219[0] + adBRe[4][0];
                double[] dArray220 = adARe[4];
                dArray220[1] = dArray220[1] + adBRe[4][1];
                double[] dArray221 = adARe[4];
                dArray221[2] = dArray221[2] + adBRe[4][2];
                double[] dArray222 = adARe[4];
                dArray222[3] = dArray222[3] + adBRe[4][3];
                double[] dArray223 = adARe[4];
                dArray223[4] = dArray223[4] + adBRe[4][4];
                double[] dArray224 = adARe[4];
                dArray224[5] = dArray224[5] + adBRe[4][5];
                double[] dArray225 = adARe[4];
                dArray225[6] = dArray225[6] + adBRe[4][6];
                double[] dArray226 = adARe[4];
                dArray226[7] = dArray226[7] + adBRe[4][7];
                double[] dArray227 = adARe[4];
                dArray227[8] = dArray227[8] + adBRe[4][8];
                double[] dArray228 = adARe[5];
                dArray228[0] = dArray228[0] + adBRe[5][0];
                double[] dArray229 = adARe[5];
                dArray229[1] = dArray229[1] + adBRe[5][1];
                double[] dArray230 = adARe[5];
                dArray230[2] = dArray230[2] + adBRe[5][2];
                double[] dArray231 = adARe[5];
                dArray231[3] = dArray231[3] + adBRe[5][3];
                double[] dArray232 = adARe[5];
                dArray232[4] = dArray232[4] + adBRe[5][4];
                double[] dArray233 = adARe[5];
                dArray233[5] = dArray233[5] + adBRe[5][5];
                double[] dArray234 = adARe[5];
                dArray234[6] = dArray234[6] + adBRe[5][6];
                double[] dArray235 = adARe[5];
                dArray235[7] = dArray235[7] + adBRe[5][7];
                double[] dArray236 = adARe[5];
                dArray236[8] = dArray236[8] + adBRe[5][8];
                double[] dArray237 = adARe[6];
                dArray237[0] = dArray237[0] + adBRe[6][0];
                double[] dArray238 = adARe[6];
                dArray238[1] = dArray238[1] + adBRe[6][1];
                double[] dArray239 = adARe[6];
                dArray239[2] = dArray239[2] + adBRe[6][2];
                double[] dArray240 = adARe[6];
                dArray240[3] = dArray240[3] + adBRe[6][3];
                double[] dArray241 = adARe[6];
                dArray241[4] = dArray241[4] + adBRe[6][4];
                double[] dArray242 = adARe[6];
                dArray242[5] = dArray242[5] + adBRe[6][5];
                double[] dArray243 = adARe[6];
                dArray243[6] = dArray243[6] + adBRe[6][6];
                double[] dArray244 = adARe[6];
                dArray244[7] = dArray244[7] + adBRe[6][7];
                double[] dArray245 = adARe[6];
                dArray245[8] = dArray245[8] + adBRe[6][8];
                double[] dArray246 = adARe[7];
                dArray246[0] = dArray246[0] + adBRe[7][0];
                double[] dArray247 = adARe[7];
                dArray247[1] = dArray247[1] + adBRe[7][1];
                double[] dArray248 = adARe[7];
                dArray248[2] = dArray248[2] + adBRe[7][2];
                double[] dArray249 = adARe[7];
                dArray249[3] = dArray249[3] + adBRe[7][3];
                double[] dArray250 = adARe[7];
                dArray250[4] = dArray250[4] + adBRe[7][4];
                double[] dArray251 = adARe[7];
                dArray251[5] = dArray251[5] + adBRe[7][5];
                double[] dArray252 = adARe[7];
                dArray252[6] = dArray252[6] + adBRe[7][6];
                double[] dArray253 = adARe[7];
                dArray253[7] = dArray253[7] + adBRe[7][7];
                double[] dArray254 = adARe[7];
                dArray254[8] = dArray254[8] + adBRe[7][8];
                double[] dArray255 = adARe[8];
                dArray255[0] = dArray255[0] + adBRe[8][0];
                double[] dArray256 = adARe[8];
                dArray256[1] = dArray256[1] + adBRe[8][1];
                double[] dArray257 = adARe[8];
                dArray257[2] = dArray257[2] + adBRe[8][2];
                double[] dArray258 = adARe[8];
                dArray258[3] = dArray258[3] + adBRe[8][3];
                double[] dArray259 = adARe[8];
                dArray259[4] = dArray259[4] + adBRe[8][4];
                double[] dArray260 = adARe[8];
                dArray260[5] = dArray260[5] + adBRe[8][5];
                double[] dArray261 = adARe[8];
                dArray261[6] = dArray261[6] + adBRe[8][6];
                double[] dArray262 = adARe[8];
                dArray262[7] = dArray262[7] + adBRe[8][7];
                double[] dArray263 = adARe[8];
                dArray263[8] = dArray263[8] + adBRe[8][8];
                double[] dArray264 = adAIm[0];
                dArray264[0] = dArray264[0] + adBIm[0][0];
                double[] dArray265 = adAIm[0];
                dArray265[1] = dArray265[1] + adBIm[0][1];
                double[] dArray266 = adAIm[0];
                dArray266[2] = dArray266[2] + adBIm[0][2];
                double[] dArray267 = adAIm[0];
                dArray267[3] = dArray267[3] + adBIm[0][3];
                double[] dArray268 = adAIm[0];
                dArray268[4] = dArray268[4] + adBIm[0][4];
                double[] dArray269 = adAIm[0];
                dArray269[5] = dArray269[5] + adBIm[0][5];
                double[] dArray270 = adAIm[0];
                dArray270[6] = dArray270[6] + adBIm[0][6];
                double[] dArray271 = adAIm[0];
                dArray271[7] = dArray271[7] + adBIm[0][7];
                double[] dArray272 = adAIm[0];
                dArray272[8] = dArray272[8] + adBIm[0][8];
                double[] dArray273 = adAIm[1];
                dArray273[0] = dArray273[0] + adBIm[1][0];
                double[] dArray274 = adAIm[1];
                dArray274[1] = dArray274[1] + adBIm[1][1];
                double[] dArray275 = adAIm[1];
                dArray275[2] = dArray275[2] + adBIm[1][2];
                double[] dArray276 = adAIm[1];
                dArray276[3] = dArray276[3] + adBIm[1][3];
                double[] dArray277 = adAIm[1];
                dArray277[4] = dArray277[4] + adBIm[1][4];
                double[] dArray278 = adAIm[1];
                dArray278[5] = dArray278[5] + adBIm[1][5];
                double[] dArray279 = adAIm[1];
                dArray279[6] = dArray279[6] + adBIm[1][6];
                double[] dArray280 = adAIm[1];
                dArray280[7] = dArray280[7] + adBIm[1][7];
                double[] dArray281 = adAIm[1];
                dArray281[8] = dArray281[8] + adBIm[1][8];
                double[] dArray282 = adAIm[2];
                dArray282[0] = dArray282[0] + adBIm[2][0];
                double[] dArray283 = adAIm[2];
                dArray283[1] = dArray283[1] + adBIm[2][1];
                double[] dArray284 = adAIm[2];
                dArray284[2] = dArray284[2] + adBIm[2][2];
                double[] dArray285 = adAIm[2];
                dArray285[3] = dArray285[3] + adBIm[2][3];
                double[] dArray286 = adAIm[2];
                dArray286[4] = dArray286[4] + adBIm[2][4];
                double[] dArray287 = adAIm[2];
                dArray287[5] = dArray287[5] + adBIm[2][5];
                double[] dArray288 = adAIm[2];
                dArray288[6] = dArray288[6] + adBIm[2][6];
                double[] dArray289 = adAIm[2];
                dArray289[7] = dArray289[7] + adBIm[2][7];
                double[] dArray290 = adAIm[2];
                dArray290[8] = dArray290[8] + adBIm[2][8];
                double[] dArray291 = adAIm[3];
                dArray291[0] = dArray291[0] + adBIm[3][0];
                double[] dArray292 = adAIm[3];
                dArray292[1] = dArray292[1] + adBIm[3][1];
                double[] dArray293 = adAIm[3];
                dArray293[2] = dArray293[2] + adBIm[3][2];
                double[] dArray294 = adAIm[3];
                dArray294[3] = dArray294[3] + adBIm[3][3];
                double[] dArray295 = adAIm[3];
                dArray295[4] = dArray295[4] + adBIm[3][4];
                double[] dArray296 = adAIm[3];
                dArray296[5] = dArray296[5] + adBIm[3][5];
                double[] dArray297 = adAIm[3];
                dArray297[6] = dArray297[6] + adBIm[3][6];
                double[] dArray298 = adAIm[3];
                dArray298[7] = dArray298[7] + adBIm[3][7];
                double[] dArray299 = adAIm[3];
                dArray299[8] = dArray299[8] + adBIm[3][8];
                double[] dArray300 = adAIm[4];
                dArray300[0] = dArray300[0] + adBIm[4][0];
                double[] dArray301 = adAIm[4];
                dArray301[1] = dArray301[1] + adBIm[4][1];
                double[] dArray302 = adAIm[4];
                dArray302[2] = dArray302[2] + adBIm[4][2];
                double[] dArray303 = adAIm[4];
                dArray303[3] = dArray303[3] + adBIm[4][3];
                double[] dArray304 = adAIm[4];
                dArray304[4] = dArray304[4] + adBIm[4][4];
                double[] dArray305 = adAIm[4];
                dArray305[5] = dArray305[5] + adBIm[4][5];
                double[] dArray306 = adAIm[4];
                dArray306[6] = dArray306[6] + adBIm[4][6];
                double[] dArray307 = adAIm[4];
                dArray307[7] = dArray307[7] + adBIm[4][7];
                double[] dArray308 = adAIm[4];
                dArray308[8] = dArray308[8] + adBIm[4][8];
                double[] dArray309 = adAIm[5];
                dArray309[0] = dArray309[0] + adBIm[5][0];
                double[] dArray310 = adAIm[5];
                dArray310[1] = dArray310[1] + adBIm[5][1];
                double[] dArray311 = adAIm[5];
                dArray311[2] = dArray311[2] + adBIm[5][2];
                double[] dArray312 = adAIm[5];
                dArray312[3] = dArray312[3] + adBIm[5][3];
                double[] dArray313 = adAIm[5];
                dArray313[4] = dArray313[4] + adBIm[5][4];
                double[] dArray314 = adAIm[5];
                dArray314[5] = dArray314[5] + adBIm[5][5];
                double[] dArray315 = adAIm[5];
                dArray315[6] = dArray315[6] + adBIm[5][6];
                double[] dArray316 = adAIm[5];
                dArray316[7] = dArray316[7] + adBIm[5][7];
                double[] dArray317 = adAIm[5];
                dArray317[8] = dArray317[8] + adBIm[5][8];
                double[] dArray318 = adAIm[6];
                dArray318[0] = dArray318[0] + adBIm[6][0];
                double[] dArray319 = adAIm[6];
                dArray319[1] = dArray319[1] + adBIm[6][1];
                double[] dArray320 = adAIm[6];
                dArray320[2] = dArray320[2] + adBIm[6][2];
                double[] dArray321 = adAIm[6];
                dArray321[3] = dArray321[3] + adBIm[6][3];
                double[] dArray322 = adAIm[6];
                dArray322[4] = dArray322[4] + adBIm[6][4];
                double[] dArray323 = adAIm[6];
                dArray323[5] = dArray323[5] + adBIm[6][5];
                double[] dArray324 = adAIm[6];
                dArray324[6] = dArray324[6] + adBIm[6][6];
                double[] dArray325 = adAIm[6];
                dArray325[7] = dArray325[7] + adBIm[6][7];
                double[] dArray326 = adAIm[6];
                dArray326[8] = dArray326[8] + adBIm[6][8];
                double[] dArray327 = adAIm[7];
                dArray327[0] = dArray327[0] + adBIm[7][0];
                double[] dArray328 = adAIm[7];
                dArray328[1] = dArray328[1] + adBIm[7][1];
                double[] dArray329 = adAIm[7];
                dArray329[2] = dArray329[2] + adBIm[7][2];
                double[] dArray330 = adAIm[7];
                dArray330[3] = dArray330[3] + adBIm[7][3];
                double[] dArray331 = adAIm[7];
                dArray331[4] = dArray331[4] + adBIm[7][4];
                double[] dArray332 = adAIm[7];
                dArray332[5] = dArray332[5] + adBIm[7][5];
                double[] dArray333 = adAIm[7];
                dArray333[6] = dArray333[6] + adBIm[7][6];
                double[] dArray334 = adAIm[7];
                dArray334[7] = dArray334[7] + adBIm[7][7];
                double[] dArray335 = adAIm[7];
                dArray335[8] = dArray335[8] + adBIm[7][8];
                double[] dArray336 = adAIm[8];
                dArray336[0] = dArray336[0] + adBIm[8][0];
                double[] dArray337 = adAIm[8];
                dArray337[1] = dArray337[1] + adBIm[8][1];
                double[] dArray338 = adAIm[8];
                dArray338[2] = dArray338[2] + adBIm[8][2];
                double[] dArray339 = adAIm[8];
                dArray339[3] = dArray339[3] + adBIm[8][3];
                double[] dArray340 = adAIm[8];
                dArray340[4] = dArray340[4] + adBIm[8][4];
                double[] dArray341 = adAIm[8];
                dArray341[5] = dArray341[5] + adBIm[8][5];
                double[] dArray342 = adAIm[8];
                dArray342[6] = dArray342[6] + adBIm[8][6];
                double[] dArray343 = adAIm[8];
                dArray343[7] = dArray343[7] + adBIm[8][7];
                double[] dArray344 = adAIm[8];
                dArray344[8] = dArray344[8] + adBIm[8][8];
                break;
            }
            default: {
                int i = 0;
                while (i < iRows) {
                    int j = 0;
                    while (j < iCols) {
                        double[] dArray = adARe[i];
                        int n = j;
                        dArray[n] = dArray[n] + adBRe[i][j];
                        double[] dArray345 = adAIm[i];
                        int n2 = j;
                        dArray345[n2] = dArray345[n2] + adBIm[i][j];
                        ++j;
                    }
                    ++i;
                }
                break block0;
            }
        }
    }

    protected void pow(double[][] adARe, double[][] adAIm, int iPow, double[][] adCRe, double[][] adCIm) {
        block12: {
            int iCols;
            int iRows;
            block11: {
                assert (iPow > 0) : "matrix power lower than 1!: " + iPow;
                assert (adARe.length == adCRe.length);
                assert (adAIm.length == adCIm.length);
                assert (adARe[0].length == adCRe[0].length);
                assert (adAIm[0].length == adCIm[0].length);
                iRows = adARe.length;
                iCols = adARe[0].length;
                if (iPow != 1) break block11;
                int r = 0;
                while (r < iRows) {
                    System.arraycopy(adARe[r], 0, adCRe[r], 0, iCols);
                    System.arraycopy(adAIm[r], 0, adCIm[r], 0, iCols);
                    ++r;
                }
                break block12;
            }
            if (this._adPowTempRe == null || this._adPowTempRe.length != iRows || this._adPowTempRe[0].length != iCols) {
                this._adPowTempRe = new double[iRows][iCols];
                this._adPowTempIm = new double[iRows][iCols];
            }
            boolean bResultInC = true;
            this.mult(adARe, adAIm, adARe, adAIm, adCRe, adCIm);
            int i = 2;
            while (i < iPow) {
                boolean bl = bResultInC = !bResultInC;
                if (bResultInC) {
                    this.mult(adARe, adAIm, this._adPowTempRe, this._adPowTempIm, adCRe, adCIm);
                } else {
                    this.mult(adARe, adAIm, adCRe, adCIm, this._adPowTempRe, this._adPowTempIm);
                }
                ++i;
            }
            if (bResultInC) break block12;
            int r = 0;
            while (r < iRows) {
                System.arraycopy(this._adPowTempRe[r], 0, adCRe[r], 0, iCols);
                System.arraycopy(this._adPowTempIm[r], 0, adCIm[r], 0, iCols);
                ++r;
            }
        }
    }

    protected void createQn(int iNmax, double[][] adQRe, double[][] adQIm, double[][][] adQnRe, double[][][] adQnIm) {
        assert (adQRe.length == adQIm.length);
        assert (adQRe[0].length == adQIm[0].length);
        assert (iNmax > 0);
        assert (adQnRe.length == iNmax + 1);
        assert (adQnIm.length == iNmax + 1);
        assert (adQnRe[1].length == adQnIm[1].length);
        assert (adQnIm[1].length == adQRe.length);
        assert (adQnRe[1][0].length == adQnIm[1][0].length);
        assert (adQnIm[1][0].length == adQRe[0].length);
        int iRows = adQRe.length;
        int iCols = adQRe[0].length;
        int r = 0;
        while (r < iRows) {
            System.arraycopy(adQRe[r], 0, adQnRe[1][r], 0, iCols);
            System.arraycopy(adQIm[r], 0, adQnIm[1][r], 0, iCols);
            ++r;
        }
        int i = 2;
        while (i <= iNmax) {
            this.mult(adQnRe[i - 1], adQnIm[i - 1], adQRe, adQIm, adQnRe[i], adQnIm[i]);
            ++i;
        }
    }

    protected void copy(double[][] adARe, double[][] adAIm, double[][] adBRe, double[][] adBIm) {
        assert (adARe.length == adBRe.length);
        assert (adARe[0].length == adBRe[0].length);
        assert (adAIm.length == adBIm.length);
        assert (adAIm[0].length == adBIm[0].length);
        int iRows = adARe.length;
        int iCols = adARe[0].length;
        int i = 0;
        while (i < iRows) {
            System.arraycopy(adARe[i], 0, adBRe[i], 0, iCols);
            System.arraycopy(adAIm[i], 0, adBIm[i], 0, iCols);
            ++i;
        }
    }

    protected double[][] diag(double dValue, int iSize) {
        assert (iSize > 1) : iSize;
        double[][] adMatrix = new double[iSize][iSize];
        int i = 0;
        while (i < iSize) {
            adMatrix[i][i] = dValue;
            ++i;
        }
        return adMatrix;
    }

    protected double spur(double[][] adMatrix) {
        double dSpur = 0.0;
        int i = 0;
        while (i < adMatrix.length) {
            dSpur += adMatrix[i][i];
            ++i;
        }
        return dSpur;
    }

    protected void reset(double[][] adMatrix) {
        int i = 0;
        while (i < adMatrix.length) {
            Arrays.fill(adMatrix[i], 0.0);
            ++i;
        }
    }

    protected boolean theSame(double[][] adA, double[][] adB) {
        assert (adA.length == adB.length);
        assert (adA[0].length == adB[0].length);
        boolean bResult = true;
        int i = 0;
        while (i < adA.length) {
            int k = 0;
            while (k < adA[i].length) {
                bResult &= Math.abs(adA[i][k] - adB[i][k]) < 1.0E-10;
                ++k;
            }
            ++i;
        }
        return bResult;
    }
}

