/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod.equation;

import java.io.Serializable;
import net.ndmystko.xrd.mod.equation.Equation;
import net.ndmystko.xrd.util.Distribution;

public class EdgeEquation
extends Equation
implements Serializable {
    private static final long serialVersionUID = 3276027294967701027L;

    public void compute(double[][][] adQRe, double[][][] adQIm, Distribution distr, double[][] adW, double[][][] adVRe, double[][][] adVIm, double[] adIntens, double[][][] adVPrim0Re, double[][][] adVPrimKRe, double[][][] adV0Re, double[][][] adV0Im, double[][][] adVKRe, double[][][] adVKIm, double[][][] adVPrimRe, double[][][] adVPrimIm, double[][][] adQ0Re, double[][][] adQ0Im) {
        assert (adQRe.length == adQIm.length);
        assert (adQRe[0].length == adQIm[0].length);
        assert (adQRe[0][0].length == adQIm[0][0].length);
        assert (adVRe.length == adVIm.length);
        assert (adVRe[0].length == adVIm[0].length);
        assert (adVRe[0][0].length == adVIm[0][0].length);
        assert (adQRe.length == adVRe.length);
        assert (adQRe[0].length == adVRe[0].length);
        assert (adQRe[0][0].length == adVRe[0][0].length);
        int iNoOfData = adIntens.length;
        int iNmax = distr.getNoOfClasses();
        int iRank = adW.length;
        double[][][] adQnRe = new double[iNmax + 1][iRank][iRank];
        double[][][] adQnIm = new double[iNmax + 1][iRank][iRank];
        double[][] adSigmaRe = new double[iRank][iRank];
        double[][] adSigmaIm = new double[iRank][iRank];
        double[][] adSubSigmaRe = new double[iRank][iRank];
        double[][] adSubSigmaIm = new double[iRank][iRank];
        double[][] adWIm = new double[iRank][iRank];
        double[][] adVWRe = new double[iRank][iRank];
        double[][] adVWIm = new double[iRank][iRank];
        double[][] adVWQRe = new double[iRank][iRank];
        double[][] adVWQIm = new double[iRank][iRank];
        double[][] ad1NE = this.diag(distr.getMean(), iRank);
        double[][] ad1TotalRe = new double[iRank][iRank];
        double[][] ad1TotalIm = new double[iRank][iRank];
        double[][] ad2TotalRe = new double[iRank][iRank];
        double[][] ad2TotalIm = new double[iRank][iRank];
        double[][] ad3TotalRe = new double[iRank][iRank];
        double[][] ad3TotalIm = new double[iRank][iRank];
        double[][] ad4TotalRe = new double[iRank][iRank];
        double[][] ad4TotalIm = new double[iRank][iRank];
        double[][] ad5VSumRe = new double[iRank][iRank];
        double[][] ad5TotalRe = new double[iRank][iRank];
        double[][] adStorageSigma1Re = new double[iRank][iRank];
        double[][] adStorageSigma1Im = new double[iRank][iRank];
        double[][] adStorageSigma2Re = new double[iRank][iRank];
        double[][] adStorageSigma2Im = new double[iRank][iRank];
        double[][] adTotalRe = new double[iRank][iRank];
        int i = 0;
        while (i < iNoOfData) {
            int m;
            double dFactor;
            if (iNmax > 1) {
                this.createQn(iNmax, adQRe[i], adQIm[i], adQnRe, adQnIm);
            }
            int n = 1;
            while (n < iNmax) {
                dFactor = 0.0;
                m = n + 1;
                while (m <= iNmax) {
                    dFactor += (double)(m - n) * distr.getContent(m);
                    ++m;
                }
                this.mult(adQnRe[n], adQnIm[n], 2.0 * dFactor, adSubSigmaRe, adSubSigmaIm);
                this.add(adSigmaRe, adSigmaIm, adSubSigmaRe, adSubSigmaIm);
                ++n;
            }
            this.add(adSigmaRe, ad1NE);
            this.mult(adVRe[i], adVIm[i], adW, adWIm, adVWRe, adVWIm);
            this.mult(adVWRe, adVWIm, adSigmaRe, adSigmaIm, ad1TotalRe, ad1TotalIm);
            this.add(adTotalRe, ad1TotalRe);
            this.reset(adSigmaRe);
            this.reset(adSigmaIm);
            n = 1;
            while (n < iNmax) {
                dFactor = 0.0;
                m = n + 1;
                while (m <= iNmax) {
                    dFactor += distr.getContent(m);
                    ++m;
                }
                this.mult(adQnRe[n], adQnIm[n], dFactor, adSubSigmaRe, adSubSigmaIm);
                this.add(adSigmaRe, adSigmaIm, adSubSigmaRe, adSubSigmaIm);
                ++n;
            }
            this.copy(adSigmaRe, adSigmaIm, adStorageSigma1Re, adStorageSigma1Im);
            this.addUnity(adSigmaRe);
            this.mult(adV0Re[i], adV0Im[i], adW, adWIm, adVWRe, adVWIm);
            this.mult(adVWRe, adVWIm, adQ0Re[i], adQ0Im[i], adVWQRe, adVWQIm);
            this.mult(adVWQRe, adVWQIm, adSigmaRe, adSigmaIm, ad2TotalRe, ad2TotalIm);
            this.add(adTotalRe, ad2TotalRe, 2.0);
            this.reset(adSigmaRe);
            this.reset(adSigmaIm);
            int m2 = 1;
            while (m2 <= iNmax) {
                this.mult(adQnRe[m2], adQnIm[m2], distr.getContent(m2), adSubSigmaRe, adSubSigmaIm);
                this.add(adSigmaRe, adSigmaIm, adSubSigmaRe, adSubSigmaIm);
                ++m2;
            }
            this.copy(adSigmaRe, adSigmaIm, adStorageSigma2Re, adStorageSigma2Im);
            this.add(adSigmaRe, adSigmaIm, adStorageSigma1Re, adStorageSigma1Im);
            this.mult(adVKRe[i], adVKIm[i], adW, adWIm, adVWRe, adVWIm);
            this.mult(adVWRe, adVWIm, adSigmaRe, adSigmaIm, ad3TotalRe, ad3TotalIm);
            this.add(adTotalRe, ad3TotalRe, 2.0);
            this.reset(adSigmaRe);
            this.reset(adSigmaIm);
            this.mult(adVPrimRe[i], adVPrimIm[i], adW, adWIm, adVWRe, adVWIm);
            this.mult(adVWRe, adVWIm, adQ0Re[i], adQ0Im[i], adVWQRe, adVWQIm);
            this.mult(adVWQRe, adVWQIm, adStorageSigma2Re, adStorageSigma2Im, ad4TotalRe, ad4TotalIm);
            this.add(adTotalRe, ad4TotalRe, 2.0);
            this.add(adVPrim0Re[i], adVPrimKRe[i], ad5VSumRe);
            this.mult(ad5VSumRe, adW, ad5TotalRe);
            this.add(adTotalRe, ad5TotalRe);
            adIntens[i] = this.spur(adTotalRe);
            this.reset(adTotalRe);
            ++i;
        }
    }
}

