/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.layer.AbstractElement;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.ChloriteLayer;
import net.ndmystko.xrd.mod.layer.IlliteLayer;
import net.ndmystko.xrd.mod.layer.KaoliniteLayer;

public class Verificator {
    private Result _result;
    private String _sErrorMessage;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.Verificator");

    public Verificator(Pattern.Content[] aContent, Object[] aPattern) {
        assert (aContent.length == aPattern.length) : "Length mismatch: " + aContent.length + " vs. " + aPattern.length;
        this._sErrorMessage = this.calculateData(aContent, aPattern);
    }

    public double getTMean() {
        return this._result._dTMean;
    }

    public double getDryDensity() {
        return this._result._dDryDensity;
    }

    public double getTSA() {
        return this._result._dTSA;
    }

    public double getPercK2O() {
        return this._result._dPercK2O;
    }

    public String getErrorMessage() {
        return this._sErrorMessage;
    }

    private String calculateData(Pattern.Content[] aContent, Object[] aPattern) {
        int i = 0;
        while (i < aPattern.length) {
            Pattern pattern = (Pattern)aPattern[i];
            if (pattern.getPhases().length > 1) {
                return "More than one phase in " + pattern.toString();
            }
            ++i;
        }
        HashSet<Entry> hsNonIS = this.buildEntries(aContent, aPattern);
        HashSet<Entry> hsIS = this.subtractIS(hsNonIS);
        if (hsIS.size() == 0) {
            return "No I/S was detected among phases,\nthe model cannot be verified.";
        }
        ISSubResult[] aISSubResult = new ISSubResult[hsIS.size()];
        int iCount = 0;
        double dISAirDryContent = 0.0;
        for (Entry is : hsIS) {
            aISSubResult[iCount] = this.processIS(is.getContent(), (MixedLayerPhase)is.getPhase());
            if (aISSubResult[iCount].getErrorMessage() != null) {
                return aISSubResult[iCount].getErrorMessage();
            }
            dISAirDryContent += is.getContent();
            ++iCount;
        }
        ISResult avgIS = this.processAvgISSub(ISSubResult.getWeightedMean(aISSubResult));
        iCount = 0;
        Result[] aNonISResult = new Result[hsNonIS.size()];
        for (Entry nonIS : hsNonIS) {
            if (nonIS.getPhase().getPhaseType() == 50) {
                aNonISResult[iCount++] = this.processIllite(nonIS.getContent(), nonIS.getPhase(), dISAirDryContent, avgIS);
            } else if (nonIS.getPhase().getPhaseType() == 52 || nonIS.getPhase().getPhaseType() == 56 || nonIS.getPhase().getPhaseType() == 57) {
                aNonISResult[iCount++] = this.processKaolinite(nonIS.getContent(), nonIS.getPhase(), dISAirDryContent, avgIS);
            } else if (nonIS.getPhase().getPhaseType() == 53 || nonIS.getPhase().getPhaseType() == 54 || nonIS.getPhase().getPhaseType() == 68) {
                aNonISResult[iCount++] = this.processChlorite(nonIS.getContent(), nonIS.getPhase(), dISAirDryContent, avgIS);
            } else {
                return "Do not know how to handle " + nonIS.getPhase().toString();
            }
            if (aNonISResult[iCount - 1].getErrorMessage() == null) continue;
            return aNonISResult[iCount - 1].getErrorMessage();
        }
        Result[] aAllResults = new Result[aNonISResult.length + 1];
        System.arraycopy(aNonISResult, 0, aAllResults, 0, aNonISResult.length);
        aAllResults[aAllResults.length - 1] = avgIS;
        this._result = Result.getWeightedMean(aAllResults);
        return null;
    }

    private ISSubResult processIS(double dContent, MixedLayerPhase mixedPhase) {
        double dPercS;
        IlliteLayer illiteLayer = (IlliteLayer)mixedPhase.getLayer("illite", false);
        double d = dPercS = illiteLayer != null ? (1.0 - mixedPhase.getAbstractProbabMatrix().getIlliteContent()) * 100.0 : 100.0;
        if (Math.abs(dPercS) < 1.0E-6) {
            return new ISSubResult("Cannot calculate I/S where content of S is 0: " + mixedPhase.toString());
        }
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "%S: " + dPercS);
        double dInterlayer = Double.NaN;
        boolean bGlycol = mixedPhase.isGlyLayer();
        boolean bAirDry = mixedPhase.isWatLayer();
        if (!(bGlycol ^ bAirDry)) {
            return new ISSubResult("Cannot recognize phase " + mixedPhase.toString());
        }
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "state: " + (bGlycol ? "glycol" : "air-dry"));
        double dPercDoubleLayer = mixedPhase.getAbstractProbabMatrix().getW(illiteLayer != null ? 1 : 0) * 100.0;
        if (mixedPhase.getPhaseType() == 2) {
            dPercDoubleLayer += mixedPhase.getAbstractProbabMatrix().getW(2) * 100.0;
        }
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "% double layer: " + dPercDoubleLayer);
        boolean bMonoLayerPresent = dPercS - dPercDoubleLayer > 1.0E-6;
        double dPercMonoLayer = dPercS - dPercDoubleLayer;
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "% mono layer: " + dPercMonoLayer);
        AbstractLayer smectiteDoubleLayer = mixedPhase.getLayer(bGlycol ? "di-smectite 2gly" : "di-smectite 2wat", false);
        if (smectiteDoubleLayer == null) {
            return new ISSubResult("Cannot find layer " + (bGlycol ? "di-smectite 2gly" : "di-smectite 2wat") + " in " + mixedPhase.toString());
        }
        AbstractLayer smectiteMonoLayer = bMonoLayerPresent ? mixedPhase.getLayer(bGlycol ? "di-smectite 1gly" : "di-smectite 1wat", true) : null;
        double dIlliteFeContent = illiteLayer != null ? AbstractElement.findLayerGene(illiteLayer, "oct iron content").getGeneValue() / 2.0 : 0.0;
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "illite Fe content: " + dIlliteFeContent);
        double dDoubleWaterContent = AbstractElement.findLayerGene(smectiteDoubleLayer, "water content").getGeneValue() * 2.0;
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "double water content: " + dDoubleWaterContent);
        if (bGlycol) {
            double dDoubleGlyContent = AbstractElement.findLayerGene(smectiteDoubleLayer, "glycol content").getGeneValue() * 4.0;
            _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "double gly content: " + dDoubleGlyContent);
            double dMonoGlyContent = bMonoLayerPresent ? AbstractElement.findLayerGene(smectiteMonoLayer, "glycol content").getGeneValue() * 2.0 : 0.0;
            _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "mono gly content: " + dMonoGlyContent);
            dInterlayer = (dDoubleGlyContent * 31.0 * dPercDoubleLayer / dPercS + dDoubleWaterContent * 18.0 * dPercDoubleLayer / dPercS + dMonoGlyContent * 31.0 * dPercMonoLayer / dPercS) / (58.003 * dIlliteFeContent + 737.38 + dDoubleGlyContent * 31.0 * dPercDoubleLayer / dPercS + dDoubleWaterContent * 18.0 * dPercDoubleLayer / dPercS + dMonoGlyContent * 31.0 * dPercMonoLayer / dPercS) * 100.0;
        } else {
            double dMonoWaterContent = bMonoLayerPresent ? AbstractElement.findLayerGene(smectiteMonoLayer, "water content").getGeneValue() : 0.0;
            _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "mono water content: " + dMonoWaterContent);
            dInterlayer = (dMonoWaterContent * 18.0 * dPercMonoLayer / dPercS + dDoubleWaterContent * 18.0 * dPercDoubleLayer / dPercS) / (58.003 * dIlliteFeContent + 737.38 + dMonoWaterContent * 18.0 * dPercMonoLayer / dPercS + dDoubleWaterContent * 18.0 * dPercDoubleLayer / dPercS) * 100.0;
        }
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "interlayer: " + dInterlayer);
        _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.Verificator", "processIS", "*****************");
        double dIlliteKContent = illiteLayer != null ? illiteLayer.getKContent() : Double.NaN;
        double dIlliteDSpacing = illiteLayer != null ? illiteLayer.getDSpacing() : Double.NaN;
        double dN = mixedPhase.getTMeanGeneValue();
        return new ISSubResult(dContent, dPercS, dN, dIlliteFeContent, dIlliteKContent, dInterlayer, dIlliteDSpacing);
    }

    private ISResult processAvgISSub(ISSubResult avgISSub) {
        avgISSub._dPercS += 0.5 * (1.0 + (100.0 - avgISSub._dPercS) / 100.0) / avgISSub._dN * 100.0;
        if (avgISSub._dPercS > 100.0) {
            avgISSub._dPercS = 100.0;
        }
        double dDryContent = (avgISSub._dContent - avgISSub._dContent * avgISSub._dPercS / 100.0 * avgISSub._dInterlayer / 100.0) / (100.0 - avgISSub._dContent * avgISSub._dPercS / 100.0 * avgISSub._dInterlayer / 100.0) * 100.0;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processAvgISSub", "dry content: " + dDryContent);
        double dTMean = 100.0 / avgISSub._dPercS;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processAvgISSub", "T mean: " + dTMean);
        double dDryDensity = 0.1645 * avgISSub._dIlliteFeContent + 2.739;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processAvgISSub", "dry density: " + dDryDensity);
        double dTSA = 2000.0 / dDryDensity / dTMean / (avgISSub._dIlliteD001 / 10.0);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processAvgISSub", "TSA: " + dTSA);
        double dKContent = avgISSub._dIlliteKContent / 2.0;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processAvgISSub", "illite K content: " + dKContent);
        double dPercK2O = dKContent * 94.2034 / (58.003 * avgISSub._dIlliteFeContent + 737.38) * 100.0 * (100.0 - avgISSub._dPercS) / 100.0;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processAvgISSub", "%K2O: " + dPercK2O);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processAvgISSub", "*****************");
        return new ISResult(avgISSub._dPercS, avgISSub._dInterlayer, dDryContent, dTMean, dDryDensity, dTSA, dPercK2O);
    }

    private Result processIllite(double dContent, Phase phase, double dISAirDryContent, ISResult avgIS) {
        double dDryContent = dContent / (100.0 - dISAirDryContent * avgIS._dPercS / 100.0 * avgIS._dInterlayer / 100.0) * 100.0;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processIllite", "illite dry content: " + dDryContent);
        IlliteLayer illiteLayer = (IlliteLayer)phase.getLayer("illite", true);
        double dIlliteFeContent = AbstractElement.findLayerGene(illiteLayer, "oct iron content").getGeneValue() / 2.0;
        double dDryDensity = 0.1645 * dIlliteFeContent + 2.739;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processIllite", "illite dry density: " + dDryDensity);
        double dNMean = phase.getTMeanGeneValue();
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processIllite", "illite N mean: " + dNMean);
        double dTSA = 2000.0 / dDryDensity / dNMean / (illiteLayer.getDSpacing() / 10.0);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processIllite", "illite TSA: " + dTSA);
        double dKContent = illiteLayer.getKContent() / 2.0;
        double dPercK2O = dKContent * 94.2034 / (58.003 * dIlliteFeContent + 737.38) * 100.0 * (dNMean - 1.0) / dNMean;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processIllite", "illite % K2O: " + dPercK2O);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processIllite", "**********************");
        return new Result(dDryContent, dNMean, dDryDensity, dTSA, dPercK2O);
    }

    private Result processKaolinite(double dContent, Phase phase, double dISAirDryContent, ISResult avgIS) {
        double dDryContent = dContent / (100.0 - dISAirDryContent * avgIS._dPercS / 100.0 * avgIS._dInterlayer / 100.0) * 100.0;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processKaolinite", "kaolinite dry content: " + dDryContent);
        KaoliniteLayer kaoliniteLayer = (KaoliniteLayer)phase.getLayer("kaolinite", true);
        double dDryDensity = 2.6222;
        double dNMean = phase.getTMeanGeneValue();
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processKaolinite", "kaolinite N mean: " + dNMean);
        double dTSA = 2000.0 / dDryDensity / dNMean / (kaoliniteLayer.getDSpacing() / 10.0);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processKaolinite", "kaolinite TSA: " + dTSA);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processKaolinite", "*********************");
        return new Result(dDryContent, Double.NaN, dDryDensity, dTSA, Double.NaN);
    }

    private Result processChlorite(double dContent, Phase phase, double dISAirDryContent, ISResult avgIS) {
        double dDryContent = dContent / (100.0 - dISAirDryContent * avgIS._dPercS / 100.0 * avgIS._dInterlayer / 100.0) * 100.0;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processChlorite", "chlorite dry content: " + dDryContent);
        ChloriteLayer chloriteLayer = (ChloriteLayer)phase.getLayer("chlorite", true);
        double dChloriteFeContent = AbstractElement.findLayerGene(chloriteLayer, "oct iron content").getGeneValue() / 2.0;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processChlorite", "chlorite iron content: " + (dChloriteFeContent += AbstractElement.findLayerGene(chloriteLayer, "interlayer iron content").getGeneValue() / 2.0));
        double dDryDensity = 0.1292 * dChloriteFeContent + 2.6622;
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processChlorite", "chlorite dry density: " + dDryDensity);
        double dNMean = phase.getTMeanGeneValue();
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processChlorite", "chlorite N mean: " + dNMean);
        double dTSA = 2000.0 / dDryDensity / dNMean / (chloriteLayer.getDSpacing() / 10.0);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processChlorite", "chlorite TSA: " + dTSA);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.Verificator", "processChlorite", "*********************");
        return new Result(dDryContent, Double.NaN, dDryDensity, dTSA, Double.NaN);
    }

    private HashSet<Entry> subtractIS(HashSet<Entry> hsFullSet) {
        HashSet<Entry> hsIS = new HashSet<Entry>();
        for (Entry entry : hsFullSet) {
            if (entry.getPhase().getPhaseType() != 0 && entry.getPhase().getPhaseType() != 1 && entry.getPhase().getPhaseType() != 2 && entry.getPhase().getPhaseType() != 3) continue;
            hsIS.add(entry);
        }
        hsFullSet.removeAll(hsIS);
        return hsIS;
    }

    private HashSet<Entry> buildEntries(Pattern.Content[] aContent, Object[] aPattern) {
        HashSet<Entry> hsEntries = new HashSet<Entry>();
        int i = 0;
        while (i < aContent.length) {
            hsEntries.add(new Entry(aContent[i].getPhaseContent(), ((Pattern)aPattern[i]).getPhases()[0]));
            ++i;
        }
        return hsEntries;
    }

    private static class Entry {
        private double _dContent;
        private Phase _phase;

        public Entry(double dContent, Phase phase) {
            this._dContent = dContent;
            this._phase = phase;
        }

        public double getContent() {
            return this._dContent;
        }

        public Phase getPhase() {
            return this._phase;
        }
    }

    private static class ISResult
    extends Result {
        protected double _dPercS;
        protected double _dInterlayer;

        public ISResult(double dPercS, double dInterlayer, double dDryContent, double dTMean, double dDryDensity, double dTSA, double dPercK2O) {
            super(dDryContent, dTMean, dDryDensity, dTSA, dPercK2O);
            this._dPercS = dPercS;
            this._dInterlayer = dInterlayer;
        }

        public ISResult(String sErrorMessage) {
            super(sErrorMessage);
        }

        public static ISResult getWeightedMean(ISResult[] aResult) {
            double dTotalContent = 0.0;
            double dPercS = 0.0;
            ISResult[] iSResultArray = aResult;
            int n = aResult.length;
            int n2 = 0;
            while (n2 < n) {
                ISResult result = iSResultArray[n2];
                if (!Double.isNaN(result._dPercS)) {
                    dPercS += result._dPercS * result._dDryContent;
                    dTotalContent += result._dDryContent;
                }
                ++n2;
            }
            dPercS /= dTotalContent;
            dTotalContent = 0.0;
            double dInterlayer = 0.0;
            ISResult[] iSResultArray2 = aResult;
            int n3 = aResult.length;
            int n4 = 0;
            while (n4 < n3) {
                ISResult result = iSResultArray2[n4];
                if (!Double.isNaN(result._dInterlayer)) {
                    dInterlayer += result._dInterlayer * result._dDryContent;
                    dTotalContent += result._dDryContent;
                }
                ++n4;
            }
            Result subResult = Result.getWeightedMean(aResult);
            return new ISResult(dPercS, dInterlayer /= dTotalContent, subResult._dDryContent, subResult._dTMean, subResult._dDryDensity, subResult._dTSA, subResult._dPercK2O);
        }
    }

    private static class ISSubResult {
        protected double _dContent;
        protected double _dPercS;
        protected double _dIlliteFeContent;
        protected double _dIlliteKContent;
        protected double _dInterlayer;
        protected double _dIlliteD001;
        protected double _dN;
        protected String _sErrorMessage;

        public ISSubResult(double dContent, double dPercS, double dN, double dIlliteFeContent, double dIlliteKContent, double dInterlayer, double dIlliteD001) {
            this._dContent = dContent;
            this._dPercS = dPercS;
            this._dN = dN;
            this._dIlliteFeContent = dIlliteFeContent;
            this._dIlliteKContent = dIlliteKContent;
            this._dInterlayer = dInterlayer;
            this._dIlliteD001 = dIlliteD001;
        }

        public ISSubResult(String sErrorMessage) {
            this._sErrorMessage = sErrorMessage;
        }

        public String getErrorMessage() {
            return this._sErrorMessage;
        }

        public static ISSubResult getWeightedMean(ISSubResult[] aResult) {
            double dTotalContent = 0.0;
            ISSubResult[] iSSubResultArray = aResult;
            int n = aResult.length;
            int n2 = 0;
            while (n2 < n) {
                ISSubResult result = iSSubResultArray[n2];
                if (result._sErrorMessage != null) {
                    throw new IllegalArgumentException("Missed error message: " + result._sErrorMessage);
                }
                dTotalContent += result._dContent;
                ++n2;
            }
            double dTotalLocalContent = 0.0;
            double dPercS = 0.0;
            ISSubResult[] iSSubResultArray2 = aResult;
            int n3 = aResult.length;
            int n4 = 0;
            while (n4 < n3) {
                ISSubResult result = iSSubResultArray2[n4];
                if (!Double.isNaN(result._dPercS)) {
                    dPercS += result._dPercS * result._dContent;
                    dTotalLocalContent += result._dContent;
                }
                ++n4;
            }
            dPercS /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dN = 0.0;
            ISSubResult[] iSSubResultArray3 = aResult;
            int n5 = aResult.length;
            int n6 = 0;
            while (n6 < n5) {
                ISSubResult result = iSSubResultArray3[n6];
                if (!Double.isNaN(result._dN)) {
                    dN += result._dN * result._dContent;
                    dTotalLocalContent += result._dContent;
                }
                ++n6;
            }
            dN /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dIlliteFeContent = 0.0;
            ISSubResult[] iSSubResultArray4 = aResult;
            int n7 = aResult.length;
            int n8 = 0;
            while (n8 < n7) {
                ISSubResult result = iSSubResultArray4[n8];
                if (!Double.isNaN(result._dIlliteFeContent)) {
                    dIlliteFeContent += result._dIlliteFeContent * result._dContent;
                    dTotalLocalContent += result._dContent;
                }
                ++n8;
            }
            dIlliteFeContent /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dIlliteKContent = 0.0;
            ISSubResult[] iSSubResultArray5 = aResult;
            int n9 = aResult.length;
            int n10 = 0;
            while (n10 < n9) {
                ISSubResult result = iSSubResultArray5[n10];
                if (!Double.isNaN(result._dIlliteKContent)) {
                    dIlliteKContent += result._dIlliteKContent * result._dContent;
                    dTotalLocalContent += result._dContent;
                }
                ++n10;
            }
            dIlliteKContent /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dInterlayer = 0.0;
            ISSubResult[] iSSubResultArray6 = aResult;
            int n11 = aResult.length;
            int n12 = 0;
            while (n12 < n11) {
                ISSubResult result = iSSubResultArray6[n12];
                if (!Double.isNaN(result._dInterlayer)) {
                    dInterlayer += result._dInterlayer * result._dContent;
                    dTotalLocalContent += result._dContent;
                }
                ++n12;
            }
            dInterlayer /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dIlliteD001 = 0.0;
            ISSubResult[] iSSubResultArray7 = aResult;
            int n13 = aResult.length;
            int n14 = 0;
            while (n14 < n13) {
                ISSubResult result = iSSubResultArray7[n14];
                if (!Double.isNaN(result._dIlliteD001)) {
                    dIlliteD001 += result._dIlliteD001 * result._dContent;
                    dTotalLocalContent += result._dContent;
                }
                ++n14;
            }
            return new ISSubResult(dTotalContent, dPercS, dN, dIlliteFeContent, dIlliteKContent, dInterlayer, dIlliteD001 /= dTotalLocalContent);
        }
    }

    private static class Result {
        protected double _dDryContent;
        protected double _dTMean;
        protected double _dDryDensity;
        protected double _dTSA;
        protected double _dPercK2O;
        protected String _sErrorMessage;

        public Result(double dDryContent, double dTMean, double dDryDensity, double dTSA, double dPercK2O) {
            this._dDryContent = dDryContent;
            this._dTMean = dTMean;
            this._dDryDensity = dDryDensity;
            this._dTSA = dTSA;
            this._dPercK2O = dPercK2O;
        }

        public Result(String sErrorMessage) {
            this._sErrorMessage = sErrorMessage;
        }

        public String getErrorMessage() {
            return this._sErrorMessage;
        }

        public static Result getWeightedMean(Result[] aResult) {
            double dTotalDryContent = 0.0;
            Result[] resultArray = aResult;
            int n = aResult.length;
            int n2 = 0;
            while (n2 < n) {
                Result result = resultArray[n2];
                if (result._sErrorMessage != null) {
                    throw new IllegalArgumentException("Missed error message: " + result._sErrorMessage);
                }
                dTotalDryContent += result._dDryContent;
                ++n2;
            }
            double dTotalLocalContent = 0.0;
            double dTMean = 0.0;
            Result[] resultArray2 = aResult;
            int n3 = aResult.length;
            int n4 = 0;
            while (n4 < n3) {
                Result result = resultArray2[n4];
                if (!Double.isNaN(result._dTMean)) {
                    dTMean += result._dTMean * result._dDryContent;
                    dTotalLocalContent += result._dDryContent;
                }
                ++n4;
            }
            dTMean /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dDryDensity = 0.0;
            Result[] resultArray3 = aResult;
            int n5 = aResult.length;
            int n6 = 0;
            while (n6 < n5) {
                Result result = resultArray3[n6];
                if (!Double.isNaN(result._dDryDensity)) {
                    dDryDensity += result._dDryDensity * result._dDryContent;
                    dTotalLocalContent += result._dDryContent;
                }
                ++n6;
            }
            dDryDensity /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dTSA = 0.0;
            Result[] resultArray4 = aResult;
            int n7 = aResult.length;
            int n8 = 0;
            while (n8 < n7) {
                Result result = resultArray4[n8];
                if (!Double.isNaN(result._dTSA)) {
                    dTSA += result._dTSA * result._dDryContent;
                    dTotalLocalContent += result._dDryContent;
                }
                ++n8;
            }
            dTSA /= dTotalLocalContent;
            dTotalLocalContent = 0.0;
            double dPercK2O = 0.0;
            Result[] resultArray5 = aResult;
            int n9 = aResult.length;
            int n10 = 0;
            while (n10 < n9) {
                Result result = resultArray5[n10];
                dTotalLocalContent += result._dDryContent;
                if (!Double.isNaN(result._dPercK2O)) {
                    dPercK2O += result._dPercK2O * result._dDryContent;
                }
                ++n10;
            }
            return new Result(dTotalDryContent, dTMean, dDryDensity, dTSA, dPercK2O /= dTotalLocalContent);
        }
    }
}

