/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.io.Serializable;
import java.util.ArrayList;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.Diffractometer;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.script.ScriptParams;

public class Task
implements Serializable {
    private static final long serialVersionUID = 8354402850752513686L;
    private AbstractDiffractogram _expDiffr = null;
    private Diffractometer _diffractometer = null;
    private PatternParams _patternParams = null;
    private Phase[] _aStablePhases = null;
    private ArrayList _alExcludedRanges = null;
    private ScriptParams _scriptParams = null;
    private int _iScriptType = 1;
    private double _dR2Limit = 10.5;
    private double _dQuickR2Limit = 12.0;
    private MixedLayerPhase _startingIS = null;
    private GeneConnector _globalSigmaStar = null;
    private Pattern[] _aFitPatterns = null;
    private String _sErrorMessage = null;
    private String _sName = null;

    public Task(MixedLayerPhase startingIS, AbstractDiffractogram expDiffr, Diffractometer diffractometer, Phase[] aStablePhases, GeneConnector globalSigmaStar, ArrayList alExcludedRanges, ScriptParams scriptParams, int iScriptType) {
        assert (expDiffr != null) : "Missing experimental diffractogram";
        this._startingIS = startingIS;
        this._expDiffr = expDiffr;
        this._diffractometer = diffractometer == null ? new Diffractometer() : diffractometer;
        this._patternParams = new PatternParams(this._expDiffr.getMin2theta(), this._expDiffr.getMax2theta(), this._expDiffr.getStepSize(), this._diffractometer);
        this._aStablePhases = aStablePhases;
        this._alExcludedRanges = alExcludedRanges;
        this._scriptParams = scriptParams;
        this._iScriptType = iScriptType;
        this._sName = this._expDiffr.getName();
        this._globalSigmaStar = globalSigmaStar;
        if (this._globalSigmaStar == null && this._aStablePhases != null) {
            int i = 0;
            while (i < this._aStablePhases.length) {
                if (!this._aStablePhases[i].isSigmaStarGenePresent()) {
                    throw new IllegalArgumentException("Some stable phases do not contain sigma star gene");
                }
                ++i;
            }
        }
    }

    public void setTreshold(double dR2Limit, double dQuickR2Limit) {
        this._dR2Limit = dR2Limit;
        this._dQuickR2Limit = dQuickR2Limit;
    }

    public double getR2Limit() {
        return this._dR2Limit;
    }

    public double getQuickR2Limit() {
        return this._dQuickR2Limit;
    }

    public void setFitPatterns(Pattern[] aFitPatterns) {
        this._aFitPatterns = aFitPatterns;
    }

    public Pattern[] getFitPatterns() {
        return this._aFitPatterns;
    }

    public MixedLayerPhase getStartingIS() {
        return this._startingIS;
    }

    public void setErrorMessage(String sErrorMessage) {
        this._sErrorMessage = sErrorMessage;
        this._sName = this._sName.concat(" - " + sErrorMessage);
    }

    public String getErrorMessage() {
        return this._sErrorMessage;
    }

    public AbstractDiffractogram getExpDiffr() {
        return this._expDiffr;
    }

    public Diffractometer getDiffractometer() {
        return this._diffractometer;
    }

    public PatternParams getPatternParams() {
        return this._patternParams;
    }

    public Phase[] getStablePhases() {
        return this._aStablePhases;
    }

    public ArrayList getExcludedRanges() {
        return this._alExcludedRanges;
    }

    public ScriptParams getScriptParams() {
        return this._scriptParams;
    }

    public int getScriptType() {
        return this._iScriptType;
    }

    public GeneConnector getSigmaStarConn() {
        return this._globalSigmaStar;
    }

    public String toString() {
        return this._sName;
    }
}

