/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.util.Arrays;
import java.util.List;
import net.ndmystko.analysis.tools.XRDLeastSquares;
import net.ndmystko.xrd.AbstractXRDData;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.mod.SybillaDiffractogram;

public class SybillaLeastSquares
extends XRDLeastSquares {
    public SybillaLeastSquares(AbstractXRDData fittedPattern, List lExcludedRanges) {
        super(fittedPattern, lExcludedRanges);
        this._dFittedTotalIntensity = 0.0;
        int i = 0;
        while (i < fittedPattern.getNoOfSteps()) {
            if (this._abExcluded == null || !this._abExcluded[i]) {
                this._dFittedTotalIntensity += fittedPattern.getIntensity(i);
            }
            ++i;
        }
    }

    public void mix(SybillaDiffractogram[] aPhaseIntensities, double[] adPhaseFactor, UserDiffractogram target) {
        int iNoOfPhases = aPhaseIntensities.length;
        double[] adFinalIntensities = target.getIntensities();
        Arrays.fill(adFinalIntensities, 0.0);
        int i = 0;
        while (i < iNoOfPhases) {
            int iNoOfSteps = aPhaseIntensities[i].getNoOfSteps();
            int j = 0;
            while (j < iNoOfSteps) {
                int n = j;
                adFinalIntensities[n] = adFinalIntensities[n] + (aPhaseIntensities[i].getIntensity(j) * (adPhaseFactor[i] + aPhaseIntensities[i].getAdjustementScale()) + aPhaseIntensities[i].getAdjustementOffset());
                ++j;
            }
            aPhaseIntensities[i].setScale(adPhaseFactor[i] + aPhaseIntensities[i].getAdjustementScale());
            ++i;
        }
        double dMaxIntensity = 0.0;
        double dAbsMisfit = 0.0;
        int j = 0;
        while (j < adFinalIntensities.length) {
            if (dMaxIntensity < adFinalIntensities[j]) {
                dMaxIntensity = adFinalIntensities[j];
            }
            if (this._abExcluded == null || !this._abExcluded[j]) {
                dAbsMisfit += Math.abs(adFinalIntensities[j] - this._fittedPattern.getIntensity(j));
            }
            ++j;
        }
        target.setMaxIntensity(dMaxIntensity);
        this._dMisfit = dAbsMisfit / this._dFittedTotalIntensity * 100.0;
    }
}

