/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.analysis.evolution.Chromosome;
import net.ndmystko.xrd.mod.EvolutionListener;
import net.ndmystko.xrd.mod.ModEvol;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.SybillaProducer;
import net.ndmystko.xrd.mod.Task;
import net.ndmystko.xrd.mod.net.ConnectorAuto;
import net.ndmystko.xrd.mod.script.MainScript;
import net.ndmystko.xrd.mod.script.Script;
import net.ndmystko.xrd.mod.script.SingleStepScript;

public class SybillaGuiLess
implements EvolutionListener,
SybillaProducer {
    private static SybillaGuiLess sybilla;
    private Chromosome _bestOne = null;
    private static final String SERIALIZED_RESULTS_FILE_NAME = "resultsAuto.ser";
    private int _iProgramState = 0;
    private static final int PROGRAM_READY = 0;
    private static final int EVOLUTION_STARTED = 5;
    private boolean _bStopEvolution = false;
    private int _iProgress = 0;
    private String _sCalculatedPatternName = "";
    private double _dCurrentMisfit = 0.0;
    private boolean _bPhaseQuick = false;
    private LinkedList _llTasksDone = new LinkedList();
    private LinkedList _llTasksToBeDone = new LinkedList();
    private ArrayList _alCalcPatterns = new ArrayList();
    private Task _processedTask = null;
    private static Logger _logger;

    static {
        _logger = Logger.getLogger("net.ndmystko.xrd.mod.SybillaGuiLess");
    }

    public static void main(String[] argv) {
        sybilla = new SybillaGuiLess();
    }

    public SybillaGuiLess() {
        try {
            new Thread(new ConnectorAuto(this)).start();
        }
        catch (IOException ioe) {
            _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.SybillaGuiLess", "constructor", "Error when establishing server socket, SybillaGuiLess quit", ioe);
            System.exit(1);
        }
        this.deserializePatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEvolution() {
        this._bestOne = null;
        this._processedTask = null;
        LinkedList linkedList = this._llTasksToBeDone;
        synchronized (linkedList) {
            if (this._llTasksToBeDone.size() > 0) {
                this._processedTask = (Task)this._llTasksToBeDone.removeFirst();
            }
        }
        if (this._processedTask == null) {
            return;
        }
        Thread script = null;
        switch (this._processedTask.getScriptType()) {
            case 1: {
                script = new MainScript(this, this._processedTask, this._processedTask.getScriptParams());
                ((Script)script).setTreshold(this._processedTask.getR2Limit(), this._processedTask.getQuickR2Limit());
                break;
            }
            case 2: {
                script = new SingleStepScript(this, this._processedTask);
                ((Script)script).setTreshold(this._processedTask.getR2Limit(), this._processedTask.getQuickR2Limit());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        script.start();
        this._iProgramState = 5;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof ModEvol) {
            this.updateShow(e);
        } else {
            System.out.println("Caught unknown exception: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateShow(ActionEvent event) {
        ModEvol evol = (ModEvol)((Object)event.getSource());
        if (event.getActionCommand().equals("bad population")) {
            this._processedTask.setErrorMessage("Could not find initial solution, restart evolution or try using less strict limits.");
            this.evolFinished(false);
            return;
        }
        if (event.getActionCommand().equals("Evolution cannot recreate failed chromosome")) {
            this._processedTask.setErrorMessage("Too many failed chromosomes, restart evolution or try using less strict limits.");
            this.evolFinished(false);
            return;
        }
        Chromosome bestOne = evol.getBestChromosome();
        this._dCurrentMisfit = bestOne.getFit() / evol.getMaxError() * 100.0;
        this._iProgress = evol.getProgress();
        if (this._bestOne == null || !this._bestOne.equals(bestOne)) {
            this._bestOne = bestOne;
            _logger.logp(Level.FINEST, "net.ndmystko.xrd.mod.SybillaGuiLess", "updateShow", "new better fit: " + this._dCurrentMisfit + " at progress: " + evol.getProgress());
        }
        if (this._bStopEvolution) {
            this._bStopEvolution = false;
            LinkedList linkedList = this._llTasksToBeDone;
            synchronized (linkedList) {
                if (this._processedTask == null) {
                    _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.SybillaGuiLess", "updateShow", "User requested to stop calculation but _processedTask is null!!!");
                } else {
                    this._llTasksToBeDone.addFirst(this._processedTask);
                }
            }
            this._processedTask = null;
            evol.okThatsEnough();
        }
    }

    @Override
    public void setDescription(String sDescription) {
        this._sCalculatedPatternName = sDescription;
    }

    @Override
    public void addResult(Pattern pattern) {
        this._alCalcPatterns.add(pattern);
    }

    @Override
    public void setPhaseQuick(boolean bPhaseQuick) {
        this._bPhaseQuick = bPhaseQuick;
    }

    @Override
    public boolean isCalculating() {
        return this._iProgramState == 5;
    }

    @Override
    public int getProgress() {
        return this._iProgress;
    }

    @Override
    public boolean isPhaseQuick() {
        return this._bPhaseQuick;
    }

    @Override
    public String getCalculatedPatternName() {
        return this._sCalculatedPatternName;
    }

    @Override
    public double getCurrentMisfit() {
        return this._dCurrentMisfit;
    }

    @Override
    public HashMap getDoneTaskNames() {
        LinkedHashMap<Integer, String> hmNames = new LinkedHashMap<Integer, String>();
        int i = 0;
        while (i < this._llTasksDone.size()) {
            Object task = this._llTasksDone.get(i);
            hmNames.put(new Integer(task.hashCode()), task.toString());
            ++i;
        }
        return hmNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getToBeDoneTaskNames() {
        LinkedHashMap<Integer, String> hmNames = new LinkedHashMap<Integer, String>();
        if (this._iProgramState == 5 && this._processedTask != null) {
            hmNames.put(new Integer(this._processedTask.hashCode()), this._processedTask.toString());
        }
        LinkedList linkedList = this._llTasksToBeDone;
        synchronized (linkedList) {
            int i = 0;
            while (i < this._llTasksToBeDone.size()) {
                Object task = this._llTasksToBeDone.get(i);
                hmNames.put(new Integer(task.hashCode()), task.toString());
                ++i;
            }
        }
        return hmNames;
    }

    @Override
    public void addTask(Task task) {
        assert (task != null) : "Got null task to add";
        this._llTasksToBeDone.add(task);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.SybillaGuiLess", "addTask", "Task " + task.toString() + " added");
        this.serializePatterns();
    }

    @Override
    public boolean startCalculation() {
        boolean bStarted = false;
        if (this._iProgramState == 0 && this._llTasksToBeDone.size() > 0) {
            this.startEvolution();
            bStarted = true;
            _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.SybillaGuiLess", "startCalculation", "Calculation started");
        }
        return bStarted;
    }

    @Override
    public void stopCalculation() {
        if (this._iProgramState == 5) {
            this._bStopEvolution = true;
        }
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.SybillaGuiLess", "stopCalculation", "Received request to stop calculation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTasks(List lTaskIds) {
        int iDeletedCount = 0;
        int i = 0;
        while (i < lTaskIds.size()) {
            Object task = null;
            int iTaskId = (Integer)lTaskIds.get(i);
            int j = 0;
            while (j < this._llTasksDone.size()) {
                if (this._llTasksDone.get(j).hashCode() == iTaskId) {
                    task = this._llTasksDone.remove(j);
                    ++iDeletedCount;
                    break;
                }
                ++j;
            }
            if (task == null) {
                j = 0;
                while (j < this._llTasksToBeDone.size()) {
                    if (this._llTasksToBeDone.get(j).hashCode() == iTaskId) {
                        LinkedList linkedList = this._llTasksToBeDone;
                        synchronized (linkedList) {
                            task = this._llTasksToBeDone.remove(j);
                            ++iDeletedCount;
                            break;
                        }
                    }
                    ++j;
                }
                if (task == null) {
                    _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.SybillaGuiLess", "deleteTasks", "Did not identify a task!");
                }
            }
            ++i;
        }
        if (iDeletedCount > 0) {
            this.serializePatterns();
            System.gc();
        }
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.SybillaGuiLess", "deleteTasks", String.valueOf(iDeletedCount) + " tasks deleted");
    }

    @Override
    public Task[] getTasks(List lTaskIds) {
        ArrayList alIdentifiedTasks = new ArrayList(lTaskIds.size());
        int i = 0;
        while (i < lTaskIds.size()) {
            Object task = null;
            int iTaskId = (Integer)lTaskIds.get(i);
            int j = 0;
            while (j < this._llTasksDone.size()) {
                if (this._llTasksDone.get(j).hashCode() == iTaskId) {
                    task = this._llTasksDone.get(j);
                    break;
                }
                ++j;
            }
            if (task == null) {
                _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.SybillaGuiLess", "getTasks", "Did not identify a task!");
            } else {
                alIdentifiedTasks.add(task);
            }
            ++i;
        }
        Task[] aTasks = new Task[alIdentifiedTasks.size()];
        aTasks = alIdentifiedTasks.toArray(aTasks);
        _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.SybillaGuiLess", "getTasks", "Returning " + aTasks.length + " tasks");
        return aTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evolFinished(boolean bStop) {
        _logger.logp(Level.INFO, "net.ndmystko.xrd.mod.SybillaGuiLess", "evolFinished", "Analysis finished");
        if (this._processedTask != null) {
            this._llTasksDone.add(this._processedTask);
            Pattern[] aPatterns = new Pattern[this._alCalcPatterns.size()];
            aPatterns = this._alCalcPatterns.toArray(aPatterns);
            this._processedTask.setFitPatterns(aPatterns);
            _logger.logp(Level.FINER, "net.ndmystko.xrd.mod.SybillaGuiLess", "evolFinished", "Task " + this._processedTask.toString() + " done");
        }
        this._processedTask = null;
        this.serializePatterns();
        this._alCalcPatterns.clear();
        this._iProgress = 0;
        this._sCalculatedPatternName = "";
        this._dCurrentMisfit = 0.0;
        LinkedList linkedList = this._llTasksToBeDone;
        synchronized (linkedList) {
            if (this._llTasksToBeDone.size() > 0 && !bStop) {
                this.startEvolution();
            } else {
                this._iProgramState = 0;
            }
        }
    }

    private void serializePatterns() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                fos = new FileOutputStream(SERIALIZED_RESULTS_FILE_NAME);
                oos = new ObjectOutputStream(fos);
                LinkedList<Task> llAllToBeDone = new LinkedList<Task>(this._llTasksToBeDone);
                if (this._processedTask != null && this._iProgramState == 5) {
                    llAllToBeDone.addFirst(this._processedTask);
                }
                oos.writeObject(llAllToBeDone);
                oos.writeObject(this._llTasksDone);
                oos.flush();
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.SybillaGuiLess", "serializePatterns", "cannot serialize", e);
        }
    }

    private void deserializePatterns() {
        File file = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            file = new File(SERIALIZED_RESULTS_FILE_NAME);
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            this._llTasksToBeDone = (LinkedList)ois.readObject();
            this._llTasksDone = (LinkedList)ois.readObject();
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ioe) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.SybillaGuiLess", "deserializePatterns", "IOException in deserializePatterns", ioe);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
        }
        catch (ClassNotFoundException cnfe) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.SybillaGuiLess", "deserializePatterns", "ClassNotFoundException in deserializePatterns", cnfe);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
        }
        catch (ClassCastException cce) {
            _logger.logp(Level.WARNING, "net.ndmystko.xrd.mod.SybillaGuiLess", "deserializePatterns", "ClassCastException in deserializePatterns", cce);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

