/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.ndmystko.xrd.Diffractometer;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.PhaseFactory;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteTwoGlyLayer;
import net.ndmystko.xrd.mod.layer.IlliteLayer;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.ProbabCondition21;

public class PhaseJUTest
extends TestCase {
    private PatternParams _params = null;

    public PhaseJUTest(String sMethodName) {
        super(sMethodName);
    }

    public void setUp() throws Exception {
        this._params = new PatternParams(2.0, 52.0, 0.05, new Diffractometer());
    }

    public void testIlliteRangeInheritance() {
        ProbabCondition21 initMatrix = new ProbabCondition21();
        AbstractLayer[] aLayers = new AbstractLayer[]{new IlliteLayer(this._params), new DiSmectiteTwoGlyLayer(this._params)};
        MixedLayerPhase phase1 = new MixedLayerPhase(this._params, aLayers, null, initMatrix, 0);
        PhaseJUTest.assertTrue((boolean)phase1.getAbstractProbabMatrix().updateProbability());
        MixedLayerPhase phase2 = PhaseFactory.createMixedLayerPhase(1, 1, 0, false, this._params, phase1, true);
        PhaseJUTest.assertTrue((boolean)phase2.getAbstractProbabMatrix().updateProbability());
        AbstractProbabCondition matrix = phase2.getAbstractProbabMatrix();
        PhaseJUTest.assertEquals((double)matrix.getIlliteRange().getDouble1(), (double)matrix.getAbsoluteLowIlliteLimit(), (double)1.0E-12);
        PhaseJUTest.assertEquals((double)matrix.getIlliteRange().getDouble2(), (double)1.0, (double)1.0E-12);
        initMatrix = new ProbabCondition21(0.95, 0.98);
        phase1 = new MixedLayerPhase(this._params, aLayers, null, initMatrix, 0);
        PhaseJUTest.assertTrue((boolean)phase1.getAbstractProbabMatrix().updateProbability());
        phase2 = PhaseFactory.createMixedLayerPhase(1, 1, 0, false, this._params, phase1, true);
        PhaseJUTest.assertTrue((boolean)phase2.getAbstractProbabMatrix().updateProbability());
        matrix = phase2.getAbstractProbabMatrix();
        PhaseJUTest.assertEquals((double)matrix.getIlliteRange().getDouble1(), (double)0.95, (double)1.0E-12);
        PhaseJUTest.assertEquals((double)matrix.getIlliteRange().getDouble2(), (double)0.98, (double)1.0E-12);
        initMatrix = new ProbabCondition21(0.95, 0.98);
        phase1 = new MixedLayerPhase(this._params, aLayers, null, initMatrix, 0);
        PhaseJUTest.assertTrue((boolean)phase1.getAbstractProbabMatrix().updateProbability());
        phase2 = PhaseFactory.createMixedLayerPhase(1, 1, 1, false, this._params, phase1, true);
        PhaseJUTest.assertTrue((boolean)phase2.getAbstractProbabMatrix().updateProbability());
        matrix = phase2.getAbstractProbabMatrix();
        PhaseJUTest.assertEquals((double)matrix.getIlliteRange().getDouble1(), (double)0.95, (double)1.0E-12);
        PhaseJUTest.assertEquals((double)matrix.getIlliteRange().getDouble2(), (double)0.98, (double)1.0E-12);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new PhaseJUTest("testIlliteRangeInheritance"));
        return suite;
    }

    public static void main(String[] argv) throws Exception {
        PhaseJUTest test = new PhaseJUTest("testIlliteRangeInheritance");
        test.setUp();
        test.testIlliteRangeInheritance();
    }
}

