/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.util.ArrayList;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.AbstractSmectite;
import net.ndmystko.xrd.mod.layer.DiSmectiteOneGlyLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteOneWatLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteTwoGlyLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteTwoWatContrLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteTwoWatLayer;
import net.ndmystko.xrd.mod.layer.IlliteLayer;
import net.ndmystko.xrd.mod.layer.edge.AbstractEdge;
import net.ndmystko.xrd.mod.layer.edge.OneGlyEdges;
import net.ndmystko.xrd.mod.layer.edge.TwoGlyEdges;
import net.ndmystko.xrd.mod.probab.ProbabCondition20;
import net.ndmystko.xrd.mod.probab.ProbabCondition21;
import net.ndmystko.xrd.mod.probab.ProbabCondition22;
import net.ndmystko.xrd.mod.probab.ProbabCondition23;
import net.ndmystko.xrd.mod.probab.ProbabCondition30;
import net.ndmystko.xrd.mod.probab.ProbabCondition31;
import net.ndmystko.xrd.mod.probab.ProbabCondition32;
import net.ndmystko.xrd.mod.probab.ProbabCondition40;
import net.ndmystko.xrd.mod.probab.ProbabCondition41;

public class PhaseFactory {
    public static MixedLayerPhase createMixedLayerPhase(int iPhaseType, int iR, int iPhaseState, boolean bWithEdges, PatternParams params, MixedLayerPhase pattern, boolean bSigmaStarGlobal) {
        assert (!bWithEdges) : "Do not use edges yet!";
        MixedLayerPhase phase = null;
        if (iPhaseType == 0 && iR == 0 && iPhaseState == 0) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoGlyLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) {
                assert (false) : "edges not implemented yet";
                edges = new AbstractEdge[]{new TwoGlyEdges(params), edges[0]};
            }
            ProbabCondition20 probab = new ProbabCondition20();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R0 GLY");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 0 && iR == 0 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition20 probab = new ProbabCondition20();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R0 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 1 && iR == 0 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params), new DiSmectiteOneWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition30 probab = new ProbabCondition30();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISS R0 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 2 && iR == 0 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params), new DiSmectiteTwoWatContrLayer(params), new DiSmectiteOneWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition40 probab = new ProbabCondition40();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISSS R0 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 1 && iR == 0 && iPhaseState == 0) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoGlyLayer(params), new DiSmectiteOneGlyLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) {
                assert (false) : "edges not implemented yet";
                edges = new AbstractEdge[]{edges[0], new TwoGlyEdges(params), new OneGlyEdges(params)};
            }
            ProbabCondition30 probab = new ProbabCondition30();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISS R0 GLY");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 0 && iR == 1 && iPhaseState == 0) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoGlyLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) {
                assert (false) : "edges not implemented yet";
                edges = new AbstractEdge[]{new TwoGlyEdges(params), edges[0]};
            }
            ProbabCondition21 probab = new ProbabCondition21();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R1 GLY");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 0 && iR == 1 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition21 probab = new ProbabCondition21();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R1 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 1 && iR == 1 && iPhaseState == 0) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoGlyLayer(params), new DiSmectiteOneGlyLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) {
                assert (false) : "edges not implemented yet";
                edges = new AbstractEdge[]{edges[0], new TwoGlyEdges(params), new OneGlyEdges(params)};
            }
            ProbabCondition31 probab = new ProbabCondition31();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISS R1 GLY");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 1 && iR == 1 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params), new DiSmectiteOneWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition31 probab = new ProbabCondition31();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISS R1 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 2 && iR == 1 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params), new DiSmectiteTwoWatContrLayer(params), new DiSmectiteOneWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition41 probab = new ProbabCondition41();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISSS R1 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 0 && iR == 2 && iPhaseState == 0) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoGlyLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition22 probab = new ProbabCondition22();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R2 GLY");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 0 && iR == 2 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition22 probab = new ProbabCondition22();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R2 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 1 && iR == 2 && iPhaseState == 0) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoGlyLayer(params), new DiSmectiteOneGlyLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition32 probab = new ProbabCondition32();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISS R2 GLY");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 1 && iR == 2 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params), new DiSmectiteOneWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition32 probab = new ProbabCondition32();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("ISS R2 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 0 && iR == 3 && iPhaseState == 0) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoGlyLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition23 probab = new ProbabCondition23();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R3 GLY");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else if (iPhaseType == 0 && iR == 3 && iPhaseState == 1) {
            AbstractLayer[] layers = new AbstractLayer[]{new IlliteLayer(params), new DiSmectiteTwoWatLayer(params)};
            AbstractEdge[] edges = null;
            if (bWithEdges) assert (false) : "edges not implemented yet";
            ProbabCondition23 probab = new ProbabCondition23();
            phase = new MixedLayerPhase(params, layers, edges, probab, iPhaseType, !bSigmaStarGlobal);
            phase.setDescription("IS R3 WAT");
            PhaseFactory.inheritGeneProperties(layers, edges, phase, pattern);
        } else {
            throw new IllegalArgumentException("Don't know how to create requested structure");
        }
        return phase;
    }

    public static AbstractLayer getSmectiteSubstitute(AbstractLayer origSmect, int iState, PatternParams patternParams) {
        AbstractSmectite subst = null;
        if (iState == 0) {
            if (origSmect instanceof DiSmectiteTwoWatLayer) {
                subst = new DiSmectiteTwoGlyLayer(patternParams);
            } else if (origSmect instanceof DiSmectiteOneWatLayer) {
                subst = new DiSmectiteOneGlyLayer(patternParams);
            } else if (origSmect instanceof DiSmectiteTwoWatContrLayer) {
                subst = new DiSmectiteOneGlyLayer(patternParams);
            }
        } else if (iState == 1) {
            if (origSmect instanceof DiSmectiteTwoGlyLayer) {
                subst = new DiSmectiteTwoWatLayer(patternParams);
            } else if (origSmect instanceof DiSmectiteOneGlyLayer) {
                subst = new DiSmectiteOneWatLayer(patternParams);
            }
        } else assert (false) : "Illegal state";
        return subst;
    }

    public static void inheritGeneProperties(AbstractLayer[] layers, AbstractEdge[] edges, MixedLayerPhase target, MixedLayerPhase pattern) {
        if (pattern == null) {
            return;
        }
        int i = 0;
        while (i < layers.length) {
            AbstractLayer patternLayer = pattern.getLayer(layers[i].getName(), false);
            if (patternLayer != null) {
                layers[i].inheritGenes(patternLayer);
                layers[i].updateLayer();
            }
            ++i;
        }
        if (edges != null) {
            i = 0;
            while (i < edges.length) {
                AbstractEdge patternEdge = pattern.getEdge(edges[i].getName(), false);
                if (patternEdge != null) {
                    edges[i].inheritGenes(patternEdge);
                    edges[i].updateLayer();
                }
                ++i;
            }
        }
        ArrayList alConnectors = new ArrayList();
        target.addConnectors(alConnectors, false, true);
        GeneConnector[] aTargetConns = new GeneConnector[alConnectors.size()];
        aTargetConns = alConnectors.toArray(aTargetConns);
        alConnectors.clear();
        pattern.addConnectors(alConnectors, false, true);
        GeneConnector[] aPatternConns = new GeneConnector[alConnectors.size()];
        aPatternConns = alConnectors.toArray(aPatternConns);
        assert (!(target.isSigmaStarGenePresent() ^ pattern.isSigmaStarGenePresent())) : "In inheritPhaseGeneValues only one phase has sigma star gene!";
        if (target.isSigmaStarGenePresent()) {
            PhaseFactory.findConn(aTargetConns, "sigma-star").updateTo(PhaseFactory.findConn(aPatternConns, "sigma-star"));
        }
        PhaseFactory.findConn(aTargetConns, "Tmean").updateTo(PhaseFactory.findConn(aPatternConns, "Tmean"));
        GeneConnector targetWa = target.getAbstractProbabMatrix().getWAConnector();
        GeneConnector patternWa = pattern.getAbstractProbabMatrix().getWAConnector();
        double dLowestLimit = target.getAbstractProbabMatrix().getAbsoluteLowIlliteLimit();
        if (patternWa.getGene().getHighLimit() > dLowestLimit) {
            double dLowLimit = patternWa.getGene().getLowLimit() < dLowestLimit ? dLowestLimit : patternWa.getGene().getLowLimit();
            targetWa.getGene().setLimits(dLowLimit, patternWa.getGene().getHighLimit());
            targetWa.getGene().setValue(patternWa.getGene().getValue() < dLowestLimit ? dLowestLimit : patternWa.getGene().getValue());
            targetWa.setActive(patternWa.isActive());
        }
        if (target.getAbstractProbabMatrix().getR() > 0 && pattern.getAbstractProbabMatrix().getR() > 0) {
            target.getAbstractProbabMatrix().getPControlConnector().updateTo(pattern.getAbstractProbabMatrix().getPControlConnector());
        }
        target.getAbstractProbabMatrix().updateProbability();
        AbstractLayer[] aSmectiteLayers = PhaseFactory.getSmectiteLayers(target);
        assert (aSmectiteLayers.length > 0) : "I/S without smectite???";
        int i2 = 1;
        while (i2 < aSmectiteLayers.length) {
            boolean bSuccess = aSmectiteLayers[i2].shareConnector(aSmectiteLayers[0], "oct iron content");
            assert (bSuccess) : "Failed oct. iron gene merging";
            ++i2;
        }
    }

    private static GeneConnector findConn(GeneConnector[] aConnectors, String sGeneName) {
        int iGeneIndex = -1;
        int iGeneCount = 0;
        int i = 0;
        while (i < aConnectors.length) {
            if (aConnectors[i].getGene().getName().equals(sGeneName)) {
                iGeneIndex = i;
                ++iGeneCount;
            }
            ++i;
        }
        assert (iGeneCount < 2);
        GeneConnector foundConn = null;
        if (iGeneCount == 1) {
            foundConn = aConnectors[iGeneIndex];
        }
        return foundConn;
    }

    private static AbstractLayer[] getSmectiteLayers(Phase phase) {
        ArrayList<AbstractLayer> alSmectiteLayers = new ArrayList<AbstractLayer>(3);
        AbstractLayer layer = null;
        layer = phase.getLayer("di-smectite 2gly", false);
        if (layer != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("di-smectite 1gly", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("di-smectite 2wat", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("di-smectite 2wat contr.", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("di-smectite 1wat", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("tri-smectite 1gly", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("tri-smectite 2gly", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("tri-smectite 1wat", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("tri-smectite 2wat", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        if ((layer = phase.getLayer("tri-smectite 2wat contr.", false)) != null) {
            alSmectiteLayers.add(layer);
        }
        return alSmectiteLayers.toArray(new AbstractLayer[alSmectiteLayers.size()]);
    }
}

