/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.Z;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.equation.MonoEdgeEquation;
import net.ndmystko.xrd.mod.equation.MonoRegularEquation;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.LayerAndEdge;
import net.ndmystko.xrd.mod.layer.edge.AbstractEdge;
import net.ndmystko.xrd.mod.probab.Probability;
import net.ndmystko.xrd.util.AnyDistribution;
import net.ndmystko.xrd.util.Distribution;
import net.ndmystko.xrd.util.LognormalDistribution;
import org.jdom.Element;

public class Phase
implements Serializable {
    private static final long serialVersionUID = 7904885074723556409L;
    protected transient UserDiffractogram _pattern = null;
    protected AbstractLayer[] _layer = null;
    protected AbstractEdge[] _edge = null;
    protected Distribution _distrib = null;
    protected PatternParams _patternParams = null;
    protected int _iPhaseType = 0;
    protected int _iNoOfData = 0;
    private String _sDescription = "unknown";
    private String _sSummaryDescription = "unknown";
    public static final double T_MEAN_LOW_LIMIT = 1.0;
    public double T_MEAN_HIGH_LIMIT = 60.0;
    public static final double T_MEAN_DEFAULT = 4.0;
    public static final double T_MEAN_DECAY_CONST = 2.0;
    protected static final double T_LIMIT_FACTOR = 2.5;
    protected GeneConnector _tMeanGene = null;
    protected boolean _bTMeanGeneActive = true;
    protected GeneConnector _sigmaGeneConnector = null;
    protected boolean _bSigmaGeneActive = true;
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.Phase");

    public Phase(PatternParams patternParams, AbstractLayer layer, AbstractEdge edge, int iPhaseType) {
        this(patternParams, layer, edge, iPhaseType, false);
    }

    public Phase(PatternParams patternParams, AbstractLayer layer, AbstractEdge edge, int iPhaseType, boolean bWithSigmaStar) {
        this._layer = new AbstractLayer[1];
        this._layer[0] = layer;
        if (edge != null) {
            this._edge = new AbstractEdge[1];
            this._edge[0] = edge;
        }
        this._distrib = new LognormalDistribution(4.0, Phase.calcDistLimit(this.T_MEAN_HIGH_LIMIT, 2.5));
        this._iPhaseType = iPhaseType;
        this._patternParams = patternParams;
        this._iNoOfData = (int)Math.round((this._patternParams.getMax2theta() - this._patternParams.getMin2theta()) / this._patternParams.getStepSize()) + 1;
        this._pattern = new UserDiffractogram(this._patternParams.getMin2theta(), this._patternParams.getMax2theta(), this._patternParams.getStepSize());
        this._tMeanGene = new GeneConnector(1.0, this.T_MEAN_HIGH_LIMIT, 4.0, 2.0);
        this._tMeanGene.getGene().setName("Tmean");
        if (bWithSigmaStar) {
            this._sigmaGeneConnector = new GeneConnector(2.0, 80.0, 12.0, 2.0);
            this._sigmaGeneConnector.getGene().setName("sigma-star");
            this._sigmaGeneConnector.setActive(false);
        }
    }

    protected Phase(PatternParams patternParams, AbstractLayer[] layers, AbstractEdge[] edges, int iPhaseType, double dTMeanHighLimit) {
        this(patternParams, layers, edges, iPhaseType, false, dTMeanHighLimit);
    }

    protected Phase(PatternParams patternParams, AbstractLayer[] layers, AbstractEdge[] edges, int iPhaseType, boolean bWithSigmaStar, double dTMeanHighLimit) {
        assert (edges == null || layers.length == edges.length);
        this._layer = layers;
        this._edge = edges;
        this.T_MEAN_HIGH_LIMIT = dTMeanHighLimit;
        this._distrib = new LognormalDistribution(4.0, Phase.calcDistLimit(this.T_MEAN_HIGH_LIMIT, 2.5));
        this._iPhaseType = iPhaseType;
        this._patternParams = patternParams;
        this._iNoOfData = (int)Math.round((this._patternParams.getMax2theta() - this._patternParams.getMin2theta()) / this._patternParams.getStepSize()) + 1;
        this._pattern = new UserDiffractogram(this._patternParams.getMin2theta(), this._patternParams.getMax2theta(), this._patternParams.getStepSize());
        this._tMeanGene = new GeneConnector(1.0, this.T_MEAN_HIGH_LIMIT, 4.0, 2.0);
        this._tMeanGene.getGene().setName("Tmean");
        if (bWithSigmaStar) {
            this._sigmaGeneConnector = new GeneConnector(2.0, 80.0, 12.0, 2.0);
            this._sigmaGeneConnector.getGene().setName("sigma-star");
            this._sigmaGeneConnector.setActive(false);
        }
    }

    public int getPhaseType() {
        return this._iPhaseType;
    }

    public AbstractLayer[] getLayers() {
        return this._layer;
    }

    public AbstractEdge[] getEdges() {
        return this._edge;
    }

    public AbstractLayer getLayer(String sName, boolean bFailOnMissing) {
        AbstractLayer layer = null;
        boolean bMoreThanOne = false;
        int i = 0;
        while (i < this._layer.length) {
            if (this._layer[i].getName().equals(sName)) {
                if (layer == null) {
                    layer = this._layer[i];
                } else {
                    bMoreThanOne = true;
                    break;
                }
            }
            ++i;
        }
        if (layer == null && bFailOnMissing) {
            throw new IllegalArgumentException("Could not find layer " + sName + " in phase type " + this.getPhaseType());
        }
        if (bMoreThanOne) {
            throw new IllegalArgumentException("There is more than one layer '" + sName + "' in phase type " + this.getPhaseType());
        }
        return layer;
    }

    public AbstractEdge getEdge(String sName, boolean bFailOnMissing) {
        AbstractEdge edge = null;
        boolean bMoreThanOne = false;
        int i = 0;
        while (i < this._edge.length) {
            if (this._edge[i].getName().equals(sName)) {
                if (edge == null) {
                    edge = this._edge[i];
                } else {
                    bMoreThanOne = true;
                    break;
                }
            }
            ++i;
        }
        if (edge == null && bFailOnMissing) {
            throw new IllegalArgumentException("Could not find edge " + sName + " in phase type " + this.getPhaseType());
        }
        if (bMoreThanOne) {
            throw new IllegalArgumentException("There is more than one edge '" + sName + "' in phase type " + this.getPhaseType());
        }
        return edge;
    }

    public boolean isGlyLayer() {
        boolean bIs = false;
        int i = 0;
        while (i < this._layer.length) {
            bIs |= this._layer[i].getClass().getName().indexOf("Gly") > -1;
            ++i;
        }
        return bIs;
    }

    public boolean isWatLayer() {
        boolean bIs = false;
        int i = 0;
        while (i < this._layer.length) {
            bIs |= this._layer[i].getClass().getName().indexOf("Wat") > -1;
            ++i;
        }
        return bIs;
    }

    public Distribution getDistribution() {
        return this._distrib;
    }

    public void setDistribution(Distribution distr) {
        this._distrib = distr;
        this._bTMeanGeneActive = false;
    }

    public void calcIntensities() {
        if (this._bTMeanGeneActive) {
            ((LognormalDistribution)this._distrib).recalcDistribution(this._tMeanGene.getValue(), Phase.calcDistLimit(this._tMeanGene.getValue(), 2.5));
        }
        this._layer[0].updateLayer();
        this._layer[0].computeVariableFactors();
        if (this._edge != null) {
            assert (this._edge.length == 1);
            this._edge[0].updateLayer();
            this._edge[0].computeVariableFactors();
        }
        Z z = this._patternParams.getZ();
        double[] adIntens = this._pattern.getIntensities();
        if (this._edge == null) {
            MonoRegularEquation eq = new MonoRegularEquation();
            eq.compute(this._layer[0].getFactorA(), this._layer[0].getFactorB(), this._layer[0].getDSpacing(), this._layer[0].getDSpacingDelta(), z, this._distrib, adIntens);
        } else {
            MonoEdgeEquation eq = new MonoEdgeEquation();
            eq.compute(this._layer[0].getFactorA(), this._layer[0].getFactorB(), this._edge[0].getFactorAK(), this._edge[0].getFactorBK(), this._edge[0].getFactorA0(), this._edge[0].getFactorB0(), this._layer[0].getDSpacing(), this._layer[0].getDSpacingDelta(), this._edge[0].getDSpacing0(), z, this._distrib, adIntens);
        }
        this.applyAbsoluteScale(null);
    }

    public UserDiffractogram getIntensities() {
        return this._pattern;
    }

    public void addConnectors(List lList, boolean bActiveOnly, boolean bNoDuplicates) {
        if (!(this._sigmaGeneConnector == null || !this._bSigmaGeneActive && bActiveOnly || lList.contains(this._sigmaGeneConnector) && bNoDuplicates)) {
            lList.add(this._sigmaGeneConnector);
        }
        if (!(!this._bTMeanGeneActive && bActiveOnly || lList.contains(this._tMeanGene) && bNoDuplicates)) {
            lList.add(this._tMeanGene);
        }
        int i = 0;
        while (i < this._layer.length) {
            this._layer[i].addConnectors(lList, bActiveOnly, bNoDuplicates);
            ++i;
        }
        if (this._edge != null) {
            i = 0;
            while (i < this._edge.length) {
                this._edge[i].addConnectors(lList, bActiveOnly, bNoDuplicates);
                ++i;
            }
        }
    }

    public void addConnectorsBranch(DefaultMutableTreeNode parent) {
        if (this._sigmaGeneConnector != null) {
            parent.add(new DefaultMutableTreeNode(this._sigmaGeneConnector));
        }
        parent.add(new DefaultMutableTreeNode(this._tMeanGene));
        int i = 0;
        while (i < this._layer.length) {
            DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(this._layer[i].getName());
            this._layer[i].addConnectorsBranch(layerNode);
            parent.add(layerNode);
            ++i;
        }
        if (this._edge != null) {
            i = 0;
            while (i < this._edge.length) {
                DefaultMutableTreeNode edgeNode = new DefaultMutableTreeNode(this._edge[i].getName());
                this._edge[i].addConnectorsBranch(edgeNode);
                parent.add(edgeNode);
                ++i;
            }
        }
    }

    public void setTMeanGeneActive(boolean bActive) {
        this._bTMeanGeneActive = bActive;
    }

    public boolean isTMeanGeneActive() {
        return this._bTMeanGeneActive;
    }

    public void freezeTMean(double dTmean) {
        this._tMeanGene.setValue(dTmean);
        ((LognormalDistribution)this._distrib).recalcDistribution(dTmean, Phase.calcDistLimit(dTmean, 2.5));
        this._bTMeanGeneActive = false;
    }

    public GeneConnector getTMeanConn() {
        return this._tMeanGene;
    }

    public void setTMeanGeneValue(double dValue) {
        this._tMeanGene.setValue(dValue);
    }

    public double getTMeanGeneValue() {
        return this._tMeanGene.getValue();
    }

    public void setSigmaStarGeneValue(double dSigmaStar) {
        assert (this._sigmaGeneConnector != null) : "Mishandling of sigma-star...";
        this._sigmaGeneConnector.setValue(dSigmaStar);
    }

    public double getSigmaStarGeneValue() {
        assert (this._sigmaGeneConnector != null) : "Mishandling of sigma-star...";
        return this._sigmaGeneConnector.getValue();
    }

    public GeneConnector getSigmaStarConn() {
        return this._sigmaGeneConnector;
    }

    public boolean isSigmaStarGenePresent() {
        return this._sigmaGeneConnector != null;
    }

    public void establishSigmaStarGene(GeneConnector sigmaStarConn) {
        if (sigmaStarConn == null) {
            this._sigmaGeneConnector = new GeneConnector(2.0, 80.0, 12.0, 2.0);
            this._sigmaGeneConnector.getGene().setName("sigma-star");
        } else {
            this._sigmaGeneConnector = (GeneConnector)sigmaStarConn.clone();
        }
    }

    public void removeSigmaStarGene() {
        this._sigmaGeneConnector = null;
    }

    public String[] dumpPhase(int iProbabType) {
        String[] asLines = new String[]{this.getSummaryDescription()};
        return asLines;
    }

    public Element serializeXML() {
        Element phase = new Element("phase");
        phase.setAttribute("type", "mono");
        phase.setAttribute("name", this.getDescription());
        if (this._sigmaGeneConnector != null && this._bSigmaGeneActive) {
            phase.setAttribute("sigma_star", String.valueOf(this._sigmaGeneConnector.getValue()));
        }
        Element[] layersAndEdges = LayerAndEdge.serializeXML(this._layer, this._edge);
        phase.addContent(layersAndEdges[0]);
        Element distribution = new Element("distribution");
        if (this._distrib instanceof LognormalDistribution) {
            distribution.setAttribute("type", "lognormal");
        } else if (this._distrib instanceof AnyDistribution) {
            distribution.setAttribute("type", "single_crystal");
        }
        if (this._distrib instanceof LognormalDistribution) {
            distribution.setAttribute("Tmean", String.valueOf(((LognormalDistribution)this._distrib).getT()));
        } else {
            distribution.setAttribute("Tmean", String.valueOf(this._distrib.getMean()));
        }
        distribution.setAttribute("Tmax", String.valueOf(this._distrib.getNoOfClasses()));
        phase.addContent(distribution);
        return phase;
    }

    public void setDescription(String sDescription) {
        this._sDescription = sDescription;
        this.setSummaryDescription(sDescription);
    }

    public String getDescription() {
        return this._sDescription;
    }

    private void setSummaryDescription(String sSummaryDescription) {
        this._sSummaryDescription = sSummaryDescription.replaceAll(" ?(WAT|GLY)", "");
    }

    public String getSummaryDescription() {
        return this._sSummaryDescription;
    }

    public static Phase[] duplicatePhases(Phase[] aPhases) {
        Phase[] aPhasesDuplicate = null;
        if (aPhases != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1000000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(aPhases);
                oos.close();
                byte[] abSerialized = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(abSerialized);
                ObjectInputStream ois = new ObjectInputStream(bais);
                aPhasesDuplicate = (Phase[])ois.readObject();
            }
            catch (IOException ioe) {
                _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.Phase", "duplicatePhases", "IOException in phases duplication", ioe);
                throw new RuntimeException("Internal error:\n" + ioe.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.Phase", "duplicatePhases", "ClassNotFoundException in phases duplication", cnfe);
                throw new RuntimeException("Internal error:\n" + cnfe.getMessage());
            }
        }
        return aPhasesDuplicate;
    }

    protected static int calcDistLimit(double dTmean, double dLimitFactor) {
        return (int)Math.ceil(dTmean * dLimitFactor);
    }

    protected void applyAbsoluteScale(Probability probab) {
        assert (probab == null && this._layer.length == 1 || probab != null && this._layer.length > 1);
        double dFactor = 0.0;
        if (this._edge == null) {
            double dMeanDSpacing = 0.0;
            double dMeanDensity = 0.0;
            double dMeanVolume = 0.0;
            double dW = 1.0;
            int i = 0;
            while (i < this._layer.length) {
                if (probab != null) {
                    dW = probab.getW0(i);
                }
                dMeanDSpacing += this._layer[i].getDSpacing() * dW;
                double dVolume = this._layer[i].getVolume();
                dMeanVolume += dVolume * dW;
                dMeanDensity += this._layer[i].getDensity(dVolume) * dW;
                ++i;
            }
            dFactor = dMeanDSpacing / (this._distrib.getMean() * dMeanVolume * dMeanVolume * dMeanDensity);
        } else {
            double dNMean = this._distrib.getMean();
            double dMeanDSpacing = 0.0;
            double dMeanDensity = 0.0;
            double dMeanVolume = 0.0;
            double dW = 1.0;
            int i = 0;
            while (i < this._layer.length) {
                if (probab != null) {
                    dW = probab.getW0(i);
                }
                dMeanDSpacing += dW * (dNMean * this._layer[i].getDSpacing() + this._edge[i].getTotalDSpacing());
                double dLayerVolume = this._layer[i].getVolume();
                double dEdgeVolume = this._edge[i].getVolume();
                dMeanVolume += dW * (dNMean * dLayerVolume + dEdgeVolume);
                dMeanDensity += dW * (dNMean * this._layer[i].getDensity(dLayerVolume) + this._edge[i].getDensity(dEdgeVolume));
                ++i;
            }
            dFactor = (dMeanDSpacing /= dNMean + 1.0) / (this._distrib.getMean() * (dMeanVolume /= dNMean + 1.0) * dMeanVolume * (dMeanDensity /= dNMean + 1.0));
        }
        double[] adIntens = this._pattern.getIntensities();
        int i = 0;
        while (i < adIntens.length) {
            int n = i++;
            adIntens[n] = adIntens[n] * dFactor;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._pattern = new UserDiffractogram(this._patternParams.getMin2theta(), this._patternParams.getMax2theta(), this._patternParams.getStepSize());
        if (this.getClass().getName().equals("net.ndmystko.xrd.mod.Phase")) {
            this.calcIntensities();
        }
    }

    public String toString() {
        return this._sDescription;
    }
}

