/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.ndmystko.xrd.AtomicScatteringFactor;
import net.ndmystko.xrd.Diffractometer;
import net.ndmystko.xrd.Lp;
import net.ndmystko.xrd.LpCache;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.Z;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class PatternParams
implements Serializable {
    private static final long serialVersionUID = -8534500008600778553L;
    private static final double DEFAULT_LAMBDA = 1.54178;
    private double _dMin2theta = 0.0;
    private double _dMax2theta = 0.0;
    private double _dStepSize = 0.0;
    private double _dLambda = 1.54178;
    private Diffractometer _diffractometer = null;
    private transient Z _z = null;
    private transient AtomicScatteringFactor[] _aFactors = null;
    private transient LpCache _lpCache = null;
    private static transient Component _guiComponent = null;
    public static final double LP_ORIENTATION_LOW = 2.0;
    public static final double LP_ORIENTATION_HIGH = 80.0;
    private static final int LP_ORIENTATION_STEPS = 40;

    public PatternParams(double dMin2theta, double dMax2theta, double dStepSize, Diffractometer diffractometer) {
        this(dMin2theta, dMax2theta, dStepSize, 1.54178, diffractometer);
    }

    public PatternParams(double dMin2theta, double dMax2theta, double dStepSize, double dLambda, Diffractometer diffractometer) {
        this._dMin2theta = dMin2theta;
        this._dMax2theta = dMax2theta;
        this._dStepSize = dStepSize;
        this._dLambda = dLambda;
        this._diffractometer = diffractometer;
        this._z = new Z(dMin2theta, dMax2theta, dStepSize, dLambda);
        this._aFactors = AtomicScatteringFactor.getAllFactors(dMin2theta, dMax2theta, dStepSize, dLambda);
        File lpCacheFile = new File("LpCache.ser");
        boolean bLpCacheOK = false;
        if (lpCacheFile.exists()) {
            try {
                this._lpCache = LpCache.deserializeData(lpCacheFile);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            boolean bl = bLpCacheOK = this._lpCache != null && this._lpCache.getS1() == this._diffractometer.getSoller1Size() && this._lpCache.getS2() == this._diffractometer.getSoller2Size() && this._lpCache.getLowOrientationLimit() == 2.0 && this._lpCache.getHighOrientationLimit() == 80.0 && this._lpCache.getNoOfPatterns() == 40 && this._lpCache.getMin2theta() == this._dMin2theta && this._lpCache.getMax2theta() == this._dMax2theta && this._lpCache.getStepSize() == this._dStepSize;
        }
        if (!bLpCacheOK) {
            this._lpCache = new LpCache(this._diffractometer.getSoller1Size(), this._diffractometer.getSoller2Size(), 2.0, 80.0, 40, this._dMin2theta, this._dMax2theta, this._dStepSize, _guiComponent);
            try {
                this._lpCache.serializeData(lpCacheFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("New Lp cache dumped");
        }
    }

    public void recalculate() {
        new PatternParams(this._dMin2theta, this._dMax2theta, this._dStepSize, this._dLambda, this._diffractometer);
    }

    public Lp getLp(double dSigmaStar) {
        return this._lpCache.getByOrientation(dSigmaStar);
    }

    public void correctForLostIntensity(UserDiffractogram ud) {
        this._diffractometer.correctForLostIntensity(ud);
    }

    public void reduceIntensity(UserDiffractogram ud) {
        this._diffractometer.reduceIntensity(ud);
    }

    public Z getZ() {
        return this._z;
    }

    public void recalculateAtomicScatteringFactors() {
        this._aFactors = AtomicScatteringFactor.getAllFactors(this._dMin2theta, this._dMax2theta, this._dStepSize, this._dLambda);
    }

    public AtomicScatteringFactor[] getAtomicScatteringFactors() {
        return this._aFactors;
    }

    public double getMin2theta() {
        return this._dMin2theta;
    }

    public double getMax2theta() {
        return this._dMax2theta;
    }

    public double getStepSize() {
        return this._dStepSize;
    }

    public double getLambda() {
        return this._dLambda;
    }

    public Diffractometer getDiffractometer() {
        return this._diffractometer;
    }

    public StringBuffer match(PatternParams anotherParams) {
        StringBuffer sbResult = new StringBuffer(200);
        if (this._dMin2theta != anotherParams._dMin2theta) {
            sbResult.append("min 2theta does not match").append('\n');
        }
        if (this._dMax2theta != anotherParams._dMax2theta) {
            sbResult.append("max 2theta does not match").append('\n');
        }
        if (this._dStepSize != anotherParams._dStepSize) {
            sbResult.append("step size does not match").append('\n');
        }
        if (this._dLambda != anotherParams._dLambda) {
            sbResult.append("lambda does not match").append('\n');
        }
        return sbResult;
    }

    public Element serializeXML() {
        Element params = new Element("basic_params");
        params.setAttribute("min2theta", String.valueOf(this._dMin2theta));
        params.setAttribute("max2theta", String.valueOf(this._dMax2theta));
        params.setAttribute("step_size", String.valueOf(this._dStepSize));
        params.setAttribute("lambda", String.valueOf(this._dLambda));
        return params;
    }

    public static PatternParams deserializeXML(Element owner) throws DataConversionException, IllegalArgumentException {
        Diffractometer diffr = Diffractometer.deserializeXML(owner);
        Element params = owner.getChild("basic_params");
        if (params == null) {
            throw new IllegalArgumentException("Missing basic pattern params");
        }
        double min2theta = params.getAttribute("min2theta").getDoubleValue();
        double max2theta = params.getAttribute("max2theta").getDoubleValue();
        double stepSize = params.getAttribute("step_size").getDoubleValue();
        Attribute lambda = params.getAttribute("lambda");
        PatternParams result = null;
        result = lambda == null ? new PatternParams(min2theta, max2theta, stepSize, diffr) : new PatternParams(min2theta, max2theta, stepSize, lambda.getDoubleValue(), diffr);
        return result;
    }

    public Element serializeDiffractometer() {
        return this._diffractometer.serializeXML();
    }

    public static void setGuiComponent(Component guiComponent) {
        _guiComponent = guiComponent;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        File lpCacheFile = new File("LpCache.ser");
        boolean bLpCacheOK = false;
        if (lpCacheFile.exists()) {
            try {
                this._lpCache = LpCache.deserializeData(lpCacheFile);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            boolean bl = bLpCacheOK = this._lpCache != null && this._lpCache.getS1() == this._diffractometer.getSoller1Size() && this._lpCache.getS2() == this._diffractometer.getSoller2Size() && this._lpCache.getLowOrientationLimit() == 2.0 && this._lpCache.getHighOrientationLimit() == 80.0 && this._lpCache.getNoOfPatterns() == 40 && this._lpCache.getMin2theta() == this._dMin2theta && this._lpCache.getMax2theta() == this._dMax2theta && this._lpCache.getStepSize() == this._dStepSize;
        }
        if (!bLpCacheOK) {
            this._lpCache = new LpCache(this._diffractometer.getSoller1Size(), this._diffractometer.getSoller2Size(), 2.0, 80.0, 40, this._dMin2theta, this._dMax2theta, this._dStepSize, _guiComponent);
            try {
                this._lpCache.serializeData(lpCacheFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("New Lp cache dumped");
        }
        this._z = new Z(this._dMin2theta, this._dMax2theta, this._dStepSize, this._dLambda);
        this._aFactors = AtomicScatteringFactor.getAllFactors(this._dMin2theta, this._dMax2theta, this._dStepSize, this._dLambda);
    }
}

