/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import net.ndmystko.analysis.tools.NNLS;
import net.ndmystko.common.util.RoundOff;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.Lp;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.XRDRangeSelected;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.Mixture;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.SybillaDiffractogram;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Pattern
implements Serializable {
    private static final long serialVersionUID = -7549119456416348101L;
    private Mixture _mixture = null;
    private PatternParams _patternParams = null;
    private GeneConnector _sigmaGeneConnector = null;
    private SybillaDiffractogram _finalDiffractogram = null;
    private AbstractDiffractogram _expPattern = null;
    private double[][] _adPhaseIntensities = null;
    private double[] _adExpPatternIntens = null;
    private double[] _adPhaseFactor = null;
    private List _lExcludedRanges = null;
    private boolean[] _abExcluded = null;
    private int _iNoNonExcludedSteps = 0;
    private Content[] _aContentInfo = null;
    private NumberFormat _oneDigitNumberFormatter = null;
    public static final double LP_ORIENTATION_DEFAULT = 12.0;
    public static final double LP_ORIENTATION_DEC_CONST = 2.0;
    private String _sDescription = "unknown";
    private static Logger _logger = Logger.getLogger("net.ndmystko.xrd.mod.Pattern");

    public Pattern(PatternParams params, Mixture mixture) {
        this(params, mixture, true);
    }

    public Pattern(PatternParams params, Mixture mixture, boolean bWithSigmaStar) {
        assert (bWithSigmaStar ^ mixture.getSigmaStar() != null) : "You miserable programmer...";
        this._mixture = mixture;
        this._patternParams = params;
        if (bWithSigmaStar) {
            this._sigmaGeneConnector = new GeneConnector(2.0, 80.0, 12.0, 2.0);
            this._sigmaGeneConnector.getGene().setName("sigma-star");
        }
        this._finalDiffractogram = new SybillaDiffractogram(this._patternParams.getMin2theta(), this._patternParams.getMax2theta(), this._patternParams.getStepSize());
        this._finalDiffractogram.setColor(Color.red);
        this._sDescription = this._mixture.buildDescription();
        this._oneDigitNumberFormatter = NumberFormat.getInstance();
        this._oneDigitNumberFormatter.setMinimumFractionDigits(0);
        this._oneDigitNumberFormatter.setMaximumFractionDigits(1);
    }

    public Phase[] getPhases() {
        return this._mixture.getPhases();
    }

    public boolean isSigmaGenePresent() {
        return this._sigmaGeneConnector != null;
    }

    public boolean calcProbabilities() {
        return this._mixture.calcProbabilities();
    }

    public void calcIntensities() {
        UserDiffractogram[] aDiffractograms = this._mixture.getIntensities();
        this.processIntensities(aDiffractograms);
    }

    public AbstractDiffractogram getFinalDiffr() {
        return this._finalDiffractogram;
    }

    public void freezeSigmaStar(double dSigmaStar) {
        assert (this._sigmaGeneConnector != null) : "Attempting to freeze sigma star gene value when gene is not present";
        this._sigmaGeneConnector.setValue(dSigmaStar);
        this._sigmaGeneConnector.setActive(false);
    }

    public void setSigmaStarGeneValue(double dValue) {
        assert (this._sigmaGeneConnector != null) : "Attempting to set sigma star gene value when gene is not present";
        this._sigmaGeneConnector.setValue(dValue);
    }

    public double getSigmaStarGeneValue() {
        assert (this._sigmaGeneConnector != null) : "Attempting to get sigma star gene value when gene is not present";
        return this._sigmaGeneConnector.getValue();
    }

    public GeneConnector duplicateSigmaStarConn() {
        assert (this._sigmaGeneConnector != null) : "Attempting to get sigma star gene value when gene is not present";
        return (GeneConnector)this._sigmaGeneConnector.clone();
    }

    public void restrictSigmaStar(GeneConnector restrSigmaStar) {
        assert (this._sigmaGeneConnector != null) : "Attempting to set sigma star gene value when gene is not present";
        this._sigmaGeneConnector.getGene().setLimits(restrSigmaStar.getGene().getLowLimit(), restrSigmaStar.getGene().getHighLimit());
        this._sigmaGeneConnector.getGene().setValue(restrSigmaStar.getGene().getValue());
        this._sigmaGeneConnector.setActive(restrSigmaStar.isActive());
    }

    public GeneConnector[] getConnectors(boolean bActiveOnly, boolean bNoDuplicates) {
        ArrayList<GeneConnector> alConnectors = new ArrayList<GeneConnector>(50);
        if (this._sigmaGeneConnector != null && (this._sigmaGeneConnector.isActive() || !bActiveOnly)) {
            alConnectors.add(this._sigmaGeneConnector);
        }
        this._mixture.addConnectors(alConnectors, bActiveOnly, bNoDuplicates);
        GeneConnector[] aConnectors = new GeneConnector[alConnectors.size()];
        return alConnectors.toArray(aConnectors);
    }

    public DefaultMutableTreeNode getConnectorsTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Pattern");
        if (this._sigmaGeneConnector != null) {
            root.add(new DefaultMutableTreeNode(this._sigmaGeneConnector));
        }
        this._mixture.addConnectorsBranch(root);
        return root;
    }

    public String getModel(String sSampleName) {
        Phase[] aPhases = this._mixture.getPhases();
        ArrayList<Object> alText = new ArrayList<Object>();
        int i = 0;
        while (i < aPhases.length) {
            alText.add(aPhases[i].dumpPhase(0));
            ++i;
        }
        if (this._aContentInfo != null) {
            int iMaxLength = 0;
            int i2 = 0;
            while (i2 < aPhases.length) {
                String sText = ((String[])alText.get(i2))[0];
                if (iMaxLength < sText.length()) {
                    iMaxLength = sText.length();
                }
                ++i2;
            }
            double[] adValues = new double[aPhases.length];
            int i3 = 0;
            while (i3 < aPhases.length) {
                adValues[i3] = this._aContentInfo[i3].getPhaseContent();
                ++i3;
            }
            int[] aiValues = RoundOff.roundOff(adValues, 100);
            iMaxLength += 3;
            int i4 = 0;
            while (i4 < aPhases.length) {
                String[] asEntry = (String[])alText.get(i4);
                int iMissingSpaces = iMaxLength - asEntry[0].length();
                assert (iMissingSpaces > 0) : "no missing spaces!";
                char[] acSpaces = new char[iMissingSpaces];
                Arrays.fill(acSpaces, ' ');
                StringBuffer sbLine = new StringBuffer(asEntry[0]);
                sbLine.append(acSpaces);
                if (aiValues[i4] > 0 || aiValues[i4] == 0 && adValues[i4] < 0.05) {
                    sbLine.append("= ").append(aiValues[i4]);
                } else {
                    sbLine.append("< 1");
                }
                sbLine.append(" %");
                asEntry[0] = sbLine.toString();
                ++i4;
            }
        }
        int iGlyLayerCount = 0;
        int iWatLayerCount = 0;
        int i5 = 0;
        while (i5 < aPhases.length) {
            if (aPhases[i5].isWatLayer()) {
                ++iWatLayerCount;
            }
            if (aPhases[i5].isGlyLayer()) {
                ++iGlyLayerCount;
            }
            ++i5;
        }
        String sState = null;
        sState = iWatLayerCount > 0 ? (iGlyLayerCount == 0 ? "air-dried" : "inconsistent state") : (iGlyLayerCount > 0 ? "E.G." : "");
        ArrayList<String[]> alW = new ArrayList<String[]>();
        int i6 = 0;
        while (i6 < aPhases.length) {
            if (aPhases[i6] instanceof MixedLayerPhase && ((MixedLayerPhase)aPhases[i6]).getProbabMatrix().getR() > 0) {
                alW.add(aPhases[i6].dumpPhase(1));
            }
            ++i6;
        }
        if (alW.size() > 0) {
            String[] asSeparator = new String[]{""};
            alText.add(asSeparator);
            String[] asTitle = new String[]{"***** occurance probabilities *****"};
            alText.add(asTitle);
            alText.addAll(alW);
        }
        String sNewLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(sSampleName).append(", ").append(sState).append(sNewLine);
        int i7 = 0;
        while (i7 < alText.size()) {
            String[] asEntry = (String[])alText.get(i7);
            int k = 0;
            while (k < asEntry.length) {
                buffer.append(asEntry[k]).append(sNewLine);
                ++k;
            }
            ++i7;
        }
        return buffer.toString();
    }

    public void serializeXML(File targetFile) throws IOException {
        Element rootElement = new Element("input_model");
        Document inputModelDump = new Document(rootElement);
        rootElement.addContent(this._patternParams.serializeXML());
        rootElement.addContent(this._patternParams.serializeDiffractometer());
        if (this._sigmaGeneConnector != null) {
            Element diffractogramParams = new Element("diffractogram");
            diffractogramParams.setAttribute("sigma_star", String.valueOf(this._sigmaGeneConnector.getValue()));
            rootElement.addContent(diffractogramParams);
        }
        if (this._aContentInfo != null) {
            Element content = new Element("content");
            int i = 0;
            while (i < this._aContentInfo.length) {
                Element subContent = new Element("phase");
                subContent.setAttribute("name", this._aContentInfo[i].getPhaseName());
                subContent.setAttribute("content", Double.toString(this._aContentInfo[i].getPhaseContent()));
                content.addContent(subContent);
                ++i;
            }
            rootElement.addContent(content);
        }
        rootElement.addContent(this._mixture.serializeXML());
        XMLOutputter outputter = new XMLOutputter("  ", true);
        FileWriter writer = new FileWriter(targetFile);
        outputter.output(inputModelDump, (Writer)writer);
        writer.close();
    }

    public static Pattern deserializeXML(File sourceFile) throws JDOMException, IllegalArgumentException {
        Mixture mixture;
        SAXBuilder builder = new SAXBuilder();
        Document xmlDocument = builder.build(sourceFile);
        Element inputModel = xmlDocument.getRootElement();
        PatternParams patternParams = PatternParams.deserializeXML(inputModel);
        double dSigmaStar = -1.0;
        Element diffractogramParams = inputModel.getChild("diffractogram");
        if (diffractogramParams != null) {
            Attribute aSigmaStar = diffractogramParams.getAttribute("sigma_star");
            if (aSigmaStar == null) {
                throw new IllegalArgumentException("Missing sigma star in diffractometer params");
            }
            dSigmaStar = aSigmaStar.getDoubleValue();
            if (dSigmaStar < 2.0 || dSigmaStar > 80.0) {
                throw new IllegalArgumentException("Sigma star out of limits: 2.0 - 80.0");
            }
        }
        if (!(dSigmaStar >= 0.0 ^ (mixture = Mixture.deserializeXML(inputModel, patternParams)).getSigmaStar() != null)) {
            throw new IllegalArgumentException("There must be sigma-star value present, either common or for each phase separately");
        }
        Pattern result = new Pattern(patternParams, mixture, dSigmaStar >= 0.0);
        if (dSigmaStar >= 0.0) {
            result._sigmaGeneConnector.setValue(dSigmaStar);
        }
        return result;
    }

    public PatternParams getPatternParams() {
        return this._patternParams;
    }

    public void setPatternParams(PatternParams patternParams) {
        this._patternParams = patternParams;
    }

    public void rebuildDescription() {
        this._sDescription = this._mixture.buildDescription();
    }

    public void setExpPattern(AbstractDiffractogram expPattern) {
        assert (expPattern.getMin2theta() == this._patternParams.getMin2theta()) : "min2theta does not match";
        assert (expPattern.getMax2theta() == this._patternParams.getMax2theta()) : "max2theta does not match";
        assert (expPattern.getStepSize() == this._patternParams.getStepSize()) : "max2theta does not match";
        assert (this._abExcluded == null);
        this._expPattern = expPattern;
        this._adPhaseIntensities = new double[expPattern.getNoOfSteps()][this._mixture.getNoOfPhases()];
        this._adExpPatternIntens = new double[expPattern.getNoOfSteps()];
    }

    public void setExcludedRanges(List lRanges) {
        assert (this._expPattern != null);
        if (lRanges == null) {
            return;
        }
        this._lExcludedRanges = new ArrayList(lRanges.size());
        this._lExcludedRanges.addAll(lRanges);
        int iExcludedSteps = 0;
        int iNoOfSteps = this._expPattern.getNoOfSteps();
        this._abExcluded = new boolean[iNoOfSteps];
        int k = 0;
        while (k < lRanges.size()) {
            XRDRangeSelected rs = (XRDRangeSelected)lRanges.get(k);
            int lowStep = (int)Math.round((rs.getMin2theta() - this._expPattern.getMin2theta()) / this._expPattern.getStepSize());
            int highStep = (int)Math.round((rs.getMax2theta() - this._expPattern.getMin2theta()) / this._expPattern.getStepSize());
            if (highStep >= 0 && lowStep <= iNoOfSteps - 1) {
                if (lowStep < 0) {
                    lowStep = 0;
                }
                if (highStep > iNoOfSteps - 1) {
                    highStep = iNoOfSteps - 1;
                }
                int i = lowStep;
                while (i < highStep + 1) {
                    this._abExcluded[i] = true;
                    ++iExcludedSteps;
                    ++i;
                }
            }
            ++k;
        }
        this._iNoNonExcludedSteps = iNoOfSteps - iExcludedSteps;
        if (iExcludedSteps > 0) {
            this._adPhaseIntensities = new double[iNoOfSteps - iExcludedSteps][this._mixture.getNoOfPhases()];
            this._adExpPatternIntens = new double[iNoOfSteps - iExcludedSteps];
        } else {
            this._abExcluded = null;
        }
    }

    public List getExcludedRanges() {
        return this._lExcludedRanges;
    }

    public boolean isStepExcluded(int iStep) {
        return this._abExcluded != null ? this._abExcluded[iStep] : false;
    }

    public AbstractDiffractogram getExpPattern() {
        return this._expPattern;
    }

    public double getFit() {
        if (this._expPattern == null) {
            return 0.0;
        }
        double dMisfit = 0.0;
        double dExpPatternArea = 0.0;
        int iNoOfSteps = this._expPattern.getNoOfSteps();
        int i = 0;
        while (i < iNoOfSteps) {
            if (!this.isStepExcluded(i)) {
                dMisfit += Math.abs(this._finalDiffractogram.getIntensity(i) - this._expPattern.getIntensity(i));
                dExpPatternArea += this._expPattern.getIntensity(i);
            }
            ++i;
        }
        return dMisfit * 100.0 / dExpPatternArea;
    }

    public void setContentInfo(Content[] aContentInfo) {
        this._aContentInfo = aContentInfo;
    }

    public StringBuffer isCompatible(Pattern anotherPattern) {
        StringBuffer sbResult = this._patternParams.match(anotherPattern._patternParams);
        this._patternParams.getDiffractometer().matches(anotherPattern._patternParams.getDiffractometer(), sbResult);
        if (this._sigmaGeneConnector != null) {
            if (anotherPattern._sigmaGeneConnector == null) {
                sbResult.append("missing gene for sigma star").append('\n');
            } else if (this._sigmaGeneConnector.getValue() != anotherPattern._sigmaGeneConnector.getValue()) {
                sbResult.append("sigma star does not match").append('\n');
            }
        }
        return sbResult;
    }

    private void processIntensities(UserDiffractogram[] aPhaseIntensities) {
        int j;
        double[] adIntensities;
        double[] adSigmaStar = this._mixture.getSigmaStar();
        int i = 0;
        while (i < aPhaseIntensities.length) {
            Lp lp = null;
            lp = this._sigmaGeneConnector != null ? this._patternParams.getLp(this._sigmaGeneConnector.getValue()) : this._patternParams.getLp(adSigmaStar[i]);
            adIntensities = aPhaseIntensities[i].getIntensities();
            j = 0;
            while (j < adIntensities.length) {
                int n = j;
                adIntensities[n] = adIntensities[n] * lp.getIntensity(j);
                ++j;
            }
            this._patternParams.reduceIntensity(aPhaseIntensities[i]);
            ++i;
        }
        if (this._expPattern == null) {
            int j2;
            int i2;
            this._adPhaseFactor = null;
            double[] adFinalIntensities = this._finalDiffractogram.getIntensities();
            Arrays.fill(adFinalIntensities, 0.0);
            double[] adContent = Mixture.get_aContent();
            if (adContent != null) {
                i2 = 0;
                while (i2 < aPhaseIntensities.length) {
                    double[] adIntensities2 = aPhaseIntensities[i2].getIntensities();
                    j2 = 0;
                    while (j2 < adIntensities2.length) {
                        int n = j2;
                        adFinalIntensities[n] = adFinalIntensities[n] + adContent[i2] * adIntensities2[j2];
                        ++j2;
                    }
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < aPhaseIntensities.length) {
                    double[] adIntensities3 = aPhaseIntensities[i2].getIntensities();
                    j2 = 0;
                    while (j2 < adIntensities3.length) {
                        int n = j2;
                        adFinalIntensities[n] = adFinalIntensities[n] + adIntensities3[j2];
                        ++j2;
                    }
                    ++i2;
                }
            }
            double dMaxIntensity = 0.0;
            j2 = 0;
            while (j2 < adFinalIntensities.length) {
                if (dMaxIntensity < adFinalIntensities[j2]) {
                    dMaxIntensity = adFinalIntensities[j2];
                }
                ++j2;
            }
            this._finalDiffractogram.setMaxIntensity(dMaxIntensity);
        } else {
            int j3;
            int i3;
            int iNoOfPhases = aPhaseIntensities.length;
            this._adPhaseFactor = new double[iNoOfPhases];
            if (this._abExcluded == null) {
                i3 = 0;
                while (i3 < iNoOfPhases) {
                    adIntensities = aPhaseIntensities[i3].getIntensities();
                    j = 0;
                    while (j < adIntensities.length) {
                        this._adPhaseIntensities[j][i3] = adIntensities[j];
                        ++j;
                    }
                    ++i3;
                }
                int iNoOfSteps = this._expPattern.getNoOfSteps();
                int i4 = 0;
                while (i4 < iNoOfSteps) {
                    this._adExpPatternIntens[i4] = this._expPattern.getIntensity(i4);
                    ++i4;
                }
            } else {
                i3 = 0;
                while (i3 < iNoOfPhases) {
                    int iNonExcludedIndex = 0;
                    double[] adIntensities4 = aPhaseIntensities[i3].getIntensities();
                    int j4 = 0;
                    while (j4 < adIntensities4.length) {
                        if (!this._abExcluded[j4]) {
                            this._adPhaseIntensities[iNonExcludedIndex++][i3] = adIntensities4[j4];
                        }
                        ++j4;
                    }
                    ++i3;
                }
                int iNonExcludedIndex = 0;
                int iNoOfSteps = this._expPattern.getNoOfSteps();
                int i5 = 0;
                while (i5 < iNoOfSteps) {
                    if (!this._abExcluded[i5]) {
                        this._adExpPatternIntens[iNonExcludedIndex++] = this._expPattern.getIntensity(i5);
                    }
                    ++i5;
                }
            }
            doubleW rNorm = new doubleW(0.0);
            double[] adW = new double[iNoOfPhases];
            double[] adZZ = new double[this._adPhaseIntensities.length];
            int[] aiIndex = new int[iNoOfPhases];
            intW mode = new intW(0);
            NNLS.NNLS((double[][])this._adPhaseIntensities, (int)this._adPhaseIntensities.length, (int)iNoOfPhases, (double[])this._adExpPatternIntens, (double[])this._adPhaseFactor, (doubleW)rNorm, (double[])adW, (double[])adZZ, (int[])aiIndex, (intW)mode);
            if (mode.val != 1) {
                _logger.logp(Level.SEVERE, "net.ndmystko.xrd.mod.Pattern", "processIntensities", "non-negative least squares failed: " + mode.val);
            }
            double[] adFinalIntensities = this._finalDiffractogram.getIntensities();
            Arrays.fill(adFinalIntensities, 0.0);
            int i6 = 0;
            while (i6 < iNoOfPhases) {
                double[] adIntensities5 = aPhaseIntensities[i6].getIntensities();
                j3 = 0;
                while (j3 < adIntensities5.length) {
                    int n = j3;
                    adFinalIntensities[n] = adFinalIntensities[n] + adIntensities5[j3] * this._adPhaseFactor[i6];
                    ++j3;
                }
                ++i6;
            }
            double dMaxIntensity = 0.0;
            j3 = 0;
            while (j3 < adFinalIntensities.length) {
                if (dMaxIntensity < adFinalIntensities[j3]) {
                    dMaxIntensity = adFinalIntensities[j3];
                }
                ++j3;
            }
            this._finalDiffractogram.setMaxIntensity(dMaxIntensity);
        }
    }

    public String toString() {
        return this._expPattern != null ? String.valueOf(this._sDescription) + " (" + this._expPattern.getName() + ")" : this._sDescription;
    }

    public static class Content {
        private String _sPhaseName = null;
        private double _dPhaseContent = 0.0;

        public Content(String sPhaseName, double dPhaseContent) {
            this._sPhaseName = sPhaseName;
            this._dPhaseContent = dPhaseContent;
        }

        public String getPhaseName() {
            return this._sPhaseName;
        }

        public double getPhaseContent() {
            return this._dPhaseContent;
        }
    }
}

