/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import net.ndmystko.analysis.evolution.CalcEngine;
import net.ndmystko.analysis.evolution.Chromosome;
import net.ndmystko.analysis.evolution.Gene;
import net.ndmystko.analysis.evolution.ThreadedAdaptingEvolution;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.mod.MicroCalcThread;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.gene.ModGene;
import net.ndmystko.xrd.mod.script.Script;

public class ModEvol
extends ThreadedAdaptingEvolution {
    private Script _script = null;
    private AbstractDiffractogram _expPattern = null;
    private Pattern[] _pattern = null;
    private GeneConnector[] _aConnectors = null;
    private ModGene[] _aGenes = null;
    private int _iPopSize = -1;
    private int _iNoOfGenes = -1;
    private int _iNoOfGenerations = -1;
    private Chromosome[] _aPopulation = null;
    private static final int RESULT_STEP = 1;

    public ModEvol(Script script, Pattern[] pattern, int iPopSize, int iNoOfGenerations) {
        this.setExtinctionStep(40);
        this.setExtinctionTreshold(0);
        this.setRecreationLimit(100000);
        this._script = script;
        this._iPopSize = iPopSize;
        this._iNoOfGenerations = iNoOfGenerations;
        this._pattern = pattern;
        this._expPattern = this._pattern[0].getExpPattern();
        this._aConnectors = this._pattern[0].getConnectors(true, true);
        this._iNoOfGenes = this._aConnectors.length;
        this._aGenes = new ModGene[this._aConnectors.length];
        this.detachGenes();
        Chromosome templateChromosome = new Chromosome((Gene[])this._aGenes);
        this._aPopulation = new Chromosome[this._iPopSize];
        int i = 0;
        while (i < this._iPopSize) {
            Gene[] aGenes = new ModGene[this._iNoOfGenes];
            int j = 0;
            while (j < this._iNoOfGenes) {
                aGenes[j] = (ModGene)this._aGenes[j].clone();
                ++j;
            }
            this._aPopulation[i] = new Chromosome(aGenes);
            ++i;
        }
        Chromosome.extinct((Chromosome[])this._aPopulation, (Chromosome)templateChromosome, (double)0.0, (double)0.0);
        this.setup(this._aPopulation, this._iNoOfGenerations, 1);
        this.calculateMaxError();
        if (this._pattern.length > 1) {
            CalcEngine[] _microThreads = new MicroCalcThread[this._pattern.length];
            int i2 = 0;
            while (i2 < this._pattern.length) {
                _microThreads[i2] = new MicroCalcThread(this._pattern[i2]);
                ++i2;
            }
            this.setUpThreads(_microThreads);
        }
    }

    protected double calculateDifference(Chromosome chromosome) {
        this.attachGenes(chromosome);
        boolean bProbabOK = this._pattern[0].calcProbabilities();
        if (!bProbabOK) {
            return Double.NaN;
        }
        this._pattern[0].calcIntensities();
        AbstractDiffractogram calcPattern = this._pattern[0].getFinalDiffr();
        int iNoOfSteps = this._expPattern.getNoOfSteps();
        double dMisfit = 0.0;
        int i = 0;
        while (i < iNoOfSteps) {
            if (!this._pattern[0].isStepExcluded(i)) {
                dMisfit += Math.abs(this._expPattern.getIntensity(i) - calcPattern.getIntensity(i));
            }
            ++i;
        }
        return dMisfit;
    }

    public void calcPattern(UserDiffractogram globalCalcPattern, Chromosome chromosome) {
        this.attachGenes(chromosome);
        boolean bProbabOK = this._pattern[0].calcProbabilities();
        if (!bProbabOK) assert (false) : "Wrong probability matrix for best chromosome?!?!?!";
        this._pattern[0].calcIntensities();
        AbstractDiffractogram calcPattern = this._pattern[0].getFinalDiffr();
        int iNoOfSteps = this._expPattern.getNoOfSteps();
        double[] adIntensities = globalCalcPattern.getIntensities();
        int i = 0;
        while (i < iNoOfSteps) {
            adIntensities[i] = calcPattern.getIntensity(i);
            ++i;
        }
        globalCalcPattern.setMaxIntensity(calcPattern.getMaxIntensity());
    }

    private void detachGenes() {
        int i = 0;
        while (i < this._aConnectors.length) {
            this._aGenes[i] = this._aConnectors[i].getGene();
            ++i;
        }
    }

    private void attachGenes(Chromosome chromosome) {
        Gene[] aGenes = chromosome.getGenes();
        int i = 0;
        while (i < this._iNoOfGenes) {
            this._aConnectors[i].setGene((ModGene)aGenes[i]);
            ++i;
        }
    }

    private void calculateMaxError() {
        double dIntegratedExpIntensity = 0.0;
        int i = 0;
        while (i < this._expPattern.getNoOfSteps()) {
            if (!this._pattern[0].isStepExcluded(i)) {
                dIntegratedExpIntensity += this._expPattern.getIntensity(i);
            }
            ++i;
        }
        this.maxError = dIntegratedExpIntensity;
        this.adaptingMaxError = dIntegratedExpIntensity;
    }

    public double getMaxError() {
        return this.maxError;
    }

    public void calcPatternForBestChromosome() {
        this.attachGenes(this.getBestChromosome());
        this._pattern[0].calcProbabilities();
        this._pattern[0].calcIntensities();
    }

    @Override
    public void run() {
        super.run();
        this._script.wakeUp();
    }
}

