/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.io.Serializable;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.mod.MixedLayerPhase;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class Mixture
implements Serializable {
    private static final long serialVersionUID = 7699736064832467242L;
    private Phase[] _aPhases = null;
    private static double[] _aContent = null;
    private PatternParams _patternParams = null;

    public Mixture(Phase[] phases, PatternParams params) {
        assert (phases != null && phases.length > 0);
        this._aPhases = phases;
        this._patternParams = params;
    }

    public int getNoOfPhases() {
        return this._aPhases.length;
    }

    public Phase getPhase(int iIndex) {
        return this._aPhases[iIndex];
    }

    public Phase[] getPhases() {
        return this._aPhases;
    }

    public boolean calcProbabilities() {
        boolean bSuccess = true;
        int i = 0;
        while (i < this._aPhases.length) {
            if (this._aPhases[i] instanceof MixedLayerPhase) {
                bSuccess &= ((MixedLayerPhase)this._aPhases[i]).calcProbabilities();
            }
            ++i;
        }
        return bSuccess;
    }

    public UserDiffractogram[] getIntensities() {
        UserDiffractogram[] result = new UserDiffractogram[this._aPhases.length];
        int i = 0;
        while (i < this._aPhases.length) {
            this._aPhases[i].calcIntensities();
            result[i] = this._aPhases[i].getIntensities();
            ++i;
        }
        return result;
    }

    public double[] getSigmaStar() {
        double[] adResult = null;
        if (this._aPhases[0].isSigmaStarGenePresent()) {
            adResult = new double[this._aPhases.length];
            int i = 0;
            while (i < adResult.length) {
                adResult[i] = this._aPhases[i].getSigmaStarGeneValue();
                ++i;
            }
        }
        return adResult;
    }

    public void addConnectors(List lList, boolean bActiveOnly, boolean bNoDuplicates) {
        int i = 0;
        while (i < this._aPhases.length) {
            this._aPhases[i].addConnectors(lList, bActiveOnly, bNoDuplicates);
            ++i;
        }
    }

    public void addConnectorsBranch(DefaultMutableTreeNode parent) {
        int i = 0;
        while (i < this._aPhases.length) {
            DefaultMutableTreeNode phase = new DefaultMutableTreeNode(this._aPhases[i].toString());
            this._aPhases[i].addConnectorsBranch(phase);
            parent.add(phase);
            ++i;
        }
    }

    public Element serializeXML() {
        Element mixture = new Element("mixture");
        int i = 0;
        while (i < this._aPhases.length) {
            mixture.addContent(this._aPhases[i].serializeXML());
            ++i;
        }
        return mixture;
    }

    public static Mixture deserializeXML(Element owner, PatternParams patternParams) throws IllegalArgumentException, DataConversionException {
        Element mixture = owner.getChild("mixture");
        if (mixture == null) {
            throw new IllegalArgumentException("Missing mixture of phases");
        }
        Phase[] phases = MixedLayerPhase.deserializeXML(mixture, patternParams);
        Element content = owner.getChild("content");
        List lPhases = content.getChildren("phase");
        int iCurrentPhase = 0;
        _aContent = new double[phases.length];
        for (Element ePhase : lPhases) {
            double aContent;
            Mixture._aContent[iCurrentPhase] = aContent = ePhase.getAttribute("content").getDoubleValue();
            ++iCurrentPhase;
        }
        return new Mixture(phases, patternParams);
    }

    public String buildDescription() {
        StringBuffer sbDescription = new StringBuffer(30);
        int i = 0;
        while (i < this._aPhases.length) {
            sbDescription.append(this._aPhases[i].getDescription());
            if (i < this._aPhases.length - 1) {
                sbDescription.append(", ");
            }
            ++i;
        }
        return sbDescription.toString();
    }

    public static double[] get_aContent() {
        return _aContent;
    }

    public String toString() {
        String output = "";
        int i = 0;
        while (i < this._aPhases.length) {
            output = String.valueOf(output) + this._aPhases[i] + "\n";
            ++i;
        }
        return output;
    }
}

