/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import net.ndmystko.xrd.Z;
import net.ndmystko.xrd.mod.PatternParams;
import net.ndmystko.xrd.mod.Phase;
import net.ndmystko.xrd.mod.PhaseFactory;
import net.ndmystko.xrd.mod.equation.EdgeEquation;
import net.ndmystko.xrd.mod.equation.RegularEquation;
import net.ndmystko.xrd.mod.layer.AbstractLayer;
import net.ndmystko.xrd.mod.layer.AbstractSmectite;
import net.ndmystko.xrd.mod.layer.DiSmectiteHeatedLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteTwoWatContrLayer;
import net.ndmystko.xrd.mod.layer.DiSmectiteTwoWatLayer;
import net.ndmystko.xrd.mod.layer.LayerAndEdge;
import net.ndmystko.xrd.mod.layer.TriSmectiteTwoWatContrLayer;
import net.ndmystko.xrd.mod.layer.TriSmectiteTwoWatLayer;
import net.ndmystko.xrd.mod.layer.edge.AbstractEdge;
import net.ndmystko.xrd.mod.probab.AbstractProbabCondition;
import net.ndmystko.xrd.mod.probab.ProbabCondition20;
import net.ndmystko.xrd.mod.probab.ProbabCondition21;
import net.ndmystko.xrd.mod.probab.ProbabCondition22;
import net.ndmystko.xrd.mod.probab.Probability;
import net.ndmystko.xrd.util.AnyDistribution;
import net.ndmystko.xrd.util.Distribution;
import net.ndmystko.xrd.util.LognormalDistribution;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class MixedLayerPhase
extends Phase
implements Serializable {
    private static final long serialVersionUID = -350613112544462352L;
    private Probability _probab = null;
    private transient double[][] _adW = null;
    private transient double[][][] _adVa = null;
    private transient double[][][] _adVb = null;
    private transient double[][][] _adQa = null;
    private transient double[][][] _adQb = null;
    private transient double[][][] _adVPrim0a = null;
    private transient double[][][] _adVPrimKa = null;
    private transient double[][][] _adV0a = null;
    private transient double[][][] _adV0b = null;
    private transient double[][][] _adVKa = null;
    private transient double[][][] _adVKb = null;
    private transient double[][][] _adVPrima = null;
    private transient double[][][] _adVPrimb = null;
    private transient double[][][] _adQ0a = null;
    private transient double[][][] _adQ0b = null;
    public static final double T_MEAN_HIGH_LIMIT = 60.0;
    private static final Pattern _glyRegexPattern = Pattern.compile("GLY");
    private static final Pattern _airRegexPattern = Pattern.compile("WAT");
    private static final Pattern _isRegexPattern = Pattern.compile("IS+");
    private static final int EMPTY = 0;
    private static final int FULL = 1;
    private static final int PARTLY = 2;

    public MixedLayerPhase(PatternParams patternParams, AbstractLayer[] layers, AbstractEdge[] edges, Probability probab, int iPhaseType) {
        this(patternParams, layers, edges, probab, iPhaseType, false);
    }

    public MixedLayerPhase(PatternParams patternParams, AbstractLayer[] layers, AbstractEdge[] edges, Probability probab, int iPhaseType, boolean bWithSigmaStar) {
        super(patternParams, layers, edges, iPhaseType, bWithSigmaStar, 60.0);
        this._probab = probab;
        this.initMatrices(edges != null);
    }

    private void initMatrices(boolean bEdgesPresent) {
        int iRank = this._probab.getRank();
        this._adW = new double[iRank][iRank];
        this._adVa = new double[this._iNoOfData][iRank][iRank];
        this._adVb = new double[this._iNoOfData][iRank][iRank];
        this._adQa = new double[this._iNoOfData][iRank][iRank];
        this._adQb = new double[this._iNoOfData][iRank][iRank];
        if (bEdgesPresent) {
            this._adVPrim0a = new double[this._iNoOfData][iRank][iRank];
            this._adVPrimKa = new double[this._iNoOfData][iRank][iRank];
            this._adV0a = new double[this._iNoOfData][iRank][iRank];
            this._adV0b = new double[this._iNoOfData][iRank][iRank];
            this._adVKa = new double[this._iNoOfData][iRank][iRank];
            this._adVKb = new double[this._iNoOfData][iRank][iRank];
            this._adVPrima = new double[this._iNoOfData][iRank][iRank];
            this._adVPrimb = new double[this._iNoOfData][iRank][iRank];
            this._adQ0a = new double[this._iNoOfData][iRank][iRank];
            this._adQ0b = new double[this._iNoOfData][iRank][iRank];
        }
    }

    public AbstractLayer layer(String sLayer) {
        AbstractLayer layer = null;
        boolean bMoreThanOne = false;
        int i = 0;
        while (i < this._layer.length) {
            if (this._layer[i].getName().equals(sLayer)) {
                if (layer == null) {
                    layer = this._layer[i];
                } else {
                    bMoreThanOne = true;
                    break;
                }
            }
            ++i;
        }
        if (layer == null) {
            throw new IllegalArgumentException("Requested layer is not present in this structure.");
        }
        if (bMoreThanOne) {
            throw new IllegalArgumentException("There is more than one layer of the requested type in this structure.");
        }
        return layer;
    }

    @Override
    public void calcIntensities() {
        assert (this._probab.verify()) : "Trying to calculate intensities for non-solved probability matrix!!!";
        long before = System.currentTimeMillis();
        if (this._bTMeanGeneActive) {
            ((LognormalDistribution)this._distrib).recalcDistribution(this._tMeanGene.getValue(), MixedLayerPhase.calcDistLimit(this._tMeanGene.getValue(), 2.5));
        }
        int i = 0;
        while (i < this._layer.length) {
            this._layer[i].updateLayer();
            this._layer[i].computeVariableFactors();
            ++i;
        }
        int iRank = this._probab.getRank();
        int i2 = 0;
        while (i2 < iRank) {
            this._adW[i2][i2] = this._probab.getW(i2);
            ++i2;
        }
        int iNoOfComp = this._probab.getNoOfComp();
        int iRankFactor = iRank / iNoOfComp;
        int i3 = 0;
        while (i3 < this._iNoOfData) {
            int r = 0;
            while (r < iNoOfComp) {
                int iBaseRow = r * iRankFactor;
                int c = 0;
                while (c < iNoOfComp) {
                    int iBaseCol = c * iRankFactor;
                    this._adVa[i3][iBaseRow][iBaseCol] = this._layer[c].getFactorA(i3) * this._layer[r].getFactorA(i3) + this._layer[c].getFactorB(i3) * this._layer[r].getFactorB(i3);
                    this._adVb[i3][iBaseRow][iBaseCol] = this._layer[c].getFactorA(i3) * this._layer[r].getFactorB(i3) - this._layer[c].getFactorB(i3) * this._layer[r].getFactorA(i3);
                    if (iRankFactor != 1) {
                        int rc = 0;
                        while (rc < iRankFactor) {
                            int cc = 0;
                            while (cc < iRankFactor) {
                                this._adVa[i3][iBaseRow + rc][iBaseCol + cc] = this._adVa[i3][iBaseRow][iBaseCol];
                                this._adVb[i3][iBaseRow + rc][iBaseCol + cc] = this._adVb[i3][iBaseRow][iBaseCol];
                                ++cc;
                            }
                            ++rc;
                        }
                    }
                    ++c;
                }
                ++r;
            }
            ++i3;
        }
        double[] adTwoPiKsi = new double[iNoOfComp];
        double[] adMinusTwoPiSquareDeltaKsiSquare = new double[iNoOfComp];
        int j = 0;
        while (j < iNoOfComp) {
            adTwoPiKsi[j] = Math.PI * 2 * this._layer[j].getDSpacing();
            adMinusTwoPiSquareDeltaKsiSquare[j] = -19.739208802178716 * this._layer[j].getDSpacingDelta() * this._layer[j].getDSpacingDelta();
            ++j;
        }
        double[] adPhiA = new double[iNoOfComp];
        double[] adPhiB = new double[iNoOfComp];
        Z z = this._patternParams.getZ();
        int i4 = 0;
        while (i4 < this._iNoOfData) {
            double dZ = z.getZ(i4);
            double dZSquare = dZ * dZ;
            int j2 = 0;
            while (j2 < iNoOfComp) {
                if (this._layer[j2].getDSpacingDelta() > 0.0) {
                    double dTermSinCos = adTwoPiKsi[j2] * dZ;
                    double dTermExp = adMinusTwoPiSquareDeltaKsiSquare[j2] * dZSquare;
                    adPhiA[j2] = Math.cos(dTermSinCos) * Math.exp(dTermExp);
                    adPhiB[j2] = Math.sin(dTermSinCos) * Math.exp(dTermExp);
                } else {
                    double dTerm = adTwoPiKsi[j2] * dZ;
                    adPhiA[j2] = Math.cos(dTerm);
                    adPhiB[j2] = Math.sin(dTerm);
                }
                ++j2;
            }
            int r = 0;
            while (r < iRank) {
                int c = 0;
                while (c < iRank) {
                    this._adQa[i4][r][c] = this._probab.getP(r, c);
                    double d = this._adQb[i4][r][c] = this._probab.getP(r, c);
                    if (d > 0.0) {
                        int iLayerIndex = r / iRankFactor;
                        double[] dArray = this._adQa[i4][r];
                        int n = c;
                        dArray[n] = dArray[n] * adPhiA[iLayerIndex];
                        double[] dArray2 = this._adQb[i4][r];
                        int n2 = c;
                        dArray2[n2] = dArray2[n2] * adPhiB[iLayerIndex];
                    }
                    ++c;
                }
                ++r;
            }
            ++i4;
        }
        double[] adIntens = this._pattern.getIntensities();
        if (this._edge == null) {
            RegularEquation eq = new RegularEquation();
            eq.compute(this._adQa, this._adQb, this._distrib, this._adW, this._adVa, this._adVb, adIntens);
        } else {
            this.createEdgeMatrices();
            EdgeEquation eq = new EdgeEquation();
            eq.compute(this._adQa, this._adQb, this._distrib, this._adW, this._adVa, this._adVb, adIntens, this._adVPrim0a, this._adVPrimKa, this._adV0a, this._adV0b, this._adVKa, this._adVKb, this._adVPrima, this._adVPrimb, this._adQ0a, this._adQ0b);
        }
        this.applyAbsoluteScale(this._probab);
    }

    @Override
    public void addConnectors(List lList, boolean bActiveOnly, boolean bNoDuplicates) {
        super.addConnectors(lList, bActiveOnly, bNoDuplicates);
        if (this._probab instanceof AbstractProbabCondition) {
            ((AbstractProbabCondition)this._probab).addConnectors(lList, bActiveOnly, bNoDuplicates);
        }
    }

    @Override
    public void addConnectorsBranch(DefaultMutableTreeNode parent) {
        super.addConnectorsBranch(parent);
        if (this._probab instanceof AbstractProbabCondition) {
            DefaultMutableTreeNode probabNode = new DefaultMutableTreeNode("probabilities");
            ((AbstractProbabCondition)this._probab).addConnectorsBranch(probabNode);
            parent.add(probabNode);
        }
    }

    public boolean calcProbabilities() {
        if (this._probab instanceof AbstractProbabCondition) {
            return ((AbstractProbabCondition)this._probab).updateProbability();
        }
        this._probab.solve();
        return this._probab.verify();
    }

    public void convertSmectite(int iState) {
        assert (this._edge == null) : "Don't know yet how to convert edges";
        int i = 0;
        while (i < this._layer.length) {
            if (this._layer[i] instanceof DiSmectiteTwoWatContrLayer || this._layer[i] instanceof TriSmectiteTwoWatContrLayer) {
                throw new IllegalArgumentException("Can't handle third smectite layer in stable I/S");
            }
            if (this._layer[i] instanceof DiSmectiteHeatedLayer) {
                throw new IllegalArgumentException("Can't convert smectite heated layer");
            }
            ++i;
        }
        AbstractLayer[] refLayer = (AbstractLayer[])this._layer.clone();
        int i2 = 0;
        while (i2 < this._layer.length) {
            if (this._layer[i2] instanceof AbstractSmectite) {
                this._layer[i2] = PhaseFactory.getSmectiteSubstitute(this._layer[i2], iState, this._patternParams);
                if (this._layer[i2] != null) {
                    this._layer[i2].inheritSmectiteGeneValues(refLayer[i2], true);
                } else {
                    this._layer[i2] = refLayer[i2];
                }
            }
            ++i2;
        }
        if (this.getDescription() != null) {
            if (iState == 0) {
                Matcher airMatcher = _airRegexPattern.matcher(this.getDescription());
                this.setDescription(airMatcher.replaceAll("GLY"));
            } else {
                Matcher matcher = _glyRegexPattern.matcher(this.getDescription());
                this.setDescription(matcher.replaceAll("WAT"));
            }
        }
    }

    public void convertSmectiteinIS(int iState) {
        assert (this._edge == null) : "Don't know yet how to convert edges";
        MixedLayerPhase copy = (MixedLayerPhase)Phase.duplicatePhases(new Phase[]{this})[0];
        if (iState == 1) {
            AbstractLayer[] refLayer = (AbstractLayer[])this._layer.clone();
            int i = 1;
            while (i < this._layer.length) {
                this._layer[i] = PhaseFactory.getSmectiteSubstitute(this._layer[i], iState, this._patternParams);
                if (this._layer[i] == null) {
                    this._layer[i] = refLayer[i];
                }
                ++i;
            }
        } else {
            assert (iState == 0);
            this._iPhaseType = 0;
            AbstractLayer[] _newLayer = new AbstractLayer[2];
            _newLayer[0] = this._layer[0];
            if (this._layer.length > 2) {
                switch (this._probab.getR()) {
                    case 0: {
                        this._probab = new ProbabCondition20();
                        break;
                    }
                    case 1: {
                        this._probab = new ProbabCondition21();
                        break;
                    }
                    case 2: {
                        this._probab = new ProbabCondition22();
                    }
                }
            }
            boolean bCorrectSmectLayerFound = false;
            int i = 1;
            while (i < this._layer.length) {
                if (this._layer[i] instanceof DiSmectiteTwoWatLayer || this._layer[i] instanceof TriSmectiteTwoWatLayer) {
                    AbstractLayer subst = PhaseFactory.getSmectiteSubstitute(this._layer[i], iState, this._patternParams);
                    assert (subst != null);
                    _newLayer[1] = subst;
                    bCorrectSmectLayerFound = true;
                    break;
                }
                ++i;
            }
            assert (bCorrectSmectLayerFound);
            this._layer = _newLayer;
        }
        int i = 0;
        while (i < this._layer.length) {
            if (!(this._layer[i] instanceof AbstractSmectite)) {
                assert (!(copy._layer[i] instanceof AbstractSmectite));
            } else {
                this._layer[i].inheritSmectiteGeneValues(copy._layer[i], true);
            }
            ++i;
        }
        PhaseFactory.inheritGeneProperties(this._layer, this._edge, this, copy);
        if (this.getDescription() != null) {
            if (iState == 0) {
                Matcher airMatcher = _airRegexPattern.matcher(this.getDescription());
                this.setDescription(airMatcher.replaceAll("GLY"));
                Matcher isMatcher = _isRegexPattern.matcher(this.getDescription());
                this.setDescription(isMatcher.replaceAll("IS"));
            } else {
                Matcher matcher = _glyRegexPattern.matcher(this.getDescription());
                this.setDescription(matcher.replaceAll("WAT"));
            }
        }
    }

    @Override
    public String[] dumpPhase(int iProbabType) {
        ArrayList<String> alLines = new ArrayList<String>();
        alLines.add(String.valueOf(this.getSummaryDescription()) + ' ' + this._probab.getWRatios());
        if (this._probab.getR() > 0) {
            if (iProbabType == 0) {
                alLines.addAll(this._probab.getPValues());
            } else {
                assert (iProbabType == 1) : "illegal probability type: " + iProbabType;
                alLines.addAll(this._probab.getWValues());
            }
        }
        return alLines.toArray(new String[alLines.size()]);
    }

    public Probability getProbabMatrix() {
        return this._probab;
    }

    public AbstractProbabCondition getAbstractProbabMatrix() {
        return (AbstractProbabCondition)this._probab;
    }

    private void createEdgeMatrices() {
        int iBaseRow;
        int r;
        int i = 0;
        while (i < this._edge.length) {
            this._edge[i].updateLayer();
            this._edge[i].computeVariableFactors();
            ++i;
        }
        int iRank = this._probab.getRank();
        int iNoOfComp = this._probab.getNoOfComp();
        int iRankFactor = iRank / iNoOfComp;
        int i2 = 0;
        while (i2 < this._iNoOfData) {
            r = 0;
            while (r < iNoOfComp) {
                iBaseRow = r * iRankFactor;
                this._adVPrim0a[i2][iBaseRow][iBaseRow] = this._edge[r].getFactorA0(i2) * this._edge[r].getFactorA0(i2) + this._edge[r].getFactorB0(i2) * this._edge[r].getFactorB0(i2);
                this._adVPrimKa[i2][iBaseRow][iBaseRow] = this._edge[r].getFactorAK(i2) * this._edge[r].getFactorAK(i2) + this._edge[r].getFactorBK(i2) * this._edge[r].getFactorBK(i2);
                if (iRankFactor != 1) {
                    int rc = 0;
                    while (rc < iRankFactor) {
                        this._adVPrim0a[i2][iBaseRow + rc][iBaseRow + rc] = this._adVPrim0a[i2][iBaseRow][iBaseRow];
                        this._adVPrimKa[i2][iBaseRow + rc][iBaseRow + rc] = this._adVPrimKa[i2][iBaseRow][iBaseRow];
                        ++rc;
                    }
                }
                ++r;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this._iNoOfData) {
            r = 0;
            while (r < iNoOfComp) {
                iBaseRow = r * iRankFactor;
                int c = 0;
                while (c < iNoOfComp) {
                    int iBaseCol = c * iRankFactor;
                    this._adV0a[i2][iBaseRow][iBaseCol] = this._edge[c].getFactorA0(i2) * this._layer[r].getFactorA(i2) + this._edge[c].getFactorB0(i2) * this._layer[r].getFactorB(i2);
                    this._adV0b[i2][iBaseRow][iBaseCol] = this._edge[c].getFactorA0(i2) * this._layer[r].getFactorB(i2) - this._edge[c].getFactorB0(i2) * this._layer[r].getFactorA(i2);
                    this._adVKa[i2][iBaseRow][iBaseCol] = this._edge[r].getFactorAK(i2) * this._layer[c].getFactorA(i2) + this._edge[r].getFactorBK(i2) * this._layer[c].getFactorB(i2);
                    this._adVKb[i2][iBaseRow][iBaseCol] = this._edge[r].getFactorBK(i2) * this._layer[c].getFactorA(i2) - this._edge[r].getFactorAK(i2) * this._layer[c].getFactorB(i2);
                    this._adVPrima[i2][iBaseRow][iBaseCol] = this._edge[c].getFactorA0(i2) * this._edge[r].getFactorAK(i2) + this._edge[c].getFactorB0(i2) * this._edge[r].getFactorBK(i2);
                    this._adVPrimb[i2][iBaseRow][iBaseCol] = this._edge[c].getFactorA0(i2) * this._edge[r].getFactorBK(i2) - this._edge[c].getFactorB0(i2) * this._edge[r].getFactorAK(i2);
                    if (iRankFactor != 1) {
                        int rc = 0;
                        while (rc < iRankFactor) {
                            int cc = 0;
                            while (cc < iRankFactor) {
                                this._adV0a[i2][iBaseRow + rc][iBaseCol + cc] = this._adV0a[i2][iBaseRow][iBaseCol];
                                this._adV0b[i2][iBaseRow + rc][iBaseCol + cc] = this._adV0b[i2][iBaseRow][iBaseCol];
                                this._adVKa[i2][iBaseRow + rc][iBaseCol + cc] = this._adVKa[i2][iBaseRow][iBaseCol];
                                this._adVKb[i2][iBaseRow + rc][iBaseCol + cc] = this._adVKb[i2][iBaseRow][iBaseCol];
                                this._adVPrima[i2][iBaseRow + rc][iBaseCol + cc] = this._adVPrima[i2][iBaseRow][iBaseCol];
                                this._adVPrimb[i2][iBaseRow + rc][iBaseCol + cc] = this._adVPrimb[i2][iBaseRow][iBaseCol];
                                ++cc;
                            }
                            ++rc;
                        }
                    }
                    ++c;
                }
                ++r;
            }
            ++i2;
        }
        double[] adTwoPiKsi = new double[iNoOfComp];
        int j = 0;
        while (j < iNoOfComp) {
            adTwoPiKsi[j] = Math.PI * 2 * this._edge[j].getDSpacing0();
            ++j;
        }
        double[] adPhi0A = new double[iNoOfComp];
        double[] adPhi0B = new double[iNoOfComp];
        Z z = this._patternParams.getZ();
        int i3 = 0;
        while (i3 < this._iNoOfData) {
            double dZ = z.getZ(i3);
            double dZSquare = dZ * dZ;
            int j2 = 0;
            while (j2 < iNoOfComp) {
                double dTerm = adTwoPiKsi[j2] * dZ;
                adPhi0A[j2] = Math.cos(dTerm);
                adPhi0B[j2] = Math.sin(dTerm);
                ++j2;
            }
            int r2 = 0;
            while (r2 < iRank) {
                int c = 0;
                while (c < iRank) {
                    this._adQ0a[i3][r2][c] = this._probab.getP(r2, c);
                    double d = this._adQ0b[i3][r2][c] = this._probab.getP(r2, c);
                    if (d > 0.0) {
                        int iLayerIndex = r2 / iRankFactor;
                        double[] dArray = this._adQ0a[i3][r2];
                        int n = c;
                        dArray[n] = dArray[n] * adPhi0A[iLayerIndex];
                        double[] dArray2 = this._adQ0b[i3][r2];
                        int n2 = c;
                        dArray2[n2] = dArray2[n2] * adPhi0B[iLayerIndex];
                    }
                    ++c;
                }
                ++r2;
            }
            ++i3;
        }
    }

    @Override
    public Element serializeXML() {
        Element phase = new Element("phase");
        phase.setAttribute("type", "mixed");
        phase.setAttribute("name", this.getDescription());
        if (this._sigmaGeneConnector != null && this._bSigmaGeneActive) {
            phase.setAttribute("sigma_star", String.valueOf(this._sigmaGeneConnector.getValue()));
        }
        Element[] layersAndEdges = LayerAndEdge.serializeXML(this._layer, this._edge);
        int i = 0;
        while (i < layersAndEdges.length) {
            phase.addContent(layersAndEdges[i]);
            ++i;
        }
        Element distribution = new Element("distribution");
        if (this._distrib instanceof LognormalDistribution) {
            distribution.setAttribute("type", "lognormal");
        } else if (this._distrib instanceof AnyDistribution) {
            distribution.setAttribute("type", "single_crystal");
        }
        distribution.setAttribute("Tmean", String.valueOf(this._distrib.getMean()));
        distribution.setAttribute("Tmax", String.valueOf(this._distrib.getNoOfClasses()));
        phase.addContent(distribution);
        phase.addContent(this._probab.serializeXML());
        return phase;
    }

    public static Phase[] deserializeXML(Element owner, PatternParams patternParams) throws IllegalArgumentException, DataConversionException {
        List lPhases = owner.getChildren("phase");
        if (lPhases.size() == 0) {
            throw new IllegalArgumentException("Missing phases in mixture");
        }
        Phase[] aPhases = new Phase[lPhases.size()];
        int iCurrentPhase = 0;
        for (Element ePhase : lPhases) {
            LayerAndEdge[] aLayersAndEdges;
            Attribute aType = ePhase.getAttribute("type");
            Attribute aName = ePhase.getAttribute("name");
            String sName = null;
            sName = aName == null ? "unnamed" : aName.getValue();
            if (aType == null) {
                throw new IllegalArgumentException("Missing type in phase " + sName);
            }
            Attribute aSigmaStar = ePhase.getAttribute("sigma_star");
            double dSigmaStar = -1.0;
            if (aSigmaStar != null && ((dSigmaStar = aSigmaStar.getDoubleValue()) < 2.0 || dSigmaStar > 80.0)) {
                throw new IllegalArgumentException("In phase " + sName + " sigma star out of limits: " + 2.0 + " - " + 80.0);
            }
            if (aType.getValue().toLowerCase().equals("mixed")) {
                aLayersAndEdges = null;
                try {
                    aLayersAndEdges = LayerAndEdge.deserializeXML(ePhase, patternParams);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("In phase '" + sName + "', following error occured:\n" + iae.getMessage());
                }
                AbstractLayer[] layers = new AbstractLayer[aLayersAndEdges.length];
                AbstractEdge[] edges = new AbstractEdge[aLayersAndEdges.length];
                int i = 0;
                while (i < aLayersAndEdges.length) {
                    layers[i] = aLayersAndEdges[i].getLayer();
                    edges[i] = aLayersAndEdges[i].getEdge();
                    ++i;
                }
                int iEdgesConsistency = MixedLayerPhase.verifyEdgeConsistence(edges);
                if (iEdgesConsistency == 0) {
                    edges = null;
                } else if (iEdgesConsistency == 2) {
                    throw new IllegalArgumentException("In phase '" + sName + "', not all layers has specified edges");
                }
                Probability probab = null;
                try {
                    probab = Probability.deserializeXML(layers.length, ePhase);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("In phase '" + sName + "', following probability error occured:\n" + iae.getMessage());
                }
                catch (DataConversionException dce) {
                    throw new IllegalArgumentException("In phase '" + sName + "', following probability error occured:\n" + dce.getMessage());
                }
                Element eDistrib = ePhase.getChild("distribution");
                if (eDistrib == null) {
                    throw new IllegalArgumentException("Missing distribution in phase '" + sName + "'");
                }
                Attribute aDistType = eDistrib.getAttribute("type");
                if (aDistType == null) {
                    throw new IllegalArgumentException("Missing distribution type in phase '" + sName + "'");
                }
                String sType = aDistType.getValue();
                Attribute aTMean = eDistrib.getAttribute("Tmean");
                if (aTMean == null) {
                    throw new IllegalArgumentException("Missing distribution T mean in phase '" + sName + "'");
                }
                double dTmean = aTMean.getDoubleValue();
                Attribute aTMax = eDistrib.getAttribute("Tmax");
                Distribution distrib = null;
                if (sType.trim().toLowerCase().equals("lognormal")) {
                    if (aTMax != null) {
                        int iTmax = aTMax.getIntValue();
                        distrib = new LognormalDistribution(dTmean, iTmax);
                    } else {
                        distrib = new LognormalDistribution(dTmean, MixedLayerPhase.calcDistLimit(dTmean, 2.5));
                    }
                } else if (sType.trim().toLowerCase().equals("single_crystal")) {
                    distrib = new AnyDistribution((int)Math.round(dTmean));
                } else {
                    throw new IllegalArgumentException("Unknown distribution type '" + sType + "' in phase '" + sName + "'");
                }
                aPhases[iCurrentPhase] = new MixedLayerPhase(patternParams, layers, edges, probab, 100, dSigmaStar >= 0.0);
                if (dSigmaStar >= 0.0) {
                    aPhases[iCurrentPhase].setSigmaStarGeneValue(dSigmaStar);
                }
                aPhases[iCurrentPhase].setDistribution(distrib);
                aPhases[iCurrentPhase].setDescription(sName);
            } else if (aType.getValue().toLowerCase().equals("mono")) {
                aLayersAndEdges = null;
                try {
                    aLayersAndEdges = LayerAndEdge.deserializeXML(ePhase, patternParams);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("In phase '" + sName + "', following error occured:\n" + iae.getMessage());
                }
                if (aLayersAndEdges.length > 1) {
                    throw new IllegalArgumentException("More than one layer in phase '" + sName + "'");
                }
                Element eDistrib = ePhase.getChild("distribution");
                if (eDistrib == null) {
                    throw new IllegalArgumentException("Missing distribution in phase '" + sName + "'");
                }
                Attribute aDistType = eDistrib.getAttribute("type");
                if (aDistType == null) {
                    throw new IllegalArgumentException("Missing distribution type in phase '" + sName + "'");
                }
                String sType = aDistType.getValue();
                Attribute aTMean = eDistrib.getAttribute("Tmean");
                if (aTMean == null) {
                    throw new IllegalArgumentException("Missing distribution T mean in phase '" + sName + "'");
                }
                double dTmean = aTMean.getDoubleValue();
                Attribute aTMax = eDistrib.getAttribute("Tmax");
                Distribution distrib = null;
                if (sType.trim().toLowerCase().equals("lognormal")) {
                    if (aTMax != null) {
                        int iTmax = aTMax.getIntValue();
                        distrib = new LognormalDistribution(dTmean, iTmax);
                    } else {
                        distrib = new LognormalDistribution(dTmean, MixedLayerPhase.calcDistLimit(dTmean, 2.5));
                    }
                } else if (sType.trim().toLowerCase().equals("single_crystal")) {
                    distrib = new AnyDistribution((int)Math.round(dTmean));
                } else {
                    throw new IllegalArgumentException("Unknown distribution type '" + sType + "' in phase '" + sName + "'");
                }
                aPhases[iCurrentPhase] = new Phase(patternParams, aLayersAndEdges[0].getLayer(), aLayersAndEdges[0].getEdge(), 100, dSigmaStar >= 0.0);
                if (dSigmaStar >= 0.0) {
                    aPhases[iCurrentPhase].setSigmaStarGeneValue(dSigmaStar);
                }
                aPhases[iCurrentPhase].setDistribution(distrib);
                aPhases[iCurrentPhase].setDescription(sName);
            } else {
                throw new IllegalArgumentException("Unknown type of phase " + sName);
            }
            ++iCurrentPhase;
        }
        boolean bFirstSigmaPresent = aPhases[0].isSigmaStarGenePresent();
        int i = 0;
        while (i < aPhases.length) {
            if (bFirstSigmaPresent != aPhases[i].isSigmaStarGenePresent()) {
                throw new IllegalArgumentException("Some sigma-star values are missing");
            }
            ++i;
        }
        return aPhases;
    }

    private static int verifyEdgeConsistence(AbstractEdge[] edges) {
        assert (edges.length > 0);
        int iPresentCount = 0;
        int i = 0;
        while (i < edges.length) {
            if (edges[i] != null) {
                ++iPresentCount;
            }
            ++i;
        }
        if (iPresentCount == 0) {
            return 0;
        }
        if (iPresentCount < edges.length) {
            return 2;
        }
        assert (iPresentCount == edges.length);
        return 1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initMatrices(this._edge != null);
        if (this.calcProbabilities()) {
            this.calcIntensities();
        }
    }
}

