/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd.mod;

import net.ndmystko.analysis.evolution.CalcEngine;
import net.ndmystko.analysis.evolution.Chromosome;
import net.ndmystko.analysis.evolution.Gene;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.mod.Pattern;
import net.ndmystko.xrd.mod.gene.GeneConnector;
import net.ndmystko.xrd.mod.gene.ModGene;

public class MicroCalcThread
extends CalcEngine {
    private Pattern _pattern = null;
    private GeneConnector[] _aConnectors = null;

    public MicroCalcThread(Pattern pattern) {
        this._pattern = pattern;
        this._aConnectors = this._pattern.getConnectors(true, true);
    }

    @Override
    public double evaluate(Chromosome chromosome) {
        this.attachGenes(chromosome);
        boolean bProbabOK = this._pattern.calcProbabilities();
        if (!bProbabOK) {
            return Double.NaN;
        }
        this._pattern.calcIntensities();
        AbstractDiffractogram calcPattern = this._pattern.getFinalDiffr();
        AbstractDiffractogram expPattern = this._pattern.getExpPattern();
        int iNoOfSteps = expPattern.getNoOfSteps();
        double dMisfit = 0.0;
        int i = 0;
        while (i < iNoOfSteps) {
            if (!this._pattern.isStepExcluded(i)) {
                dMisfit += Math.abs(expPattern.getIntensity(i) - calcPattern.getIntensity(i));
            }
            ++i;
        }
        return dMisfit;
    }

    private void attachGenes(Chromosome chromosome) {
        Gene[] aGenes = chromosome.getGenes();
        int i = 0;
        while (i < aGenes.length) {
            this._aConnectors[i].setGene((ModGene)aGenes[i]);
            ++i;
        }
    }
}

