/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.ndmystko.common.util.RoundOff;
import net.ndmystko.xrd.Radiation;
import net.ndmystko.xrd.RealDiffractogram;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class XlsParser {
    public static RealDiffractogram loadDiffractogram(String sFileName) throws IOException {
        int noOfSteps = 0;
        double min2theta = 0.0;
        double stepSize = 0.0;
        double maxIntensity = 0.0;
        int iMaxSteps = 150000;
        int iChunkSize = 10000;
        double[][] adIntensity = new double[iMaxSteps / iChunkSize][];
        adIntensity[0] = new double[iChunkSize];
        try (FileInputStream fis = new FileInputStream(new File(sFileName));){
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fis);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int iRowIndex = 0;
            if (Double.isNaN(XlsParser.getValueAt(sheet, 0, 0)) || Double.isNaN(XlsParser.getValueAt(sheet, 0, 1))) {
                ++iRowIndex;
            }
            double dFirstStep = XlsParser.getValueAt(sheet, iRowIndex, 0);
            double dSecondStep = XlsParser.getValueAt(sheet, iRowIndex + 1, 0);
            if (Double.isNaN(dFirstStep)) {
                throw new IOException("Wrong format of the " + sFileName + " file: missing or non-numeric value in cell A" + (iRowIndex + 1) + " in sheet " + wb.getSheetName(0));
            }
            if (Double.isNaN(dSecondStep)) {
                throw new IOException("Wrong format of the " + sFileName + " file: missing or non-numeric value in cell A" + (iRowIndex + 2) + " in sheet " + wb.getSheetName(0));
            }
            min2theta = RoundOff.roundOff(dFirstStep, 3);
            stepSize = RoundOff.roundOff(dSecondStep - dFirstStep, 3);
            while (noOfSteps < iMaxSteps) {
                double dIntensity;
                if (Double.isNaN(dIntensity = XlsParser.getValueAt(sheet, iRowIndex++, 1))) {
                    if (noOfSteps < 11) {
                        throw new IOException("Wrong format of the " + sFileName + " file: missing or non-numeric value in cell B" + iRowIndex + " in sheet " + wb.getSheetName(0));
                    }
                    break;
                }
                adIntensity[noOfSteps / iChunkSize][noOfSteps % iChunkSize] = dIntensity;
                if (maxIntensity < dIntensity) {
                    maxIntensity = dIntensity;
                }
                if (++noOfSteps % iChunkSize != 0 || noOfSteps >= iMaxSteps) continue;
                adIntensity[noOfSteps / iChunkSize] = new double[iChunkSize];
            }
        }
        RealDiffractogram data = new RealDiffractogram();
        data.min2theta = min2theta;
        data.max2theta = min2theta + stepSize * (double)(noOfSteps - 1);
        data.stepSize = stepSize;
        data.lamp = Radiation.Cu;
        data.sampleName = sFileName;
        data.intensity = new double[noOfSteps];
        int iTotalLength = 0;
        int i = 0;
        while (i < adIntensity.length) {
            int iLength = Math.min(noOfSteps - i * iChunkSize, iChunkSize);
            System.arraycopy(adIntensity[i], 0, data.intensity, i * iChunkSize, iLength);
            if ((iTotalLength += iLength) == noOfSteps) break;
            ++i;
        }
        data.noOfSteps = noOfSteps;
        data.maxIntensity = maxIntensity;
        return data;
    }

    private static double getValueAt(HSSFSheet sheet, int iRow, int iCol) {
        HSSFCell cell;
        double dValue = Double.NaN;
        HSSFRow row = sheet.getRow(iRow);
        if (row != null && (cell = row.getCell((short)iCol)) != null && cell.getCellType() == 0) {
            dValue = cell.getNumericCellValue();
        }
        return dValue;
    }
}

