/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.io.IOException;
import java.io.Serializable;
import net.ndmystko.xrd.AbstractDiffractogram;
import net.ndmystko.xrd.Radiation;

public class RealDiffractogram
extends AbstractDiffractogram
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8556526192333016584L;
    private static final double LOW_LIMIT_QUARTZ = 26.5;
    private static final double HIGH_LIMIT_QUARTZ = 26.8;

    public RealDiffractogram() {
        super(5.0, 6.0, 0.02);
        this.sampleName = "unknown";
        this.lamp = Radiation.Cu;
    }

    public RealDiffractogram(RealDiffractogram source) {
        super(source);
        this.sampleName = source.sampleName;
        this.lamp = source.lamp;
        System.arraycopy(source.intensity, 0, this.intensity, 0, this.noOfSteps);
    }

    public RealDiffractogram(String file) throws IOException {
        super(file);
    }

    public void shiftForQuartz() {
        int lowLimit = this.index(26.5);
        int highLimit = this.index(26.8);
        int position = 0;
        double maxValue = 0.0;
        int i = lowLimit;
        while (i < highLimit) {
            if (maxValue < this.intensity[i]) {
                maxValue = this.intensity[i];
                position = i;
            }
            ++i;
        }
        int range = (int)Math.round(0.08 / this.stepSize);
        double leftDrop = this.intensity[position - range] / this.intensity[position];
        double rightDrop = this.intensity[position + range] / this.intensity[position];
        if (leftDrop < 0.85 && rightDrop < 0.85) {
            this.shift(this.index(26.64) - position);
        }
    }

    public void setName(String sampleName) {
        this.sampleName = sampleName;
    }

    public double[] getIntensities() {
        return this.intensity;
    }

    public void setMaxIntensity(double maxIntensity) {
        this.maxIntensity = maxIntensity;
    }
}

