/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.io.Serializable;
import java.text.NumberFormat;

public class Radiation
implements Serializable {
    private static final long serialVersionUID = 1091743451247653236L;
    public static final Character ALPHA = new Character('\u03b1');
    public static final Character BETA = new Character('\u03b2');
    public static final Radiation Cu = new Radiation(1.54178, 1.54056, 1.39217);
    public static final Radiation Co = new Radiation(1.79021, 1.7889, 1.62073);
    public static final Radiation Fe = new Radiation(1.93728, 1.93597, 1.75654);
    private double _dKalphaMean = Double.NaN;
    private double _dKalpha1 = Double.NaN;
    private double _dKbeta1 = Double.NaN;
    private double _selectedValue = Double.NaN;
    private String _kalphaMeanType = "";
    private String _kalpha1Type = "";
    private String _kbeta1Type = "";
    private String _customType = "";
    private String _selectedType = "";
    private NumberFormat _numberFormatter = null;
    private String symbol;

    public Radiation(double dKalphaMean, double dKalpha1, double dKbeta1, String type) {
        this._dKalphaMean = dKalphaMean;
        this._dKalpha1 = dKalpha1;
        this._dKbeta1 = dKbeta1;
        this._customType = type;
        this.setFormatter();
        this._kalphaMeanType = "[" + this._numberFormatter.format(this._dKalphaMean) + "\u00c5]" + "  (K" + ALPHA + " mean)";
        this._kalpha1Type = "[" + this._numberFormatter.format(this._dKalpha1) + "\u00c5]" + "  (K" + ALPHA + "1)";
        this._kbeta1Type = "[" + this._numberFormatter.format(this._dKbeta1) + "\u00c5]" + "  (K" + BETA + "1)";
    }

    public Radiation(double dKalphaMean, double dKalpha1, double dKbeta1) {
        this(dKalphaMean, dKalpha1, dKbeta1, null);
    }

    private void setFormatter() {
        this._numberFormatter = NumberFormat.getInstance();
        this._numberFormatter.setMinimumFractionDigits(3);
        this._numberFormatter.setMaximumFractionDigits(5);
    }

    public double getKalphaMean() {
        return this._dKalphaMean;
    }

    public double getKalpha1() {
        return this._dKalpha1;
    }

    public double getKbeta1() {
        return this._dKbeta1;
    }

    public double twoTheta(double d) {
        return Math.asin(this._dKalphaMean / 2.0 / d) / Math.PI * 360.0;
    }

    public static double twoTheta(double d, double dWaveLength) {
        return Math.asin(dWaveLength / 2.0 / d) / Math.PI * 360.0;
    }

    public double d(double twoTheta) {
        return this._dKalphaMean / (2.0 * Math.sin(twoTheta * Math.PI / 360.0));
    }

    public static double d(double twoTheta, double dWaveLength) {
        return dWaveLength / (2.0 * Math.sin(twoTheta * Math.PI / 360.0));
    }

    public void setSelection(String type, double value) {
        this.setSelectedType(type);
        this.setSelectedValue(value);
    }

    public void setSelectedType(String type) {
        this._selectedType = type;
    }

    public String getSelectedType() {
        return this._selectedType;
    }

    public void setSelectedValue(double value) {
        this._selectedValue = value;
    }

    public double getSelectedValue() {
        return this._selectedValue;
    }

    public String getKalphaMeanType() {
        return this._kalphaMeanType;
    }

    public String getKalpha1Type() {
        return this._kalpha1Type;
    }

    public String getKbeta1Type() {
        return this._kbeta1Type;
    }

    public String getCustomType() {
        return this._customType;
    }

    public String getSymbol() {
        if (this._dKalphaMean == Radiation.Cu._dKalphaMean) {
            return "Cu";
        }
        if (this._dKalphaMean == Radiation.Co._dKalphaMean) {
            return "Co";
        }
        if (this._dKalphaMean == Radiation.Fe._dKalphaMean) {
            return "Fe";
        }
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }
}

