/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import jamlab.Polyfit;
import net.ndmystko.xrd.AbstractXRDData;

public class PolynomialTool {
    private AbstractXRDData _data = null;
    private int _iNoOfPoints = -1;
    private int _iTail = -1;
    private int _iPolynomialOrder = -1;
    private double[] _adX = null;
    private double[] _adY = null;

    public PolynomialTool(AbstractXRDData data, int iNoOfPoints, int iPolynomialOrder) throws IllegalArgumentException {
        if (iNoOfPoints % 2 == 0 || iNoOfPoints < 3 || iNoOfPoints > data.getNoOfSteps()) {
            throw new IllegalArgumentException("iNoOfPoints must be an odd number, at least 3, at most number of points in the pattern");
        }
        if (iPolynomialOrder < 0 || iPolynomialOrder > 4) {
            throw new IllegalArgumentException("iPolynomialOrder must be within [0-4] range");
        }
        this._data = data;
        this._iNoOfPoints = iNoOfPoints;
        this._iTail = iNoOfPoints / 2;
        this._iPolynomialOrder = iPolynomialOrder;
        this._adX = new double[iNoOfPoints];
        this._adY = new double[iNoOfPoints];
    }

    public double getIntensityAt(double dTwoTheta) throws Exception {
        int iStep = (int)Math.round((dTwoTheta - this._data.getMin2theta()) / this._data.getStepSize());
        if (iStep < this._iTail) {
            iStep = this._iTail;
        }
        if (iStep > this._data.getNoOfSteps() - this._iTail - 1) {
            iStep = this._data.getNoOfSteps() - this._iTail - 1;
        }
        int j = 0;
        while (j < this._iNoOfPoints) {
            this._adY[j] = this._data.getIntensity(iStep - this._iTail + j);
            this._adX[j] = this._data.getMin2theta() + (double)(iStep - this._iTail + j) * this._data.getStepSize();
            ++j;
        }
        Polyfit polyf = new Polyfit(this._adX, this._adY, this._iPolynomialOrder);
        double[] adCoef = polyf.getPolyCoeffMatrix().getColumnPackedCopy();
        double dIntensity = 0.0;
        switch (this._iPolynomialOrder) {
            case 4: {
                dIntensity += adCoef[0] * dTwoTheta * dTwoTheta * dTwoTheta * dTwoTheta;
            }
            case 3: {
                dIntensity += adCoef[-3 + this._iPolynomialOrder] * dTwoTheta * dTwoTheta * dTwoTheta;
            }
            case 2: {
                dIntensity += adCoef[-2 + this._iPolynomialOrder] * dTwoTheta * dTwoTheta;
            }
            case 1: {
                dIntensity += adCoef[-1 + this._iPolynomialOrder] * dTwoTheta;
            }
            case 0: {
                dIntensity += adCoef[this._iPolynomialOrder];
                break;
            }
            default: {
                assert (false) : "Illegal polynomial order: " + this._iPolynomialOrder;
                break;
            }
        }
        return Math.max(dIntensity, 0.0);
    }
}

