/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import net.ndmystko.xrd.Lp;

public class LpCache
implements Serializable {
    private static final long serialVersionUID = 7085773024000764614L;
    Lp[] _lpCache = null;
    double _dOrientLow;
    double _dOrientDelta;
    double _dOrientHigh;
    double _s1;
    double _s2;

    public LpCache(double s1, double s2, double dOrientLow, double dOrientHigh, int iOrientResults, double dLow2theta, double dHigh2theta, double dStepSize) {
        this(s1, s2, dOrientLow, dOrientHigh, iOrientResults, dLow2theta, dHigh2theta, dStepSize, null);
    }

    public LpCache(double s1, double s2, double dOrientLow, double dOrientHigh, int iOrientResults, double dLow2theta, double dHigh2theta, double dStepSize, Component gui) {
        this._s1 = s1;
        this._s2 = s2;
        this._dOrientLow = dOrientLow;
        this._dOrientDelta = (dOrientHigh - dOrientLow) / (double)(iOrientResults - 1);
        this._dOrientHigh = dOrientHigh;
        this._lpCache = new Lp[iOrientResults];
        ProgressMonitor monitor = null;
        if (gui != null) {
            NumberFormat diffrNumberFormatter = NumberFormat.getInstance();
            diffrNumberFormatter.setMinimumFractionDigits(0);
            diffrNumberFormatter.setMaximumFractionDigits(3);
            monitor = new ProgressMonitor(gui, "Calculating Lp for 2theta: " + diffrNumberFormatter.format(dLow2theta) + "-" + diffrNumberFormatter.format(dHigh2theta) + ", step size: " + diffrNumberFormatter.format(dStepSize), "sigma star: " + dOrientLow, 0, iOrientResults);
            monitor.setMillisToDecideToPopup(0);
        }
        boolean bDontCancelShown = false;
        int i = 0;
        while (i < iOrientResults) {
            double dOrientation = dOrientLow + (double)i * this._dOrientDelta;
            if (monitor != null) {
                monitor.setNote("sigma star: " + dOrientation);
                monitor.setProgress(i);
                if (monitor.isCanceled() && !bDontCancelShown) {
                    JOptionPane.showMessageDialog(gui, "Cancel is not supported here, please wait patiently until calculation is finished.\nIf you want to be able to cancel ask for it.", "Lp cache calculation", 1);
                    bDontCancelShown = true;
                }
            } else {
                System.out.println(String.valueOf(i) + ": Calculating Lp for sigma star: " + dOrientation);
            }
            this._lpCache[i] = new Lp(dLow2theta, dHigh2theta, dStepSize);
            this._lpCache[i].calculateFunction(s1, s2, dOrientation);
            ++i;
        }
        if (monitor != null) {
            monitor.close();
        }
    }

    public Lp getByIndex(int iOrientIndex) {
        return this._lpCache[iOrientIndex];
    }

    public Lp getByOrientation(double dOrientation) {
        int iOrientIndex = (int)Math.round((dOrientation - this._dOrientLow) / this._dOrientDelta);
        return this._lpCache[iOrientIndex];
    }

    public double getLowOrientationLimit() {
        return this._dOrientLow;
    }

    public double getHighOrientationLimit() {
        return this._dOrientHigh;
    }

    public int getNoOfPatterns() {
        return this._lpCache.length;
    }

    public double getS1() {
        return this._s1;
    }

    public double getS2() {
        return this._s2;
    }

    public double getMin2theta() {
        return this._lpCache[0].getMin2theta();
    }

    public double getMax2theta() {
        return this._lpCache[0].getMax2theta();
    }

    public double getStepSize() {
        return this._lpCache[0].getStepSize();
    }

    public void serializeData(File targetFile) throws IOException {
        ObjectOutputStream oos = null;
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(targetFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.flush();
        }
    }

    public static LpCache deserializeData(File sourceFile) throws IOException, FileNotFoundException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(sourceFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        LpCache data = (LpCache)ois.readObject();
        try {
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }
}

