/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.io.Serializable;
import net.ndmystko.xrd.AbstractXRDData;

public class Lp
extends AbstractXRDData
implements Serializable {
    private static final long serialVersionUID = 8831442613820724905L;
    public static final int SINGLE_CRISTAL = 0;
    public static final int RANDOM_POWDER = 1;
    public static final int GLASS_SLIDE = 2;

    public Lp(double min2theta, double max2theta, double stepSize) {
        super(min2theta, max2theta, stepSize);
    }

    public Lp(AbstractXRDData pattern) {
        super(pattern);
    }

    public void calculateFunction(int type) {
        double sinTheta;
        double cos2theta;
        int i;
        if (type == 1) {
            i = 0;
            while (i < this.noOfSteps) {
                cos2theta = Math.cos(this.theta(i) * Math.PI / 90.0);
                sinTheta = Math.sin(this.theta(i) * Math.PI / 180.0);
                this.intensity[i] = (1.0 + cos2theta * cos2theta) / (sinTheta * sinTheta);
                ++i;
            }
        }
        if (type == 0) {
            i = 0;
            while (i < this.noOfSteps) {
                cos2theta = Math.cos(this.theta(i) * Math.PI / 90.0);
                sinTheta = Math.sin(this.theta(i) * Math.PI / 180.0);
                this.intensity[i] = (1.0 + cos2theta * cos2theta) / sinTheta;
                ++i;
            }
        }
        if (type == 2) {
            i = 0;
            while (i < this.noOfSteps) {
                cos2theta = Math.cos(this.theta(i) * Math.PI / 90.0);
                this.intensity[i] = (1.0 + cos2theta * cos2theta) / Math.sin(this.theta(i) * Math.PI / 180.0) / Math.pow(Math.sin(this.theta(i) * Math.PI / 180.0), 0.8);
                ++i;
            }
        }
        this.maxIntensity = this.intensity[0];
    }

    public void calculateMMFunction(int type) {
        double cos2theta;
        int i;
        if (type == 1) {
            i = 0;
            while (i < this.noOfSteps) {
                cos2theta = Math.cos(this.theta(i) * Math.PI / 90.0);
                double sinTheta = Math.sin(this.theta(i) * Math.PI / 180.0);
                double sin2Theta = Math.sin(this.theta(i) * Math.PI / 90.0);
                this.intensity[i] = (1.0 + cos2theta * cos2theta) / (sinTheta * sin2Theta);
                ++i;
            }
        }
        if (type == 0) {
            i = 0;
            while (i < this.noOfSteps) {
                cos2theta = Math.cos(this.theta(i) * Math.PI / 90.0);
                double sin2Theta = Math.sin(this.theta(i) * Math.PI / 90.0);
                this.intensity[i] = (1.0 + cos2theta * cos2theta) / sin2Theta;
                ++i;
            }
        }
        if (type == 2) {
            i = 0;
            while (i < this.noOfSteps) {
                cos2theta = Math.cos(this.theta(i) * Math.PI / 90.0);
                this.intensity[i] = (1.0 + cos2theta * cos2theta) / Math.sin(this.theta(i) * Math.PI / 90.0) / Math.pow(Math.sin(this.theta(i) * Math.PI / 180.0), 0.8);
                ++i;
            }
        }
        this.maxIntensity = this.intensity[0];
    }

    public void calculateFunction(double s1, double s2, double sigmaStar) {
        this.calculateFunction(s1, s2, sigmaStar, false);
    }

    public void calculateFunction(double s1, double s2, double sigmaStar, boolean bFull) {
        if (bFull) {
            this.calculateFullKappa(s1, s2, sigmaStar);
        } else {
            this.calculateSimpleKappa(s1, s2, sigmaStar);
        }
        double dMaxIntensity = 0.0;
        int i = 0;
        while (i < this.intensity.length) {
            double dTheta = (this.min2theta + (double)i * this.stepSize) / 2.0;
            this.intensity[i] = (1.0 + Math.cos(Math.toRadians(2.0 * dTheta)) * Math.cos(Math.toRadians(2.0 * dTheta))) * this.intensity[i] / Math.sin(Math.toRadians(dTheta));
            dMaxIntensity = Math.max(this.intensity[i], dMaxIntensity);
            ++i;
        }
        this.maxIntensity = dMaxIntensity;
    }

    public void calculateSimpleKappa(double s1, double s2, double sigmaStar) {
        double dMaxIntensity = 0.0;
        double dSMean = Math.sqrt(s1 / 2.0 * (s1 / 2.0) + s2 / 2.0 * (s2 / 2.0));
        double dConst1 = Math.sqrt(Math.PI * 2) / (2.0 * sigmaStar * dSMean);
        double dConst2 = 2.0 / (dSMean * dSMean);
        double dConst3 = dSMean / (2.0 * Math.sqrt(2.0) * sigmaStar);
        int i = 0;
        while (i < this.intensity.length) {
            double dTheta = Math.toRadians((this.min2theta + (double)i * this.stepSize) / 2.0);
            double dSinTheta = Math.sin(dTheta);
            double dQ = dConst3 / dSinTheta;
            this.intensity[i] = this.erf(dQ, 1000) * dConst1 - dConst2 * dSinTheta * (1.0 - Math.exp(-dQ * dQ));
            dMaxIntensity = Math.max(this.intensity[i], dMaxIntensity);
            ++i;
        }
        this.maxIntensity = dMaxIntensity;
    }

    public void calculateFullKappa(double s1, double s2, double sigmaStar) {
        double dMaxIntensity = 0.0;
        double dConst1 = (s1 + s2) / (12.0 * s1 * s2);
        double dConst2 = (s1 + s2) * (s1 + s2);
        double dConst3 = (s1 - s2) / (12.0 * s1 * s2);
        double dConst4 = (s1 - s2) * (s1 - s2);
        double dConst5 = 6.0 * Math.sqrt(Math.PI) * s1 * s2;
        double dConst6 = 3.0 * Math.sqrt(Math.PI) * s1 * s2;
        double dConst7 = 2.0 * Math.sqrt(2.0) * sigmaStar;
        int i = 0;
        while (i < this.intensity.length) {
            double dTheta = Math.toRadians((this.min2theta + (double)i * this.stepSize) / 2.0);
            double dQ = dConst7 * Math.sin(dTheta);
            this.intensity[i] = 1.0 / sigmaStar * (dConst1 * this.erf((s1 + s2) / dQ, 1000) * (2.0 * dConst2 + 3.0 * dQ * dQ) + dConst3 * this.erf((s1 - s2) / dQ, 1000) * (2.0 * dConst4 + 3.0 * dQ * dQ) - 1.0 / (6.0 * s1) * this.erf(s2 / dQ, 1000) * (2.0 * s2 * s2 + 3.0 * dQ * dQ) - 1.0 / (6.0 * s2) * this.erf(s1 / dQ, 1000) * (2.0 * s1 * s1 + 3.0 * dQ * dQ) + dQ / dConst5 * Math.exp(-dConst2 / (dQ * dQ)) * (dConst2 + dQ * dQ) + dQ / dConst5 * Math.exp(-dConst4 / (dQ * dQ)) * (dConst4 + dQ * dQ) - dQ / dConst6 * Math.exp(-(s2 / dQ * (s2 / dQ))) * (s2 * s2 + dQ * dQ) - dQ / dConst6 * Math.exp(-(s1 / dQ * (s1 / dQ))) * (s1 * s1 + dQ * dQ) + dQ * dQ * dQ / dConst6);
            dMaxIntensity = Math.max(this.intensity[i], dMaxIntensity);
            ++i;
        }
        this.maxIntensity = dMaxIntensity;
    }

    private double erf(double x, int steps) {
        double result = 0.0;
        double dt = x / (double)steps;
        int i = 0;
        while (i < steps) {
            double t = ((double)i + 0.5) * dt;
            result += Math.exp(-(t * t)) * dt;
            ++i;
        }
        return result *= 2.0 / Math.sqrt(Math.PI);
    }
}

