/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.io.Serializable;
import net.ndmystko.xrd.UserDiffractogram;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class Diffractometer
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4034485753194594217L;
    private static final double DEFAULT_SAMPLE_LENGTH = 3.5;
    private static final double DEFAULT_GONIO_RADIUS = 25.0;
    private static final double DEFAULT_DIVERG_SLIT_SIZE = 1.0;
    private static final double DEFAULT_SOLLER1_SIZE = 2.0;
    private static final double DEFAULT_SOLLER2_SIZE = 2.0;
    private double _dGonioRadius = 25.0;
    private double _dDivergSlitSize = 1.0;
    private double _dSoller1Size = 2.0;
    private double _dSoller2Size = 2.0;
    private double _dSampleLength = 3.5;

    public Diffractometer() {
    }

    public Diffractometer(double dRadius, double dDivergSlitSize, double dSampleLength) {
        this(dRadius, dDivergSlitSize, 2.0, 2.0, dSampleLength);
    }

    public Diffractometer(double dRadius, double dDivergSlitSize, double dSoler1Size, double dSoler2Size, double dSampleLength) {
        this._dGonioRadius = dRadius;
        this._dDivergSlitSize = dDivergSlitSize;
        this._dSoller1Size = dSoler1Size;
        this._dSoller2Size = dSoler2Size;
        this._dSampleLength = dSampleLength;
    }

    public double getDivergenceSlitSize() {
        return this._dDivergSlitSize;
    }

    public double getSoller1Size() {
        return this._dSoller1Size;
    }

    public double getSoller2Size() {
        return this._dSoller2Size;
    }

    public double getGonioRadius() {
        return this._dGonioRadius;
    }

    public double getSampleLength() {
        return this._dSampleLength;
    }

    public void correctForLostIntensity(UserDiffractogram ud) {
        this.correctIntensity(ud, false);
    }

    public void reduceIntensity(UserDiffractogram ud) {
        this.correctIntensity(ud, true);
    }

    public void matches(Diffractometer anotherDiffr, StringBuffer sbResult) {
        if (this._dGonioRadius != anotherDiffr._dGonioRadius) {
            sbResult.append("goniometer radius does not match").append('\n');
        }
        if (this._dDivergSlitSize != anotherDiffr._dDivergSlitSize) {
            sbResult.append("divergence slit size does not match").append('\n');
        }
        if (this._dSoller1Size != anotherDiffr._dSoller1Size) {
            sbResult.append("Soller1 size does not match").append('\n');
        }
        if (this._dSoller2Size != anotherDiffr._dSoller2Size) {
            sbResult.append("Soller2 size does not match").append('\n');
        }
        if (this._dSampleLength != anotherDiffr._dSampleLength) {
            sbResult.append("sample length does not match").append('\n');
        }
    }

    public Element serializeXML() {
        Element params = new Element("diffractometer");
        params.setAttribute("gonio_radius", String.valueOf(this._dGonioRadius));
        params.setAttribute("diverg_slit", String.valueOf(this._dDivergSlitSize));
        params.setAttribute("Soller1", String.valueOf(this._dSoller1Size));
        params.setAttribute("Soller2", String.valueOf(this._dSoller2Size));
        params.setAttribute("sample_length", String.valueOf(this._dSampleLength));
        return params;
    }

    public static Diffractometer deserializeXML(Element owner) throws DataConversionException {
        Element params = owner.getChild("diffractometer");
        if (params == null) {
            throw new IllegalArgumentException("Missing diffractometer params");
        }
        Attribute gonio_rad = params.getAttribute("gonio_radius");
        Attribute diverg_slit = params.getAttribute("diverg_slit");
        Attribute sample_length = params.getAttribute("sample_length");
        Attribute soller1 = params.getAttribute("Soller1");
        Attribute soller2 = params.getAttribute("Soller2");
        return new Diffractometer(gonio_rad.getDoubleValue(), diverg_slit.getDoubleValue(), soller1.getDoubleValue(), soller2.getDoubleValue(), sample_length.getDoubleValue());
    }

    private void correctIntensity(UserDiffractogram ud, boolean bReduce) {
        double min2theta = ud.getMin2theta();
        double stepSize = ud.getStepSize();
        int noOfSteps = ud.getNoOfSteps();
        double[] intensity = ud.getIntensities();
        double maxIntensity = ud.getMaxIntensity();
        int i = 0;
        while (i < noOfSteps) {
            double theta = (min2theta + (double)i * stepSize) / 2.0;
            double lb = this._dGonioRadius * Math.tan(this._dDivergSlitSize * Math.PI / 180.0) / Math.sin(theta * Math.PI / 180.0);
            if (!(lb > this._dSampleLength)) break;
            if (bReduce) {
                int n = i;
                intensity[n] = intensity[n] * (this._dSampleLength / lb);
            } else {
                int n = i;
                intensity[n] = intensity[n] * (lb / this._dSampleLength);
            }
            if (!bReduce && maxIntensity < intensity[i]) {
                maxIntensity = intensity[i];
            }
            ++i;
        }
        if (bReduce) {
            maxIntensity = 0.0;
            i = 0;
            while (i < noOfSteps) {
                if (maxIntensity < intensity[i]) {
                    maxIntensity = intensity[i];
                }
                ++i;
            }
        }
        ud.setMaxIntensity(maxIntensity);
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Cannot clone Diffractometer class");
        }
        return o;
    }
}

