/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import net.ndmystko.analysis.tools.PolynomialTool;
import net.ndmystko.analysis.tools.Spline;
import net.ndmystko.xrd.AbstractXRDData;
import net.ndmystko.xrd.XRDException;
import net.ndmystko.xrd.XRDPoint;

public class Background
extends AbstractXRDData
implements Serializable {
    private static final long serialVersionUID = 4006262218064144646L;

    public Background(String file) throws IOException {
        super(file);
    }

    public Background(double min2theta, double max2theta, double stepSize) {
        super(min2theta, max2theta, stepSize);
    }

    public Background(AbstractXRDData pattern) {
        super(pattern);
    }

    public void setBackground(double value) {
        Arrays.fill(this.intensity, value);
        this.maxIntensity = value;
    }

    public void calculateSpline(XRDPoint[] aPoint) throws Exception {
        if (aPoint.length == 1) {
            this.setBackground(aPoint[0].getIntensity());
            return;
        }
        double[] adX = new double[aPoint.length];
        double[] adY = new double[aPoint.length];
        int i = 0;
        while (i < aPoint.length) {
            adX[i] = aPoint[i].getTwoTheta();
            adY[i] = aPoint[i].getIntensity();
            ++i;
        }
        Spline splineX = new Spline(adX);
        Spline splineY = new Spline(adY);
        LinkedList<XRDPoint> llPoints = new LinkedList<XRDPoint>();
        double dX = splineX.fn(0, 0.0);
        double dY = splineY.fn(0, 0.0);
        llPoints.add(new XRDPoint(dX, dY));
        int i2 = 0;
        while (i2 < aPoint.length - 1) {
            int iSteps = (int)Math.round((adX[i2 + 1] - adX[i2]) / this.stepSize);
            int t = 1;
            while (t <= iSteps) {
                dX = splineX.fn(i2, (double)t / (double)iSteps);
                dY = splineY.fn(i2, (double)t / (double)iSteps);
                llPoints.add(new XRDPoint(dX, dY));
                ++t;
            }
            ++i2;
        }
        int iSteps = (int)Math.round((adX[1] - adX[0]) / this.stepSize);
        int iStepsBackwards = 1;
        do {
            dX = splineX.fn(0, (double)(-iStepsBackwards) / (double)iSteps);
            dY = splineY.fn(0, (double)(-iStepsBackwards) / (double)iSteps);
            llPoints.addFirst(new XRDPoint(dX, dY));
            if (!(dX > ((XRDPoint)llPoints.getFirst()).getTwoTheta()) && ++iStepsBackwards <= 3000) continue;
            throw new XRDException("Illegal points");
        } while (dX > this.min2theta);
        iSteps = (int)Math.round((adX[adX.length - 1] - adX[adX.length - 2]) / this.stepSize);
        int iStepsForward = 1;
        do {
            dX = splineX.fn(aPoint.length - 2, 1.0 + (double)iStepsForward / (double)iSteps);
            dY = splineY.fn(aPoint.length - 2, 1.0 + (double)iStepsForward / (double)iSteps);
            llPoints.add(new XRDPoint(dX, dY));
            if (!(dX < ((XRDPoint)llPoints.getLast()).getTwoTheta()) && ++iStepsForward <= 3000) continue;
            throw new XRDException("Illegal points");
        } while (dX < this.max2theta);
        double[] adTwoTheta = new double[llPoints.size()];
        double[] adIntensity = new double[llPoints.size()];
        int iIndex = 0;
        ListIterator iterator = llPoints.listIterator();
        while (iterator.hasNext()) {
            XRDPoint point = (XRDPoint)iterator.next();
            adTwoTheta[iIndex] = point.getTwoTheta();
            adIntensity[iIndex] = point.getIntensity();
            ++iIndex;
        }
        PolynomialTool poly = new PolynomialTool(adTwoTheta, adIntensity, 5, 3);
        this.maxIntensity = 0.0;
        int i3 = 0;
        while (i3 < this.intensity.length) {
            this.intensity[i3] = poly.getValueAt(this.min2theta + (double)i3 * this.stepSize);
            if (this.maxIntensity < this.intensity[i3]) {
                this.maxIntensity = this.intensity[i3];
            }
            ++i3;
        }
    }
}

