/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.io.Serializable;
import net.ndmystko.xrd.AbstractXRDData;
import net.ndmystko.xrd.Atom;

public class AtomicScatteringFactor
extends AbstractXRDData
implements Serializable {
    private static final long serialVersionUID = 7681905999761840156L;
    public static final int O_0 = 0;
    public static final int O_2 = 1;
    public static final int H_2 = 2;
    public static final int S_2 = 3;
    public static final int Si_1_5 = 4;
    public static final int Al_1_5 = 5;
    public static final int Fe_1_5 = 6;
    public static final int K_1_5 = 7;
    public static final int Na_1_5 = 8;
    public static final int Ca_1_5 = 9;
    public static final int Mg_1_5 = 10;
    public static final int C_0 = 11;
    public static final int OH_2 = 12;
    public static final int H2O_2 = 13;
    public static final int H2O_11 = 14;
    public static final int Gly_11 = 15;
    public static final int NH_1_5 = 16;
    public static final int CO3_2 = 17;
    public static final int Glycerine_29 = 18;
    public static final int Glycerine_42 = 19;
    public static final int H2O_35 = 20;
    public static final int H2O_48 = 21;
    public static final int Mg_24 = 22;
    public static final int CS_1_5 = 23;
    public static final int CU_ = 24;
    public static final int TRIEN_ = 25;
    public static final int NO_OF_ELEMENTS = 26;
    private static final String[] ELEMENT_NAME = new String[]{"O neutral", "O", "H", "S", "Si", "Al", "Fe", "K", "Na", "Ca", "Mg", "C", "OH", "H2O", "H2O B=11", "Gly", "NH4", "CO3", "Glycerine B=29", "Glycerine B=42", "H2O B=35", "H2O B=48", "Mg B=24", "Cs", "Cu", "Trien"};
    private static final double[] TEMP_FACTOR = new double[]{0.0, 2.0, 2.0, 2.0, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 0.0, 2.0, 2.0, 11.0, 11.0, 1.5, 2.0, 29.0, 42.0, 35.0, 48.0, 24.0, 1.5, 20.0, 30.0};
    private static final double[] ATOMIC_WEIGHT = new double[]{16.0, 16.0, 1.0, 32.066, 28.0, 27.0, 55.84, 39.0, 23.0, 40.08, 24.3, 12.0, 17.0, 18.0, 18.0, 31.0, 18.042, 60.0, 92.0, 9382.0, 92.0, 9382.0, 18.0, 18.0, 24.305, 132.90545, 63.546, 380.0};

    public AtomicScatteringFactor(double min2theta, double max2theta, double stepSize) {
        super(min2theta, max2theta, stepSize);
        assert (ELEMENT_NAME.length == 26);
        assert (TEMP_FACTOR.length == 26);
    }

    public static synchronized AtomicScatteringFactor[] getAllFactors(double min2theta, double max2theta, double stepSize, double lambda) {
        AtomicScatteringFactor[] aFactors = new AtomicScatteringFactor[26];
        int i = 0;
        while (i < 26) {
            aFactors[i] = new AtomicScatteringFactor(min2theta, max2theta, stepSize);
            aFactors[i].calculateScatteringFactor(i, lambda);
            ++i;
        }
        return aFactors;
    }

    public void calculateScatteringFactor(int atomIndex, double lambda) {
        int i = 0;
        while (i < this.intensity.length) {
            double dTheta = this.min2theta / 2.0 + (double)i * (this.stepSize / 2.0);
            double zTek = 2.0 * Math.sin(dTheta * Math.PI / 180.0) / lambda;
            switch (atomIndex) {
                case 0: {
                    this.intensity[i] = Atom.O.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 1: {
                    this.intensity[i] = Atom.O_1.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 2: {
                    this.intensity[i] = Atom.H.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 3: {
                    this.intensity[i] = Atom.S.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 4: {
                    this.intensity[i] = Atom.SI_2.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 5: {
                    this.intensity[i] = Atom.AL_1_5.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 6: {
                    this.intensity[i] = Atom.FE_2.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 7: {
                    this.intensity[i] = Atom.K_1.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 8: {
                    this.intensity[i] = Atom.NA_1.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 9: {
                    this.intensity[i] = Atom.CA_2.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 10: {
                    this.intensity[i] = Atom.MG_2.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 11: {
                    this.intensity[i] = Atom.C.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 12: {
                    this.intensity[i] = (Atom.O_1.getScatteringPower(zTek) + Atom.H.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 13: {
                    this.intensity[i] = (Atom.O.getScatteringPower(zTek) + 2.0 * Atom.H.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 14: {
                    this.intensity[i] = (Atom.O.getScatteringPower(zTek) + 2.0 * Atom.H.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 15: {
                    this.intensity[i] = (Atom.C.getScatteringPower(zTek) + 3.0 * Atom.H.getScatteringPower(zTek) + Atom.O.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 16: {
                    this.intensity[i] = Atom.NH_4.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 17: {
                    this.intensity[i] = (Atom.C.getScatteringPower(zTek) + 3.0 * Atom.O_1.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 18: {
                    this.intensity[i] = (3.0 * Atom.C.getScatteringPower(zTek) + 8.0 * Atom.H.getScatteringPower(zTek) + 3.0 * Atom.O.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 19: {
                    this.intensity[i] = (3.0 * Atom.C.getScatteringPower(zTek) + 8.0 * Atom.H.getScatteringPower(zTek) + 3.0 * Atom.O.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 20: {
                    this.intensity[i] = (Atom.O.getScatteringPower(zTek) + 2.0 * Atom.H.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 21: {
                    this.intensity[i] = (Atom.O.getScatteringPower(zTek) + 2.0 * Atom.H.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 22: {
                    this.intensity[i] = Atom.MG_2.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 23: {
                    this.intensity[i] = Atom.CS_1.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 24: {
                    this.intensity[i] = Atom.CU_.getScatteringPower(zTek) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                case 25: {
                    this.intensity[i] = (10.0 * Atom.C.getScatteringPower(zTek) + 22.0 * Atom.H.getScatteringPower(zTek)) * this.dw(TEMP_FACTOR[atomIndex], dTheta, lambda);
                    break;
                }
                default: {
                    assert (false) : "case: " + atomIndex;
                    break;
                }
            }
            ++i;
        }
    }

    public static String getName(int iIndex) {
        return ELEMENT_NAME[iIndex];
    }

    public static int getIndex(String sName) {
        int iIndex = -1;
        int i = 0;
        while (i < ELEMENT_NAME.length) {
            if (ELEMENT_NAME[i].equals(sName)) {
                iIndex = i;
                break;
            }
            ++i;
        }
        return iIndex;
    }

    public static double getTempFactor(int iIndex) {
        return TEMP_FACTOR[iIndex];
    }

    public static double getAtomicWeight(int iIndex) {
        return ATOMIC_WEIGHT[iIndex];
    }

    private double dw(double b, double dTheta, double lambda) {
        double sinTheta = Math.sin(dTheta * Math.PI / 180.0);
        return Math.exp(-b * sinTheta * sinTheta / lambda / lambda);
    }
}

