/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;

public class Atom {
    private static final double[] H_FACTORS = new double[]{0.0019, -0.0321, 0.6853, -0.0402, 0.3855};
    public static Atom H = new Atom(H_FACTORS);
    private static final double[] C_FACTORS = new double[]{0.9155, 3.5601, -7.4819, 12.314, -3.3153};
    public static Atom C = new Atom(C_FACTORS);
    private static final double[] O_FACTORS = new double[]{1.3641, -0.6136, 13.0097, -7.9226, 2.1625};
    public static Atom O = new Atom(O_FACTORS);
    private static final double[] S_FACTORS = new double[]{0.0411, 42.5904, -95.7124, 105.0704, -36.0084};
    public static Atom S = new Atom(S_FACTORS);
    private static final double[] O_1_FACTORS = new double[]{1.4415, -1.3709, 15.7756, -13.7247, 6.8675};
    public static Atom O_1 = new Atom(O_1_FACTORS);
    private static final double[] Na_1_FACTORS = new double[]{0.3425, 11.2534, 5.7734, -12.9302, 5.5675};
    public static Atom NA_1 = new Atom(Na_1_FACTORS);
    private static final double[] Al_1_5_FACTORS = new double[]{-0.5238, 27.5813, -32.9244, 18.9622, -1.5941};
    public static Atom AL_1_5 = new Atom(Al_1_5_FACTORS);
    private static final double[] Si_2_FACTORS = new double[]{-0.3639, 31.7591, -46.1761, 33.3949, -6.6261};
    public static Atom SI_2 = new Atom(Si_2_FACTORS);
    private static final double[] K_1_FACTORS = new double[]{4.0544, 15.0697, -21.1472, 36.3321, -16.3314};
    public static Atom K_1 = new Atom(K_1_FACTORS);
    private static final double[] FE_2_FACTORS = new double[]{4.1364, 18.3396, 21.3104, -34.9806, 14.2093};
    public static Atom FE_2 = new Atom(FE_2_FACTORS);
    private static final double[] NH_4_FACTORS = new double[]{1.1459, 1.196, 5.6484, -10.708, 12.6924};
    public static Atom NH_4 = new Atom(NH_4_FACTORS);
    private static final double[] Ca_2_FACTORS = new double[]{4.8314, 8.4222, 4.3226, 5.4041, -4.9955};
    public static Atom CA_2 = new Atom(Ca_2_FACTORS);
    private static final double[] Mg_2_FACTORS = new double[]{0.1323, 16.5772, -4.2, -6.6534, 4.1498};
    public static Atom MG_2 = new Atom(Mg_2_FACTORS);
    private static final double[] CS_1_FACTORS = new double[]{8.26967, 95.16026, -130.839, 110.4224, -28.9999};
    public static Atom CS_1 = new Atom(CS_1_FACTORS);
    private static final double[] CU_FACTORS = new double[]{3.0954, 34.3556, -3.8047, -14.2827, 7.6488};
    public static Atom CU_ = new Atom(CU_FACTORS);
    private double[] factor;
    public static String[] atomsNames = new String[]{"H", "C", "O", "S", "O_1", "NA_1", "AL_1_5", "SI_2", "K_1", "FE_2", "NH_4", "CA_2", "MG_2", "CU"};
    public static Atom[] atomsFactors = new Atom[]{H, C, O, S, O_1, NA_1, AL_1_5, SI_2, K_1, FE_2, NH_4, CA_2, MG_2, CU_};

    public Atom(double[] factor) {
        this.factor = factor;
    }

    public double getScatteringPower(double mi) {
        return this.factor[0] + this.factor[1] / (1.0 + 2.0 * mi * mi) + this.factor[2] * Math.pow(1.0 / (1.0 + 2.0 * mi * mi), 2.0) + this.factor[3] * Math.pow(1.0 / (1.0 + 2.0 * mi * mi), 3.0) + this.factor[4] * Math.pow(1.0 / (1.0 + 2.0 * mi * mi), 4.0);
    }

    public static Element serializeXML() {
        Element atoms = new Element("atoms");
        int i = 0;
        while (i < atomsFactors.length) {
            Element atom = new Element("atom");
            atom.setAttribute("name", String.valueOf(atomsNames[i]));
            atom.setAttribute("f_1", String.valueOf(Atom.atomsFactors[i].factor[0]));
            atom.setAttribute("f_2", String.valueOf(Atom.atomsFactors[i].factor[1]));
            atom.setAttribute("f_3", String.valueOf(Atom.atomsFactors[i].factor[2]));
            atom.setAttribute("f_4", String.valueOf(Atom.atomsFactors[i].factor[3]));
            atom.setAttribute("f_5", String.valueOf(Atom.atomsFactors[i].factor[4]));
            atoms.addContent(atom);
            ++i;
        }
        return atoms;
    }

    public static void deserializeXML(Element structuralFactors) {
        Element atoms = structuralFactors.getChild("atoms");
        List lAtoms = atoms.getChildren("atom");
        ArrayList listLayers = new ArrayList();
        int iCurrentAtom = 0;
        for (Element atom : lAtoms) {
            Attribute aName = atom.getAttribute("name");
            Attribute aF1 = atom.getAttribute("f_1");
            Attribute aF2 = atom.getAttribute("f_2");
            Attribute aF3 = atom.getAttribute("f_3");
            Attribute aF4 = atom.getAttribute("f_4");
            Attribute aF5 = atom.getAttribute("f_5");
            double f1 = Double.parseDouble(aF1.getValue());
            double f2 = Double.parseDouble(aF2.getValue());
            double f3 = Double.parseDouble(aF3.getValue());
            double f4 = Double.parseDouble(aF4.getValue());
            double f5 = Double.parseDouble(aF5.getValue());
            double[] factor = new double[]{f1, f2, f3, f4, f5};
            if (iCurrentAtom == 0) {
                H = new Atom(factor);
            } else if (iCurrentAtom == 1) {
                C = new Atom(factor);
            } else if (iCurrentAtom == 2) {
                O = new Atom(factor);
            } else if (iCurrentAtom == 3) {
                S = new Atom(factor);
            } else if (iCurrentAtom == 4) {
                O_1 = new Atom(factor);
            } else if (iCurrentAtom == 5) {
                NA_1 = new Atom(factor);
            } else if (iCurrentAtom == 6) {
                AL_1_5 = new Atom(factor);
            } else if (iCurrentAtom == 7) {
                SI_2 = new Atom(factor);
            } else if (iCurrentAtom == 8) {
                K_1 = new Atom(factor);
            } else if (iCurrentAtom == 9) {
                FE_2 = new Atom(factor);
            } else if (iCurrentAtom == 10) {
                NH_4 = new Atom(factor);
            } else if (iCurrentAtom == 11) {
                CA_2 = new Atom(factor);
            } else if (iCurrentAtom == 12) {
                MG_2 = new Atom(factor);
            } else if (iCurrentAtom == 13) {
                CU_ = new Atom(factor);
            }
            if (iCurrentAtom == 0) {
                Atom.atomsFactors[0] = new Atom(factor);
            } else if (iCurrentAtom == 1) {
                Atom.atomsFactors[1] = new Atom(factor);
            } else if (iCurrentAtom == 2) {
                Atom.atomsFactors[2] = new Atom(factor);
            } else if (iCurrentAtom == 3) {
                Atom.atomsFactors[3] = new Atom(factor);
            } else if (iCurrentAtom == 4) {
                Atom.atomsFactors[4] = new Atom(factor);
            } else if (iCurrentAtom == 5) {
                Atom.atomsFactors[5] = new Atom(factor);
            } else if (iCurrentAtom == 6) {
                Atom.atomsFactors[6] = new Atom(factor);
            } else if (iCurrentAtom == 7) {
                Atom.atomsFactors[7] = new Atom(factor);
            } else if (iCurrentAtom == 8) {
                Atom.atomsFactors[8] = new Atom(factor);
            } else if (iCurrentAtom == 9) {
                Atom.atomsFactors[9] = new Atom(factor);
            } else if (iCurrentAtom == 10) {
                Atom.atomsFactors[10] = new Atom(factor);
            } else if (iCurrentAtom == 11) {
                Atom.atomsFactors[11] = new Atom(factor);
            } else if (iCurrentAtom == 12) {
                Atom.atomsFactors[12] = new Atom(factor);
            } else if (iCurrentAtom == 13) {
                Atom.atomsFactors[13] = new Atom(factor);
            }
            ++iCurrentAtom;
        }
    }

    public String toString() {
        String out = "";
        out = String.valueOf(out) + this.factor[0] + " " + this.factor[1];
        return out;
    }
}

