/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.xrd;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.ndmystko.xrd.PolynomialTool;
import net.ndmystko.xrd.Radiation;
import net.ndmystko.xrd.XRDException;

public abstract class AbstractXRDData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6400129581652007813L;
    protected double min2theta;
    protected double max2theta;
    protected double stepSize;
    protected int interpolationOrder = 1;
    protected int noOfSteps;
    protected double[] intensity;
    protected double[] twoTheta;
    protected double maxIntensity;
    protected Color color;
    protected double offset;
    protected double scale;
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
    private PrintWriter printWriter;
    private PolynomialTool polynomialTool;
    protected String sampleName;
    protected String filename;
    protected String fileExtension;
    protected Radiation lamp;
    private static final double MAX_DOUBLE_ERROR = 1.0E-6;

    protected AbstractXRDData(double min2theta, double max2theta, double stepSize) {
        this.min2theta = min2theta;
        this.max2theta = max2theta;
        this.stepSize = stepSize;
        this.noOfSteps = (int)Math.round((max2theta - min2theta) / stepSize) + 1;
        this.intensity = new double[this.noOfSteps];
        this.color = Color.black;
        this.scale = 1.0;
        this.offset = 0.0;
    }

    protected AbstractXRDData(AbstractXRDData pattern) {
        this(pattern.getMin2theta(), pattern.getMax2theta(), pattern.getStepSize());
    }

    protected AbstractXRDData(String file) throws IOException {
        this.color = Color.black;
        this.scale = 1.0;
        this.offset = 0.0;
        this.load(file);
    }

    public double getMin2theta() {
        return this.min2theta;
    }

    public double getMax2theta() {
        return this.max2theta;
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public double getIntensity(int i) {
        return this.intensity[i];
    }

    public double getIntensity(double twoTheta) {
        return this.intensity[this.index(twoTheta)];
    }

    public void setIntensity(int i, double newValue) {
        this.intensity[i] = newValue;
    }

    public void setIntensity(double twoTheta, double newValue) {
        this.intensity[this.index((double)twoTheta)] = newValue;
    }

    public double getMaxIntensity() {
        return this.maxIntensity;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public int getNoOfSteps() {
        return this.noOfSteps;
    }

    public void copyIntensities(AbstractXRDData source) throws IllegalArgumentException {
        if (Math.abs(this.min2theta - source.min2theta) > 1.0E-6 || Math.abs(this.max2theta - source.max2theta) > 1.0E-6) {
            throw new IllegalArgumentException("Range does't match: [" + this.min2theta + "-" + this.max2theta + "] vs. [" + source.min2theta + "-" + source.max2theta + "]");
        }
        if (Math.abs(this.stepSize - source.stepSize) > 1.0E-6) {
            throw new IllegalArgumentException("Step size does't match: " + this.stepSize + " vs. " + source.stepSize);
        }
        System.arraycopy(source.intensity, 0, this.intensity, 0, this.noOfSteps);
        this.maxIntensity = source.maxIntensity;
    }

    public void shiftToStepSize() {
        int lowNumSteps = (int)Math.round(this.min2theta / this.stepSize);
        this.min2theta = (double)lowNumSteps * this.stepSize;
        this.max2theta = this.min2theta + this.stepSize * (double)(this.noOfSteps - 1);
    }

    public void adjustMin2theta(double twoTheta) {
        this.adjustMin2theta(twoTheta, false);
    }

    public void adjustMin2theta(double twoTheta, boolean bFillValues) {
        if (this.min2theta == twoTheta) {
            return;
        }
        if (twoTheta < this.max2theta && twoTheta > 0.0) {
            int i = this.index(twoTheta);
            double[] tempIntensities = new double[this.noOfSteps - i];
            if (i < 0) {
                double dValuesForGap = 0.0;
                if (bFillValues) {
                    dValuesForGap = this.intensity[0];
                }
                int counter = 0;
                while (counter < -i) {
                    tempIntensities[counter] = dValuesForGap;
                    ++counter;
                }
                System.arraycopy(this.intensity, 0, tempIntensities, -i, this.noOfSteps);
            } else {
                System.arraycopy(this.intensity, i, tempIntensities, 0, this.noOfSteps - i);
            }
            this.min2theta = twoTheta;
            this.noOfSteps -= i;
            this.intensity = tempIntensities;
            double maxIntens = 0.0;
            int j = 0;
            while (j < this.noOfSteps) {
                if (maxIntens < this.intensity[j]) {
                    maxIntens = this.intensity[j];
                }
                ++j;
            }
            this.maxIntensity = maxIntens;
        }
    }

    public void adjustMax2theta(double twoTheta) {
        this.adjustMax2theta(twoTheta, false);
    }

    public void adjustMax2theta(double twoTheta, boolean bFillValues) {
        if (this.max2theta == twoTheta) {
            return;
        }
        if (twoTheta > this.min2theta && twoTheta < 180.0) {
            int i = this.index(twoTheta);
            double[] tempIntensities = new double[i + 1];
            if (i + 1 - this.noOfSteps > 0) {
                System.arraycopy(this.intensity, 0, tempIntensities, 0, this.noOfSteps);
                double dValuesForGap = 0.0;
                if (bFillValues) {
                    dValuesForGap = this.intensity[this.noOfSteps - 1];
                }
                int counter = 0;
                while (counter < i - this.noOfSteps) {
                    tempIntensities[counter + this.noOfSteps] = dValuesForGap;
                    ++counter;
                }
            } else {
                System.arraycopy(this.intensity, 0, tempIntensities, 0, i + 1);
            }
            this.max2theta = twoTheta;
            this.noOfSteps = i + 1;
            this.intensity = tempIntensities;
            double maxIntens = 0.0;
            int j = 0;
            while (j < this.noOfSteps) {
                if (maxIntens < this.intensity[j]) {
                    maxIntens = this.intensity[j];
                }
                ++j;
            }
            this.maxIntensity = maxIntens;
        }
    }

    public void adjustStepSize(double stepSize) throws XRDException {
        int j;
        int noOfSteps = (int)Math.round((this.max2theta - this.min2theta) / stepSize) + 1;
        if (Math.abs(this.min2theta + (double)(noOfSteps - 1) * stepSize - this.max2theta) > 1.0E-4) {
            throw new XRDException("Step size " + this.stepSize + " cannot be converted to " + stepSize + " over the same 2theta range");
        }
        if (this.stepSize < stepSize) {
            double[] intensities = new double[noOfSteps];
            int jump = (int)Math.round(stepSize / this.stepSize);
            int i = 0;
            while (i < noOfSteps) {
                intensities[i] = this.intensity[i * jump];
                ++i;
            }
            this.intensity = null;
            this.intensity = intensities;
            intensities = null;
            this.stepSize = stepSize;
            this.noOfSteps = noOfSteps;
            double maxIntens = 0.0;
            j = 0;
            while (j < noOfSteps) {
                if (maxIntens < this.intensity[j]) {
                    maxIntens = this.intensity[j];
                }
                ++j;
            }
            this.maxIntensity = maxIntens;
        }
        if (this.stepSize > stepSize) {
            int jump = (int)Math.round(this.stepSize / stepSize);
            if ((this.noOfSteps - 2) * jump + jump - 1 > noOfSteps) {
                throw new XRDException("Step size " + this.stepSize + " cannot be converted to " + stepSize + " over the same 2theta range");
            }
            double[] intensities = new double[noOfSteps];
            int i = 0;
            while (i < this.noOfSteps - 2) {
                double delta = (this.intensity[i + 1] - this.intensity[i]) / (double)jump;
                int k = 0;
                while (k < jump) {
                    intensities[i * jump + k] = this.intensity[i] + (double)k * delta;
                    ++k;
                }
                ++i;
            }
            intensities[noOfSteps - 1] = this.intensity[this.noOfSteps - 1];
            this.intensity = null;
            this.intensity = intensities;
            intensities = null;
            this.stepSize = stepSize;
            this.noOfSteps = noOfSteps;
            double maxIntens = 0.0;
            j = 0;
            while (j < noOfSteps) {
                if (maxIntens < this.intensity[j]) {
                    maxIntens = this.intensity[j];
                }
                ++j;
            }
            this.maxIntensity = maxIntens;
        }
    }

    public void adjustByPolynomial(double dNewMin2theta, double dNewMax2theta, double dNewStepSize, int iNoOfPoints, int iPolynomialOrder) throws Exception {
        this.polynomialTool = new PolynomialTool(this, iNoOfPoints, iPolynomialOrder);
        int iNoOfSteps = (int)Math.round((dNewMax2theta - dNewMin2theta) / dNewStepSize) + 1;
        double[] adIntensity = new double[iNoOfSteps];
        double dMaxIntensity = 0.0;
        int i = 0;
        while (i < adIntensity.length) {
            double dTwoTheta = dNewMin2theta + (double)i * dNewStepSize;
            adIntensity[i] = this.polynomialTool.getIntensityAt(dTwoTheta);
            if (dMaxIntensity < adIntensity[i]) {
                dMaxIntensity = adIntensity[i];
            }
            ++i;
        }
        this.min2theta = dNewMin2theta;
        this.max2theta = dNewMax2theta;
        this.stepSize = dNewStepSize;
        this.noOfSteps = iNoOfSteps;
        this.intensity = adIntensity;
        this.maxIntensity = dMaxIntensity;
    }

    private void interpolateHeadAndTail(double[] adIntensity, int iNoOfPoints, int dNewStepSize) {
        adIntensity[0] = this.intensity[0];
        int headLength = iNoOfPoints / 2;
        double headStart2Theta = this.getMin2theta();
        double headEnd2Theta = this.getMin2theta() + (double)headLength * this.getStepSize();
        double dHead2Theta = headEnd2Theta - headStart2Theta;
        double headStartIntensity = adIntensity[0];
        double headEndIntensity = adIntensity[headLength - 1];
        double dHeadIntensity = headEndIntensity - headStartIntensity;
        double gradient = dHeadIntensity / dHead2Theta;
        int i = 1;
        while (i < headLength) {
            double dTwoTheta = this.getMin2theta() + (double)(i * dNewStepSize);
            double yIntercept = headStartIntensity - gradient * headStart2Theta;
            adIntensity[i] = gradient * dTwoTheta + yIntercept;
            ++i;
        }
        adIntensity[adIntensity.length - 1] = this.intensity[this.intensity.length - 1];
        int tailLength = iNoOfPoints / 2;
        double tailStart2Theta = this.getMax2theta() - (double)headLength * this.getStepSize();
        double tailEnd2Theta = this.getMax2theta();
        double dTail2Theta = tailEnd2Theta - tailStart2Theta;
        double tailStartIntensity = adIntensity[adIntensity.length - 1 - tailLength];
        double tailEndIntensity = adIntensity[adIntensity.length - 1];
        double dTailIntensity = tailEndIntensity - tailStartIntensity;
        gradient = dTailIntensity / dTail2Theta;
        int i2 = adIntensity.length - tailLength;
        while (i2 < adIntensity.length) {
            double dTwoTheta = this.getMin2theta() + (double)(i2 * dNewStepSize);
            double yIntercept = tailStartIntensity - gradient * tailStart2Theta;
            adIntensity[i2] = gradient * dTwoTheta + yIntercept;
            ++i2;
        }
    }

    public void convertLambda(Radiation fromLambda, Radiation toLambda, int iNoOfPoints, int iPolynomialOrder, boolean bUseKalpha1) throws Exception {
        PolynomialTool tool = new PolynomialTool(this, iNoOfPoints, iPolynomialOrder);
        double dNewMin2theta = bUseKalpha1 ? Radiation.twoTheta(Radiation.d(this.min2theta, fromLambda.getKalpha1()), toLambda.getKalpha1()) : toLambda.twoTheta(fromLambda.d(this.min2theta));
        int iMinStep = (int)Math.round(dNewMin2theta / this.stepSize);
        dNewMin2theta = (double)iMinStep * this.stepSize;
        double dNewMax2theta = bUseKalpha1 ? Radiation.twoTheta(Radiation.d(this.max2theta, fromLambda.getKalpha1()), toLambda.getKalpha1()) : toLambda.twoTheta(fromLambda.d(this.max2theta));
        int iMaxStep = (int)Math.round(dNewMax2theta / this.stepSize);
        dNewMax2theta = (double)iMaxStep * this.stepSize;
        int iNoOfSteps = (int)Math.round((dNewMax2theta - dNewMin2theta) / this.stepSize) + 1;
        double[] adIntensity = new double[iNoOfSteps];
        double dMaxIntensity = 0.0;
        int i = 0;
        while (i < adIntensity.length) {
            double dTwoTheta = dNewMin2theta + (double)i * this.stepSize;
            double dFormerTwoTheta = bUseKalpha1 ? Radiation.twoTheta(Radiation.d(dTwoTheta, toLambda.getKalpha1()), fromLambda.getKalpha1()) : fromLambda.twoTheta(toLambda.d(dTwoTheta));
            adIntensity[i] = tool.getIntensityAt(dFormerTwoTheta);
            if (dMaxIntensity < adIntensity[i]) {
                dMaxIntensity = adIntensity[i];
            }
            ++i;
        }
        this.min2theta = dNewMin2theta;
        this.max2theta = dNewMax2theta;
        this.noOfSteps = iNoOfSteps;
        this.intensity = adIntensity;
        this.maxIntensity = dMaxIntensity;
        this.lamp = toLambda;
    }

    public void shift(int steps) {
        if (steps > 0) {
            if (steps >= this.noOfSteps) {
                throw new IllegalArgumentException("Shift value larger than number of steps");
            }
            double[] intensitiesTemp = (double[])this.intensity.clone();
            System.arraycopy(this.intensity, 0, intensitiesTemp, steps, this.noOfSteps - steps);
            Arrays.fill(intensitiesTemp, 0, steps, this.intensity[0]);
            this.intensity = intensitiesTemp;
            intensitiesTemp = null;
            double maxIntens = 0.0;
            int j = 0;
            while (j < this.noOfSteps) {
                if (maxIntens < this.intensity[j]) {
                    maxIntens = this.intensity[j];
                }
                ++j;
            }
            this.maxIntensity = maxIntens;
        } else if (steps < 0) {
            if ((steps = -steps) >= this.noOfSteps) {
                throw new IllegalArgumentException("Shift value larger than number of steps");
            }
            double[] intensitiesTemp = (double[])this.intensity.clone();
            System.arraycopy(this.intensity, steps, intensitiesTemp, 0, this.noOfSteps - steps);
            Arrays.fill(intensitiesTemp, this.noOfSteps - steps, this.noOfSteps - 1, this.intensity[this.noOfSteps - 1]);
            this.intensity = intensitiesTemp;
            intensitiesTemp = null;
            double maxIntens = 0.0;
            int j = 0;
            while (j < this.noOfSteps) {
                if (maxIntens < this.intensity[j]) {
                    maxIntens = this.intensity[j];
                }
                ++j;
            }
            this.maxIntensity = maxIntens;
        }
    }

    public void addPattern(AbstractXRDData pattern) {
        if (pattern.min2theta != this.min2theta || pattern.max2theta != this.max2theta || pattern.stepSize != this.stepSize) {
            throw new IllegalArgumentException("Pattern params do not match");
        }
        int i = 0;
        while (i < this.noOfSteps) {
            int n = i;
            this.intensity[n] = this.intensity[n] + pattern.intensity[i];
            if (this.maxIntensity < this.intensity[i]) {
                this.maxIntensity = this.intensity[i];
            }
            ++i;
        }
    }

    public void subtractPattern(AbstractXRDData pattern) {
        if (pattern.min2theta != this.min2theta || pattern.max2theta != this.max2theta || pattern.stepSize != this.stepSize) {
            throw new IllegalArgumentException("Pattern params do not match");
        }
        this.maxIntensity = 0.0;
        int i = 0;
        while (i < this.noOfSteps) {
            int n = i;
            this.intensity[n] = this.intensity[n] - pattern.intensity[i];
            if (this.maxIntensity < this.intensity[i]) {
                this.maxIntensity = this.intensity[i];
            }
            ++i;
        }
    }

    public void matchIntensityOf(AbstractXRDData target) {
        double ratio = target.maxIntensity / this.maxIntensity;
        int i = 0;
        while (i < this.intensity.length) {
            int n = i++;
            this.intensity[n] = this.intensity[n] * ratio;
        }
        this.maxIntensity = target.maxIntensity;
    }

    public void matchIntensityOf(AbstractXRDData target, double atAngle) {
        this.maxIntensity = 0.0;
        int index = (int)Math.round((atAngle - this.min2theta) / this.stepSize);
        double ratio = target.intensity[index] / this.intensity[index];
        int i = 0;
        while (i < this.intensity.length) {
            int n = i++;
            this.intensity[n] = this.intensity[n] * ratio;
        }
        this.maxIntensity *= ratio;
    }

    public void matchIntensityOf(AbstractXRDData target, double fromAngle, double toAngle) {
        this.maxIntensity = 0.0;
        int fromIndex = this.index(fromAngle);
        int toIndex = this.index(toAngle);
        double thisMax = this.intensity[fromIndex];
        double targetMax = target.intensity[fromIndex];
        int i = fromIndex + 1;
        while (i < toIndex) {
            thisMax = Math.max(thisMax, this.intensity[i]);
            targetMax = Math.max(targetMax, target.intensity[i]);
            ++i;
        }
        double ratio = targetMax / thisMax;
        int i2 = 0;
        while (i2 < this.intensity.length) {
            int n = i2++;
            this.intensity[n] = this.intensity[n] * ratio;
        }
        this.maxIntensity *= ratio;
    }

    public void normalizeTo(double dTargetNumber, double dAtAngle) {
        this.maxIntensity = 0.0;
        int index = (int)Math.round((dAtAngle - this.min2theta) / this.stepSize);
        double ratio = dTargetNumber / this.intensity[index];
        int i = 0;
        while (i < this.intensity.length) {
            int n = i;
            this.intensity[n] = this.intensity[n] * ratio;
            if (this.maxIntensity < this.intensity[i]) {
                this.maxIntensity = this.intensity[i];
            }
            ++i;
        }
    }

    public double getAngleOfMinIntensity() {
        double dLowest = this.maxIntensity;
        int iIndexOfLowest = 0;
        int i = 0;
        while (i < this.intensity.length) {
            if (dLowest > this.intensity[i]) {
                dLowest = this.intensity[i];
                iIndexOfLowest = i;
            }
            ++i;
        }
        return 2.0 * this.theta(iIndexOfLowest);
    }

    public int index(double twoTheta) {
        return (int)Math.round((twoTheta - this.min2theta) / this.stepSize);
    }

    public void setFilename(String fileName) {
        this.filename = fileName;
        this.setFileExtension(fileName);
    }

    public void setFileExtension(String fileName) {
        if (fileName.toLowerCase().endsWith(".csv")) {
            this.fileExtension = ".csv";
        } else if (fileName.toLowerCase().endsWith(".ex")) {
            this.fileExtension = ".ex";
        } else if (fileName.toLowerCase().endsWith(".ex$")) {
            this.fileExtension = ".ex$";
        } else if (fileName.toLowerCase().endsWith(".jt")) {
            this.fileExtension = ".jt";
        } else if (fileName.toLowerCase().endsWith(".nmd")) {
            this.fileExtension = ".nmd";
        } else if (fileName.toLowerCase().endsWith(".txt")) {
            this.fileExtension = ".txt";
        } else if (fileName.toLowerCase().endsWith(".udf")) {
            this.fileExtension = ".udf";
        } else if (fileName.toLowerCase().endsWith(".uxd")) {
            this.fileExtension = ".uxd";
        } else if (fileName.toLowerCase().endsWith(".vba")) {
            this.fileExtension = ".vba";
        }
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFilename() {
        return this.filename;
    }

    public void load(String fullFileName) throws IOException {
        BufferedReader bf = new BufferedReader(new InputStreamReader(new FileInputStream(fullFileName)));
        File f = new File(fullFileName);
        this.load(bf, f.getName());
    }

    /*
     * Unable to fully structure code
     */
    public void load(BufferedReader bf, String fileName) throws IOException {
        block110: {
            block115: {
                block114: {
                    block113: {
                        block112: {
                            block111: {
                                sampleName = "unknown";
                                noOfSteps = 0;
                                lamp = Radiation.Cu;
                                min2theta = 0.0;
                                max2theta = 0.0;
                                stepSize = 0.0;
                                maxIntensity = 0.0;
                                iMaxSteps = 150000;
                                iChunkSize = 10000;
                                adIntensity = new double[iMaxSteps / iChunkSize][];
                                adIntensity[0] = new double[iChunkSize];
                                st = new StreamTokenizer(bf);
                                this.setFilename(fileName);
                                if (!fileName.toLowerCase().endsWith(".ex$")) break block111;
                                try {
                                    sampleName = bf.readLine().trim();
                                    singleLine = bf.readLine().trim().toUpperCase();
                                    if (singleLine.startsWith("CU")) {
                                        lamp = Radiation.Cu;
                                    } else if (singleLine.startsWith("CO")) {
                                        lamp = Radiation.Co;
                                    } else if (singleLine.startsWith("FE")) {
                                        lamp = Radiation.Fe;
                                    }
                                    st.eolIsSignificant(true);
                                    st.nextToken();
                                    if (st.ttype != -2) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    min2theta = this.roundOut(st.nval, 3);
                                    do {
                                        st.nextToken();
                                    } while (st.ttype != 10);
                                    st.nextToken();
                                    if (st.ttype != -2) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    stepSize = this.roundOut(st.nval, 3);
                                    do {
                                        st.nextToken();
                                    } while (st.ttype != 10);
                                    st.nextToken();
                                    do {
                                        st.nextToken();
                                    } while (st.ttype != 10);
                                    st.eolIsSignificant(false);
                                    block32: while (noOfSteps < iMaxSteps) {
                                        switch (st.nextToken()) {
                                            case -2: {
                                                adIntensity[noOfSteps / iChunkSize][noOfSteps % iChunkSize] = dIntensity = st.nval;
                                                if (maxIntensity < dIntensity) {
                                                    maxIntensity = dIntensity;
                                                }
                                                if (++noOfSteps % iChunkSize != 0 || noOfSteps >= iMaxSteps) ** GOTO lbl65
                                                adIntensity[noOfSteps / iChunkSize] = new double[iChunkSize];
                                                ** GOTO lbl65
                                            }
                                            case -3: {
                                                throw new IOException("Wrong format of the " + fileName + " file");
                                            }
                                            case -1: {
                                                break;
                                            }
lbl65:
                                            // 3 sources

                                            default: {
                                                continue block32;
                                            }
                                        }
                                    }
                                }
                                finally {
                                    bf.close();
                                }
                            }
                            if (!fileName.toLowerCase().endsWith(".ex")) break block112;
                            try {
                                sampleName = bf.readLine().trim();
                                singleLine = bf.readLine().trim().toUpperCase();
                                if (singleLine.startsWith("CU")) {
                                    lamp = Radiation.Cu;
                                } else if (singleLine.startsWith("CO")) {
                                    lamp = Radiation.Co;
                                } else if (singleLine.startsWith("FE")) {
                                    lamp = Radiation.Fe;
                                }
                                bf.readLine();
                                st.eolIsSignificant(true);
                                st.nextToken();
                                if (st.ttype != -2) {
                                    throw new IOException("Wrong format of the " + fileName + " file");
                                }
                                min2theta = this.roundOut(st.nval, 3);
                                st.nextToken();
                                if (st.ttype != -2) {
                                    throw new IOException("Wrong format of the " + fileName + " file");
                                }
                                adIntensity[0][noOfSteps] = st.nval;
                                maxIntensity = adIntensity[0][noOfSteps++];
                                st.nextToken();
                                if (st.ttype != 10) {
                                    throw new IOException("Wrong format of the " + fileName + " file");
                                }
                                st.nextToken();
                                if (st.ttype != -2) {
                                    throw new IOException("Wrong format of the " + fileName + " file");
                                }
                                stepSize = this.roundOut(st.nval - min2theta, 3);
                                st.nextToken();
                                if (st.ttype != -2) {
                                    throw new IOException("Wrong format of the " + fileName + " file");
                                }
                                adIntensity[0][noOfSteps] = st.nval;
                                if (maxIntensity < adIntensity[0][noOfSteps]) {
                                    maxIntensity = adIntensity[0][noOfSteps];
                                }
                                ++noOfSteps;
                                st.nextToken();
                                if (st.ttype == 10) ** GOTO lbl143
                                throw new IOException("Wrong format of the " + fileName + " file");
lbl-1000:
                                // 1 sources

                                {
                                    st.nextToken();
                                    if (st.ttype == -1) {
                                    }
                                    if (st.ttype != -2) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    if (st.nval - min2theta - (double)noOfSteps * stepSize > 0.001) {
                                        throw new IOException("Current XRD library does not support non-continous data in EX files.");
                                    }
                                    st.nextToken();
                                    if (st.ttype != -2) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    adIntensity[noOfSteps / iChunkSize][noOfSteps % iChunkSize] = dIntensity = st.nval;
                                    if (maxIntensity < dIntensity) {
                                        maxIntensity = dIntensity;
                                    }
                                    if (++noOfSteps % iChunkSize == 0 && noOfSteps < iMaxSteps) {
                                        adIntensity[noOfSteps / iChunkSize] = new double[iChunkSize];
                                    }
                                    st.nextToken();
                                    if (st.ttype == -1) {
                                    }
                                    if (st.ttype == 10) continue;
                                    throw new IOException("Wrong format of the " + fileName + " file");
lbl143:
                                    // 2 sources

                                    ** while (noOfSteps < iMaxSteps)
                                }
lbl144:
                                // 1 sources

                            }
                            finally {
                                bf.close();
                            }
                        }
                        if (fileName.toLowerCase().endsWith(".uxd") || fileName.toLowerCase().endsWith(".txt") || fileName.toLowerCase().endsWith(".jt")) {
                            sampleName = fileName;
                            try {
                                try {
                                    singleLine = bf.readLine();
                                    if (fileName.toLowerCase().endsWith(".jt") || fileName.toLowerCase().endsWith("txt")) {
                                        singleLine = bf.readLine();
                                    }
                                    if (!(tokenizer = new StringTokenizer(singleLine)).hasMoreTokens()) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    min2theta = this.readIntensity(tokenizer.nextToken());
                                    if (!tokenizer.hasMoreTokens()) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    adIntensity[0][noOfSteps] = this.readIntensity(tokenizer.nextToken());
                                    if (maxIntensity < adIntensity[0][noOfSteps]) {
                                        maxIntensity = adIntensity[0][noOfSteps];
                                    }
                                    ++noOfSteps;
                                    singleLine = bf.readLine();
                                    tokenizer = new StringTokenizer(singleLine);
                                    if (!tokenizer.hasMoreTokens()) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    stepSize = this.readIntensity(tokenizer.nextToken()) - min2theta;
                                    if (stepSize == 0.0) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    if (!tokenizer.hasMoreTokens()) {
                                        throw new IOException("Wrong format of the " + fileName + " file");
                                    }
                                    adIntensity[0][noOfSteps] = this.readIntensity(tokenizer.nextToken());
                                    if (maxIntensity < adIntensity[0][noOfSteps]) {
                                        maxIntensity = adIntensity[0][noOfSteps];
                                    }
                                    ++noOfSteps;
                                    while (noOfSteps < iMaxSteps) {
                                        singleLine = bf.readLine();
                                        if (singleLine == null) {
                                            break block110;
                                        }
                                        tokenizer = new StringTokenizer(singleLine);
                                        if (tokenizer.countTokens() == 0) {
                                            break block110;
                                        }
                                        if (tokenizer.countTokens() != 2) {
                                            throw new IOException("Wrong format of the " + fileName + " file");
                                        }
                                        tokenizer.nextToken();
                                        adIntensity[noOfSteps / iChunkSize][noOfSteps % iChunkSize] = dIntensity = this.readIntensity(tokenizer.nextToken());
                                        if (maxIntensity < dIntensity) {
                                            maxIntensity = dIntensity;
                                        }
                                        if (++noOfSteps % iChunkSize != 0 || noOfSteps >= iMaxSteps) continue;
                                        adIntensity[noOfSteps / iChunkSize] = new double[iChunkSize];
                                    }
                                    break block110;
                                }
                                catch (ParseException pe) {
                                    throw new IOException("Wrong format of the " + fileName + " file: " + pe.getMessage());
                                }
                            }
                            finally {
                                bf.close();
                            }
                        }
                        if (!fileName.toLowerCase().endsWith(".udf")) break block113;
                        infoPattern = Pattern.compile("^[\\w]+.*");
                        sampleNamePattern = Pattern.compile("SampleIdent,(.*),/");
                        bSampleNameMatched = false;
                        dataRangePattern = Pattern.compile("DataAngleRange,\\s*([\\d\\.]+),\\s*([\\d\\.]+),/");
                        bDataRangeMatched = false;
                        stepSizePattern = Pattern.compile("ScanStepSize,\\s*([\\d\\.]+),/");
                        bStepSizeMatched = false;
                        scanTypePattern = Pattern.compile("ScanType,\\s*([\\w]+),/");
                        bScanTypeMatched = false;
                        try {
                            try {
                                while (true) {
                                    if (!(infoMatcher = infoPattern.matcher(singleLine = bf.readLine())).matches()) {
                                        if (!bSampleNameMatched) {
                                            throw new IOException("Missing or wrong sample name");
                                        }
                                        if (!bDataRangeMatched) {
                                            throw new IOException("Missing or wrong data range");
                                        }
                                        if (!bStepSizeMatched) {
                                            throw new IOException("Missing or wrong step size");
                                        }
                                        if (bScanTypeMatched) break;
                                        throw new IOException("Missing or wrong scan type");
                                    }
                                    sampleNameMatcher = sampleNamePattern.matcher(singleLine);
                                    dataRangeMatcher = dataRangePattern.matcher(singleLine);
                                    stepSizeMatcher = stepSizePattern.matcher(singleLine);
                                    scanTypeMatcher = scanTypePattern.matcher(singleLine);
                                    if (sampleNameMatcher.matches()) {
                                        sampleName = sampleNameMatcher.group(1);
                                        bSampleNameMatched = true;
                                        continue;
                                    }
                                    if (dataRangeMatcher.matches()) {
                                        min2theta = Double.parseDouble(dataRangeMatcher.group(1));
                                        min2theta = this.roundOut(min2theta, 3);
                                        bDataRangeMatched = true;
                                        continue;
                                    }
                                    if (stepSizeMatcher.matches()) {
                                        stepSize = Double.parseDouble(stepSizeMatcher.group(1));
                                        stepSize = this.roundOut(stepSize, 3);
                                        bStepSizeMatched = true;
                                        continue;
                                    }
                                    if (!scanTypeMatcher.matches()) continue;
                                    if (!(scanTypeMatcher.group(1).toLowerCase().equals("continuous") || scanTypeMatcher.group(1).toLowerCase().equals("continous") || scanTypeMatcher.group(1).toLowerCase().equals("step"))) {
                                        throw new IOException("Non-continous udf scans are not supported");
                                    }
                                    bScanTypeMatched = true;
                                }
                                if (!(stepSize > 0.1) && stepSize != 0.0) ** GOTO lbl262
                                throw new IOException("Wrong format of the " + fileName + " file");
lbl-1000:
                                // 1 sources

                                {
                                    if (singleLine == null) {
                                        break block110;
                                    }
                                    asTokens = singleLine.split("(,?\\s+|,?/)");
                                    i = 0;
                                    while (i < asTokens.length) {
                                        if (!asTokens[i].equals("")) {
                                            adIntensity[noOfSteps / iChunkSize][noOfSteps % iChunkSize] = dIntensity = Double.parseDouble(asTokens[i]);
                                            if (maxIntensity < dIntensity) {
                                                maxIntensity = dIntensity;
                                            }
                                            if (++noOfSteps % iChunkSize == 0 && noOfSteps < iMaxSteps) {
                                                adIntensity[noOfSteps / iChunkSize] = new double[iChunkSize];
                                            }
                                        }
                                        ++i;
                                    }
                                    singleLine = bf.readLine();
lbl262:
                                    // 2 sources

                                    ** while (noOfSteps < iMaxSteps)
                                }
lbl263:
                                // 1 sources

                                break block110;
                            }
                            catch (NumberFormatException nfe) {
                                throw new IOException("Wrong format of the " + fileName + " file: " + nfe.getMessage());
                            }
                        }
                        finally {
                            bf.close();
                        }
                    }
                    if (!fileName.toLowerCase().endsWith(".csv")) break block114;
                    sampleName = fileName;
                    try {
                        entry = this.parseLine(bf.readLine());
                        if (entry == null && (entry = this.parseLine(bf.readLine())) == null) {
                            throw new IOException("Wrong format of the " + fileName + " file (entry == null)");
                        }
                        min2theta = entry.getTwoTheta();
                        adIntensity[0][noOfSteps] = entry.getIntensity();
                        if (maxIntensity < adIntensity[0][noOfSteps]) {
                            maxIntensity = adIntensity[0][noOfSteps];
                        }
                        ++noOfSteps;
                        entry = this.parseLine(bf.readLine());
                        if (entry == null) {
                            throw new IOException(". " + fileName + " file");
                        }
                        stepSize = this.roundOut(entry.getTwoTheta() - min2theta, 3);
                        adIntensity[0][noOfSteps] = entry.getIntensity();
                        if (maxIntensity < adIntensity[0][noOfSteps]) {
                            maxIntensity = adIntensity[0][noOfSteps];
                        }
                        ++noOfSteps;
                        while (noOfSteps < iMaxSteps) {
                            entry = this.parseLine(bf.readLine());
                            if (entry == null) {
                            }
                            adIntensity[noOfSteps / iChunkSize][noOfSteps % iChunkSize] = dIntensity = entry.getIntensity();
                            if (maxIntensity < dIntensity) {
                                maxIntensity = dIntensity;
                            }
                            if (++noOfSteps % iChunkSize != 0 || noOfSteps >= iMaxSteps) continue;
                            adIntensity[noOfSteps / iChunkSize] = new double[iChunkSize];
                        }
                    }
                    finally {
                        bf.close();
                    }
                }
                if (!fileName.toLowerCase().endsWith(".nmd") && !fileName.toLowerCase().endsWith(".vba")) break block115;
                try {
                    sampleName = bf.readLine().trim();
                    while (true) {
                        block116: {
                            if ((singleLine = bf.readLine()) == null) {
                                throw new IOException("Wrong format of the " + fileName + " file");
                            }
                            number = this.getNumber(singleLine.trim());
                            if (number <= 0.0) {
                                min2theta = 0.0;
                                max2theta = 0.0;
                                stepSize = 0.0;
                                continue;
                            }
                            if (min2theta == 0.0) {
                                if (!(number <= 20.0)) continue;
                                min2theta = number;
                                continue;
                            }
                            if (max2theta == 0.0) {
                                if (number >= 20.0 && number < 100.0 && number > min2theta) {
                                    max2theta = number;
                                    continue;
                                }
                                if (number <= 20.0) {
                                    min2theta = number;
                                    continue;
                                }
                                min2theta = 0.0;
                                continue;
                            }
                            if (stepSize != 0.0) continue;
                            if (!(number <= 0.05)) break block116;
                            stepSize = number;
                            if (true) ** GOTO lbl352
                        }
                        min2theta = 0.0;
                        max2theta = 0.0;
                    }
                    do {
                        if ((line = bf.readLine()) == null) {
                        }
                        dIntensity = 0.0;
                        if (line.trim().equals("")) {
                        }
                        try {
                            adIntensity[noOfSteps / iChunkSize][noOfSteps % iChunkSize] = dIntensity = this.readIntensity(line.trim());
                            if (maxIntensity < dIntensity) {
                                maxIntensity = dIntensity;
                            }
                            if (++noOfSteps % iChunkSize != 0 || noOfSteps >= iMaxSteps) continue;
                            adIntensity[noOfSteps / iChunkSize] = new double[iChunkSize];
                        }
                        catch (ParseException e) {
                            throw new IOException("Wrong format of the " + fileName + " file");
                        }
lbl352:
                        // 3 sources

                    } while (noOfSteps < iMaxSteps);
                }
                finally {
                    bf.close();
                }
            }
            bf.close();
            throw new IOException("The only supported file formats are .ex$, .uxd, .csv, .nmd, .vba and .txt");
        }
        if (noOfSteps < 15 || min2theta < 0.0 || stepSize <= 0.0 || min2theta > 180.0 || stepSize > 5.0) {
            throw new IOException("File " + fileName + " probably corrupted");
        }
        if (maxIntensity == 0.0) {
            throw new IOException("File " + fileName + " is damaged: all intensities are 0.");
        }
        this.lamp = lamp;
        this.sampleName = sampleName;
        this.min2theta = min2theta;
        this.stepSize = stepSize;
        this.intensity = new double[noOfSteps];
        iTotalLength = 0;
        i = 0;
        while (i < adIntensity.length) {
            iLength = Math.min(noOfSteps - i * iChunkSize, iChunkSize);
            System.arraycopy(adIntensity[i], 0, this.intensity, i * iChunkSize, iLength);
            if ((iTotalLength += iLength) == noOfSteps) break;
            ++i;
        }
        this.max2theta = min2theta + stepSize * (double)(noOfSteps - 1);
        this.noOfSteps = noOfSteps;
        this.maxIntensity = maxIntensity;
    }

    public void saveEXS(BufferedWriter bf, boolean integers) throws IOException {
        PrintWriter pw = new PrintWriter(bf);
        pw.println(this.sampleName);
        pw.println("Cu");
        pw.println(this.min2theta);
        pw.println(this.stepSize);
        pw.println(this.noOfSteps);
        if (integers) {
            int i = 0;
            while (i < this.noOfSteps) {
                pw.println(Math.round(this.intensity[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.noOfSteps) {
                pw.println(this.intensity[i]);
                ++i;
            }
        }
        if (pw.checkError()) {
            throw new IOException("Error occured during writing");
        }
        pw.close();
        if (pw.checkError()) {
            throw new IOException("Error occured during writing");
        }
        pw = null;
    }

    public void save(BufferedWriter bf, boolean integers) throws IOException {
        this.save(bf, integers, false);
    }

    public void save(String fileName) {
        try {
            if (this.filename.endsWith(".csv")) {
                this.saveCSV(new BufferedWriter(new PrintWriter(fileName)), false, false);
            } else {
                this.save(new BufferedWriter(new PrintWriter(fileName)), false, false);
            }
        }
        catch (Exception e) {
            System.out.println("Could not save" + fileName);
        }
    }

    public void save(BufferedWriter bf, boolean integers, boolean bScaled) throws IOException {
        PrintWriter pw = new PrintWriter(bf);
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMinimumFractionDigits(3);
        nf.setMaximumFractionDigits(3);
        if (integers) {
            int i = 0;
            while (i < this.noOfSteps) {
                double twoTheta = this.min2theta + (double)i * this.stepSize;
                pw.print("  " + nf.format(twoTheta) + "    ");
                if (bScaled) {
                    pw.println((int)(this.intensity[i] * this.scale + this.offset));
                } else {
                    pw.println((int)this.intensity[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.noOfSteps) {
                double twoTheta = this.min2theta + (double)i * this.stepSize;
                pw.print("  " + nf.format(twoTheta) + "    ");
                if (bScaled) {
                    pw.println(this.intensity[i] * this.scale + this.offset);
                } else {
                    pw.println(this.intensity[i]);
                }
                ++i;
            }
        }
        if (pw.checkError()) {
            throw new IOException("Error occured during writing");
        }
        pw.close();
        if (pw.checkError()) {
            throw new IOException("Error occured during writing");
        }
        pw = null;
    }

    public void saveCSV(BufferedWriter bf, boolean integers, boolean bScaled) throws IOException {
        PrintWriter pw = new PrintWriter(bf);
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMinimumFractionDigits(3);
        nf.setMaximumFractionDigits(3);
        if (integers) {
            int i = 0;
            while (i < this.noOfSteps) {
                double twoTheta = this.min2theta + (double)i * this.stepSize;
                pw.print(String.valueOf(nf.format(twoTheta)) + ",");
                if (bScaled) {
                    pw.println((int)(this.intensity[i] * this.scale + this.offset));
                } else {
                    pw.println((int)this.intensity[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.noOfSteps) {
                double twoTheta = this.min2theta + (double)i * this.stepSize;
                pw.print(String.valueOf(nf.format(twoTheta)) + ",");
                if (bScaled) {
                    pw.println(this.intensity[i] * this.scale + this.offset);
                } else {
                    pw.println(this.intensity[i]);
                }
                ++i;
            }
        }
        if (pw.checkError()) {
            throw new IOException("Error occured during writing");
        }
        pw.close();
        if (pw.checkError()) {
            throw new IOException("Error occured during writing");
        }
        pw = null;
    }

    public void multiplyBy(double factor) {
        int i = 0;
        while (i < this.intensity.length) {
            int n = i++;
            this.intensity[n] = this.intensity[n] * factor;
        }
        this.maxIntensity *= factor;
    }

    private double getNumber(String line) {
        double result = 0.0;
        try {
            result = Double.parseDouble(line);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private double readIntensity(String line) throws ParseException {
        line = line.replace('e', 'E');
        line = line.replace('+', '0');
        return this.nf.parse(line).doubleValue();
    }

    private Entry parseLine(String sLine) throws IOException {
        if (sLine == null) {
            return null;
        }
        Entry entry = null;
        String[] asItems = sLine.split(",");
        if (asItems.length > 1) {
            double dTwoTheta = 0.0;
            double dIntensity = 0.0;
            boolean bOK = false;
            try {
                dTwoTheta = Double.parseDouble(asItems[0]);
                dIntensity = Double.parseDouble(asItems[1]);
                bOK = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bOK) {
                entry = new Entry(dTwoTheta, dIntensity);
            }
        }
        return entry;
    }

    protected double theta(int index) {
        return ((double)index * this.stepSize + this.min2theta) / 2.0;
    }

    public Object clone() {
        AbstractXRDData o = null;
        try {
            o = (AbstractXRDData)super.clone();
            o.intensity = (double[])this.intensity.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Cannot clone AbstractXRDData class");
        }
        return o;
    }

    protected double roundOut(double number, int precision) {
        int rounded = (int)Math.round(number * Math.pow(10.0, precision));
        return (double)rounded / Math.pow(10.0, precision);
    }

    private class Entry {
        private double _dTwoTheta;
        private double _dIntensity;

        public Entry(double dTwoTheta, double dIntensity) {
            this._dTwoTheta = dTwoTheta;
            this._dIntensity = dIntensity;
        }

        public double getTwoTheta() {
            return this._dTwoTheta;
        }

        public double getIntensity() {
            return this._dIntensity;
        }
    }
}

