/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.presentation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import net.ndmystko.presentation.DrawXRDAdapterEnhanced;
import net.ndmystko.presentation.DrawXRDEvent;
import net.ndmystko.presentation.DrawXRDJPanel;
import net.ndmystko.xrd.XRDRangeSelected;

public class DrawXRDJPanelEnhanced
extends DrawXRDJPanel {
    private static final int NO_OF_LINES = 7;
    private static final Color exclusionsColor = new Color(130, 130, 130);
    private ArrayList rangeSelectedList = new ArrayList();
    private int noOfRanges = 0;
    private boolean displayable = false;

    @Override
    protected void drawAll(Graphics2D g2, int target) {
        if (this.noOfRanges > 0 && this.displayable && this.diffrList.size() > 0 && target != 0) {
            g2.setClip(this.clipRect);
            int Y2 = this.positionY(0.0);
            int Y1 = this.positionY(this.tempMaxIntens);
            g2.setColor(exclusionsColor);
            int i = 0;
            while (i < this.noOfRanges) {
                int y1;
                XRDRangeSelected rs = (XRDRangeSelected)this.rangeSelectedList.get(i);
                int X1 = this.positionXfrom2theta(rs.getMin2theta());
                int X2 = this.positionXfrom2theta(rs.getMax2theta());
                g2.drawLine(X1, Y1, X1, Y2);
                g2.drawLine(X2, Y1, X2, Y2);
                int step = (Y2 - Y1) / 7;
                int k = 0;
                while (k < 7) {
                    int y12 = Y1 + k * step;
                    int y2 = y12 + (X2 - X1);
                    g2.drawLine(X1, y12, X2, y2);
                    ++k;
                }
                int j = 0;
                int y2 = 0;
                while ((y2 = (y1 = Y1 + --j * step) + (X2 - X1)) > Y1) {
                    g2.drawLine(X1, y1, X2, y2);
                }
                ++i;
            }
        }
        super.drawAll(g2, target);
    }

    public synchronized void addRangeSelected(XRDRangeSelected rs) {
        this.rangeSelectedList.add(rs);
        ++this.noOfRanges;
        if (this._alDrawXRDListener.size() > 0) {
            DrawXRDEvent event = new DrawXRDEvent(this, null);
            event.setRangeSelected(rs);
            int i = 0;
            while (i < this._alDrawXRDListener.size()) {
                if (this._alDrawXRDListener.get(i) instanceof DrawXRDAdapterEnhanced) {
                    ((DrawXRDAdapterEnhanced)this._alDrawXRDListener.get(i)).rangeAdded(event);
                }
                ++i;
            }
        }
    }

    public synchronized void removeRangeSelected(XRDRangeSelected rs) {
        if (this.rangeSelectedList.contains(rs)) {
            int index = this.rangeSelectedList.indexOf(rs);
            this.rangeSelectedList.remove(index);
            --this.noOfRanges;
            if (this._alDrawXRDListener.size() > 0) {
                DrawXRDEvent event = new DrawXRDEvent(this, null);
                event.setRangeSelected(rs);
                int i = 0;
                while (i < this._alDrawXRDListener.size()) {
                    if (this._alDrawXRDListener.get(i) instanceof DrawXRDAdapterEnhanced) {
                        ((DrawXRDAdapterEnhanced)this._alDrawXRDListener.get(i)).rangeRemoved(event);
                    }
                    ++i;
                }
            }
        }
    }

    public synchronized void removeAllRanges() {
        this.rangeSelectedList.clear();
        this.noOfRanges = 0;
        if (this._alDrawXRDListener.size() > 0) {
            DrawXRDEvent event = new DrawXRDEvent(this, null);
            int i = 0;
            while (i < this._alDrawXRDListener.size()) {
                if (this._alDrawXRDListener.get(i) instanceof DrawXRDAdapterEnhanced) {
                    ((DrawXRDAdapterEnhanced)this._alDrawXRDListener.get(i)).rangesRemoved(event);
                }
                ++i;
            }
        }
    }

    public synchronized void setRanges(List lRanges) {
        this.rangeSelectedList.clear();
        if (lRanges != null) {
            this.rangeSelectedList.addAll(lRanges);
        }
        this.noOfRanges = this.rangeSelectedList.size();
        if (this._alDrawXRDListener.size() > 0) {
            DrawXRDEvent event = new DrawXRDEvent(this, null);
            int i = 0;
            while (i < this._alDrawXRDListener.size()) {
                if (this._alDrawXRDListener.get(i) instanceof DrawXRDAdapterEnhanced) {
                    ((DrawXRDAdapterEnhanced)this._alDrawXRDListener.get(i)).rangesChanged(event);
                }
                ++i;
            }
        }
    }

    public ArrayList getAllRanges() {
        return this.rangeSelectedList;
    }

    public void setRangesDisplayable(boolean disp) {
        this.displayable = disp;
    }

    @Override
    protected Object whatItIs(MouseEvent e) {
        Object selectedObject = null;
        double angle = this.angle2theta(e.getX());
        XRDRangeSelected rs = null;
        if (angle >= this.tempMin2theta && angle <= this.tempMax2theta) {
            int i = 0;
            while (i < this.noOfRanges) {
                rs = (XRDRangeSelected)this.rangeSelectedList.get(i);
                if (angle >= rs.getMin2theta() && angle <= rs.getMax2theta()) {
                    selectedObject = rs;
                    break;
                }
                ++i;
            }
        }
        if (selectedObject == null) {
            selectedObject = super.whatItIs(e);
        }
        return selectedObject;
    }
}

