/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.presentation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.ndmystko.presentation.AreaSelected;
import net.ndmystko.presentation.DrawXRDAdapter;
import net.ndmystko.presentation.DrawXRDEvent;
import net.ndmystko.xrd.AbstractXRDData;
import net.ndmystko.xrd.XRDException;
import net.ndmystko.xrd.XRDRangeSelected;

public class DrawXRDJPanel
extends JPanel
implements Printable {
    private static final long serialVersionUID = -851543327939818081L;
    protected double tempMin2theta;
    protected double tempMax2theta;
    protected double tempMaxIntens;
    protected double maxIntens;
    protected double tempMinIntens;
    protected double minIntens;
    protected double intensity100;
    protected Shape clipRect;
    private Shape fullClipRect;
    private static final String TEXT_100 = "100";
    private static final String TEXT_999 = "99.9";
    private static final String STRING_2THETA = "2theta";
    private static final byte LEFT = 0;
    private static final byte RIGHT = 1;
    private static final byte TOP = 2;
    private static final byte BOTTOM = 3;
    private static final int[] SCREEN_BOUNDS = new int[]{5, 10, 10, 5};
    private static final int[] PRINTER_BOUNDS = new int[4];
    private static final byte PERCENT_EMPTY_ABOVE = 5;
    private static final Color niceColor = new Color(0.1f, 0.5f, 0.1f);
    protected Color mainDrawColor;
    private static final Color bcgColor = new JPanel().getBackground();
    private static final Color zeroColor = new Color(160, 160, 160);
    protected int drawWidth;
    protected int drawHeight;
    protected int leftMargin;
    protected int topMargin;
    protected int rightMargin;
    protected int bottomMargin;
    private int textHeight;
    private int panelWidth;
    private int panelHeight;
    private int noOfDiffr = 0;
    private int noOfSteps;
    private int tempNoOfSteps;
    private int lowStep;
    private int highStep;
    protected ArrayList<AbstractXRDData> diffrList;
    private double min2theta;
    private double max2theta;
    private double stepSize;
    private double axisXLabelStepSize;
    private byte axisXLabelPrecision;
    protected FontMetrics currentFontMetrics;
    private AreaSelected zoom;
    private XRDRangeSelected rangeSelection;
    private boolean zoomable = false;
    private boolean rangeSelectable = false;
    private boolean interestedInMouseMotion = false;
    private boolean interestedInPopup = false;
    private boolean _bShowNegative = false;
    protected ArrayList<DrawXRDAdapter> _alDrawXRDListener;
    private float _fLineWidth = 1.0f;
    private GeneralPath _chartPath;
    private boolean objectSelectable = false;
    protected Object selectedObject = null;
    protected static final int MARK_SELECTED_SIZE = 6;
    protected MouseEvent selectionStartEvent = null;
    protected Object beingBuiltObject = null;
    private Cursor storeCursor = null;
    private Cursor buildCursor = new Cursor(0);
    protected static final int PRINTER = 0;
    protected static final int DISPLAY = 1;
    protected static final double ERROR_LIMIT = 1.0E-8;
    private Font defaultFont = new Font("sans-serif", 0, 12);

    public DrawXRDJPanel() {
        this.diffrList = new ArrayList();
        this._alDrawXRDListener = new ArrayList(3);
        this.currentFontMetrics = this.getFontMetrics(this.getFont());
        this._chartPath = new GeneralPath(0, 1000);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && DrawXRDJPanel.this.interestedInPopup && DrawXRDJPanel.this.noOfDiffr > 0) {
                    DrawXRDJPanel.this.selectObject(e);
                    return;
                }
                if (e.isShiftDown() && !e.isPopupTrigger() && DrawXRDJPanel.this.rangeSelectable && DrawXRDJPanel.this.noOfDiffr > 0) {
                    DrawXRDJPanel.this.rangeSelectBegin(e);
                }
                if (!e.isShiftDown() && !e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e) && DrawXRDJPanel.this.noOfDiffr > 0) {
                    if (DrawXRDJPanel.this.beingBuiltObject != null) {
                        DrawXRDJPanel.this.builtObjectMousePressed(e);
                    } else if (DrawXRDJPanel.this.objectSelectable) {
                        Object tmpSelObject = DrawXRDJPanel.this.whatItIs(e);
                        if (tmpSelObject != null && tmpSelObject instanceof XRDRangeSelected) {
                            tmpSelObject = null;
                        }
                        if (DrawXRDJPanel.this.selectedObject != null && tmpSelObject == DrawXRDJPanel.this.selectedObject) {
                            DrawXRDJPanel.this.selectionStartEvent = e;
                            DrawXRDJPanel.this.dragSelectedObjectStarted(e);
                        }
                        if (tmpSelObject != null && tmpSelObject != DrawXRDJPanel.this.selectedObject) {
                            DrawXRDJPanel.this.newObjectSelected(tmpSelObject, e);
                        }
                        if (tmpSelObject == null && DrawXRDJPanel.this.selectedObject != null) {
                            DrawXRDJPanel.this.objectDeselected(DrawXRDJPanel.this.selectedObject, e);
                        }
                        if (tmpSelObject != null && tmpSelObject != DrawXRDJPanel.this.selectedObject || tmpSelObject == null && DrawXRDJPanel.this.selectedObject != null) {
                            DrawXRDJPanel.this.selectedObject = tmpSelObject;
                            DrawXRDJPanel.this.repaint();
                        }
                        DrawXRDJPanel.this.selectedObject = tmpSelObject;
                        if (DrawXRDJPanel.this.selectedObject == null && DrawXRDJPanel.this.zoomable) {
                            DrawXRDJPanel.this.zoomBegin(e);
                        }
                    } else if (DrawXRDJPanel.this.zoomable) {
                        DrawXRDJPanel.this.zoomBegin(e);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && DrawXRDJPanel.this.interestedInPopup && DrawXRDJPanel.this.noOfDiffr > 0) {
                    DrawXRDJPanel.this.selectObject(e);
                }
                if (DrawXRDJPanel.this.zoom != null) {
                    DrawXRDJPanel.this.zoomEnd(e);
                }
                if (DrawXRDJPanel.this.rangeSelection != null) {
                    DrawXRDJPanel.this.rangeSelectEnd(e);
                }
                if (DrawXRDJPanel.this.selectedObject != null && DrawXRDJPanel.this.selectionStartEvent != null) {
                    DrawXRDJPanel.this.dragSelectedObjectFinished(e);
                }
                if (DrawXRDJPanel.this.selectionStartEvent != null) {
                    DrawXRDJPanel.this.selectionStartEvent = null;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (DrawXRDJPanel.this.zoom != null) {
                    DrawXRDJPanel.this.zoomBeingSelected(e);
                }
                if (DrawXRDJPanel.this.rangeSelection != null) {
                    DrawXRDJPanel.this.rangeBeingSelected(e);
                }
                if (DrawXRDJPanel.this.interestedInMouseMotion && DrawXRDJPanel.this.noOfDiffr > 0 && DrawXRDJPanel.this._alDrawXRDListener.size() > 0) {
                    DrawXRDJPanel.this.sendMouseMovedEvent(e);
                }
                if (DrawXRDJPanel.this.selectedObject != null && DrawXRDJPanel.this.selectionStartEvent != null) {
                    DrawXRDJPanel.this.dragSelectedObject(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (DrawXRDJPanel.this.interestedInMouseMotion && DrawXRDJPanel.this.noOfDiffr > 0 && DrawXRDJPanel.this._alDrawXRDListener.size() > 0) {
                    DrawXRDJPanel.this.sendMouseMovedEvent(e);
                }
                if (DrawXRDJPanel.this.beingBuiltObject != null) {
                    DrawXRDJPanel.this.builtObjectMouseMoved(e);
                }
            }
        });
    }

    @Override
    public final void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.panelWidth = this.getWidth();
        this.panelHeight = this.getHeight();
        g2.setBackground(bcgColor);
        g2.clearRect(0, 0, this.panelWidth, this.panelHeight);
        this.mainDrawColor = Color.black;
        this.calculateMargins(g2, true, SCREEN_BOUNDS);
        this.drawAll(g2, 1);
    }

    public BufferedImage captureImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        this.mainDrawColor = Color.black;
        this.calculateMargins(g2, true, SCREEN_BOUNDS);
        this.drawAll(g2, 1);
        return image;
    }

    @Override
    public final int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform defaultTransform = g2.getTransform();
        double dScaleX = pf.getPaper().getHeight() / (double)this.getWidth();
        double dScaleY = pf.getPaper().getWidth() / (double)this.getHeight();
        AffineTransform afScaleToFit = new AffineTransform();
        afScaleToFit.setToScale(Math.min(dScaleX, dScaleY), Math.min(dScaleX, dScaleY));
        g2.transform(afScaleToFit);
        try {
            this.panelWidth = this.getWidth();
            this.panelHeight = this.getHeight();
            g2.setBackground(Color.white);
            g2.clearRect(0, 0, this.panelWidth, this.panelHeight);
            this.mainDrawColor = Color.black;
            DrawXRDJPanel.PRINTER_BOUNDS[2] = this.panelHeight / 20;
            DrawXRDJPanel.PRINTER_BOUNDS[3] = this.panelHeight / 16;
            DrawXRDJPanel.PRINTER_BOUNDS[0] = this.panelWidth / 25;
            DrawXRDJPanel.PRINTER_BOUNDS[1] = this.panelWidth / 18;
            this.calculateMargins(g2, true, PRINTER_BOUNDS);
            this.drawAll(g2, 0);
        }
        finally {
            g2.setTransform(defaultTransform);
        }
        return 0;
    }

    protected void drawAll(Graphics2D g2, int target) {
        this.calculateMaxIntens();
        g2.setFont(this.defaultFont);
        g2.setClip(this.fullClipRect);
        this.drawBox(g2, target);
        if (this.noOfDiffr > 0) {
            this.drawYAxisLabels(g2);
            this.drawXAxisLabels(g2);
        }
        this.markSelectedDiffr(g2, this.diffrList);
        g2.setClip(this.clipRect);
        int i = 0;
        while (i < this.noOfDiffr) {
            this.drawChart(g2, this.diffrList.get(i));
            ++i;
        }
    }

    private void calculateMargins(Graphics2D g2, boolean axisY, int[] bound) {
        int fontSize = this.defaultFont.getSize();
        this.textHeight = this.currentFontMetrics.getHeight();
        this.leftMargin = axisY ? bound[0] + fontSize * 2 : bound[0] + fontSize * 2;
        this.bottomMargin = bound[3] + fontSize * 2;
        this.rightMargin = bound[1] + this.currentFontMetrics.stringWidth(TEXT_999) / 2;
        this.topMargin = bound[2] + this.currentFontMetrics.getHeight() / 2;
        this.drawWidth = this.panelWidth - this.leftMargin - this.rightMargin;
        this.drawHeight = this.panelHeight - this.topMargin - this.bottomMargin;
        this.clipRect = new Rectangle(this.leftMargin, this.topMargin, this.drawWidth, this.drawHeight);
        this.fullClipRect = new Rectangle(bound[0] - 2, bound[2] - 1, this.panelWidth - bound[0] - bound[1] + 3, this.panelHeight - bound[2] - bound[3] + 2);
    }

    private void drawYAxisLabels(Graphics2D g2) {
        String axisLabel;
        int position;
        g2.setColor(this.mainDrawColor);
        int fontSize = this.defaultFont.getSize();
        double deltaY = Math.abs(this.tempMaxIntens > this.intensity100 ? this.intensity100 : this.tempMaxIntens - this.tempMinIntens) / 5.0;
        int counter = 1;
        while ((double)counter * deltaY <= this.tempMaxIntens) {
            position = this.positionY((double)counter * deltaY);
            axisLabel = Integer.toString((int)Math.round((double)counter * deltaY / this.intensity100 * 100.0));
            g2.drawLine(this.leftMargin, position, this.leftMargin - this.textHeight / 3, position);
            g2.drawString(axisLabel, SCREEN_BOUNDS[0] + fontSize * 2 - g2.getFontMetrics().stringWidth(axisLabel) - fontSize / 3, position + g2.getFontMetrics().getHeight() / 3);
            ++counter;
        }
        counter = 0;
        if (this.tempMinIntens < 0.0) {
            while ((double)counter * deltaY >= this.tempMinIntens) {
                position = this.positionY((double)counter * deltaY);
                axisLabel = Integer.toString((int)Math.round((double)counter * deltaY / this.intensity100 * 100.0));
                g2.drawLine(this.leftMargin, position, this.leftMargin - this.textHeight / 3, position);
                g2.drawString(axisLabel, SCREEN_BOUNDS[0] + fontSize * 2 - g2.getFontMetrics().stringWidth(axisLabel) - fontSize / 3, position + g2.getFontMetrics().getHeight() / 3);
                --counter;
            }
        }
    }

    private void calculateAxisXParameters() {
        this.axisXLabelPrecision = (byte)2;
        this.axisXLabelStepSize = 0.01;
        do {
            int axisXLabelSpread = this.currentFontMetrics.stringWidth(this.convertDtoS(this.tempMax2theta, this.axisXLabelPrecision)) * 2;
            int deltaX = this.positionXfrom2theta(this.tempMin2theta + this.axisXLabelStepSize) - this.positionXfrom2theta(this.tempMin2theta);
            if (deltaX > axisXLabelSpread) break;
            this.axisXLabelStepSize *= 5.0;
            deltaX = this.positionXfrom2theta(this.tempMin2theta + this.axisXLabelStepSize) - this.positionXfrom2theta(this.tempMin2theta);
            if (deltaX > axisXLabelSpread) break;
            this.axisXLabelStepSize *= 2.0;
            if (this.axisXLabelPrecision <= 0) continue;
            this.axisXLabelPrecision = (byte)(this.axisXLabelPrecision - 1);
        } while (this.axisXLabelStepSize < 100.0);
    }

    private void drawXAxisLabels(Graphics2D g2) {
        int fontSize = this.defaultFont.getSize();
        g2.setColor(this.mainDrawColor);
        this.calculateAxisXParameters();
        int stepNumber = (int)(this.tempMin2theta / this.axisXLabelStepSize);
        if ((double)stepNumber * this.axisXLabelStepSize < this.tempMin2theta - 0.001) {
            ++stepNumber;
        }
        do {
            int position = this.positionXfrom2theta((double)stepNumber * this.axisXLabelStepSize);
            String labelX = this.convertDtoS((double)stepNumber * this.axisXLabelStepSize, this.axisXLabelPrecision);
            g2.drawLine(position, this.topMargin + this.drawHeight, position, this.topMargin + this.drawHeight + this.textHeight / 3);
            g2.drawString(labelX, position - (g2.getFontMetrics().stringWidth(labelX) >> 1), (int)((float)(this.topMargin + this.drawHeight) + (float)fontSize * 1.1f));
        } while ((double)(++stepNumber) * this.axisXLabelStepSize < this.tempMax2theta + 0.001);
        g2.drawString(STRING_2THETA, this.leftMargin + this.drawWidth / 2 - this.currentFontMetrics.stringWidth(STRING_2THETA) / 2, this.topMargin + this.drawHeight + fontSize * 2);
    }

    private void markSelectedDiffr(Graphics2D g2, ArrayList<AbstractXRDData> diffrList) {
        if (this.selectedObject == null) {
            return;
        }
        int index = diffrList.indexOf(this.selectedObject);
        if (index > -1) {
            AbstractXRDData dd = diffrList.get(index);
            double scale = dd.getScale();
            double offset = dd.getOffset();
            g2.setColor(dd.getColor());
            int threeFourth = 4;
            int X1 = this.positionX(this.lowStep);
            int Y1 = this.positionY(dd.getIntensity(this.lowStep) * scale + offset);
            g2.fillRect(X1 - threeFourth, Y1 - threeFourth, threeFourth * 2, threeFourth * 2);
            X1 = this.positionX(this.highStep);
            Y1 = this.positionY(dd.getIntensity(this.highStep) * scale + offset);
            g2.fillRect(X1 - threeFourth, Y1 - threeFourth, threeFourth * 2, threeFourth * 2);
            g2.setColor(this.mainDrawColor);
        }
    }

    private void drawChart(Graphics2D g2, AbstractXRDData dd) {
        if (Math.abs(this._fLineWidth - 1.0f) < 0.001f) {
            double scale = dd.getScale();
            double offset = dd.getOffset();
            g2.setColor(dd.getColor());
            int X1 = this.positionX(this.lowStep);
            int Y1 = this.positionY(dd.getIntensity(this.lowStep) * scale + offset);
            int i = this.lowStep + 1;
            while (i <= this.highStep) {
                int X2 = this.positionX(i);
                if (X2 != X1) {
                    int Y2 = this.positionY(dd.getIntensity(i) * scale + offset);
                    g2.drawLine(X1, Y1, X2, Y2);
                    X1 = X2;
                    Y1 = Y2;
                }
                ++i;
            }
            g2.setColor(this.mainDrawColor);
        } else {
            this._chartPath.reset();
            int iX = this.positionX(this.lowStep);
            int iY = this.positionY(dd.getIntensity(this.lowStep) * dd.getScale() + dd.getOffset());
            this._chartPath.moveTo(iX, iY);
            int i = this.lowStep + 1;
            while (i <= this.highStep) {
                int iNewX = this.positionX(i);
                if (iNewX != iX) {
                    iX = iNewX;
                    iY = this.positionY(dd.getIntensity(i) * dd.getScale() + dd.getOffset());
                    this._chartPath.lineTo(iX, iY);
                }
                ++i;
            }
            g2.setColor(dd.getColor());
            Stroke defaultStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(this._fLineWidth, 1, 1));
            RenderingHints defaultHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.draw(this._chartPath);
            g2.setStroke(defaultStroke);
            g2.setRenderingHints(defaultHints);
            g2.setColor(this.mainDrawColor);
        }
    }

    public void setLineWidth(float fLineWidth) {
        if (fLineWidth <= 0.0f) {
            throw new IllegalArgumentException("Illegal line width: " + fLineWidth);
        }
        this._fLineWidth = fLineWidth;
    }

    private void drawBox(Graphics2D g2, int target) {
        if (target == 1) {
            g2.setColor(niceColor);
            g2.drawLine(this.leftMargin - 1, this.topMargin, this.leftMargin - 1, this.topMargin + this.drawHeight + 1);
            g2.drawLine(this.leftMargin - 1, this.topMargin + this.drawHeight - 1, this.leftMargin + this.drawWidth, this.topMargin + this.drawHeight - 1);
            g2.drawLine(this.leftMargin + 1, this.topMargin, this.leftMargin + 1, this.topMargin + this.drawHeight + 1);
            g2.drawLine(this.leftMargin - 1, this.topMargin + this.drawHeight + 1, this.leftMargin + this.drawWidth, this.topMargin + this.drawHeight + 1);
        }
        g2.setColor(this.mainDrawColor);
        g2.drawLine(this.leftMargin, this.topMargin, this.leftMargin, this.topMargin + this.drawHeight);
        g2.drawLine(this.leftMargin, this.topMargin + this.drawHeight, this.leftMargin + this.drawWidth, this.topMargin + this.drawHeight);
        g2.drawLine(this.leftMargin + this.drawWidth, this.topMargin + this.drawHeight, this.leftMargin + this.drawWidth, this.topMargin);
        g2.drawLine(this.leftMargin + this.drawWidth, this.topMargin, this.leftMargin, this.topMargin);
        if (this.tempMinIntens < 0.0) {
            g2.setColor(zeroColor);
            int iPosition0 = this.positionY(0.0);
            g2.drawLine(this.leftMargin, iPosition0, this.leftMargin + this.drawWidth, iPosition0);
        }
    }

    private void calculateMaxIntens() {
        this.maxIntens = 0.0;
        this.minIntens = 0.0;
        this.intensity100 = 0.0;
        int i = 0;
        while (i < this.noOfDiffr) {
            AbstractXRDData aDiffr = this.diffrList.get(i);
            int k = 0;
            while (k < this.noOfSteps) {
                double aDiffrIntens = aDiffr.getIntensity(k) * aDiffr.getScale() + aDiffr.getOffset();
                if (this.maxIntens < aDiffrIntens) {
                    this.intensity100 = this.maxIntens = aDiffrIntens;
                }
                if (this.minIntens > aDiffrIntens) {
                    this.minIntens = aDiffrIntens;
                }
                ++k;
            }
            ++i;
        }
        this.maxIntens = this.maxIntens * 105.0 / 100.0;
        this.minIntens = this.minIntens * 105.0 / 100.0;
    }

    public void updateRanges() {
        if (this.noOfDiffr > 0) {
            AbstractXRDData aDiffr = this.diffrList.get(0);
            this.tempMin2theta = this.min2theta = aDiffr.getMin2theta();
            this.tempMax2theta = this.max2theta = aDiffr.getMax2theta();
            this.tempNoOfSteps = this.noOfSteps = aDiffr.getNoOfSteps();
            this.stepSize = aDiffr.getStepSize();
            this.lowStep = 0;
            this.highStep = this.noOfSteps - 1;
            this.calculateMaxIntens();
            this.tempMaxIntens = this.maxIntens;
            this.tempMinIntens = this._bShowNegative ? this.minIntens : 0.0;
        }
    }

    public void addDiffractogram(AbstractXRDData aDiffr, boolean adjustMaxIntens) throws XRDException {
        if (this.noOfDiffr == 0) {
            this.tempMin2theta = this.min2theta = aDiffr.getMin2theta();
            this.tempMax2theta = this.max2theta = aDiffr.getMax2theta();
            this.tempNoOfSteps = this.noOfSteps = aDiffr.getNoOfSteps();
            this.stepSize = aDiffr.getStepSize();
            this.lowStep = 0;
            this.highStep = this.noOfSteps - 1;
            this.diffrList.add(aDiffr);
            ++this.noOfDiffr;
            this.calculateMaxIntens();
            this.tempMaxIntens = this.maxIntens;
            this.tempMinIntens = this._bShowNegative ? this.minIntens : 0.0;
        } else {
            if (Math.abs(this.stepSize - aDiffr.getStepSize()) > 1.0E-8) {
                throw new XRDException("All diffractograms must have the same step size");
            }
            if ((aDiffr.getMax2theta() - this.min2theta) / this.stepSize < 15.0) {
                throw new XRDException("2theta range of the diffractograms does not match");
            }
            if ((this.max2theta - aDiffr.getMin2theta()) / this.stepSize < 15.0) {
                throw new XRDException("2theta range of the diffractograms does not match");
            }
            if (Math.abs(aDiffr.getMax2theta() - this.max2theta) > 1.0E-8) {
                aDiffr.adjustMax2theta(this.max2theta);
            }
            if (Math.abs(aDiffr.getMin2theta() - this.min2theta) > 1.0E-8) {
                aDiffr.adjustMin2theta(this.min2theta);
            }
            this.diffrList.add(aDiffr);
            ++this.noOfDiffr;
            this.calculateMaxIntens();
            if (adjustMaxIntens) {
                this.tempMaxIntens = this.maxIntens;
                this.tempMinIntens = this._bShowNegative ? this.minIntens : 0.0;
            }
        }
    }

    public ArrayList<AbstractXRDData> getDiffractionList() {
        return this.diffrList;
    }

    public AbstractXRDData getDiffractogramDataForIndex(int index) {
        return this.diffrList.get(index);
    }

    public void removeDiffractogram(AbstractXRDData aDiffr, boolean adjustMaxIntens) {
        if (this.diffrList.contains(aDiffr)) {
            int index = this.diffrList.indexOf(aDiffr);
            this.diffrList.remove(index);
            --this.noOfDiffr;
            this.calculateMaxIntens();
            if (adjustMaxIntens) {
                this.tempMaxIntens = this.maxIntens;
                double d = this.tempMinIntens = this._bShowNegative ? this.minIntens : 0.0;
            }
            if (this.selectedObject == aDiffr) {
                this.selectedObject = null;
            }
        }
    }

    public void removeAllDiffractograms() {
        this.diffrList.clear();
        this.noOfDiffr = 0;
        this.calculateMaxIntens();
        this.tempMaxIntens = this.maxIntens;
        this.tempMinIntens = this._bShowNegative ? this.minIntens : 0.0;
    }

    public String convertDtoS(double d, byte precision) {
        String matrix = String.valueOf(Double.toString(d)) + "000";
        int index = matrix.indexOf(46) + precision;
        if (precision > 0) {
            ++index;
        }
        return matrix.substring(0, index);
    }

    public void setZoomable(boolean zoomable) {
        this.zoomable = zoomable;
    }

    private void zoomBegin(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x >= this.leftMargin && x <= this.leftMargin + this.drawWidth && y >= this.topMargin && y < this.topMargin + this.drawHeight - 5) {
            this.zoom = new AreaSelected(this.angle2theta(x), this.angle2theta(x), this.intens(y));
        }
    }

    private void zoomBeingSelected(MouseEvent e) {
        int xPocz = this.positionXfrom2theta(this.zoom.getMin2theta());
        int xKonc = this.positionXfrom2theta(this.zoom.getMax2theta());
        int yMax = this.positionY(this.zoom.getIntensity());
        int y0 = this.positionY(this.tempMinIntens);
        Graphics g = this.getGraphics();
        g.setXORMode(Color.red);
        g.drawLine(xPocz, y0, xPocz, yMax + 1);
        g.drawLine(xPocz, yMax, xKonc, yMax);
        g.drawLine(xKonc, yMax + 1, xKonc, y0);
        int x = e.getX();
        int y = e.getY();
        if (x < this.leftMargin) {
            x = this.leftMargin;
        }
        if (x > this.leftMargin + this.drawWidth) {
            x = this.leftMargin + this.drawWidth;
        }
        if (y < this.topMargin) {
            y = this.topMargin;
        }
        if (y > this.topMargin + this.drawHeight - 5) {
            y = this.topMargin + this.drawHeight - 5;
        }
        this.zoom.setMax2theta(this.angle2theta(x));
        this.zoom.setIntensity(this.intens(y));
        xKonc = this.positionXfrom2theta(this.zoom.getMax2theta());
        yMax = this.positionY(this.zoom.getIntensity());
        g.drawLine(xPocz, y0, xPocz, yMax + 1);
        g.drawLine(xPocz, yMax, xKonc, yMax);
        g.drawLine(xKonc, yMax + 1, xKonc, y0);
    }

    private void zoomEnd(MouseEvent e) {
        Graphics g = this.getGraphics();
        g.setPaintMode();
        if (this.zoom.getMin2theta() > this.zoom.getMax2theta()) {
            this.zoom.swap();
        }
        if (this.stepFrom2theta(this.zoom.getMax2theta()) - this.stepFrom2theta(this.zoom.getMin2theta()) > 5) {
            this.tempMax2theta = this.zoom.getMax2theta();
            this.highStep = this.stepFrom2theta(this.tempMax2theta);
            this.tempMin2theta = this.zoom.getMin2theta();
            this.lowStep = this.stepFrom2theta(this.tempMin2theta);
            this.tempMaxIntens = this.zoom.getIntensity();
            this.tempNoOfSteps = this.highStep - this.lowStep + 1;
        }
        this.zoom = null;
        this.repaint();
        DrawXRDEvent event = new DrawXRDEvent(this, e);
        for (DrawXRDAdapter adapter : this._alDrawXRDListener) {
            adapter.zoomedIn(event);
        }
    }

    public void unzoom() {
        this.tempMin2theta = this.min2theta;
        this.lowStep = 0;
        this.tempMax2theta = this.max2theta;
        this.highStep = this.stepFrom2theta(this.tempMax2theta);
        this.tempMaxIntens = this.maxIntens;
        this.tempMinIntens = this._bShowNegative ? this.minIntens : 0.0;
        this.tempNoOfSteps = this.highStep - this.lowStep + 1;
        this.repaint();
        DrawXRDEvent event = new DrawXRDEvent(this, null);
        for (DrawXRDAdapter adapter : this._alDrawXRDListener) {
            adapter.zoomedOut(event);
        }
    }

    public void setTwoThetaRange(double dMin2theta, double dMax2theta) {
        this.tempMax2theta = Math.min(dMax2theta, this.max2theta);
        this.highStep = this.stepFrom2theta(this.tempMax2theta);
        this.tempMin2theta = Math.max(dMin2theta, this.min2theta);
        this.lowStep = this.stepFrom2theta(this.tempMin2theta);
        this.tempNoOfSteps = this.highStep - this.lowStep + 1;
        this.repaint();
    }

    public void setAreaSelectable(boolean selectable) {
        this.rangeSelectable = selectable;
    }

    public void setObjectSelectable(boolean selectable) {
        this.objectSelectable = selectable;
    }

    public void selectDiffractogram(AbstractXRDData aDiffr) {
        if (this.diffrList.contains(aDiffr)) {
            int index = this.diffrList.indexOf(aDiffr);
            this.selectedObject = this.diffrList.get(index);
            this.repaint();
        }
    }

    public void rangeSelectBegin(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x >= this.leftMargin && x <= this.leftMargin + this.drawWidth && y >= this.topMargin && y < this.topMargin + this.drawHeight - 5) {
            this.rangeSelection = new XRDRangeSelected(this.angle2theta(x), this.angle2theta(x));
        }
    }

    private void rangeBeingSelected(MouseEvent e) {
        int xPocz = this.positionXfrom2theta(this.rangeSelection.getMin2theta());
        int xKonc = this.positionXfrom2theta(this.rangeSelection.getMax2theta());
        int yMax = this.positionY(this.tempMaxIntens);
        int y0 = this.positionY(this.tempMinIntens);
        Graphics g = this.getGraphics();
        g.setXORMode(Color.green);
        g.drawLine(xPocz, y0, xPocz, yMax);
        g.drawLine(xKonc, yMax, xKonc, y0);
        int x = e.getX();
        int y = e.getY();
        if (x < this.leftMargin) {
            x = this.leftMargin;
        }
        if (x > this.leftMargin + this.drawWidth) {
            x = this.leftMargin + this.drawWidth;
        }
        if (y < this.topMargin) {
            y = this.topMargin;
        }
        if (y > this.topMargin + this.drawHeight - 5) {
            y = this.topMargin + this.drawHeight - 5;
        }
        this.rangeSelection.setMax2theta(this.angle2theta(x));
        xKonc = this.positionXfrom2theta(this.rangeSelection.getMax2theta());
        g.drawLine(xPocz, y0, xPocz, yMax);
        g.drawLine(xKonc, yMax, xKonc, y0);
    }

    private void rangeSelectEnd(MouseEvent e) {
        Graphics g = this.getGraphics();
        g.setPaintMode();
        if (this.rangeSelection.getMin2theta() > this.rangeSelection.getMax2theta()) {
            this.rangeSelection.swap();
        }
        this.repaint();
        if (this._alDrawXRDListener.size() > 0 && this.rangeSelection.getMin2theta() < this.rangeSelection.getMax2theta()) {
            DrawXRDEvent event = new DrawXRDEvent(this, e);
            event.setRangeSelected(this.rangeSelection);
            for (DrawXRDAdapter adapter : this._alDrawXRDListener) {
                adapter.rangeSelected(event);
            }
        }
        this.rangeSelection = null;
    }

    private void newObjectSelected(Object selectedObject, MouseEvent e) {
        DrawXRDEvent event = new DrawXRDEvent(this, e);
        event.setTargetObject(selectedObject);
        event.set2theta(this.angle2theta(e.getX()));
        event.setIntensity(this.intens(e.getY()));
        for (DrawXRDAdapter adapter : this._alDrawXRDListener) {
            adapter.objectSelected(event);
        }
    }

    private void objectDeselected(Object selectedObject, MouseEvent e) {
        DrawXRDEvent event = new DrawXRDEvent(this, e);
        event.setTargetObject(selectedObject);
        event.set2theta(this.angle2theta(e.getX()));
        event.setIntensity(this.intens(e.getY()));
        for (DrawXRDAdapter adapter : this._alDrawXRDListener) {
            adapter.objectDeselected(event);
        }
    }

    private void selectObject(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < this.leftMargin || x > this.leftMargin + this.drawWidth || y < this.topMargin || y > this.topMargin + this.drawHeight) {
            return;
        }
        Object selectedObject = this.whatItIs(e);
        DrawXRDEvent event = new DrawXRDEvent(this, e);
        event.setTargetObject(selectedObject);
        event.set2theta(this.angle2theta(x));
        event.setIntensity(this.intens(y));
        for (DrawXRDAdapter adapter : this._alDrawXRDListener) {
            adapter.rightButtonClicked(event);
        }
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    public boolean deselectObject() {
        boolean eventConsumed = false;
        if (this.selectedObject != null) {
            this.selectedObject = null;
            this.repaint();
            eventConsumed = true;
        }
        return eventConsumed;
    }

    public Object removeSelectedObject() {
        return this.removeSelectedObject(this.selectedObject);
    }

    public Object removeSelectedObject(Object selectedObject) {
        if (selectedObject == null) {
            return null;
        }
        AbstractXRDData toBeRemoved = null;
        int index = this.diffrList.indexOf(selectedObject);
        if (index > -1) {
            toBeRemoved = this.diffrList.get(index);
            this.removeDiffractogram(toBeRemoved, true);
            this.selectedObject = null;
            this.repaint();
        }
        return toBeRemoved;
    }

    public Object removeBuiltObject() {
        return null;
    }

    protected void dragSelectedObjectStarted(MouseEvent e) {
    }

    protected void dragSelectedObject(MouseEvent e) {
    }

    protected void dragSelectedObjectFinished(MouseEvent e) {
    }

    public void setBuiltObject(Object object) {
        this.beingBuiltObject = object;
        this.storeCursor = this.getCursor();
        this.setCursor(this.buildCursor);
    }

    public boolean isObjectBeingBuilt() {
        return this.beingBuiltObject != null;
    }

    protected void builtObjectMouseMoved(MouseEvent e) {
    }

    protected void builtObjectMousePressed(MouseEvent e) {
    }

    protected void finishBuildingObject() {
        this.setCursor(this.storeCursor);
        this.beingBuiltObject = null;
    }

    protected Object whatItIs(MouseEvent e) {
        AbstractXRDData selectedObject = null;
        AbstractXRDData diffr = null;
        int noOfStep = this.stepNumber(e.getX());
        if (noOfStep >= this.lowStep && noOfStep <= this.highStep) {
            int i = 0;
            while (i < this.noOfDiffr) {
                diffr = this.diffrList.get(i);
                int y = this.positionY(diffr.getIntensity(noOfStep) * diffr.getScale() + diffr.getOffset());
                if (Math.abs(y - e.getY()) < 5) {
                    selectedObject = diffr;
                    break;
                }
                ++i;
            }
        }
        return selectedObject;
    }

    public void setInterestedInMouseMotion(boolean interested) {
        this.interestedInMouseMotion = interested;
    }

    public void setInterestedInPopup(boolean interested) {
        this.interestedInPopup = interested;
    }

    public void setShowNegative(boolean bShowNegative) {
        this._bShowNegative = bShowNegative;
    }

    private void sendMouseMovedEvent(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        DrawXRDEvent event = new DrawXRDEvent(this, e);
        double angle = this.angle2theta(x);
        if (x < this.leftMargin || x > this.leftMargin + this.drawWidth) {
            angle = 0.0;
        }
        event.set2theta(angle);
        double intensity = this.intens(y);
        if (y < this.topMargin || y > this.topMargin + this.drawHeight) {
            intensity = 0.0;
        }
        event.setIntensity(intensity);
        for (DrawXRDAdapter adapter : this._alDrawXRDListener) {
            adapter.mouseMoved(event);
        }
    }

    public void addDrawXRDListener(DrawXRDAdapter ad) {
        if (!this._alDrawXRDListener.contains(ad)) {
            this._alDrawXRDListener.add(ad);
        }
    }

    public void removeDrawXRDListener(DrawXRDAdapter ad) {
        this._alDrawXRDListener.remove(ad);
    }

    protected final int positionX(int stepNumber) {
        return (int)((float)this.leftMargin + (float)(stepNumber - this.lowStep) / (float)(this.tempNoOfSteps - 1) * (float)this.drawWidth);
    }

    protected final int stepNumber(int positionX) {
        return (int)(Math.round((double)(positionX - this.leftMargin) / (double)this.drawWidth * (double)(this.tempNoOfSteps - 1)) + (long)this.lowStep);
    }

    public final double intens(int positionY) {
        return (double)(this.drawHeight + this.topMargin - positionY) / (double)this.drawHeight * (this.tempMaxIntens - this.tempMinIntens) + this.tempMinIntens;
    }

    public final int positionY(double intens) {
        return (int)((double)(this.topMargin + this.drawHeight) - (intens - this.tempMinIntens) / (this.tempMaxIntens - this.tempMinIntens) * (double)this.drawHeight);
    }

    public final int positionXfrom2theta(double angle) {
        return (int)((double)this.leftMargin + (angle - this.tempMin2theta) / (this.tempMax2theta - this.tempMin2theta) * (double)this.drawWidth);
    }

    public final double angle2theta(int positionX) {
        return (double)this.stepNumber(positionX) * this.stepSize + this.min2theta;
    }

    protected final int stepFrom2theta(double angle) {
        return (int)Math.round((angle - this.min2theta) / this.stepSize);
    }

    public double getMin2theta() {
        return this.tempMin2theta;
    }

    public double getMax2theta() {
        return this.tempMax2theta;
    }

    public double getAbsMin2theta() {
        return this.min2theta;
    }

    public double getAbsMax2theta() {
        return this.max2theta;
    }

    public void setPanelFontSize(Font _f) {
        this.defaultFont = _f;
        this.repaint();
    }
}

