/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.presentation;

import net.ndmystko.xrd.AbstractXRDData;

public class AreaSelected {
    private double min2theta;
    private double max2theta;
    private double intensity;
    private AbstractXRDData pattern;
    private double gradient;
    private double greatestIntensity;
    private double reflectionIntensity;
    private double betaI;
    private double area;

    public AreaSelected(double min2theta, double max2theta, double intensity) {
        this.min2theta = min2theta;
        this.intensity = intensity;
        this.max2theta = max2theta;
    }

    public void setIntensity(double intensity) {
        this.intensity = intensity;
    }

    public void setMax2theta(double max2theta) {
        this.max2theta = max2theta;
    }

    public double getMin2theta() {
        return this.min2theta;
    }

    public double getMax2theta() {
        return this.max2theta;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setPattern(AbstractXRDData pattern) {
        if (this.pattern == pattern) {
            System.out.println("this.pattern == pattern");
            return;
        }
        this.pattern = pattern;
        if (this.min2theta == this.max2theta) {
            System.out.println("min2theta == max2theta");
            return;
        }
        int lowerLimitAddress = (int)Math.round((this.min2theta - pattern.getMin2theta()) / pattern.getStepSize());
        int upperLimitAddress = (int)Math.round((this.max2theta - pattern.getMin2theta()) / pattern.getStepSize());
        int greatestIntensityAddress = this.findGreatestIntensity(lowerLimitAddress, upperLimitAddress);
        this.calculateArea(lowerLimitAddress, upperLimitAddress);
        this.calculateReflectionIntensity(lowerLimitAddress, upperLimitAddress, greatestIntensityAddress);
    }

    public void calculateArea(int lowerLimitAddress, int upperLimitAddress) {
        double[] baseValues = new double[upperLimitAddress - lowerLimitAddress + 1];
        double intensityRange = this.pattern.getIntensity(upperLimitAddress) - this.pattern.getIntensity(lowerLimitAddress);
        double twoThetaRange = upperLimitAddress - lowerLimitAddress;
        double trapezoidHeight1 = 0.0;
        double trapezoidHeight2 = 0.0;
        double trapezoidBase = 1.0;
        this.gradient = intensityRange / twoThetaRange;
        this.area = 0.0;
        int j = 0;
        int i = lowerLimitAddress;
        while (i <= upperLimitAddress) {
            baseValues[j] = this.gradient * (double)(i - lowerLimitAddress) + this.pattern.getIntensity(lowerLimitAddress);
            if (i > lowerLimitAddress && this.pattern.getIntensity(i) > baseValues[j] && this.pattern.getIntensity(i - 1) > baseValues[j - 1]) {
                trapezoidHeight1 = this.pattern.getIntensity(i) - baseValues[j];
                trapezoidHeight2 = this.pattern.getIntensity(i - 1) - baseValues[j - 1];
                this.area += trapezoidBase / 2.0 * (trapezoidHeight1 + trapezoidHeight2);
            }
            ++j;
            ++i;
        }
        this.area *= this.pattern.getStepSize();
    }

    public int findGreatestIntensity(int lowerLimitAddress, int upperLimitAddress) {
        this.greatestIntensity = this.pattern.getIntensity(lowerLimitAddress);
        int greatestIntensityAddress = lowerLimitAddress;
        int i = lowerLimitAddress;
        while (i <= upperLimitAddress) {
            if (this.pattern.getIntensity(i) > this.greatestIntensity) {
                this.greatestIntensity = this.pattern.getIntensity(i);
                greatestIntensityAddress = i;
            }
            ++i;
        }
        return greatestIntensityAddress;
    }

    public void calculateReflectionIntensity(int lowerLimitAddress, int upperLimitAddress, int greatestIntensityAddress) {
        double base = 0.0;
        base = (double)(greatestIntensityAddress - lowerLimitAddress) * this.gradient + this.pattern.getIntensity(lowerLimitAddress);
        this.reflectionIntensity = this.pattern.getIntensity(greatestIntensityAddress) - base;
        if (this.reflectionIntensity <= 0.0) {
            this.reflectionIntensity = 0.0;
        }
        this.betaI = this.reflectionIntensity > 0.0 ? this.area / this.reflectionIntensity : 0.0;
    }

    public double getArea() {
        return this.area;
    }

    public double getReflectionIntensity() {
        return this.reflectionIntensity;
    }

    public double getBetaI() {
        return this.betaI;
    }

    public void swap() {
        double box = this.min2theta;
        this.min2theta = this.max2theta;
        this.max2theta = box;
    }

    private double interpolate(int x1, double intensity1, int x2, double intensity2) {
        double twoTheta1 = this.pattern.getMin2theta() + (double)x1 * this.pattern.getStepSize();
        double twoTheta2 = this.pattern.getMin2theta() + (double)x2 * this.pattern.getStepSize();
        double twoThetaMidPoint = (twoTheta1 + twoTheta2) / 2.0;
        double dTwoTheta = twoTheta2 - twoTheta1;
        double dIntensity = intensity2 - intensity1;
        double gradient = dIntensity / dTwoTheta;
        double yIntercept = intensity1 + gradient * twoTheta1;
        return gradient * twoThetaMidPoint + yIntercept;
    }
}

