/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.common.util;

import net.ndmystko.common.util.PrintTable;

public class RoundOff {
    private static final double DOUBLE_ERROR = 1.0E-6;

    public static int[] roundOff(double[] adValues, int iTotal) {
        assert (RoundOff.isTotalCorrect(adValues, iTotal)) : "Total " + iTotal + " is incorrect: " + PrintTable.toString(adValues);
        int[] aiValues = new int[adValues.length];
        double[] adLeftOvers = new double[adValues.length];
        int iRoundedTotal = 0;
        int i = 0;
        while (i < adValues.length) {
            double dRounded = Math.round(adValues[i]);
            adLeftOvers[i] = Math.abs(adValues[i] - dRounded);
            aiValues[i] = (int)dRounded;
            iRoundedTotal += aiValues[i];
            ++i;
        }
        while (iRoundedTotal != iTotal) {
            int iIndexHighest = 0;
            double dHighest = adLeftOvers[0];
            int i2 = 1;
            while (i2 < adLeftOvers.length) {
                if (dHighest < adLeftOvers[i2]) {
                    dHighest = adLeftOvers[i2];
                    iIndexHighest = i2;
                }
                ++i2;
            }
            int iChangeBy = iRoundedTotal < iTotal ? 1 : -1;
            int n = iIndexHighest;
            aiValues[n] = aiValues[n] + iChangeBy;
            iRoundedTotal += iChangeBy;
            adLeftOvers[iIndexHighest] = 0.0;
        }
        return aiValues;
    }

    public static double roundOff(double dValue, int iPrecision) {
        long lRounded = Math.round(dValue * Math.pow(10.0, iPrecision));
        return (double)lRounded / Math.pow(10.0, iPrecision);
    }

    private static boolean isTotalCorrect(double[] adValues, int iTotal) {
        double dTotal = 0.0;
        int i = 0;
        while (i < adValues.length) {
            dTotal += adValues[i];
            ++i;
        }
        return Math.abs(dTotal - (double)iTotal) < 1.0E-6;
    }
}

