/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import net.ndmystko.common.gui.JFileMenuItem;
import net.ndmystko.common.gui.OpenFileListener;

public class RecentlyOpenedFiles
implements ActionListener,
Serializable {
    private static final long serialVersionUID = 6359537151994745652L;
    private static final int NUMBER_OF_FILES = 5;
    private JFileMenuItem[] items;
    private transient OpenFileListener listener;
    private static transient Logger _logger = Logger.getLogger("net.ndmystko.common.gui.RecentlyOpenedFiles");

    public void createItems() {
        this.items = new JFileMenuItem[5];
        int i = 0;
        while (i < 5) {
            this.items[i] = new JFileMenuItem("empty");
            this.items[i].setVisible(false);
            this.items[i].addActionListener(this);
            ++i;
        }
    }

    public void createItems(Preferences prefs) {
        try {
            this.items = new JFileMenuItem[5];
            int i = 0;
            while (i < 5) {
                if (prefs.nodeExists("file" + i)) {
                    Preferences node = prefs.node("file" + i);
                    this.items[i] = new JFileMenuItem(node.get("file.name", "error"));
                    this.items[i].setFile(new File(node.get("full.file", "error")));
                    this.items[i].setVisible(true);
                } else {
                    this.items[i] = new JFileMenuItem("empty");
                    this.items[i].setVisible(false);
                }
                this.items[i].addActionListener(this);
                ++i;
            }
        }
        catch (BackingStoreException bse) {
            _logger.logp(Level.WARNING, "net.ndmystko.common.gui.RecentlyOpenedFiles", "createItems", "Error while testing node existence", bse);
            this.createItems();
        }
    }

    public void saveState(Preferences prefs) {
        int i = 0;
        while (i < 5) {
            Preferences node = prefs.node("file" + i);
            if (!this.items[i].isVisible()) {
                try {
                    node.removeNode();
                }
                catch (BackingStoreException bse) {
                    System.err.println("Cannot delete Preference node: " + bse.getMessage());
                    _logger.logp(Level.WARNING, "net.ndmystko.common.gui.RecentlyOpenedFiles", "saveState", "Cannot delete Preference node", bse);
                }
            } else {
                node.put("full.file", this.items[i].getFile().getPath());
                node.put("file.name", this.items[i].getText());
            }
            ++i;
        }
    }

    public void registerItems(JMenu hostMenu) {
        int i = 0;
        while (i < 5) {
            hostMenu.add(this.items[i]);
            ++i;
        }
    }

    public void setOpenFileListener(OpenFileListener listener) {
        this.listener = listener;
    }

    public void setEnabled(boolean enabled) {
        int i = 0;
        while (i < 5) {
            this.items[i].setEnabled(enabled);
            ++i;
        }
    }

    public void openingFile(File file) {
        int positionIdentified = -1;
        int positionFirstEmpty = -1;
        int i = 0;
        while (i < 5) {
            File itemFile = this.items[i].getFile();
            if (itemFile == null) {
                positionFirstEmpty = i;
                break;
            }
            if (itemFile.getPath().equals(file.getPath())) {
                positionIdentified = i;
                break;
            }
            ++i;
        }
        if (positionIdentified < 0) {
            if (positionFirstEmpty > -1) {
                this.items[positionFirstEmpty].setText(file.getName());
                this.items[positionFirstEmpty].setFile(file);
                this.items[positionFirstEmpty].setVisible(true);
                this.shift(positionFirstEmpty);
            } else {
                this.shift(4);
                this.items[0].setFile(file);
                this.items[0].setText(file.getName());
            }
        } else {
            this.shift(positionIdentified);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.items.length) {
            if (e.getSource() == this.items[i]) {
                this.shift(i);
                if (this.listener == null) break;
                this.listener.openFile(this.items[0].getFile());
                break;
            }
            ++i;
        }
    }

    private void shift(int to) {
        if (to < 1) {
            return;
        }
        File shifted = this.items[to].getFile();
        int i = to;
        while (i > 0) {
            this.items[i].setFile(this.items[i - 1].getFile());
            this.items[i].setText(this.items[i].getFile().getName());
            --i;
        }
        this.items[0].setFile(shifted);
        this.items[0].setText(this.items[0].getFile().getName());
    }
}

