/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.common.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CTCopyrightWindow
extends JDialog
implements ActionListener {
    private JFrame _frame = null;
    private JButton _continueButton;
    private JButton _cancelButton;
    private boolean _bCanContinue = false;
    private static final Pattern _copyrightPattern = Pattern.compile("200__");
    private static final String NOTICE = "<html>Sybilla was originally developed as a proprietary software by Chevron for its own research activity. Following a licensing agreement between Chevron and The Clay Minerals Society (CMS), this program is now freely distributed by CMS to its members under the MIT license available at the following link:</html>";

    public CTCopyrightWindow(JFrame frame, String sCopyrightYears) {
        super((Frame)frame, true);
        this.setTitle("Copyright notice");
        this._frame = frame;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CTCopyrightWindow.this.cancelAction();
            }
        });
        Matcher matcher = _copyrightPattern.matcher(NOTICE);
        String sUpdatedNotice = matcher.replaceAll(sCopyrightYears);
        JPanel noticePanel = new JPanel();
        noticePanel.setLayout(new BorderLayout());
        noticePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(15, 15, 15, 35)));
        noticePanel.setPreferredSize(new Dimension(400, 160));
        JLabel noticeLabel = new JLabel(sUpdatedNotice);
        final JLabel linkLabel = new JLabel("https://opensource.org/licenses/MIT");
        linkLabel.setForeground(Color.BLUE.darker());
        linkLabel.setCursor(Cursor.getPredefinedCursor(12));
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://opensource.org/licenses/MIT"));
                }
                catch (IOException | URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                linkLabel.setText("<html><a href=''>https://opensource.org/licenses/MIT</a></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                linkLabel.setText("https://opensource.org/licenses/MIT");
            }
        });
        noticePanel.add((Component)noticeLabel, "Center");
        noticePanel.add((Component)linkLabel, "South");
        this.getContentPane().add((Component)noticePanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this._continueButton = new JButton("continue");
        this._continueButton.addActionListener(this);
        buttonPanel.add(this._continueButton);
        this._cancelButton = new JButton("cancel");
        this._cancelButton.addActionListener(this);
        buttonPanel.add(this._cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton(this._continueButton);
        this.pack();
        int x = (this.getGraphicsConfiguration().getBounds().width - this.getWidth()) / 2;
        int y = (this.getGraphicsConfiguration().getBounds().height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._continueButton) {
            this.continueAction();
        } else if (e.getSource() == this._cancelButton) {
            this.cancelAction();
        } else {
            System.out.println("Unknown event caught: " + e.toString());
        }
    }

    public boolean canContinue() {
        return this._bCanContinue;
    }

    private void continueAction() {
        this._bCanContinue = true;
        this.setVisible(false);
    }

    private void cancelAction() {
        this._bCanContinue = false;
        this.setVisible(false);
    }
}

