/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.tools;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.analysis.tools.NNLS;
import net.ndmystko.xrd.AbstractXRDData;
import net.ndmystko.xrd.UserDiffractogram;
import net.ndmystko.xrd.XRDRangeSelected;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class XRDLeastSquares {
    protected AbstractXRDData _fittedPattern = null;
    protected double _dFittedTotalIntensity = 0.0;
    protected double[][] _adPhaseIntensities = null;
    protected double[] _adExpPatternIntens = null;
    protected boolean[] _abExcluded = null;
    protected int _iNoNonExcludedSteps = 0;
    protected double _dMisfit = 0.0;
    protected static Logger _logger = Logger.getLogger("net.ndmystko.analysis.tools.XRDLeastSquares");

    public XRDLeastSquares(AbstractXRDData fittedPattern, List lExcludedRanges) {
        this._fittedPattern = fittedPattern;
        int i = 0;
        while (i < this._fittedPattern.getNoOfSteps()) {
            this._dFittedTotalIntensity += this._fittedPattern.getIntensity(i);
            ++i;
        }
        this.setExcludedRanges(lExcludedRanges);
    }

    public void setExcludedRanges(List lRanges) {
        assert (this._fittedPattern != null);
        this._abExcluded = null;
        this._iNoNonExcludedSteps = this._fittedPattern.getNoOfSteps();
        if (lRanges == null || lRanges.size() == 0) {
            this._adExpPatternIntens = this.fittedIntensities();
            if (this._adPhaseIntensities != null) {
                this._adPhaseIntensities = new double[this._iNoNonExcludedSteps][this._adPhaseIntensities[0].length];
            }
            return;
        }
        int iExcludedSteps = 0;
        int iNoOfSteps = this._fittedPattern.getNoOfSteps();
        this._abExcluded = new boolean[iNoOfSteps];
        int k = 0;
        while (k < lRanges.size()) {
            XRDRangeSelected rs = (XRDRangeSelected)lRanges.get(k);
            int lowStep = (int)Math.round((rs.getMin2theta() - this._fittedPattern.getMin2theta()) / this._fittedPattern.getStepSize());
            int highStep = (int)Math.round((rs.getMax2theta() - this._fittedPattern.getMin2theta()) / this._fittedPattern.getStepSize());
            if (highStep >= 0 && lowStep <= iNoOfSteps - 1) {
                if (lowStep < 0) {
                    lowStep = 0;
                }
                if (highStep > iNoOfSteps - 1) {
                    highStep = iNoOfSteps - 1;
                }
                int i = lowStep;
                while (i < highStep + 1) {
                    this._abExcluded[i] = true;
                    ++iExcludedSteps;
                    ++i;
                }
            }
            ++k;
        }
        if (iExcludedSteps > 0) {
            this._iNoNonExcludedSteps = iNoOfSteps - iExcludedSteps;
            if (this._adPhaseIntensities != null) {
                this._adPhaseIntensities = new double[this._iNoNonExcludedSteps][this._adPhaseIntensities[0].length];
            }
            this._adExpPatternIntens = new double[iNoOfSteps - iExcludedSteps];
        } else {
            this._abExcluded = null;
        }
    }

    public double[] fit(AbstractXRDData[] aPhaseIntensities) {
        int i;
        int iNoOfSteps;
        int iNoOfPhases = aPhaseIntensities.length;
        if (this._adPhaseIntensities == null || this._adPhaseIntensities != null && this._adPhaseIntensities[0].length != iNoOfPhases) {
            this._adPhaseIntensities = new double[this._iNoNonExcludedSteps][iNoOfPhases];
        }
        if (this._abExcluded == null) {
            iNoOfSteps = aPhaseIntensities[0].getNoOfSteps();
            i = 0;
            while (i < iNoOfPhases) {
                assert (iNoOfSteps == aPhaseIntensities[i].getNoOfSteps());
                int j = 0;
                while (j < iNoOfSteps) {
                    this._adPhaseIntensities[j][i] = aPhaseIntensities[i].getIntensity(j);
                    ++j;
                }
                ++i;
            }
            assert (iNoOfSteps == this._fittedPattern.getNoOfSteps());
            int j = 0;
            while (j < iNoOfSteps) {
                this._adExpPatternIntens[j] = this._fittedPattern.getIntensity(j);
                ++j;
            }
        } else {
            iNoOfSteps = aPhaseIntensities[0].getNoOfSteps();
            i = 0;
            while (i < iNoOfPhases) {
                int iNonExcludedIndex = 0;
                assert (iNoOfSteps == aPhaseIntensities[i].getNoOfSteps());
                int j = 0;
                while (j < iNoOfSteps) {
                    if (!this._abExcluded[j]) {
                        this._adPhaseIntensities[iNonExcludedIndex++][i] = aPhaseIntensities[i].getIntensity(j);
                    }
                    ++j;
                }
                ++i;
            }
            int iNonExcludedIndex = 0;
            assert (iNoOfSteps == this._fittedPattern.getNoOfSteps());
            int i2 = 0;
            while (i2 < iNoOfSteps) {
                if (!this._abExcluded[i2]) {
                    this._adExpPatternIntens[iNonExcludedIndex++] = this._fittedPattern.getIntensity(i2);
                }
                ++i2;
            }
        }
        double[] adPhaseFactor = new double[iNoOfPhases];
        doubleW rNorm = new doubleW(0.0);
        double[] adW = new double[iNoOfPhases];
        double[] adZZ = new double[this._adPhaseIntensities.length];
        int[] aiIndex = new int[iNoOfPhases];
        intW mode = new intW(0);
        NNLS.NNLS((double[][])this._adPhaseIntensities, (int)this._adPhaseIntensities.length, (int)iNoOfPhases, (double[])this._adExpPatternIntens, (double[])adPhaseFactor, (doubleW)rNorm, (double[])adW, (double[])adZZ, (int[])aiIndex, (intW)mode);
        if (mode.val != 1) {
            _logger.logp(Level.SEVERE, "net.ndmystko.analysis.tools.XRDLeastSquares", "fit", "non-negative least squares failed: " + mode.val);
        }
        return adPhaseFactor;
    }

    public void mix(AbstractXRDData[] aPhaseIntensities, UserDiffractogram target) {
        this.mix(aPhaseIntensities, null, target);
    }

    public void mix(AbstractXRDData[] aPhaseIntensities, double[] adPhaseFactor, UserDiffractogram target) {
        this.mix(aPhaseIntensities, adPhaseFactor, false, target);
    }

    public void mix(AbstractXRDData[] aPhaseIntensities, double[] adPhaseFactor, boolean bSetScale, UserDiffractogram target) {
        int iNoOfPhases = aPhaseIntensities.length;
        double[] adFinalIntensities = target.getIntensities();
        Arrays.fill(adFinalIntensities, 0.0);
        int i = 0;
        while (i < iNoOfPhases) {
            int j;
            int iNoOfSteps = aPhaseIntensities[i].getNoOfSteps();
            if (adPhaseFactor != null) {
                j = 0;
                while (j < iNoOfSteps) {
                    int n = j;
                    adFinalIntensities[n] = adFinalIntensities[n] + aPhaseIntensities[i].getIntensity(j) * adPhaseFactor[i];
                    ++j;
                }
            } else {
                j = 0;
                while (j < iNoOfSteps) {
                    int n = j;
                    adFinalIntensities[n] = adFinalIntensities[n] + (aPhaseIntensities[i].getIntensity(j) * aPhaseIntensities[i].getScale() + aPhaseIntensities[i].getOffset());
                    ++j;
                }
            }
            if (bSetScale) {
                aPhaseIntensities[i].setScale(adPhaseFactor[i]);
            }
            ++i;
        }
        double dMaxIntensity = 0.0;
        double dAbsMisfit = 0.0;
        int j = 0;
        while (j < adFinalIntensities.length) {
            if (dMaxIntensity < adFinalIntensities[j]) {
                dMaxIntensity = adFinalIntensities[j];
            }
            dAbsMisfit += Math.abs(adFinalIntensities[j] - this._fittedPattern.getIntensity(j));
            ++j;
        }
        target.setMaxIntensity(dMaxIntensity);
        this._dMisfit = dAbsMisfit / this._dFittedTotalIntensity * 100.0;
    }

    public double getMisfit() {
        return this._dMisfit;
    }

    private double[] fittedIntensities() {
        double[] adIntens = new double[this._fittedPattern.getNoOfSteps()];
        int i = 0;
        while (i < this._fittedPattern.getNoOfSteps()) {
            adIntens[i] = this._fittedPattern.getIntensity(i);
            ++i;
        }
        return adIntens;
    }
}

