/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.tools;

import jamlab.Polyfit;

public class PolynomialTool {
    private double[] _adX = null;
    private double[] _adY = null;
    private int _iNoOfPoints = -1;
    private int _iTail = -1;
    private int _iPolynomialOrder = -1;
    private double[] _adWindowX = null;
    private double[] _adWindowY = null;
    private int _iLastAskedIndex = 0;
    private Polyfit polyf = null;
    private double[] adCoef = null;

    public PolynomialTool(double[] adX, double[] adY, int iNoOfPoints, int iPolynomialOrder) throws IllegalArgumentException {
        if (adX.length != adY.length) {
            throw new IllegalArgumentException("data length do not match");
        }
        if (iNoOfPoints % 2 == 0 || iNoOfPoints < 3 || iNoOfPoints > adX.length) {
            throw new IllegalArgumentException("iNoOfPoints (" + iNoOfPoints + ") must be an odd number, at least 3, at most number of points in the pattern");
        }
        if (iPolynomialOrder < 0 || iPolynomialOrder > 4) {
            throw new IllegalArgumentException("iPolynomialOrder must be within [0-4] range");
        }
        this._adX = adX;
        this._adY = adY;
        this._iNoOfPoints = iNoOfPoints;
        this._iTail = iNoOfPoints / 2;
        this._iPolynomialOrder = iPolynomialOrder;
        this._adWindowX = new double[iNoOfPoints];
        this._adWindowY = new double[iNoOfPoints];
        this.adCoef = new double[this._iPolynomialOrder + 1];
    }

    public double getValueAt(double dX) throws Exception {
        int iStep;
        this._iLastAskedIndex = iStep = this.getIndexOf(dX, this._adX, this._iLastAskedIndex);
        if (iStep < this._iTail) {
            iStep = this._iTail;
        }
        if (iStep > this._adX.length - this._iTail - 1) {
            iStep = this._adX.length - this._iTail - 1;
        }
        int j = 0;
        while (j < this._iNoOfPoints) {
            this._adWindowY[j] = this._adY[iStep - this._iTail + j];
            this._adWindowX[j] = this._adX[iStep - this._iTail + j];
            ++j;
        }
        this.polyf = new Polyfit(this._adWindowX, this._adWindowY, this._iPolynomialOrder);
        this.adCoef = this.polyf.getPolyCoeffMatrix().getColumnPackedCopy();
        double dAbsorption = 0.0;
        switch (this._iPolynomialOrder) {
            case 4: {
                dAbsorption += this.adCoef[0] * dX * dX * dX * dX;
            }
            case 3: {
                dAbsorption += this.adCoef[-3 + this._iPolynomialOrder] * dX * dX * dX;
            }
            case 2: {
                dAbsorption += this.adCoef[-2 + this._iPolynomialOrder] * dX * dX;
            }
            case 1: {
                dAbsorption += this.adCoef[-1 + this._iPolynomialOrder] * dX;
            }
            case 0: {
                dAbsorption += this.adCoef[this._iPolynomialOrder];
                break;
            }
            default: {
                assert (false) : "Illegal polynomial order: " + this._iPolynomialOrder;
                break;
            }
        }
        return Math.max(dAbsorption, 0.0);
    }

    private int getIndexOf(double dValue, double[] adValues, int iLastIndex) {
        int iNewIndex = iLastIndex;
        while (iNewIndex < adValues.length - 1 && dValue > adValues[iNewIndex]) {
            ++iNewIndex;
        }
        if (iNewIndex > 0 && Math.abs(dValue - adValues[iNewIndex - 1]) < Math.abs(dValue - adValues[iNewIndex])) {
            --iNewIndex;
        }
        return iNewIndex;
    }

    public double[] getCoefficients() {
        return this.adCoef;
    }
}

