/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.tools;

import org.apache.commons.math.analysis.PolynomialFunction;
import org.apache.commons.math.analysis.PolynomialSplineFunction;
import org.apache.commons.math.analysis.SplineInterpolator;

public class NaturalCubicSpline {
    private double[] xValues = null;
    private double[] yValues = null;
    private double stepSize = 0.0;
    private int degree = 3;
    private double[] splineFunctionValues = null;
    private SplineInterpolator splineInterpolator = null;
    private PolynomialSplineFunction splineFunction = null;
    private PolynomialFunction[] polynomials = null;

    public NaturalCubicSpline(double[] xValues, double[] yValues) {
        this.xValues = xValues;
        this.yValues = yValues;
        this.splineFunction = this.constructNaturalCubicSplineFunction();
        this.polynomials = this.splineFunction.getPolynomials();
    }

    public NaturalCubicSpline(double[] xValues, double[] yValues, double stepSize) {
        this(xValues, yValues);
        this.stepSize = stepSize;
    }

    public PolynomialSplineFunction constructNaturalCubicSplineFunction() {
        System.out.println("interpolation....");
        this.splineInterpolator = new SplineInterpolator();
        System.out.println("interpolation ok?");
        this.splineFunction = (PolynomialSplineFunction)this.splineInterpolator.interpolate(this.xValues, this.yValues);
        this.splineFunctionValues = new double[this.xValues.length];
        try {
            int i = 0;
            while (i < this.splineFunctionValues.length) {
                this.splineFunctionValues[i] = this.splineFunction.value(this.xValues[i]);
                System.out.println(this.splineFunctionValues[i]);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error:  Could not get the natural cubic spline values.");
        }
        return this.splineFunction;
    }

    public PolynomialFunction[] getPolynomials() {
        return this.polynomials;
    }

    public double[] getCoefficientsForPolynomial(PolynomialFunction polynomial) {
        return polynomial.getCoefficients();
    }

    public double findIntegral() {
        double area = 0.0;
        double[] coefficientSums = this.getCoefficientsForPolynomial(this.polynomials[0]);
        int i = 1;
        while (i < this.polynomials.length) {
            double[] coefficients = this.getCoefficientsForPolynomial(this.polynomials[i]);
            int j = 0;
            while (j < coefficients.length) {
                coefficientSums[j] = coefficientSums[j] + coefficients[j];
                System.out.println("coefficientSums[" + j + "] = " + coefficientSums[j]);
                ++j;
            }
            ++i;
        }
        if (this.stepSize == 0.0) {
            this.stepSize = (this.xValues[this.xValues.length - 1] - this.xValues[0]) / (double)(this.xValues.length - 1);
        }
        System.out.println("stepSize = " + this.stepSize);
        int n = 3;
        while (n >= 0) {
            area += Math.pow(this.stepSize, n + 1) / (double)(n + 1) * coefficientSums[n];
            --n;
        }
        return area;
    }
}

