/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.evolution;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.analysis.evolution.AdaptingEvolution;
import net.ndmystko.analysis.evolution.CalcEngine;
import net.ndmystko.analysis.evolution.Chromosome;

public abstract class ThreadedAdaptingEvolution
extends AdaptingEvolution {
    private static Logger _logger = Logger.getLogger("net.ndmystko.analysis.evolution.ThreadedAdaptingEvolution");
    private CalcEngine[] _calcThread = null;
    private LinkedList _llGlobalJobList = null;
    private boolean[] _abEngineDone = null;
    private boolean _bFirstRun = true;

    protected void setUpThreads(CalcEngine[] calcThread) {
        this._calcThread = calcThread;
        this._abEngineDone = new boolean[this._calcThread.length];
        this._llGlobalJobList = new LinkedList();
        int i = 0;
        while (i < this._calcThread.length) {
            this._calcThread[i].setJobList(this._llGlobalJobList);
            this._calcThread[i].setEvolutionOwner(this);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String evalP(Chromosome[] population, double[] eval) {
        if (this._calcThread == null) {
            return super.evalP(population, eval);
        }
        LinkedList<Chromosome> llToBeCalculated = new LinkedList<Chromosome>();
        int i22 = 0;
        while (i22 < population.length) {
            if (population[i22].needsEvaluation()) {
                llToBeCalculated.add(population[i22]);
            }
            ++i22;
        }
        if (llToBeCalculated.size() < 2) {
            return super.evalP(population, eval);
        }
        Arrays.fill(this._abEngineDone, false);
        LinkedList i22 = this._llGlobalJobList;
        synchronized (i22) {
            int iNoToBeCalculated = llToBeCalculated.size();
            int i = 0;
            while (i < iNoToBeCalculated) {
                this._llGlobalJobList.addLast(llToBeCalculated.removeFirst());
                this._llGlobalJobList.notify();
                ++i;
            }
        }
        if (this._bFirstRun) {
            int i = 0;
            while (i < this._calcThread.length) {
                this._calcThread[i].start();
                ++i;
            }
        }
        int i = 0;
        while (i < this._calcThread.length) {
            try {
                ((Object)((Object)this)).wait(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.countNotDone() == 0 && i < this._calcThread.length - 1) break;
            ++i;
        }
        this._bFirstRun = false;
        if (this.countNotDone() > 0) {
            _logger.logp(Level.SEVERE, "net.ndmystko.analysis.evolution.ThreadedAdaptingEvolution", "evalP", "still calculating threads out of the loop!!!: " + this.countNotDone());
        }
        return super.evalP(population, eval);
    }

    public synchronized void threadDone(CalcEngine engine) {
        int i = 0;
        while (i < this._calcThread.length) {
            if (this._calcThread[i] == engine) {
                this._abEngineDone[i] = true;
                break;
            }
            ++i;
        }
        ((Object)((Object)this)).notify();
    }

    private int countNotDone() {
        int iResult = 0;
        int i = 0;
        while (i < this._abEngineDone.length) {
            if (!this._abEngineDone[i]) {
                ++iResult;
            }
            ++i;
        }
        return iResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
        if (this._calcThread != null) {
            LinkedList linkedList = this._llGlobalJobList;
            synchronized (linkedList) {
                int i = 0;
                while (i < this._calcThread.length * 2) {
                    this._llGlobalJobList.addLast(null);
                    this._llGlobalJobList.notify();
                    ++i;
                }
            }
        }
    }
}

