/*
 * Decompiled with CFR 0.152.
 */
package net.ndmystko.analysis.evolution;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ndmystko.analysis.evolution.Chromosome;
import net.ndmystko.analysis.evolution.ThreadedAdaptingEvolution;

public abstract class CalcEngine
extends Thread {
    private LinkedList _llJobList = null;
    private ThreadedAdaptingEvolution _owner = null;
    private static Logger _logger = Logger.getLogger("net.ndmystko.analysis.evolution.CalcEngine");

    public CalcEngine() {
        this.setPriority(1);
    }

    public void setJobList(LinkedList llJobList) {
        this._llJobList = llJobList;
    }

    public void setEvolutionOwner(ThreadedAdaptingEvolution owner) {
        this._owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int iCalculated = 0;
        Chromosome chromosome = null;
        while (true) {
            LinkedList linkedList = this._llJobList;
            synchronized (linkedList) {
                if (this._llJobList.isEmpty()) {
                    iCalculated = 0;
                    this._owner.threadDone(this);
                    while (this._llJobList.isEmpty()) {
                        try {
                            this._llJobList.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                chromosome = (Chromosome)this._llJobList.removeFirst();
            }
            if (chromosome == null) {
                return;
            }
            try {
                double dFit = this.evaluate(chromosome);
                chromosome.setFit(dFit);
            }
            catch (RuntimeException re) {
                _logger.logp(Level.SEVERE, "net.ndmystko.analysis.evolution.CalcEngine", "run", "RuntimeException in calc thread.", re);
                throw re;
            }
            ++iCalculated;
        }
    }

    public double evaluate(Chromosome chromosome) {
        return 0.0;
    }
}

